# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_models_enums_global_role import HelloAssoModelsEnumsGlobalRole
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsOrganizationOrganizationLightModel(BaseModel):
    """
    OrganizationLightModel class
    """ # noqa: E501
    logo: Optional[StrictStr] = Field(default=None, description="Logo of organization")
    name: Optional[StrictStr] = Field(default=None, description="Name of organization")
    role: Optional[HelloAssoModelsEnumsGlobalRole] = None
    city: Optional[StrictStr] = Field(default=None, description="Organization city")
    zip_code: Optional[StrictStr] = Field(default=None, description="Organization zip code", alias="zipCode")
    description: Optional[StrictStr] = Field(default=None, description="Organization description")
    update_date: Optional[datetime] = Field(default=None, description="Last update date of the organization", alias="updateDate")
    category_jo_id: Optional[StrictInt] = Field(default=None, alias="categoryJoId")
    url: Optional[StrictStr] = Field(default=None, description="The organization url")
    organization_slug: Optional[StrictStr] = Field(default=None, description="The organization slug", alias="organizationSlug")
    __properties: ClassVar[List[str]] = ["logo", "name", "role", "city", "zipCode", "description", "updateDate", "categoryJoId", "url", "organizationSlug"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsOrganizationOrganizationLightModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if logo (nullable) is None
        # and model_fields_set contains the field
        if self.logo is None and "logo" in self.model_fields_set:
            _dict['logo'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if city (nullable) is None
        # and model_fields_set contains the field
        if self.city is None and "city" in self.model_fields_set:
            _dict['city'] = None

        # set to None if zip_code (nullable) is None
        # and model_fields_set contains the field
        if self.zip_code is None and "zip_code" in self.model_fields_set:
            _dict['zipCode'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if category_jo_id (nullable) is None
        # and model_fields_set contains the field
        if self.category_jo_id is None and "category_jo_id" in self.model_fields_set:
            _dict['categoryJoId'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if organization_slug (nullable) is None
        # and model_fields_set contains the field
        if self.organization_slug is None and "organization_slug" in self.model_fields_set:
            _dict['organizationSlug'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsOrganizationOrganizationLightModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "logo": obj.get("logo"),
            "name": obj.get("name"),
            "role": obj.get("role"),
            "city": obj.get("city"),
            "zipCode": obj.get("zipCode"),
            "description": obj.get("description"),
            "updateDate": obj.get("updateDate"),
            "categoryJoId": obj.get("categoryJoId"),
            "url": obj.get("url"),
            "organizationSlug": obj.get("organizationSlug")
        })
        return _obj


