# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsPartnerStatisticsModel(BaseModel):
    """
    HelloAssoApiV5ModelsPartnerStatisticsModel
    """ # noqa: E501
    linked_organizations_count: Optional[StrictInt] = Field(default=None, description="Number of organizations linked to this partner", alias="linkedOrganizationsCount")
    linked_organizations_collected_amount: Optional[StrictInt] = Field(default=None, description="Collected amount by linked organizations", alias="linkedOrganizationsCollectedAmount")
    checkout_collected_amount: Optional[StrictInt] = Field(default=None, description="Collected amount by All partner checkouts", alias="checkoutCollectedAmount")
    organizations_using_checkout: Optional[StrictInt] = Field(default=None, description="Number of organizations using the checkout with this partner", alias="organizationsUsingCheckout")
    available_organizations_access_token_count: Optional[StrictInt] = Field(default=None, description="Number of organizations access token obtains by authorize flow", alias="availableOrganizationsAccessTokenCount")
    __properties: ClassVar[List[str]] = ["linkedOrganizationsCount", "linkedOrganizationsCollectedAmount", "checkoutCollectedAmount", "organizationsUsingCheckout", "availableOrganizationsAccessTokenCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsPartnerStatisticsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsPartnerStatisticsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "linkedOrganizationsCount": obj.get("linkedOrganizationsCount"),
            "linkedOrganizationsCollectedAmount": obj.get("linkedOrganizationsCollectedAmount"),
            "checkoutCollectedAmount": obj.get("checkoutCollectedAmount"),
            "organizationsUsingCheckout": obj.get("organizationsUsingCheckout"),
            "availableOrganizationsAccessTokenCount": obj.get("availableOrganizationsAccessTokenCount")
        })
        return _obj


