# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from helloasso_python.models.hello_asso_api_v5_models_carts_checkout_payer import HelloAssoApiV5ModelsCartsCheckoutPayer
from helloasso_python.models.hello_asso_api_v5_models_carts_checkout_term import HelloAssoApiV5ModelsCartsCheckoutTerm
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsCartsInitCheckoutBody(BaseModel):
    """
    HelloAssoApiV5ModelsCartsInitCheckoutBody
    """ # noqa: E501
    total_amount: StrictInt = Field(description="Total amount, all taxes included, in cents (required)  Must be equal to the sum of the initial amount and subsequent terms", alias="totalAmount")
    initial_amount: StrictInt = Field(description="The amount for the first term, all taxes included, in cents (required)", alias="initialAmount")
    item_name: Annotated[str, Field(min_length=1, strict=True, max_length=250)] = Field(description="Item name (required)  A text describing what the user paid for ('Renew license', '3 tickets', donation, etc).  Will be displayed in the near future in the user space and in the organization back office", alias="itemName")
    back_url: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Url followed by the contributor if he wants to return to its previous site", alias="backUrl")
    error_url: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Url called in case of an error during the checkout process", alias="errorUrl")
    return_url: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Url called after the payment", alias="returnUrl")
    contains_donation: StrictBool = Field(description="The sale (or a part of) is a donation", alias="containsDonation")
    terms: Optional[List[HelloAssoApiV5ModelsCartsCheckoutTerm]] = Field(default=None, description="The list of future terms (if applicable)")
    payer: Optional[HelloAssoApiV5ModelsCartsCheckoutPayer] = None
    metadata: Optional[Any] = Field(default=None, description="Metadata (optional)  Json object (max length : 20000)")
    __properties: ClassVar[List[str]] = ["totalAmount", "initialAmount", "itemName", "backUrl", "errorUrl", "returnUrl", "containsDonation", "terms", "payer", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsCartsInitCheckoutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in terms (list)
        _items = []
        if self.terms:
            for _item_terms in self.terms:
                if _item_terms:
                    _items.append(_item_terms.to_dict())
            _dict['terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of payer
        if self.payer:
            _dict['payer'] = self.payer.to_dict()
        # set to None if terms (nullable) is None
        # and model_fields_set contains the field
        if self.terms is None and "terms" in self.model_fields_set:
            _dict['terms'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsCartsInitCheckoutBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totalAmount": obj.get("totalAmount"),
            "initialAmount": obj.get("initialAmount"),
            "itemName": obj.get("itemName"),
            "backUrl": obj.get("backUrl"),
            "errorUrl": obj.get("errorUrl"),
            "returnUrl": obj.get("returnUrl"),
            "containsDonation": obj.get("containsDonation"),
            "terms": [HelloAssoApiV5ModelsCartsCheckoutTerm.from_dict(_item) for _item in obj["terms"]] if obj.get("terms") is not None else None,
            "payer": HelloAssoApiV5ModelsCartsCheckoutPayer.from_dict(obj["payer"]) if obj.get("payer") is not None else None,
            "metadata": obj.get("metadata")
        })
        return _obj


