# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsCartsCheckoutPayer(BaseModel):
    """
    HelloAssoApiV5ModelsCartsCheckoutPayer
    """ # noqa: E501
    first_name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="FirstName", alias="firstName")
    last_name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="LastName", alias="lastName")
    email: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Email")
    date_of_birth: Optional[datetime] = Field(default=None, description="Date of birth (Date only, no time part)", alias="dateOfBirth")
    address: Optional[StrictStr] = Field(default=None, description="Address")
    city: Optional[StrictStr] = Field(default=None, description="City")
    zip_code: Optional[StrictStr] = Field(default=None, description="ZipCode", alias="zipCode")
    country: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=3)]] = Field(default=None, description="3 letter country code")
    company_name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Used if the payer is a company", alias="companyName")
    __properties: ClassVar[List[str]] = ["firstName", "lastName", "email", "dateOfBirth", "address", "city", "zipCode", "country", "companyName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsCartsCheckoutPayer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['firstName'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['lastName'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if date_of_birth (nullable) is None
        # and model_fields_set contains the field
        if self.date_of_birth is None and "date_of_birth" in self.model_fields_set:
            _dict['dateOfBirth'] = None

        # set to None if address (nullable) is None
        # and model_fields_set contains the field
        if self.address is None and "address" in self.model_fields_set:
            _dict['address'] = None

        # set to None if city (nullable) is None
        # and model_fields_set contains the field
        if self.city is None and "city" in self.model_fields_set:
            _dict['city'] = None

        # set to None if zip_code (nullable) is None
        # and model_fields_set contains the field
        if self.zip_code is None and "zip_code" in self.model_fields_set:
            _dict['zipCode'] = None

        # set to None if country (nullable) is None
        # and model_fields_set contains the field
        if self.country is None and "country" in self.model_fields_set:
            _dict['country'] = None

        # set to None if company_name (nullable) is None
        # and model_fields_set contains the field
        if self.company_name is None and "company_name" in self.model_fields_set:
            _dict['companyName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsCartsCheckoutPayer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "email": obj.get("email"),
            "dateOfBirth": obj.get("dateOfBirth"),
            "address": obj.get("address"),
            "city": obj.get("city"),
            "zipCode": obj.get("zipCode"),
            "country": obj.get("country"),
            "companyName": obj.get("companyName")
        })
        return _obj


