# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from helloasso_python.models.hello_asso_api_v5_models_common_document_model import HelloAssoApiV5ModelsCommonDocumentModel
from helloasso_python.models.hello_asso_api_v5_models_common_meta_model import HelloAssoApiV5ModelsCommonMetaModel
from helloasso_python.models.hello_asso_api_v5_models_enums_payment_frequency_type import HelloAssoApiV5ModelsEnumsPaymentFrequencyType
from helloasso_python.models.hello_asso_api_v5_models_enums_tier_type import HelloAssoApiV5ModelsEnumsTierType
from helloasso_python.models.hello_asso_api_v5_models_forms_term_model import HelloAssoApiV5ModelsFormsTermModel
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsFormsTierPublicModel(BaseModel):
    """
    TierPublicModel class
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="id")
    label: Optional[StrictStr] = Field(default=None, description="label")
    description: Optional[StrictStr] = Field(default=None, description="description")
    tier_type: Optional[HelloAssoApiV5ModelsEnumsTierType] = Field(default=None, alias="tierType")
    price: Optional[StrictInt] = Field(default=None, description="the Price in cents  if price equals 0 then it is free or there is a MinAmount")
    vat_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Vat rate if applicable  Amount have to be 0.10 for 10%", alias="vatRate")
    min_amount: Optional[StrictInt] = Field(default=None, description="If set, it means the payment is free to choose, according to the specified minAmount in cents", alias="minAmount")
    payment_frequency: Optional[HelloAssoApiV5ModelsEnumsPaymentFrequencyType] = Field(default=None, alias="paymentFrequency")
    max_per_user: Optional[StrictInt] = Field(default=None, description="Max quantity buyable in this cart", alias="maxPerUser")
    meta: Optional[HelloAssoApiV5ModelsCommonMetaModel] = None
    sale_start_date: Optional[datetime] = Field(default=None, description="The datetime (Inclusive) at which the users can start buying this tier.  If null the tier will be available at the start of the event.", alias="saleStartDate")
    sale_end_date: Optional[datetime] = Field(default=None, description="The datetime (Inclusive) at which the tier is no longer available.  If null the tier will be available until the end of the event.", alias="saleEndDate")
    is_eligible_tax_receipt: Optional[StrictBool] = Field(default=None, description="Whether this is eligible to a deduction", alias="isEligibleTaxReceipt")
    terms: Optional[List[HelloAssoApiV5ModelsFormsTermModel]] = Field(default=None, description="Terms of tier")
    picture: Optional[HelloAssoApiV5ModelsCommonDocumentModel] = None
    is_excluded_from_form_payment_terms: Optional[StrictBool] = Field(default=None, description="True means this tier must be paid in the initial payment, false means it can be paid in payment with installments  Null when the form payment terms are disabled or not compatible with the related form", alias="isExcludedFromFormPaymentTerms")
    __properties: ClassVar[List[str]] = ["id", "label", "description", "tierType", "price", "vatRate", "minAmount", "paymentFrequency", "maxPerUser", "meta", "saleStartDate", "saleEndDate", "isEligibleTaxReceipt", "terms", "picture", "isExcludedFromFormPaymentTerms"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsTierPublicModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in terms (list)
        _items = []
        if self.terms:
            for _item_terms in self.terms:
                if _item_terms:
                    _items.append(_item_terms.to_dict())
            _dict['terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of picture
        if self.picture:
            _dict['picture'] = self.picture.to_dict()
        # set to None if label (nullable) is None
        # and model_fields_set contains the field
        if self.label is None and "label" in self.model_fields_set:
            _dict['label'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if price (nullable) is None
        # and model_fields_set contains the field
        if self.price is None and "price" in self.model_fields_set:
            _dict['price'] = None

        # set to None if min_amount (nullable) is None
        # and model_fields_set contains the field
        if self.min_amount is None and "min_amount" in self.model_fields_set:
            _dict['minAmount'] = None

        # set to None if max_per_user (nullable) is None
        # and model_fields_set contains the field
        if self.max_per_user is None and "max_per_user" in self.model_fields_set:
            _dict['maxPerUser'] = None

        # set to None if sale_start_date (nullable) is None
        # and model_fields_set contains the field
        if self.sale_start_date is None and "sale_start_date" in self.model_fields_set:
            _dict['saleStartDate'] = None

        # set to None if sale_end_date (nullable) is None
        # and model_fields_set contains the field
        if self.sale_end_date is None and "sale_end_date" in self.model_fields_set:
            _dict['saleEndDate'] = None

        # set to None if terms (nullable) is None
        # and model_fields_set contains the field
        if self.terms is None and "terms" in self.model_fields_set:
            _dict['terms'] = None

        # set to None if is_excluded_from_form_payment_terms (nullable) is None
        # and model_fields_set contains the field
        if self.is_excluded_from_form_payment_terms is None and "is_excluded_from_form_payment_terms" in self.model_fields_set:
            _dict['isExcludedFromFormPaymentTerms'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsTierPublicModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "label": obj.get("label"),
            "description": obj.get("description"),
            "tierType": obj.get("tierType"),
            "price": obj.get("price"),
            "vatRate": obj.get("vatRate"),
            "minAmount": obj.get("minAmount"),
            "paymentFrequency": obj.get("paymentFrequency"),
            "maxPerUser": obj.get("maxPerUser"),
            "meta": HelloAssoApiV5ModelsCommonMetaModel.from_dict(obj["meta"]) if obj.get("meta") is not None else None,
            "saleStartDate": obj.get("saleStartDate"),
            "saleEndDate": obj.get("saleEndDate"),
            "isEligibleTaxReceipt": obj.get("isEligibleTaxReceipt"),
            "terms": [HelloAssoApiV5ModelsFormsTermModel.from_dict(_item) for _item in obj["terms"]] if obj.get("terms") is not None else None,
            "picture": HelloAssoApiV5ModelsCommonDocumentModel.from_dict(obj["picture"]) if obj.get("picture") is not None else None,
            "isExcludedFromFormPaymentTerms": obj.get("isExcludedFromFormPaymentTerms")
        })
        return _obj


