# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from helloasso_python.models.hello_asso_api_v5_models_common_contact_model import HelloAssoApiV5ModelsCommonContactModel
from helloasso_python.models.hello_asso_api_v5_models_common_place_model import HelloAssoApiV5ModelsCommonPlaceModel
from helloasso_python.models.hello_asso_api_v5_models_enums_membership_validity_type import HelloAssoApiV5ModelsEnumsMembershipValidityType
from helloasso_python.models.hello_asso_api_v5_models_forms_tier_light_model import HelloAssoApiV5ModelsFormsTierLightModel
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsFormsFormQuickCreateRequest(BaseModel):
    """
    HelloAssoApiV5ModelsFormsFormQuickCreateRequest
    """ # noqa: E501
    tier_list: Optional[List[HelloAssoApiV5ModelsFormsTierLightModel]] = Field(default=None, alias="tierList")
    banner: Optional[StrictStr] = Field(default=None, description="The banner of the form")
    description: Optional[StrictStr] = Field(default=None, description="The description of form")
    end_date: Optional[datetime] = Field(default=None, description="The datetime of the activity end", alias="endDate")
    logo: Optional[StrictStr] = Field(default=None, description="The logo of the form")
    private_title: Optional[StrictStr] = Field(default=None, description="Private Title : displayed only in the organization back office", alias="privateTitle")
    start_date: Optional[datetime] = Field(default=None, description="The datetime of the activity start", alias="startDate")
    title: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The title of the form. It will be used to generate the url which that can't be changed.")
    activity_type_id: Optional[StrictInt] = Field(default=None, description="Activity type identifier, matching one of the provided type values <a href=\"index#!/Values/Values_Get\"> provided here</a>", alias="activityTypeId")
    place: Optional[HelloAssoApiV5ModelsCommonPlaceModel] = None
    sale_end_date: Optional[datetime] = Field(default=None, description="The datetime (Inclusive) at which the sales end.  If null the orders will be available until the end of the campaign.", alias="saleEndDate")
    sale_start_date: Optional[datetime] = Field(default=None, description="The datetime (Inclusive) at which the users can start placing orders.  If null the orders will be available as soon as the campaign is published.", alias="saleStartDate")
    validity_type: Optional[HelloAssoApiV5ModelsEnumsMembershipValidityType] = Field(default=None, alias="validityType")
    accept_open_donation: Optional[StrictBool] = Field(default=None, description="Whether the user will be allowed to make a single open donation with an order. The amount of the donation is open, but 3 presets can be set in OpenDonationPresetAmount", alias="acceptOpenDonation")
    accept_open_monthly_donation: Optional[StrictBool] = Field(default=None, description="Whether the user will be allowed to make a monthly open donation for donation forms", alias="acceptOpenMonthlyDonation")
    allow_comment: Optional[StrictBool] = Field(default=None, description="allowComment", alias="allowComment")
    amount_visible: Optional[StrictBool] = Field(default=None, description="amountVisible", alias="amountVisible")
    color: Optional[StrictStr] = Field(default=None, description="The color of the form")
    widget_button_text: Optional[StrictStr] = Field(default=None, description="The text displayed in the widget button", alias="widgetButtonText")
    contact: Optional[HelloAssoApiV5ModelsCommonContactModel] = None
    display_contributor_name: Optional[StrictBool] = Field(default=None, description="Display contributor name for fundraiser", alias="displayContributorName")
    display_participants_count: Optional[StrictBool] = Field(default=None, description="Indicates that the members count must be displayed on the form.", alias="displayParticipantsCount")
    display_remaining_entries: Optional[StrictBool] = Field(default=None, description="Indicates that the remaining entries must be displayed on the form.", alias="displayRemainingEntries")
    financial_goal: Optional[StrictInt] = Field(default=None, description="Indicates the financial goal (amount of money raised) for the whole form. Null means no goal.", alias="financialGoal")
    generate_membership_cards: Optional[StrictBool] = Field(default=None, description="Entrust the issuance of membership cards to HelloAsso (automatically sent by email to participants)", alias="generateMembershipCards")
    generate_tickets: Optional[StrictBool] = Field(default=None, description="Entrust the issuance of tickets to HelloAsso (automatically sent by email to participants)", alias="generateTickets")
    invert_descriptions: Optional[StrictBool] = Field(default=None, description="Allows you to add the long description above the store catalog.", alias="invertDescriptions")
    label_conditions_and_terms_file: Optional[StrictStr] = Field(default=None, description="Label conditions and terms file", alias="labelConditionsAndTermsFile")
    long_description: Optional[StrictStr] = Field(default=None, description="The long description of the form (rich Html)", alias="longDescription")
    open_donation_preset_amounts: Optional[List[StrictInt]] = Field(default=None, description="The preset amounts to be shown to the user. Maximum 3 amounts.", alias="openDonationPresetAmounts")
    personalized_message: Optional[StrictStr] = Field(default=None, description="Personalized message for participants", alias="personalizedMessage")
    project_beneficiaries: Optional[StrictStr] = Field(default=None, description="The project beneficiaries of the form (rich Html)", alias="projectBeneficiaries")
    project_expenses_details: Optional[StrictStr] = Field(default=None, description="Details of the project expenses (rich Html)", alias="projectExpensesDetails")
    project_owners: Optional[StrictStr] = Field(default=None, description="Description of the project owners (rich Html)", alias="projectOwners")
    project_target_country: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=3)]] = Field(default=None, description="3 letter country code", alias="projectTargetCountry")
    allow_organism_payer: Optional[StrictBool] = Field(default=None, description="Whether users are allowed to contribute to this form through an organism (only for donation and crowdfunding).", alias="allowOrganismPayer")
    allow_individual_payer: Optional[StrictBool] = Field(default=None, description="Whether user are allowed to personally contribute to this form (only for donation and crowdfunding).", alias="allowIndividualPayer")
    max_entries: Optional[StrictInt] = Field(default=None, description="Indicates the maximum available entries for the whole form. Null means unlimited entries.", alias="maxEntries")
    __properties: ClassVar[List[str]] = ["tierList", "banner", "description", "endDate", "logo", "privateTitle", "startDate", "title", "activityTypeId", "place", "saleEndDate", "saleStartDate", "validityType", "acceptOpenDonation", "acceptOpenMonthlyDonation", "allowComment", "amountVisible", "color", "widgetButtonText", "contact", "displayContributorName", "displayParticipantsCount", "displayRemainingEntries", "financialGoal", "generateMembershipCards", "generateTickets", "invertDescriptions", "labelConditionsAndTermsFile", "longDescription", "openDonationPresetAmounts", "personalizedMessage", "projectBeneficiaries", "projectExpensesDetails", "projectOwners", "projectTargetCountry", "allowOrganismPayer", "allowIndividualPayer", "maxEntries"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsFormQuickCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tier_list (list)
        _items = []
        if self.tier_list:
            for _item_tier_list in self.tier_list:
                if _item_tier_list:
                    _items.append(_item_tier_list.to_dict())
            _dict['tierList'] = _items
        # override the default output from pydantic by calling `to_dict()` of place
        if self.place:
            _dict['place'] = self.place.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contact
        if self.contact:
            _dict['contact'] = self.contact.to_dict()
        # set to None if tier_list (nullable) is None
        # and model_fields_set contains the field
        if self.tier_list is None and "tier_list" in self.model_fields_set:
            _dict['tierList'] = None

        # set to None if banner (nullable) is None
        # and model_fields_set contains the field
        if self.banner is None and "banner" in self.model_fields_set:
            _dict['banner'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        # set to None if logo (nullable) is None
        # and model_fields_set contains the field
        if self.logo is None and "logo" in self.model_fields_set:
            _dict['logo'] = None

        # set to None if private_title (nullable) is None
        # and model_fields_set contains the field
        if self.private_title is None and "private_title" in self.model_fields_set:
            _dict['privateTitle'] = None

        # set to None if start_date (nullable) is None
        # and model_fields_set contains the field
        if self.start_date is None and "start_date" in self.model_fields_set:
            _dict['startDate'] = None

        # set to None if activity_type_id (nullable) is None
        # and model_fields_set contains the field
        if self.activity_type_id is None and "activity_type_id" in self.model_fields_set:
            _dict['activityTypeId'] = None

        # set to None if sale_end_date (nullable) is None
        # and model_fields_set contains the field
        if self.sale_end_date is None and "sale_end_date" in self.model_fields_set:
            _dict['saleEndDate'] = None

        # set to None if sale_start_date (nullable) is None
        # and model_fields_set contains the field
        if self.sale_start_date is None and "sale_start_date" in self.model_fields_set:
            _dict['saleStartDate'] = None

        # set to None if color (nullable) is None
        # and model_fields_set contains the field
        if self.color is None and "color" in self.model_fields_set:
            _dict['color'] = None

        # set to None if widget_button_text (nullable) is None
        # and model_fields_set contains the field
        if self.widget_button_text is None and "widget_button_text" in self.model_fields_set:
            _dict['widgetButtonText'] = None

        # set to None if financial_goal (nullable) is None
        # and model_fields_set contains the field
        if self.financial_goal is None and "financial_goal" in self.model_fields_set:
            _dict['financialGoal'] = None

        # set to None if label_conditions_and_terms_file (nullable) is None
        # and model_fields_set contains the field
        if self.label_conditions_and_terms_file is None and "label_conditions_and_terms_file" in self.model_fields_set:
            _dict['labelConditionsAndTermsFile'] = None

        # set to None if long_description (nullable) is None
        # and model_fields_set contains the field
        if self.long_description is None and "long_description" in self.model_fields_set:
            _dict['longDescription'] = None

        # set to None if open_donation_preset_amounts (nullable) is None
        # and model_fields_set contains the field
        if self.open_donation_preset_amounts is None and "open_donation_preset_amounts" in self.model_fields_set:
            _dict['openDonationPresetAmounts'] = None

        # set to None if personalized_message (nullable) is None
        # and model_fields_set contains the field
        if self.personalized_message is None and "personalized_message" in self.model_fields_set:
            _dict['personalizedMessage'] = None

        # set to None if project_beneficiaries (nullable) is None
        # and model_fields_set contains the field
        if self.project_beneficiaries is None and "project_beneficiaries" in self.model_fields_set:
            _dict['projectBeneficiaries'] = None

        # set to None if project_expenses_details (nullable) is None
        # and model_fields_set contains the field
        if self.project_expenses_details is None and "project_expenses_details" in self.model_fields_set:
            _dict['projectExpensesDetails'] = None

        # set to None if project_owners (nullable) is None
        # and model_fields_set contains the field
        if self.project_owners is None and "project_owners" in self.model_fields_set:
            _dict['projectOwners'] = None

        # set to None if project_target_country (nullable) is None
        # and model_fields_set contains the field
        if self.project_target_country is None and "project_target_country" in self.model_fields_set:
            _dict['projectTargetCountry'] = None

        # set to None if max_entries (nullable) is None
        # and model_fields_set contains the field
        if self.max_entries is None and "max_entries" in self.model_fields_set:
            _dict['maxEntries'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsFormQuickCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tierList": [HelloAssoApiV5ModelsFormsTierLightModel.from_dict(_item) for _item in obj["tierList"]] if obj.get("tierList") is not None else None,
            "banner": obj.get("banner"),
            "description": obj.get("description"),
            "endDate": obj.get("endDate"),
            "logo": obj.get("logo"),
            "privateTitle": obj.get("privateTitle"),
            "startDate": obj.get("startDate"),
            "title": obj.get("title"),
            "activityTypeId": obj.get("activityTypeId"),
            "place": HelloAssoApiV5ModelsCommonPlaceModel.from_dict(obj["place"]) if obj.get("place") is not None else None,
            "saleEndDate": obj.get("saleEndDate"),
            "saleStartDate": obj.get("saleStartDate"),
            "validityType": obj.get("validityType"),
            "acceptOpenDonation": obj.get("acceptOpenDonation"),
            "acceptOpenMonthlyDonation": obj.get("acceptOpenMonthlyDonation"),
            "allowComment": obj.get("allowComment"),
            "amountVisible": obj.get("amountVisible"),
            "color": obj.get("color"),
            "widgetButtonText": obj.get("widgetButtonText"),
            "contact": HelloAssoApiV5ModelsCommonContactModel.from_dict(obj["contact"]) if obj.get("contact") is not None else None,
            "displayContributorName": obj.get("displayContributorName"),
            "displayParticipantsCount": obj.get("displayParticipantsCount"),
            "displayRemainingEntries": obj.get("displayRemainingEntries"),
            "financialGoal": obj.get("financialGoal"),
            "generateMembershipCards": obj.get("generateMembershipCards"),
            "generateTickets": obj.get("generateTickets"),
            "invertDescriptions": obj.get("invertDescriptions"),
            "labelConditionsAndTermsFile": obj.get("labelConditionsAndTermsFile"),
            "longDescription": obj.get("longDescription"),
            "openDonationPresetAmounts": obj.get("openDonationPresetAmounts"),
            "personalizedMessage": obj.get("personalizedMessage"),
            "projectBeneficiaries": obj.get("projectBeneficiaries"),
            "projectExpensesDetails": obj.get("projectExpensesDetails"),
            "projectOwners": obj.get("projectOwners"),
            "projectTargetCountry": obj.get("projectTargetCountry"),
            "allowOrganismPayer": obj.get("allowOrganismPayer"),
            "allowIndividualPayer": obj.get("allowIndividualPayer"),
            "maxEntries": obj.get("maxEntries")
        })
        return _obj


