# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_enums_item_state import HelloAssoApiV5ModelsEnumsItemState
from helloasso_python.models.hello_asso_api_v5_models_enums_price_category import HelloAssoApiV5ModelsEnumsPriceCategory
from helloasso_python.models.hello_asso_api_v5_models_enums_tier_type import HelloAssoApiV5ModelsEnumsTierType
from helloasso_python.models.hello_asso_api_v5_models_statistics_item_custom_field import HelloAssoApiV5ModelsStatisticsItemCustomField
from helloasso_python.models.hello_asso_api_v5_models_statistics_item_discount import HelloAssoApiV5ModelsStatisticsItemDiscount
from helloasso_python.models.hello_asso_api_v5_models_statistics_item_option import HelloAssoApiV5ModelsStatisticsItemOption
from helloasso_python.models.hello_asso_api_v5_models_statistics_item_payment import HelloAssoApiV5ModelsStatisticsItemPayment
from helloasso_python.models.hello_asso_api_v5_models_statistics_order_light import HelloAssoApiV5ModelsStatisticsOrderLight
from helloasso_python.models.hello_asso_api_v5_models_statistics_payer import HelloAssoApiV5ModelsStatisticsPayer
from helloasso_python.models.hello_asso_api_v5_models_statistics_user import HelloAssoApiV5ModelsStatisticsUser
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsStatisticsItemDetail(BaseModel):
    """
    HelloAssoApiV5ModelsStatisticsItemDetail
    """ # noqa: E501
    order: Optional[HelloAssoApiV5ModelsStatisticsOrderLight] = None
    payer: Optional[HelloAssoApiV5ModelsStatisticsPayer] = None
    payments: Optional[List[HelloAssoApiV5ModelsStatisticsItemPayment]] = Field(default=None, description="Payments linked to this item")
    name: Optional[StrictStr] = None
    user: Optional[HelloAssoApiV5ModelsStatisticsUser] = None
    price_category: Optional[HelloAssoApiV5ModelsEnumsPriceCategory] = Field(default=None, alias="priceCategory")
    min_amount: Optional[StrictInt] = Field(default=None, description="Minimum amount that was specified on the tier (in cents)", alias="minAmount")
    discount: Optional[HelloAssoApiV5ModelsStatisticsItemDiscount] = None
    custom_fields: Optional[List[HelloAssoApiV5ModelsStatisticsItemCustomField]] = Field(default=None, description="Custom fields related to this item", alias="customFields")
    options: Optional[List[HelloAssoApiV5ModelsStatisticsItemOption]] = Field(default=None, description="Extra options taken with this item")
    ticket_url: Optional[StrictStr] = Field(default=None, description="The Ticket Url", alias="ticketUrl")
    qr_code: Optional[StrictStr] = Field(default=None, description="The item QrCode (for ticket scanning only)", alias="qrCode")
    membership_card_url: Optional[StrictStr] = Field(default=None, description="The Membership Card Url", alias="membershipCardUrl")
    day_of_levy: Optional[StrictInt] = Field(default=None, description="The day of levy for monthly donation only", alias="dayOfLevy")
    tier_description: Optional[StrictStr] = Field(default=None, description="Tier description", alias="tierDescription")
    tier_id: Optional[StrictInt] = Field(default=None, alias="tierId")
    comment: Optional[StrictStr] = None
    id: Optional[StrictInt] = Field(default=None, description="ID of the Item")
    amount: Optional[StrictInt] = Field(default=None, description="Total item Price in cents (after discount without extra options)")
    type: Optional[HelloAssoApiV5ModelsEnumsTierType] = None
    initial_amount: Optional[StrictInt] = Field(default=None, description="The raw amount (without reduction)", alias="initialAmount")
    state: Optional[HelloAssoApiV5ModelsEnumsItemState] = None
    __properties: ClassVar[List[str]] = ["order", "payer", "payments", "name", "user", "priceCategory", "minAmount", "discount", "customFields", "options", "ticketUrl", "qrCode", "membershipCardUrl", "dayOfLevy", "tierDescription", "tierId", "comment", "id", "amount", "type", "initialAmount", "state"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsItemDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['order'] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payer
        if self.payer:
            _dict['payer'] = self.payer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item_payments in self.payments:
                if _item_payments:
                    _items.append(_item_payments.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of discount
        if self.discount:
            _dict['discount'] = self.discount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in custom_fields (list)
        _items = []
        if self.custom_fields:
            for _item_custom_fields in self.custom_fields:
                if _item_custom_fields:
                    _items.append(_item_custom_fields.to_dict())
            _dict['customFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in options (list)
        _items = []
        if self.options:
            for _item_options in self.options:
                if _item_options:
                    _items.append(_item_options.to_dict())
            _dict['options'] = _items
        # set to None if payments (nullable) is None
        # and model_fields_set contains the field
        if self.payments is None and "payments" in self.model_fields_set:
            _dict['payments'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if min_amount (nullable) is None
        # and model_fields_set contains the field
        if self.min_amount is None and "min_amount" in self.model_fields_set:
            _dict['minAmount'] = None

        # set to None if custom_fields (nullable) is None
        # and model_fields_set contains the field
        if self.custom_fields is None and "custom_fields" in self.model_fields_set:
            _dict['customFields'] = None

        # set to None if options (nullable) is None
        # and model_fields_set contains the field
        if self.options is None and "options" in self.model_fields_set:
            _dict['options'] = None

        # set to None if ticket_url (nullable) is None
        # and model_fields_set contains the field
        if self.ticket_url is None and "ticket_url" in self.model_fields_set:
            _dict['ticketUrl'] = None

        # set to None if qr_code (nullable) is None
        # and model_fields_set contains the field
        if self.qr_code is None and "qr_code" in self.model_fields_set:
            _dict['qrCode'] = None

        # set to None if membership_card_url (nullable) is None
        # and model_fields_set contains the field
        if self.membership_card_url is None and "membership_card_url" in self.model_fields_set:
            _dict['membershipCardUrl'] = None

        # set to None if day_of_levy (nullable) is None
        # and model_fields_set contains the field
        if self.day_of_levy is None and "day_of_levy" in self.model_fields_set:
            _dict['dayOfLevy'] = None

        # set to None if tier_description (nullable) is None
        # and model_fields_set contains the field
        if self.tier_description is None and "tier_description" in self.model_fields_set:
            _dict['tierDescription'] = None

        # set to None if tier_id (nullable) is None
        # and model_fields_set contains the field
        if self.tier_id is None and "tier_id" in self.model_fields_set:
            _dict['tierId'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if initial_amount (nullable) is None
        # and model_fields_set contains the field
        if self.initial_amount is None and "initial_amount" in self.model_fields_set:
            _dict['initialAmount'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsItemDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "order": HelloAssoApiV5ModelsStatisticsOrderLight.from_dict(obj["order"]) if obj.get("order") is not None else None,
            "payer": HelloAssoApiV5ModelsStatisticsPayer.from_dict(obj["payer"]) if obj.get("payer") is not None else None,
            "payments": [HelloAssoApiV5ModelsStatisticsItemPayment.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "name": obj.get("name"),
            "user": HelloAssoApiV5ModelsStatisticsUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "priceCategory": obj.get("priceCategory"),
            "minAmount": obj.get("minAmount"),
            "discount": HelloAssoApiV5ModelsStatisticsItemDiscount.from_dict(obj["discount"]) if obj.get("discount") is not None else None,
            "customFields": [HelloAssoApiV5ModelsStatisticsItemCustomField.from_dict(_item) for _item in obj["customFields"]] if obj.get("customFields") is not None else None,
            "options": [HelloAssoApiV5ModelsStatisticsItemOption.from_dict(_item) for _item in obj["options"]] if obj.get("options") is not None else None,
            "ticketUrl": obj.get("ticketUrl"),
            "qrCode": obj.get("qrCode"),
            "membershipCardUrl": obj.get("membershipCardUrl"),
            "dayOfLevy": obj.get("dayOfLevy"),
            "tierDescription": obj.get("tierDescription"),
            "tierId": obj.get("tierId"),
            "comment": obj.get("comment"),
            "id": obj.get("id"),
            "amount": obj.get("amount"),
            "type": obj.get("type"),
            "initialAmount": obj.get("initialAmount"),
            "state": obj.get("state")
        })
        return _obj


