# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsDirectoryListOrganizationsRequest(BaseModel):
    """
    HelloAssoApiV5ModelsDirectoryListOrganizationsRequest
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Textual search for organization name")
    description: Optional[StrictStr] = Field(default=None, description="Textual search for organization description")
    categories: Optional[List[StrictStr]] = Field(default=None, description="The categories of the organizations")
    types: Optional[List[StrictStr]] = Field(default=None, description="The organization types")
    zip_codes: Optional[List[StrictStr]] = Field(default=None, description="The zip codes where the organizations are located", alias="zipCodes")
    cities: Optional[List[StrictStr]] = Field(default=None, description="The cities where the organizations are located")
    regions: Optional[List[StrictStr]] = Field(default=None, description="The regions where the organizations are located")
    departments: Optional[List[StrictStr]] = Field(default=None, description="The departments where the organizations are located")
    fiscal_receipt_eligibility: Optional[StrictBool] = Field(default=None, description="Allow only organization with a fiscal receipt eligibility", alias="fiscalReceiptEligibility")
    internal_tags: Optional[List[StrictStr]] = Field(default=None, description="Allow only Organization with internal tags  this filter is for special operations only", alias="internalTags")
    tags: Optional[List[StrictStr]] = Field(default=None, description="Allow only Organization with public tags")
    linked_partners: Optional[List[StrictStr]] = Field(default=None, description="Allow only Organization with linked partners", alias="linkedPartners")
    __properties: ClassVar[List[str]] = ["name", "description", "categories", "types", "zipCodes", "cities", "regions", "departments", "fiscalReceiptEligibility", "internalTags", "tags", "linkedPartners"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsDirectoryListOrganizationsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if categories (nullable) is None
        # and model_fields_set contains the field
        if self.categories is None and "categories" in self.model_fields_set:
            _dict['categories'] = None

        # set to None if types (nullable) is None
        # and model_fields_set contains the field
        if self.types is None and "types" in self.model_fields_set:
            _dict['types'] = None

        # set to None if zip_codes (nullable) is None
        # and model_fields_set contains the field
        if self.zip_codes is None and "zip_codes" in self.model_fields_set:
            _dict['zipCodes'] = None

        # set to None if cities (nullable) is None
        # and model_fields_set contains the field
        if self.cities is None and "cities" in self.model_fields_set:
            _dict['cities'] = None

        # set to None if regions (nullable) is None
        # and model_fields_set contains the field
        if self.regions is None and "regions" in self.model_fields_set:
            _dict['regions'] = None

        # set to None if departments (nullable) is None
        # and model_fields_set contains the field
        if self.departments is None and "departments" in self.model_fields_set:
            _dict['departments'] = None

        # set to None if fiscal_receipt_eligibility (nullable) is None
        # and model_fields_set contains the field
        if self.fiscal_receipt_eligibility is None and "fiscal_receipt_eligibility" in self.model_fields_set:
            _dict['fiscalReceiptEligibility'] = None

        # set to None if internal_tags (nullable) is None
        # and model_fields_set contains the field
        if self.internal_tags is None and "internal_tags" in self.model_fields_set:
            _dict['internalTags'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if linked_partners (nullable) is None
        # and model_fields_set contains the field
        if self.linked_partners is None and "linked_partners" in self.model_fields_set:
            _dict['linkedPartners'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsDirectoryListOrganizationsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "categories": obj.get("categories"),
            "types": obj.get("types"),
            "zipCodes": obj.get("zipCodes"),
            "cities": obj.get("cities"),
            "regions": obj.get("regions"),
            "departments": obj.get("departments"),
            "fiscalReceiptEligibility": obj.get("fiscalReceiptEligibility"),
            "internalTags": obj.get("internalTags"),
            "tags": obj.get("tags"),
            "linkedPartners": obj.get("linkedPartners")
        })
        return _obj


