# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from helloasso_python.models.hello_asso_api_v5_models_enums_form_type import HelloAssoApiV5ModelsEnumsFormType
from helloasso_python.models.hello_asso_api_v5_models_enums_item_state import HelloAssoApiV5ModelsEnumsItemState
from helloasso_python.models.hello_asso_api_v5_models_enums_sort_field import HelloAssoApiV5ModelsEnumsSortField
from helloasso_python.models.hello_asso_api_v5_models_enums_sort_order import HelloAssoApiV5ModelsEnumsSortOrder
from helloasso_python.models.hello_asso_api_v5_models_enums_tier_type import HelloAssoApiV5ModelsEnumsTierType
from helloasso_python.models.hello_asso_api_v5_models_statistics_item_detail import HelloAssoApiV5ModelsStatisticsItemDetail
from helloasso_python.models.hello_asso_api_v5_models_statistics_order_detail import HelloAssoApiV5ModelsStatisticsOrderDetail
from helloasso_python.models.results_with_pagination_model_order import ResultsWithPaginationModelOrder

from helloasso_python.api_client import ApiClient, RequestSerialized
from helloasso_python.api_response import ApiResponse
from helloasso_python.rest import RESTResponseType


class CommandesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def items_item_id_get(
        self,
        item_id: Annotated[StrictInt, Field(description="The item ID")],
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields and Options")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> HelloAssoApiV5ModelsStatisticsItemDetail:
        """Obtenir le détail d'un article contenu dans une commande

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param item_id: The item ID (required)
        :type item_id: int
        :param with_details: Set to true to return CustomFields and Options
        :type with_details: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._items_item_id_get_serialize(
            item_id=item_id,
            with_details=with_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HelloAssoApiV5ModelsStatisticsItemDetail",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def items_item_id_get_with_http_info(
        self,
        item_id: Annotated[StrictInt, Field(description="The item ID")],
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields and Options")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[HelloAssoApiV5ModelsStatisticsItemDetail]:
        """Obtenir le détail d'un article contenu dans une commande

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param item_id: The item ID (required)
        :type item_id: int
        :param with_details: Set to true to return CustomFields and Options
        :type with_details: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._items_item_id_get_serialize(
            item_id=item_id,
            with_details=with_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HelloAssoApiV5ModelsStatisticsItemDetail",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def items_item_id_get_without_preload_content(
        self,
        item_id: Annotated[StrictInt, Field(description="The item ID")],
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields and Options")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Obtenir le détail d'un article contenu dans une commande

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param item_id: The item ID (required)
        :type item_id: int
        :param with_details: Set to true to return CustomFields and Options
        :type with_details: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._items_item_id_get_serialize(
            item_id=item_id,
            with_details=with_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HelloAssoApiV5ModelsStatisticsItemDetail",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _items_item_id_get_serialize(
        self,
        item_id,
        with_details,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        # process the query parameters
        if with_details is not None:
            
            _query_params.append(('withDetails', with_details))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/items/{itemId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def orders_order_id_cancel_post(
        self,
        order_id: Annotated[StrictInt, Field(description="The order identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Annuler les paiements futurs pour une commande (pas de remboursement).

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>OrganizationAdmin<br/>FormAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> RefundManagement<br/><br/>

        :param order_id: The order identifier. (required)
        :type order_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_order_id_cancel_post_serialize(
            order_id=order_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def orders_order_id_cancel_post_with_http_info(
        self,
        order_id: Annotated[StrictInt, Field(description="The order identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Annuler les paiements futurs pour une commande (pas de remboursement).

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>OrganizationAdmin<br/>FormAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> RefundManagement<br/><br/>

        :param order_id: The order identifier. (required)
        :type order_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_order_id_cancel_post_serialize(
            order_id=order_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def orders_order_id_cancel_post_without_preload_content(
        self,
        order_id: Annotated[StrictInt, Field(description="The order identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Annuler les paiements futurs pour une commande (pas de remboursement).

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>OrganizationAdmin<br/>FormAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> RefundManagement<br/><br/>

        :param order_id: The order identifier. (required)
        :type order_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_order_id_cancel_post_serialize(
            order_id=order_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _orders_order_id_cancel_post_serialize(
        self,
        order_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['orderId'] = order_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/orders/{orderId}/cancel',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def orders_order_id_get(
        self,
        order_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> HelloAssoApiV5ModelsStatisticsOrderDetail:
        """Obtenir des informations détaillées sur une commande

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param order_id: (required)
        :type order_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_order_id_get_serialize(
            order_id=order_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HelloAssoApiV5ModelsStatisticsOrderDetail",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def orders_order_id_get_with_http_info(
        self,
        order_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[HelloAssoApiV5ModelsStatisticsOrderDetail]:
        """Obtenir des informations détaillées sur une commande

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param order_id: (required)
        :type order_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_order_id_get_serialize(
            order_id=order_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HelloAssoApiV5ModelsStatisticsOrderDetail",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def orders_order_id_get_without_preload_content(
        self,
        order_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Obtenir des informations détaillées sur une commande

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param order_id: (required)
        :type order_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_order_id_get_serialize(
            order_id=order_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HelloAssoApiV5ModelsStatisticsOrderDetail",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _orders_order_id_get_serialize(
        self,
        order_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['orderId'] = order_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/orders/{orderId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def organizations_organization_slug_forms_form_type_form_slug_items_get(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        form_slug: Annotated[StrictStr, Field(description="The form slug")],
        form_type: Annotated[HelloAssoApiV5ModelsEnumsFormType, Field(description="The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        tier_types: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsTierType]], Field(description="The type of tiers")] = None,
        item_states: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsItemState]], Field(description="The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid")] = None,
        tier_name: Annotated[Optional[StrictStr], Field(description="The name of a tier")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields and Options")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort forms items by ascending or descending order. Default is descending")] = None,
        sort_field: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortField], Field(description="Sort forms items by a specific field (Date or UpdateDate). Default is date")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Obtenir une liste d'articles vendus dans un formulaire

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param form_slug: The form slug (required)
        :type form_slug: str
        :param form_type: The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop (required)
        :type form_type: HelloAssoApiV5ModelsEnumsFormType
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param tier_types: The type of tiers
        :type tier_types: List[HelloAssoApiV5ModelsEnumsTierType]
        :param item_states: The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid
        :type item_states: List[HelloAssoApiV5ModelsEnumsItemState]
        :param tier_name: The name of a tier
        :type tier_name: str
        :param with_details: Set to true to return CustomFields and Options
        :type with_details: bool
        :param sort_order: Sort forms items by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param sort_field: Sort forms items by a specific field (Date or UpdateDate). Default is date
        :type sort_field: HelloAssoApiV5ModelsEnumsSortField
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_forms_form_type_form_slug_items_get_serialize(
            organization_slug=organization_slug,
            form_slug=form_slug,
            form_type=form_type,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            tier_types=tier_types,
            item_states=item_states,
            tier_name=tier_name,
            with_details=with_details,
            sort_order=sort_order,
            sort_field=sort_field,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def organizations_organization_slug_forms_form_type_form_slug_items_get_with_http_info(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        form_slug: Annotated[StrictStr, Field(description="The form slug")],
        form_type: Annotated[HelloAssoApiV5ModelsEnumsFormType, Field(description="The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        tier_types: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsTierType]], Field(description="The type of tiers")] = None,
        item_states: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsItemState]], Field(description="The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid")] = None,
        tier_name: Annotated[Optional[StrictStr], Field(description="The name of a tier")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields and Options")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort forms items by ascending or descending order. Default is descending")] = None,
        sort_field: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortField], Field(description="Sort forms items by a specific field (Date or UpdateDate). Default is date")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Obtenir une liste d'articles vendus dans un formulaire

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param form_slug: The form slug (required)
        :type form_slug: str
        :param form_type: The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop (required)
        :type form_type: HelloAssoApiV5ModelsEnumsFormType
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param tier_types: The type of tiers
        :type tier_types: List[HelloAssoApiV5ModelsEnumsTierType]
        :param item_states: The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid
        :type item_states: List[HelloAssoApiV5ModelsEnumsItemState]
        :param tier_name: The name of a tier
        :type tier_name: str
        :param with_details: Set to true to return CustomFields and Options
        :type with_details: bool
        :param sort_order: Sort forms items by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param sort_field: Sort forms items by a specific field (Date or UpdateDate). Default is date
        :type sort_field: HelloAssoApiV5ModelsEnumsSortField
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_forms_form_type_form_slug_items_get_serialize(
            organization_slug=organization_slug,
            form_slug=form_slug,
            form_type=form_type,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            tier_types=tier_types,
            item_states=item_states,
            tier_name=tier_name,
            with_details=with_details,
            sort_order=sort_order,
            sort_field=sort_field,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def organizations_organization_slug_forms_form_type_form_slug_items_get_without_preload_content(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        form_slug: Annotated[StrictStr, Field(description="The form slug")],
        form_type: Annotated[HelloAssoApiV5ModelsEnumsFormType, Field(description="The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        tier_types: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsTierType]], Field(description="The type of tiers")] = None,
        item_states: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsItemState]], Field(description="The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid")] = None,
        tier_name: Annotated[Optional[StrictStr], Field(description="The name of a tier")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields and Options")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort forms items by ascending or descending order. Default is descending")] = None,
        sort_field: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortField], Field(description="Sort forms items by a specific field (Date or UpdateDate). Default is date")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Obtenir une liste d'articles vendus dans un formulaire

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param form_slug: The form slug (required)
        :type form_slug: str
        :param form_type: The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop (required)
        :type form_type: HelloAssoApiV5ModelsEnumsFormType
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param tier_types: The type of tiers
        :type tier_types: List[HelloAssoApiV5ModelsEnumsTierType]
        :param item_states: The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid
        :type item_states: List[HelloAssoApiV5ModelsEnumsItemState]
        :param tier_name: The name of a tier
        :type tier_name: str
        :param with_details: Set to true to return CustomFields and Options
        :type with_details: bool
        :param sort_order: Sort forms items by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param sort_field: Sort forms items by a specific field (Date or UpdateDate). Default is date
        :type sort_field: HelloAssoApiV5ModelsEnumsSortField
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_forms_form_type_form_slug_items_get_serialize(
            organization_slug=organization_slug,
            form_slug=form_slug,
            form_type=form_type,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            tier_types=tier_types,
            item_states=item_states,
            tier_name=tier_name,
            with_details=with_details,
            sort_order=sort_order,
            sort_field=sort_field,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _organizations_organization_slug_forms_form_type_form_slug_items_get_serialize(
        self,
        organization_slug,
        form_slug,
        form_type,
        var_from,
        to,
        user_search_key,
        page_index,
        page_size,
        continuation_token,
        tier_types,
        item_states,
        tier_name,
        with_details,
        sort_order,
        sort_field,
        with_count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'tierTypes': 'multi',
            'itemStates': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_slug is not None:
            _path_params['organizationSlug'] = organization_slug
        if form_slug is not None:
            _path_params['formSlug'] = form_slug
        if form_type is not None:
            _path_params['formType'] = form_type.value
        # process the query parameters
        if var_from is not None:
            if isinstance(var_from, datetime):
                _query_params.append(
                    (
                        'from',
                        var_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('from', var_from))
            
        if to is not None:
            if isinstance(to, datetime):
                _query_params.append(
                    (
                        'to',
                        to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('to', to))
            
        if user_search_key is not None:
            
            _query_params.append(('userSearchKey', user_search_key))
            
        if page_index is not None:
            
            _query_params.append(('pageIndex', page_index))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if continuation_token is not None:
            
            _query_params.append(('continuationToken', continuation_token))
            
        if tier_types is not None:
            
            _query_params.append(('tierTypes', tier_types))
            
        if item_states is not None:
            
            _query_params.append(('itemStates', item_states))
            
        if tier_name is not None:
            
            _query_params.append(('tierName', tier_name))
            
        if with_details is not None:
            
            _query_params.append(('withDetails', with_details))
            
        if sort_order is not None:
            
            _query_params.append(('sortOrder', sort_order.value))
            
        if sort_field is not None:
            
            _query_params.append(('sortField', sort_field.value))
            
        if with_count is not None:
            
            _query_params.append(('withCount', with_count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'text/csv'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/organizations/{organizationSlug}/forms/{formType}/{formSlug}/items',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def organizations_organization_slug_forms_form_type_form_slug_orders_get(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        form_slug: Annotated[StrictStr, Field(description="The form slug")],
        form_type: Annotated[HelloAssoApiV5ModelsEnumsFormType, Field(description="The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort forms orders by ascending or descending order. Default is descending")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ResultsWithPaginationModelOrder:
        """Obtenir les commandes d'un formulaire

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param form_slug: The form slug (required)
        :type form_slug: str
        :param form_type: The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop (required)
        :type form_type: HelloAssoApiV5ModelsEnumsFormType
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param with_details: Set to true to return CustomFields
        :type with_details: bool
        :param sort_order: Sort forms orders by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_forms_form_type_form_slug_orders_get_serialize(
            organization_slug=organization_slug,
            form_slug=form_slug,
            form_type=form_type,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            with_details=with_details,
            sort_order=sort_order,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelOrder",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def organizations_organization_slug_forms_form_type_form_slug_orders_get_with_http_info(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        form_slug: Annotated[StrictStr, Field(description="The form slug")],
        form_type: Annotated[HelloAssoApiV5ModelsEnumsFormType, Field(description="The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort forms orders by ascending or descending order. Default is descending")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ResultsWithPaginationModelOrder]:
        """Obtenir les commandes d'un formulaire

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param form_slug: The form slug (required)
        :type form_slug: str
        :param form_type: The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop (required)
        :type form_type: HelloAssoApiV5ModelsEnumsFormType
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param with_details: Set to true to return CustomFields
        :type with_details: bool
        :param sort_order: Sort forms orders by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_forms_form_type_form_slug_orders_get_serialize(
            organization_slug=organization_slug,
            form_slug=form_slug,
            form_type=form_type,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            with_details=with_details,
            sort_order=sort_order,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelOrder",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def organizations_organization_slug_forms_form_type_form_slug_orders_get_without_preload_content(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        form_slug: Annotated[StrictStr, Field(description="The form slug")],
        form_type: Annotated[HelloAssoApiV5ModelsEnumsFormType, Field(description="The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort forms orders by ascending or descending order. Default is descending")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Obtenir les commandes d'un formulaire

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>FormAdmin<br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param form_slug: The form slug (required)
        :type form_slug: str
        :param form_type: The form type CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop (required)
        :type form_type: HelloAssoApiV5ModelsEnumsFormType
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param with_details: Set to true to return CustomFields
        :type with_details: bool
        :param sort_order: Sort forms orders by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_forms_form_type_form_slug_orders_get_serialize(
            organization_slug=organization_slug,
            form_slug=form_slug,
            form_type=form_type,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            with_details=with_details,
            sort_order=sort_order,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelOrder",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _organizations_organization_slug_forms_form_type_form_slug_orders_get_serialize(
        self,
        organization_slug,
        form_slug,
        form_type,
        var_from,
        to,
        user_search_key,
        page_index,
        page_size,
        continuation_token,
        with_details,
        sort_order,
        with_count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_slug is not None:
            _path_params['organizationSlug'] = organization_slug
        if form_slug is not None:
            _path_params['formSlug'] = form_slug
        if form_type is not None:
            _path_params['formType'] = form_type.value
        # process the query parameters
        if var_from is not None:
            if isinstance(var_from, datetime):
                _query_params.append(
                    (
                        'from',
                        var_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('from', var_from))
            
        if to is not None:
            if isinstance(to, datetime):
                _query_params.append(
                    (
                        'to',
                        to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('to', to))
            
        if user_search_key is not None:
            
            _query_params.append(('userSearchKey', user_search_key))
            
        if page_index is not None:
            
            _query_params.append(('pageIndex', page_index))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if continuation_token is not None:
            
            _query_params.append(('continuationToken', continuation_token))
            
        if with_details is not None:
            
            _query_params.append(('withDetails', with_details))
            
        if sort_order is not None:
            
            _query_params.append(('sortOrder', sort_order.value))
            
        if with_count is not None:
            
            _query_params.append(('withCount', with_count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/organizations/{organizationSlug}/forms/{formType}/{formSlug}/orders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def organizations_organization_slug_items_get(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        tier_types: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsTierType]], Field(description="The type of tiers Donation, Payment, Registration, Membership, MonthlyDonation, MonthlyPayment, OfflineDonation, Contribution, Bonus")] = None,
        item_states: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsItemState]], Field(description="The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid")] = None,
        tier_name: Annotated[Optional[StrictStr], Field(description="The name of a tier")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields and Options")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort organizations items by ascending or descending order. Default is descending")] = None,
        sort_field: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortField], Field(description="Sort organizations items by a specific field (Date or UpdateDate). Default is date")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Obtenir une liste d'articles vendus par une organisation

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param tier_types: The type of tiers Donation, Payment, Registration, Membership, MonthlyDonation, MonthlyPayment, OfflineDonation, Contribution, Bonus
        :type tier_types: List[HelloAssoApiV5ModelsEnumsTierType]
        :param item_states: The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid
        :type item_states: List[HelloAssoApiV5ModelsEnumsItemState]
        :param tier_name: The name of a tier
        :type tier_name: str
        :param with_details: Set to true to return CustomFields and Options
        :type with_details: bool
        :param sort_order: Sort organizations items by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param sort_field: Sort organizations items by a specific field (Date or UpdateDate). Default is date
        :type sort_field: HelloAssoApiV5ModelsEnumsSortField
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_items_get_serialize(
            organization_slug=organization_slug,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            tier_types=tier_types,
            item_states=item_states,
            tier_name=tier_name,
            with_details=with_details,
            sort_order=sort_order,
            sort_field=sort_field,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def organizations_organization_slug_items_get_with_http_info(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        tier_types: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsTierType]], Field(description="The type of tiers Donation, Payment, Registration, Membership, MonthlyDonation, MonthlyPayment, OfflineDonation, Contribution, Bonus")] = None,
        item_states: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsItemState]], Field(description="The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid")] = None,
        tier_name: Annotated[Optional[StrictStr], Field(description="The name of a tier")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields and Options")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort organizations items by ascending or descending order. Default is descending")] = None,
        sort_field: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortField], Field(description="Sort organizations items by a specific field (Date or UpdateDate). Default is date")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Obtenir une liste d'articles vendus par une organisation

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param tier_types: The type of tiers Donation, Payment, Registration, Membership, MonthlyDonation, MonthlyPayment, OfflineDonation, Contribution, Bonus
        :type tier_types: List[HelloAssoApiV5ModelsEnumsTierType]
        :param item_states: The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid
        :type item_states: List[HelloAssoApiV5ModelsEnumsItemState]
        :param tier_name: The name of a tier
        :type tier_name: str
        :param with_details: Set to true to return CustomFields and Options
        :type with_details: bool
        :param sort_order: Sort organizations items by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param sort_field: Sort organizations items by a specific field (Date or UpdateDate). Default is date
        :type sort_field: HelloAssoApiV5ModelsEnumsSortField
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_items_get_serialize(
            organization_slug=organization_slug,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            tier_types=tier_types,
            item_states=item_states,
            tier_name=tier_name,
            with_details=with_details,
            sort_order=sort_order,
            sort_field=sort_field,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def organizations_organization_slug_items_get_without_preload_content(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        tier_types: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsTierType]], Field(description="The type of tiers Donation, Payment, Registration, Membership, MonthlyDonation, MonthlyPayment, OfflineDonation, Contribution, Bonus")] = None,
        item_states: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsItemState]], Field(description="The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid")] = None,
        tier_name: Annotated[Optional[StrictStr], Field(description="The name of a tier")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields and Options")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort organizations items by ascending or descending order. Default is descending")] = None,
        sort_field: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortField], Field(description="Sort organizations items by a specific field (Date or UpdateDate). Default is date")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Obtenir une liste d'articles vendus par une organisation

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param tier_types: The type of tiers Donation, Payment, Registration, Membership, MonthlyDonation, MonthlyPayment, OfflineDonation, Contribution, Bonus
        :type tier_types: List[HelloAssoApiV5ModelsEnumsTierType]
        :param item_states: The item states  Available values: * `Processed` - The item is paid and is valid * `Registered` - The item has been registered manually by the organization and is valid * `Unknown` * `Canceled` - The item has been canceled, and is no longer valid
        :type item_states: List[HelloAssoApiV5ModelsEnumsItemState]
        :param tier_name: The name of a tier
        :type tier_name: str
        :param with_details: Set to true to return CustomFields and Options
        :type with_details: bool
        :param sort_order: Sort organizations items by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param sort_field: Sort organizations items by a specific field (Date or UpdateDate). Default is date
        :type sort_field: HelloAssoApiV5ModelsEnumsSortField
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_items_get_serialize(
            organization_slug=organization_slug,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            tier_types=tier_types,
            item_states=item_states,
            tier_name=tier_name,
            with_details=with_details,
            sort_order=sort_order,
            sort_field=sort_field,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _organizations_organization_slug_items_get_serialize(
        self,
        organization_slug,
        var_from,
        to,
        user_search_key,
        page_index,
        page_size,
        continuation_token,
        tier_types,
        item_states,
        tier_name,
        with_details,
        sort_order,
        sort_field,
        with_count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'tierTypes': 'multi',
            'itemStates': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_slug is not None:
            _path_params['organizationSlug'] = organization_slug
        # process the query parameters
        if var_from is not None:
            if isinstance(var_from, datetime):
                _query_params.append(
                    (
                        'from',
                        var_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('from', var_from))
            
        if to is not None:
            if isinstance(to, datetime):
                _query_params.append(
                    (
                        'to',
                        to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('to', to))
            
        if user_search_key is not None:
            
            _query_params.append(('userSearchKey', user_search_key))
            
        if page_index is not None:
            
            _query_params.append(('pageIndex', page_index))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if continuation_token is not None:
            
            _query_params.append(('continuationToken', continuation_token))
            
        if tier_types is not None:
            
            _query_params.append(('tierTypes', tier_types))
            
        if item_states is not None:
            
            _query_params.append(('itemStates', item_states))
            
        if tier_name is not None:
            
            _query_params.append(('tierName', tier_name))
            
        if with_details is not None:
            
            _query_params.append(('withDetails', with_details))
            
        if sort_order is not None:
            
            _query_params.append(('sortOrder', sort_order.value))
            
        if sort_field is not None:
            
            _query_params.append(('sortField', sort_field.value))
            
        if with_count is not None:
            
            _query_params.append(('withCount', with_count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'text/csv'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/organizations/{organizationSlug}/items',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def organizations_organization_slug_orders_get(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        form_types: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsFormType]], Field(description="The type of the form CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort organizations orders by ascending or descending order. Default is descending")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ResultsWithPaginationModelOrder:
        """Obtenir les commandes d'une organisation

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param form_types: The type of the form CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop
        :type form_types: List[HelloAssoApiV5ModelsEnumsFormType]
        :param with_details: Set to true to return CustomFields
        :type with_details: bool
        :param sort_order: Sort organizations orders by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_orders_get_serialize(
            organization_slug=organization_slug,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            form_types=form_types,
            with_details=with_details,
            sort_order=sort_order,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelOrder",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def organizations_organization_slug_orders_get_with_http_info(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        form_types: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsFormType]], Field(description="The type of the form CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort organizations orders by ascending or descending order. Default is descending")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ResultsWithPaginationModelOrder]:
        """Obtenir les commandes d'une organisation

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param form_types: The type of the form CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop
        :type form_types: List[HelloAssoApiV5ModelsEnumsFormType]
        :param with_details: Set to true to return CustomFields
        :type with_details: bool
        :param sort_order: Sort organizations orders by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_orders_get_serialize(
            organization_slug=organization_slug,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            form_types=form_types,
            with_details=with_details,
            sort_order=sort_order,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelOrder",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def organizations_organization_slug_orders_get_without_preload_content(
        self,
        organization_slug: Annotated[StrictStr, Field(description="The organization slug")],
        var_from: Annotated[Optional[datetime], Field(description="First Date Filter")] = None,
        to: Annotated[Optional[datetime], Field(description="End Date Filter (exclusive)")] = None,
        user_search_key: Annotated[Optional[StrictStr], Field(description="Filter results on user or payer first name, last name or email")] = None,
        page_index: Annotated[Optional[StrictInt], Field(description="The page of results to retrieve")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        form_types: Annotated[Optional[List[HelloAssoApiV5ModelsEnumsFormType]], Field(description="The type of the form CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop")] = None,
        with_details: Annotated[Optional[StrictBool], Field(description="Set to true to return CustomFields")] = None,
        sort_order: Annotated[Optional[HelloAssoApiV5ModelsEnumsSortOrder], Field(description="Sort organizations orders by ascending or descending order. Default is descending")] = None,
        with_count: Annotated[Optional[StrictBool], Field(description="Whether the pagination should include totalCount and totalPages.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Obtenir les commandes d'une organisation

        <br/><br/><b>Votre token doit avoir l'un de ces rôles : </b><br/>OrganizationAdmin<br/><br/>Si vous êtes une <b>association</b>, vous pouvez obtenir ces rôles avec votre client.<br/>Si vous êtes un <b>partenaire</b>, vous pouvez obtenir ces rôles par le flux d'autorisation.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> AccessTransactions<br/><br/>

        :param organization_slug: The organization slug (required)
        :type organization_slug: str
        :param var_from: First Date Filter
        :type var_from: datetime
        :param to: End Date Filter (exclusive)
        :type to: datetime
        :param user_search_key: Filter results on user or payer first name, last name or email
        :type user_search_key: str
        :param page_index: The page of results to retrieve
        :type page_index: int
        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param form_types: The type of the form CrowdFunding, Membership, Event, Donation, PaymentForm, Checkout, Shop
        :type form_types: List[HelloAssoApiV5ModelsEnumsFormType]
        :param with_details: Set to true to return CustomFields
        :type with_details: bool
        :param sort_order: Sort organizations orders by ascending or descending order. Default is descending
        :type sort_order: HelloAssoApiV5ModelsEnumsSortOrder
        :param with_count: Whether the pagination should include totalCount and totalPages.
        :type with_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organizations_organization_slug_orders_get_serialize(
            organization_slug=organization_slug,
            var_from=var_from,
            to=to,
            user_search_key=user_search_key,
            page_index=page_index,
            page_size=page_size,
            continuation_token=continuation_token,
            form_types=form_types,
            with_details=with_details,
            sort_order=sort_order,
            with_count=with_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelOrder",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _organizations_organization_slug_orders_get_serialize(
        self,
        organization_slug,
        var_from,
        to,
        user_search_key,
        page_index,
        page_size,
        continuation_token,
        form_types,
        with_details,
        sort_order,
        with_count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'formTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_slug is not None:
            _path_params['organizationSlug'] = organization_slug
        # process the query parameters
        if var_from is not None:
            if isinstance(var_from, datetime):
                _query_params.append(
                    (
                        'from',
                        var_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('from', var_from))
            
        if to is not None:
            if isinstance(to, datetime):
                _query_params.append(
                    (
                        'to',
                        to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('to', to))
            
        if user_search_key is not None:
            
            _query_params.append(('userSearchKey', user_search_key))
            
        if page_index is not None:
            
            _query_params.append(('pageIndex', page_index))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if continuation_token is not None:
            
            _query_params.append(('continuationToken', continuation_token))
            
        if form_types is not None:
            
            _query_params.append(('formTypes', form_types))
            
        if with_details is not None:
            
            _query_params.append(('withDetails', with_details))
            
        if sort_order is not None:
            
            _query_params.append(('sortOrder', sort_order.value))
            
        if with_count is not None:
            
            _query_params.append(('withCount', with_count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/organizations/{organizationSlug}/orders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


