# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_accounts_clients_api_client_model import HelloAssoApiV5ModelsAccountsClientsApiClientModel
from helloasso_python.models.hello_asso_api_v5_models_api_notifications_api_url_notification_model import HelloAssoApiV5ModelsApiNotificationsApiUrlNotificationModel
from helloasso_python.models.hello_asso_api_v5_models_partner_statistics_model import HelloAssoApiV5ModelsPartnerStatisticsModel
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsPartnersPartnerPublicModel(BaseModel):
    """
    HelloAssoApiV5ModelsPartnersPartnerPublicModel
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name of the partner")
    display_name: Optional[StrictStr] = Field(default=None, description="Display Name of the partner", alias="displayName")
    description: Optional[StrictStr] = Field(default=None, description="Description of the partner")
    url: Optional[StrictStr] = Field(default=None, description="Website of the partner")
    logo: Optional[StrictStr] = Field(default=None, description="Logo of the partner : square format")
    logo_rectangle: Optional[StrictStr] = Field(default=None, description="Logo of the partner : rectangle format", alias="logoRectangle")
    api_client: Optional[HelloAssoApiV5ModelsAccountsClientsApiClientModel] = Field(default=None, alias="apiClient")
    url_notification_list: Optional[List[HelloAssoApiV5ModelsApiNotificationsApiUrlNotificationModel]] = Field(default=None, description="Url Notification of the partner", alias="urlNotificationList")
    partner_statistics: Optional[HelloAssoApiV5ModelsPartnerStatisticsModel] = Field(default=None, alias="partnerStatistics")
    __properties: ClassVar[List[str]] = ["name", "displayName", "description", "url", "logo", "logoRectangle", "apiClient", "urlNotificationList", "partnerStatistics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsPartnersPartnerPublicModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of api_client
        if self.api_client:
            _dict['apiClient'] = self.api_client.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in url_notification_list (list)
        _items = []
        if self.url_notification_list:
            for _item_url_notification_list in self.url_notification_list:
                if _item_url_notification_list:
                    _items.append(_item_url_notification_list.to_dict())
            _dict['urlNotificationList'] = _items
        # override the default output from pydantic by calling `to_dict()` of partner_statistics
        if self.partner_statistics:
            _dict['partnerStatistics'] = self.partner_statistics.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if logo (nullable) is None
        # and model_fields_set contains the field
        if self.logo is None and "logo" in self.model_fields_set:
            _dict['logo'] = None

        # set to None if logo_rectangle (nullable) is None
        # and model_fields_set contains the field
        if self.logo_rectangle is None and "logo_rectangle" in self.model_fields_set:
            _dict['logoRectangle'] = None

        # set to None if url_notification_list (nullable) is None
        # and model_fields_set contains the field
        if self.url_notification_list is None and "url_notification_list" in self.model_fields_set:
            _dict['urlNotificationList'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsPartnersPartnerPublicModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "logo": obj.get("logo"),
            "logoRectangle": obj.get("logoRectangle"),
            "apiClient": HelloAssoApiV5ModelsAccountsClientsApiClientModel.from_dict(obj["apiClient"]) if obj.get("apiClient") is not None else None,
            "urlNotificationList": [HelloAssoApiV5ModelsApiNotificationsApiUrlNotificationModel.from_dict(_item) for _item in obj["urlNotificationList"]] if obj.get("urlNotificationList") is not None else None,
            "partnerStatistics": HelloAssoApiV5ModelsPartnerStatisticsModel.from_dict(obj["partnerStatistics"]) if obj.get("partnerStatistics") is not None else None
        })
        return _obj


