# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_enums_price_category import HelloAssoApiV5ModelsEnumsPriceCategory
from helloasso_python.models.hello_asso_api_v5_models_statistics_item_custom_field import HelloAssoApiV5ModelsStatisticsItemCustomField
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsStatisticsItemOption(BaseModel):
    """
    ItemOption class
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name of the option")
    amount: Optional[StrictInt] = Field(default=None, description="Amount of the option in cents")
    price_category: Optional[HelloAssoApiV5ModelsEnumsPriceCategory] = Field(default=None, alias="priceCategory")
    is_required: Optional[StrictBool] = Field(default=None, description="Option is required or optional", alias="isRequired")
    custom_fields: Optional[List[HelloAssoApiV5ModelsStatisticsItemCustomField]] = Field(default=None, description="Custom fields related to this option", alias="customFields")
    option_id: Optional[StrictInt] = Field(default=None, alias="optionId")
    __properties: ClassVar[List[str]] = ["name", "amount", "priceCategory", "isRequired", "customFields", "optionId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsItemOption from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_fields (list)
        _items = []
        if self.custom_fields:
            for _item_custom_fields in self.custom_fields:
                if _item_custom_fields:
                    _items.append(_item_custom_fields.to_dict())
            _dict['customFields'] = _items
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if custom_fields (nullable) is None
        # and model_fields_set contains the field
        if self.custom_fields is None and "custom_fields" in self.model_fields_set:
            _dict['customFields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsItemOption from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "amount": obj.get("amount"),
            "priceCategory": obj.get("priceCategory"),
            "isRequired": obj.get("isRequired"),
            "customFields": [HelloAssoApiV5ModelsStatisticsItemCustomField.from_dict(_item) for _item in obj["customFields"]] if obj.get("customFields") is not None else None,
            "optionId": obj.get("optionId")
        })
        return _obj


