# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_common_meta_model import HelloAssoApiV5ModelsCommonMetaModel
from helloasso_python.models.hello_asso_api_v5_models_enums_payment_cash_out_state import HelloAssoApiV5ModelsEnumsPaymentCashOutState
from helloasso_python.models.hello_asso_api_v5_models_enums_payment_means import HelloAssoApiV5ModelsEnumsPaymentMeans
from helloasso_python.models.hello_asso_api_v5_models_enums_payment_state import HelloAssoApiV5ModelsEnumsPaymentState
from helloasso_python.models.hello_asso_api_v5_models_enums_payment_type import HelloAssoApiV5ModelsEnumsPaymentType
from helloasso_python.models.hello_asso_api_v5_models_statistics_refund_operation_light_model import HelloAssoApiV5ModelsStatisticsRefundOperationLightModel
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsStatisticsItemPayment(BaseModel):
    """
    Payment linked to the item
    """ # noqa: E501
    cash_out_state: Optional[HelloAssoApiV5ModelsEnumsPaymentCashOutState] = Field(default=None, alias="cashOutState")
    share_amount: Optional[StrictInt] = Field(default=None, description="Amount of the item and extra options payed on this payment term (in cents)", alias="shareAmount")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the payment")
    amount: Optional[StrictInt] = Field(default=None, description="Total Amount of the payment (in cents)")
    amount_tip: Optional[StrictInt] = Field(default=None, description="Tip Amount of the payment (in cents)", alias="amountTip")
    var_date: Optional[datetime] = Field(default=None, description="Date of the payment", alias="date")
    payment_means: Optional[HelloAssoApiV5ModelsEnumsPaymentMeans] = Field(default=None, alias="paymentMeans")
    installment_number: Optional[StrictInt] = Field(default=None, description="Indicates the payment number (useful in the case of an order comprising payments with installments)", alias="installmentNumber")
    state: Optional[HelloAssoApiV5ModelsEnumsPaymentState] = None
    type: Optional[HelloAssoApiV5ModelsEnumsPaymentType] = None
    meta: Optional[HelloAssoApiV5ModelsCommonMetaModel] = None
    payment_off_line_mean: Optional[HelloAssoApiV5ModelsEnumsPaymentMeans] = Field(default=None, alias="paymentOffLineMean")
    refund_operations: Optional[List[HelloAssoApiV5ModelsStatisticsRefundOperationLightModel]] = Field(default=None, description="The refund operations information for the specific payment.", alias="refundOperations")
    __properties: ClassVar[List[str]] = ["cashOutState", "shareAmount", "id", "amount", "amountTip", "date", "paymentMeans", "installmentNumber", "state", "type", "meta", "paymentOffLineMean", "refundOperations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsItemPayment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in refund_operations (list)
        _items = []
        if self.refund_operations:
            for _item_refund_operations in self.refund_operations:
                if _item_refund_operations:
                    _items.append(_item_refund_operations.to_dict())
            _dict['refundOperations'] = _items
        # set to None if amount_tip (nullable) is None
        # and model_fields_set contains the field
        if self.amount_tip is None and "amount_tip" in self.model_fields_set:
            _dict['amountTip'] = None

        # set to None if installment_number (nullable) is None
        # and model_fields_set contains the field
        if self.installment_number is None and "installment_number" in self.model_fields_set:
            _dict['installmentNumber'] = None

        # set to None if refund_operations (nullable) is None
        # and model_fields_set contains the field
        if self.refund_operations is None and "refund_operations" in self.model_fields_set:
            _dict['refundOperations'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsItemPayment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cashOutState": obj.get("cashOutState"),
            "shareAmount": obj.get("shareAmount"),
            "id": obj.get("id"),
            "amount": obj.get("amount"),
            "amountTip": obj.get("amountTip"),
            "date": obj.get("date"),
            "paymentMeans": obj.get("paymentMeans"),
            "installmentNumber": obj.get("installmentNumber"),
            "state": obj.get("state"),
            "type": obj.get("type"),
            "meta": HelloAssoApiV5ModelsCommonMetaModel.from_dict(obj["meta"]) if obj.get("meta") is not None else None,
            "paymentOffLineMean": obj.get("paymentOffLineMean"),
            "refundOperations": [HelloAssoApiV5ModelsStatisticsRefundOperationLightModel.from_dict(_item) for _item in obj["refundOperations"]] if obj.get("refundOperations") is not None else None
        })
        return _obj


