# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_common_meta_model import HelloAssoApiV5ModelsCommonMetaModel
from helloasso_python.models.hello_asso_api_v5_models_common_place_model import HelloAssoApiV5ModelsCommonPlaceModel
from helloasso_python.models.hello_asso_api_v5_models_enums_form_type import HelloAssoApiV5ModelsEnumsFormType
from helloasso_python.models.hello_asso_api_v5_models_enums_organization_type import HelloAssoApiV5ModelsEnumsOrganizationType
from helloasso_python.models.hello_asso_api_v5_models_statistics_order_amount_model import HelloAssoApiV5ModelsStatisticsOrderAmountModel
from helloasso_python.models.hello_asso_api_v5_models_statistics_order_item import HelloAssoApiV5ModelsStatisticsOrderItem
from helloasso_python.models.hello_asso_api_v5_models_statistics_order_payment import HelloAssoApiV5ModelsStatisticsOrderPayment
from helloasso_python.models.hello_asso_api_v5_models_statistics_payer import HelloAssoApiV5ModelsStatisticsPayer
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsStatisticsOrder(BaseModel):
    """
    HelloAssoApiV5ModelsStatisticsOrder
    """ # noqa: E501
    payer: Optional[HelloAssoApiV5ModelsStatisticsPayer] = None
    items: Optional[List[HelloAssoApiV5ModelsStatisticsOrderItem]] = Field(default=None, description="All items of the order")
    payments: Optional[List[HelloAssoApiV5ModelsStatisticsOrderPayment]] = Field(default=None, description="All payments of the order")
    amount: Optional[HelloAssoApiV5ModelsStatisticsOrderAmountModel] = None
    id: Optional[StrictInt] = Field(default=None, description="The ID of the Order")
    var_date: Optional[datetime] = Field(default=None, description="Order creation date", alias="date")
    form_slug: Optional[StrictStr] = Field(default=None, description="FormSlug (lowercase name of the form without special characters)", alias="formSlug")
    form_type: Optional[HelloAssoApiV5ModelsEnumsFormType] = Field(default=None, alias="formType")
    organization_name: Optional[StrictStr] = Field(default=None, description="The organization name.", alias="organizationName")
    organization_slug: Optional[StrictStr] = Field(default=None, description="OrganizationSlug (lowercase name of the organization without special characters)", alias="organizationSlug")
    organization_type: Optional[HelloAssoApiV5ModelsEnumsOrganizationType] = Field(default=None, alias="organizationType")
    organization_is_under_coluche_law: Optional[StrictBool] = Field(default=None, description="Whether or not the organization is subject to the coluche law", alias="organizationIsUnderColucheLaw")
    checkout_intent_id: Optional[StrictInt] = Field(default=None, description="Checkout intent Id if available", alias="checkoutIntentId")
    meta: Optional[HelloAssoApiV5ModelsCommonMetaModel] = None
    place: Optional[HelloAssoApiV5ModelsCommonPlaceModel] = None
    __properties: ClassVar[List[str]] = ["payer", "items", "payments", "amount", "id", "date", "formSlug", "formType", "organizationName", "organizationSlug", "organizationType", "organizationIsUnderColucheLaw", "checkoutIntentId", "meta", "place"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payer
        if self.payer:
            _dict['payer'] = self.payer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item_payments in self.payments:
                if _item_payments:
                    _items.append(_item_payments.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict['amount'] = self.amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of place
        if self.place:
            _dict['place'] = self.place.to_dict()
        # set to None if items (nullable) is None
        # and model_fields_set contains the field
        if self.items is None and "items" in self.model_fields_set:
            _dict['items'] = None

        # set to None if payments (nullable) is None
        # and model_fields_set contains the field
        if self.payments is None and "payments" in self.model_fields_set:
            _dict['payments'] = None

        # set to None if form_slug (nullable) is None
        # and model_fields_set contains the field
        if self.form_slug is None and "form_slug" in self.model_fields_set:
            _dict['formSlug'] = None

        # set to None if organization_name (nullable) is None
        # and model_fields_set contains the field
        if self.organization_name is None and "organization_name" in self.model_fields_set:
            _dict['organizationName'] = None

        # set to None if organization_slug (nullable) is None
        # and model_fields_set contains the field
        if self.organization_slug is None and "organization_slug" in self.model_fields_set:
            _dict['organizationSlug'] = None

        # set to None if checkout_intent_id (nullable) is None
        # and model_fields_set contains the field
        if self.checkout_intent_id is None and "checkout_intent_id" in self.model_fields_set:
            _dict['checkoutIntentId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "payer": HelloAssoApiV5ModelsStatisticsPayer.from_dict(obj["payer"]) if obj.get("payer") is not None else None,
            "items": [HelloAssoApiV5ModelsStatisticsOrderItem.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "payments": [HelloAssoApiV5ModelsStatisticsOrderPayment.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "amount": HelloAssoApiV5ModelsStatisticsOrderAmountModel.from_dict(obj["amount"]) if obj.get("amount") is not None else None,
            "id": obj.get("id"),
            "date": obj.get("date"),
            "formSlug": obj.get("formSlug"),
            "formType": obj.get("formType"),
            "organizationName": obj.get("organizationName"),
            "organizationSlug": obj.get("organizationSlug"),
            "organizationType": obj.get("organizationType"),
            "organizationIsUnderColucheLaw": obj.get("organizationIsUnderColucheLaw"),
            "checkoutIntentId": obj.get("checkoutIntentId"),
            "meta": HelloAssoApiV5ModelsCommonMetaModel.from_dict(obj["meta"]) if obj.get("meta") is not None else None,
            "place": HelloAssoApiV5ModelsCommonPlaceModel.from_dict(obj["place"]) if obj.get("place") is not None else None
        })
        return _obj


