# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsCommonPaginationModel(BaseModel):
    """
    Pagination model class
    """ # noqa: E501
    page_size: Optional[StrictInt] = Field(default=None, description="Page size", alias="pageSize")
    total_count: Optional[StrictInt] = Field(default=None, description="Total number of results available", alias="totalCount")
    page_index: Optional[StrictInt] = Field(default=None, description="Current page index", alias="pageIndex")
    total_pages: Optional[StrictInt] = Field(default=None, description="Total number of pages of results with current page size", alias="totalPages")
    continuation_token: Optional[StrictStr] = Field(default=None, description="Continuation Token to get next results", alias="continuationToken")
    __properties: ClassVar[List[str]] = ["pageSize", "totalCount", "pageIndex", "totalPages", "continuationToken"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsCommonPaginationModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if continuation_token (nullable) is None
        # and model_fields_set contains the field
        if self.continuation_token is None and "continuation_token" in self.model_fields_set:
            _dict['continuationToken'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsCommonPaginationModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pageSize": obj.get("pageSize"),
            "totalCount": obj.get("totalCount"),
            "pageIndex": obj.get("pageIndex"),
            "totalPages": obj.get("totalPages"),
            "continuationToken": obj.get("continuationToken")
        })
        return _obj


