# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from helloasso_python.models.hello_asso_api_v5_models_forms_custom_field_public_model import HelloAssoApiV5ModelsFormsCustomFieldPublicModel
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsFormsExtraOptionPublicModel(BaseModel):
    """
    ExtraOptionFullModel
    """ # noqa: E501
    custom_fields: Optional[List[HelloAssoApiV5ModelsFormsCustomFieldPublicModel]] = Field(default=None, description="List of custom fields to be filled by the user", alias="customFields")
    id: Optional[StrictInt] = Field(default=None, description="Id")
    price: Optional[StrictInt] = Field(default=None, description="Price of the extraOption, can be free")
    vat_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Vat rate if applicable  Amount have to be 0.10 for 10%", alias="vatRate")
    label: Optional[StrictStr] = Field(default=None, description="The name of the option")
    description: Optional[StrictStr] = Field(default=None, description="The description of the option")
    is_required: Optional[StrictBool] = Field(default=None, description="Additional option is required/mandatory", alias="isRequired")
    __properties: ClassVar[List[str]] = ["customFields", "id", "price", "vatRate", "label", "description", "isRequired"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsExtraOptionPublicModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_required",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_fields (list)
        _items = []
        if self.custom_fields:
            for _item_custom_fields in self.custom_fields:
                if _item_custom_fields:
                    _items.append(_item_custom_fields.to_dict())
            _dict['customFields'] = _items
        # set to None if custom_fields (nullable) is None
        # and model_fields_set contains the field
        if self.custom_fields is None and "custom_fields" in self.model_fields_set:
            _dict['customFields'] = None

        # set to None if label (nullable) is None
        # and model_fields_set contains the field
        if self.label is None and "label" in self.model_fields_set:
            _dict['label'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsExtraOptionPublicModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customFields": [HelloAssoApiV5ModelsFormsCustomFieldPublicModel.from_dict(_item) for _item in obj["customFields"]] if obj.get("customFields") is not None else None,
            "id": obj.get("id"),
            "price": obj.get("price"),
            "vatRate": obj.get("vatRate"),
            "label": obj.get("label"),
            "description": obj.get("description"),
            "isRequired": obj.get("isRequired")
        })
        return _obj


