# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_enums_field_type import HelloAssoApiV5ModelsEnumsFieldType
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsFormsCustomFieldPublicModel(BaseModel):
    """
    A custom field can be assigned to a Tier or an ExtraOption  It is used to give extra information during the reservation of a tier
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Id of the customField")
    values: Optional[List[StrictStr]] = Field(default=None, description="The list of possible values if type is a CHOICE_LIST")
    is_required: Optional[StrictBool] = Field(default=None, description="True if the custom field must be filled by the user before validating a cart", alias="isRequired")
    type: Optional[HelloAssoApiV5ModelsEnumsFieldType] = None
    label: Optional[StrictStr] = Field(default=None, description="The label to be displayed to the user")
    __properties: ClassVar[List[str]] = ["id", "values", "isRequired", "type", "label"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsCustomFieldPublicModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "values",
            "is_required",
            "label",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if values (nullable) is None
        # and model_fields_set contains the field
        if self.values is None and "values" in self.model_fields_set:
            _dict['values'] = None

        # set to None if label (nullable) is None
        # and model_fields_set contains the field
        if self.label is None and "label" in self.model_fields_set:
            _dict['label'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsCustomFieldPublicModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "values": obj.get("values"),
            "isRequired": obj.get("isRequired"),
            "type": obj.get("type"),
            "label": obj.get("label")
        })
        return _obj


