"""
    HelloSign API

    HelloSign v3 API  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Contact: apisupport@hellosign.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from metadict import MetaDict

from hellosign_sdk.api_client import ApiClient, ApiException, Endpoint as _Endpoint
from hellosign_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from hellosign_sdk.model.error_response import ErrorResponse
from hellosign_sdk.model.unclaimed_draft_create_embedded_request import UnclaimedDraftCreateEmbeddedRequest
from hellosign_sdk.model.unclaimed_draft_create_embedded_with_template_request import UnclaimedDraftCreateEmbeddedWithTemplateRequest
from hellosign_sdk.model.unclaimed_draft_create_request import UnclaimedDraftCreateRequest
from hellosign_sdk.model.unclaimed_draft_create_response import UnclaimedDraftCreateResponse
from hellosign_sdk.model.unclaimed_draft_edit_and_resend_request import UnclaimedDraftEditAndResendRequest


class UnclaimedDraftApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.unclaimed_draft_create_endpoint = _Endpoint(
            settings={
                'response_type': (UnclaimedDraftCreateResponse,),
                'auth': [
                    'api_key',
                    'oauth2'
                ],
                'endpoint_path': '/unclaimed_draft/create',
                'operation_id': 'unclaimed_draft_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'unclaimed_draft_create_request',
                ],
                'required': [
                    'unclaimed_draft_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'unclaimed_draft_create_request':
                        (UnclaimedDraftCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'unclaimed_draft_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.unclaimed_draft_create_embedded_endpoint = _Endpoint(
            settings={
                'response_type': (UnclaimedDraftCreateResponse,),
                'auth': [
                    'api_key',
                    'oauth2'
                ],
                'endpoint_path': '/unclaimed_draft/create_embedded',
                'operation_id': 'unclaimed_draft_create_embedded',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'unclaimed_draft_create_embedded_request',
                ],
                'required': [
                    'unclaimed_draft_create_embedded_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'unclaimed_draft_create_embedded_request':
                        (UnclaimedDraftCreateEmbeddedRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'unclaimed_draft_create_embedded_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.unclaimed_draft_create_embedded_with_template_endpoint = _Endpoint(
            settings={
                'response_type': (UnclaimedDraftCreateResponse,),
                'auth': [
                    'api_key',
                    'oauth2'
                ],
                'endpoint_path': '/unclaimed_draft/create_embedded_with_template',
                'operation_id': 'unclaimed_draft_create_embedded_with_template',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'unclaimed_draft_create_embedded_with_template_request',
                ],
                'required': [
                    'unclaimed_draft_create_embedded_with_template_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'unclaimed_draft_create_embedded_with_template_request':
                        (UnclaimedDraftCreateEmbeddedWithTemplateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'unclaimed_draft_create_embedded_with_template_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.unclaimed_draft_edit_and_resend_endpoint = _Endpoint(
            settings={
                'response_type': (UnclaimedDraftCreateResponse,),
                'auth': [
                    'api_key',
                    'oauth2'
                ],
                'endpoint_path': '/unclaimed_draft/edit_and_resend/{signature_request_id}',
                'operation_id': 'unclaimed_draft_edit_and_resend',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'signature_request_id',
                    'unclaimed_draft_edit_and_resend_request',
                ],
                'required': [
                    'signature_request_id',
                    'unclaimed_draft_edit_and_resend_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'signature_request_id':
                        (str,),
                    'unclaimed_draft_edit_and_resend_request':
                        (UnclaimedDraftEditAndResendRequest,),
                },
                'attribute_map': {
                    'signature_request_id': 'signature_request_id',
                },
                'location_map': {
                    'signature_request_id': 'path',
                    'unclaimed_draft_edit_and_resend_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def unclaimed_draft_create(
        self,
        unclaimed_draft_create_request,
        **kwargs
    ):
        """Create Unclaimed Draft  # noqa: E501

        Creates a new Draft that can be claimed using the claim URL. The first authenticated user to access the URL will claim the Draft and will be shown either the \"Sign and send\" or the \"Request signature\" page with the Draft loaded. Subsequent access to the claim URL will result in a 404.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unclaimed_draft_create(unclaimed_draft_create_request, async_req=True)
        >>> result = thread.get()

        Args:
            unclaimed_draft_create_request (UnclaimedDraftCreateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UnclaimedDraftCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['unclaimed_draft_create_request'] = \
            unclaimed_draft_create_request
        try:
            return self.unclaimed_draft_create_endpoint.call_with_http_info(**kwargs)
        except ApiException as e:
            if e.status == 200:
                e.body = self.api_client.deserialize(
                    response=MetaDict({'data': e.body}),
                    response_type=[UnclaimedDraftCreateResponse],
                    _check_type=True,
                )

                raise e
            range_code = "4XX"[0]
            range_code_left = int(f"{range_code}00")
            range_code_right = int(f"{range_code}99")

            if range_code_left <= e.status <= range_code_right:
                e.body = self.api_client.deserialize(
                    response=MetaDict({'data': e.body}),
                    response_type=[ErrorResponse],
                    _check_type=True,
                )

                raise e

    def unclaimed_draft_create_embedded(
        self,
        unclaimed_draft_create_embedded_request,
        **kwargs
    ):
        """Create Embedded Unclaimed Draft  # noqa: E501

        Creates a new Draft that can be claimed and used in an embedded iFrame. The first authenticated user to access the URL will claim the Draft and will be shown the \"Request signature\" page with the Draft loaded. Subsequent access to the claim URL will result in a `404`. For this embedded endpoint the `requester_email_address` parameter is required.  **NOTE**: Embedded unclaimed drafts can only be accessed in embedded iFrames whereas normal drafts can be used and accessed on HelloSign.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unclaimed_draft_create_embedded(unclaimed_draft_create_embedded_request, async_req=True)
        >>> result = thread.get()

        Args:
            unclaimed_draft_create_embedded_request (UnclaimedDraftCreateEmbeddedRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UnclaimedDraftCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['unclaimed_draft_create_embedded_request'] = \
            unclaimed_draft_create_embedded_request
        try:
            return self.unclaimed_draft_create_embedded_endpoint.call_with_http_info(**kwargs)
        except ApiException as e:
            if e.status == 200:
                e.body = self.api_client.deserialize(
                    response=MetaDict({'data': e.body}),
                    response_type=[UnclaimedDraftCreateResponse],
                    _check_type=True,
                )

                raise e
            range_code = "4XX"[0]
            range_code_left = int(f"{range_code}00")
            range_code_right = int(f"{range_code}99")

            if range_code_left <= e.status <= range_code_right:
                e.body = self.api_client.deserialize(
                    response=MetaDict({'data': e.body}),
                    response_type=[ErrorResponse],
                    _check_type=True,
                )

                raise e

    def unclaimed_draft_create_embedded_with_template(
        self,
        unclaimed_draft_create_embedded_with_template_request,
        **kwargs
    ):
        """Create Embedded Unclaimed Draft with Template  # noqa: E501

        Creates a new Draft with a previously saved template(s) that can be claimed and used in an embedded iFrame. The first authenticated user to access the URL will claim the Draft and will be shown the \"Request signature\" page with the Draft loaded. Subsequent access to the claim URL will result in a `404`. For this embedded endpoint the `requester_email_address` parameter is required.  **NOTE**: Embedded unclaimed drafts can only be accessed in embedded iFrames whereas normal drafts can be used and accessed on HelloSign.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unclaimed_draft_create_embedded_with_template(unclaimed_draft_create_embedded_with_template_request, async_req=True)
        >>> result = thread.get()

        Args:
            unclaimed_draft_create_embedded_with_template_request (UnclaimedDraftCreateEmbeddedWithTemplateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UnclaimedDraftCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['unclaimed_draft_create_embedded_with_template_request'] = \
            unclaimed_draft_create_embedded_with_template_request
        try:
            return self.unclaimed_draft_create_embedded_with_template_endpoint.call_with_http_info(**kwargs)
        except ApiException as e:
            if e.status == 200:
                e.body = self.api_client.deserialize(
                    response=MetaDict({'data': e.body}),
                    response_type=[UnclaimedDraftCreateResponse],
                    _check_type=True,
                )

                raise e
            range_code = "4XX"[0]
            range_code_left = int(f"{range_code}00")
            range_code_right = int(f"{range_code}99")

            if range_code_left <= e.status <= range_code_right:
                e.body = self.api_client.deserialize(
                    response=MetaDict({'data': e.body}),
                    response_type=[ErrorResponse],
                    _check_type=True,
                )

                raise e

    def unclaimed_draft_edit_and_resend(
        self,
        signature_request_id,
        unclaimed_draft_edit_and_resend_request,
        **kwargs
    ):
        """Edit and Resend Unclaimed Draft  # noqa: E501

        Creates a new signature request from an embedded request that can be edited prior to being sent to the recipients. Parameter `test_mode` can be edited prior to request. Signers can be edited in embedded editor. Requester's email address will remain unchanged if `requester_email_address` parameter is not set.  **NOTE**: Embedded unclaimed drafts can only be accessed in embedded iFrames whereas normal drafts can be used and accessed on HelloSign.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unclaimed_draft_edit_and_resend(signature_request_id, unclaimed_draft_edit_and_resend_request, async_req=True)
        >>> result = thread.get()

        Args:
            signature_request_id (str): The ID of the signature request to edit and resend.
            unclaimed_draft_edit_and_resend_request (UnclaimedDraftEditAndResendRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UnclaimedDraftCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['signature_request_id'] = \
            signature_request_id
        kwargs['unclaimed_draft_edit_and_resend_request'] = \
            unclaimed_draft_edit_and_resend_request
        try:
            return self.unclaimed_draft_edit_and_resend_endpoint.call_with_http_info(**kwargs)
        except ApiException as e:
            if e.status == 200:
                e.body = self.api_client.deserialize(
                    response=MetaDict({'data': e.body}),
                    response_type=[UnclaimedDraftCreateResponse],
                    _check_type=True,
                )

                raise e
            range_code = "4XX"[0]
            range_code_left = int(f"{range_code}00")
            range_code_right = int(f"{range_code}99")

            if range_code_left <= e.status <= range_code_right:
                e.body = self.api_client.deserialize(
                    response=MetaDict({'data': e.body}),
                    response_type=[ErrorResponse],
                    _check_type=True,
                )

                raise e

