# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import transaction_pb2 as transaction__pb2
from . import transaction_response_pb2 as transaction__response__pb2

GRPC_GENERATED_VERSION = '1.68.1'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in address_book_service_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class AddressBookServiceStub(object):
    """*
    The Address Book service provides the ability for Hedera network node
    administrators to add, update, and remove consensus nodes. This addition,
    update, or removal of a consensus node requires governing council approval,
    but each node operator may update their own operational attributes without
    additional approval, reducing overhead for routine operations.

    Most operations are `privileged operations` and require governing council
    approval.

    ### For a node creation transaction.
    - The node operator SHALL create a `createNode` transaction.
    - The node operator SHALL sign this transaction with the active `key` for
    the account to be assigned as the "node account".
    - The node operator MUST deliver the signed transaction to the Hedera
    council representative.
    - The Hedera council representative SHALL arrange for council members to
    review and sign the transaction.
    - Once sufficient council members have signed the transaction, the
    Hedera council representative SHALL submit the transaction to the
    network.
    - Upon receipt of a valid and signed node creation transaction the network
    software SHALL
    - Validate the threshold signature for the Hedera governing council
    - Validate the signature of the active `key` for the account to be
    assigned as the "node account".
    - Create the new node in state, this new node SHALL NOT be active in the
    network at this time.
    - When executing the next `freeze` transaction with `freeze_type` set to
    `PREPARE_UPGRADE`, update network configuration and bring the
    new node to an active status within the network. The node to be added
    SHALL be active in the network following this upgrade.

    ### For a node deletion transaction.
    - The node operator or Hedera council representative SHALL create a
    `deleteNode` transaction.
    - If the node operator creates the transaction
    - The node operator MUST sign this transaction with the active `key`
    for the account assigned as the "node account".
    - The node operator SHALL deliver the signed transaction to the Hedera
    council representative.
    - The Hedera council representative SHALL arrange for council members to
    review and sign the transaction.
    - Once sufficient council members have signed the transaction, the
    Hedera council representative SHALL submit the transaction to the
    network.
    - Upon receipt of a valid and signed node deletion transaction the network
    software SHALL
    - Validate the threshold signature for the Hedera governing council
    - Remove the existing node from network state. The node SHALL still
    be active in the network at this time.
    - When executing the next `freeze` transaction with `freeze_type` set to
    `PREPARE_UPGRADE`, update network configuration and remove the
    node to be deleted from the network. The node to be deleted SHALL NOT
    be active in the network following this upgrade.

    ### For a node update transaction.
    - The node operator SHALL create an `updateNode` transaction.
    - The node operator MUST sign this transaction with the active `key`
    assigned as the `admin_key`.
    - The node operator SHALL submit the transaction to the
    network.  Hedera council approval SHALL NOT be sought for this
    transaction
    - Upon receipt of a valid and signed node update transaction the network
    software SHALL
    - If the transaction modifies the value of the "node account",
    - Validate the signature of the active `key` for the account
    assigned as the _current_ "node account".
    - Validate the signature of the active `key` for the account to be
    assigned as the _new_ "node account".
    - Modify the node information held in network state with the changes
    requested in the update transaction. The node changes SHALL NOT be
    applied to network configuration, and SHALL NOT affect network
    operation at this time.
    - When executing the next `freeze` transaction with `freeze_type` set to
    `PREPARE_UPGRADE`, update network configuration according to the
    modified information in network state. The requested changes SHALL
    affect network operation following this upgrade.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.createNode = channel.unary_unary(
                '/proto.AddressBookService/createNode',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)
        self.deleteNode = channel.unary_unary(
                '/proto.AddressBookService/deleteNode',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)
        self.updateNode = channel.unary_unary(
                '/proto.AddressBookService/updateNode',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)


class AddressBookServiceServicer(object):
    """*
    The Address Book service provides the ability for Hedera network node
    administrators to add, update, and remove consensus nodes. This addition,
    update, or removal of a consensus node requires governing council approval,
    but each node operator may update their own operational attributes without
    additional approval, reducing overhead for routine operations.

    Most operations are `privileged operations` and require governing council
    approval.

    ### For a node creation transaction.
    - The node operator SHALL create a `createNode` transaction.
    - The node operator SHALL sign this transaction with the active `key` for
    the account to be assigned as the "node account".
    - The node operator MUST deliver the signed transaction to the Hedera
    council representative.
    - The Hedera council representative SHALL arrange for council members to
    review and sign the transaction.
    - Once sufficient council members have signed the transaction, the
    Hedera council representative SHALL submit the transaction to the
    network.
    - Upon receipt of a valid and signed node creation transaction the network
    software SHALL
    - Validate the threshold signature for the Hedera governing council
    - Validate the signature of the active `key` for the account to be
    assigned as the "node account".
    - Create the new node in state, this new node SHALL NOT be active in the
    network at this time.
    - When executing the next `freeze` transaction with `freeze_type` set to
    `PREPARE_UPGRADE`, update network configuration and bring the
    new node to an active status within the network. The node to be added
    SHALL be active in the network following this upgrade.

    ### For a node deletion transaction.
    - The node operator or Hedera council representative SHALL create a
    `deleteNode` transaction.
    - If the node operator creates the transaction
    - The node operator MUST sign this transaction with the active `key`
    for the account assigned as the "node account".
    - The node operator SHALL deliver the signed transaction to the Hedera
    council representative.
    - The Hedera council representative SHALL arrange for council members to
    review and sign the transaction.
    - Once sufficient council members have signed the transaction, the
    Hedera council representative SHALL submit the transaction to the
    network.
    - Upon receipt of a valid and signed node deletion transaction the network
    software SHALL
    - Validate the threshold signature for the Hedera governing council
    - Remove the existing node from network state. The node SHALL still
    be active in the network at this time.
    - When executing the next `freeze` transaction with `freeze_type` set to
    `PREPARE_UPGRADE`, update network configuration and remove the
    node to be deleted from the network. The node to be deleted SHALL NOT
    be active in the network following this upgrade.

    ### For a node update transaction.
    - The node operator SHALL create an `updateNode` transaction.
    - The node operator MUST sign this transaction with the active `key`
    assigned as the `admin_key`.
    - The node operator SHALL submit the transaction to the
    network.  Hedera council approval SHALL NOT be sought for this
    transaction
    - Upon receipt of a valid and signed node update transaction the network
    software SHALL
    - If the transaction modifies the value of the "node account",
    - Validate the signature of the active `key` for the account
    assigned as the _current_ "node account".
    - Validate the signature of the active `key` for the account to be
    assigned as the _new_ "node account".
    - Modify the node information held in network state with the changes
    requested in the update transaction. The node changes SHALL NOT be
    applied to network configuration, and SHALL NOT affect network
    operation at this time.
    - When executing the next `freeze` transaction with `freeze_type` set to
    `PREPARE_UPGRADE`, update network configuration according to the
    modified information in network state. The requested changes SHALL
    affect network operation following this upgrade.
    """

    def createNode(self, request, context):
        """*
        A transaction to create a new consensus node in the network.
        address book.
        <p>
        This transaction, once complete, SHALL add a new consensus node to the
        network state.<br/>
        The new consensus node SHALL remain in state, but SHALL NOT participate
        in network consensus until the network updates the network configuration.
        <p>
        Hedera governing council authorization is REQUIRED for this transaction.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteNode(self, request, context):
        """*
        A transaction to remove a consensus node from the network address
        book.
        <p>
        This transaction, once complete, SHALL remove the identified consensus
        node from the network state.
        <p>
        Hedera governing council authorization is REQUIRED for this transaction.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def updateNode(self, request, context):
        """*
        A transaction to update an existing consensus node from the network
        address book.
        <p>
        This transaction, once complete, SHALL modify the identified consensus
        node state as requested.
        <p>
        This transaction is authorized by the node operator
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_AddressBookServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'createNode': grpc.unary_unary_rpc_method_handler(
                    servicer.createNode,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
            'deleteNode': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteNode,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
            'updateNode': grpc.unary_unary_rpc_method_handler(
                    servicer.updateNode,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'proto.AddressBookService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('proto.AddressBookService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class AddressBookService(object):
    """*
    The Address Book service provides the ability for Hedera network node
    administrators to add, update, and remove consensus nodes. This addition,
    update, or removal of a consensus node requires governing council approval,
    but each node operator may update their own operational attributes without
    additional approval, reducing overhead for routine operations.

    Most operations are `privileged operations` and require governing council
    approval.

    ### For a node creation transaction.
    - The node operator SHALL create a `createNode` transaction.
    - The node operator SHALL sign this transaction with the active `key` for
    the account to be assigned as the "node account".
    - The node operator MUST deliver the signed transaction to the Hedera
    council representative.
    - The Hedera council representative SHALL arrange for council members to
    review and sign the transaction.
    - Once sufficient council members have signed the transaction, the
    Hedera council representative SHALL submit the transaction to the
    network.
    - Upon receipt of a valid and signed node creation transaction the network
    software SHALL
    - Validate the threshold signature for the Hedera governing council
    - Validate the signature of the active `key` for the account to be
    assigned as the "node account".
    - Create the new node in state, this new node SHALL NOT be active in the
    network at this time.
    - When executing the next `freeze` transaction with `freeze_type` set to
    `PREPARE_UPGRADE`, update network configuration and bring the
    new node to an active status within the network. The node to be added
    SHALL be active in the network following this upgrade.

    ### For a node deletion transaction.
    - The node operator or Hedera council representative SHALL create a
    `deleteNode` transaction.
    - If the node operator creates the transaction
    - The node operator MUST sign this transaction with the active `key`
    for the account assigned as the "node account".
    - The node operator SHALL deliver the signed transaction to the Hedera
    council representative.
    - The Hedera council representative SHALL arrange for council members to
    review and sign the transaction.
    - Once sufficient council members have signed the transaction, the
    Hedera council representative SHALL submit the transaction to the
    network.
    - Upon receipt of a valid and signed node deletion transaction the network
    software SHALL
    - Validate the threshold signature for the Hedera governing council
    - Remove the existing node from network state. The node SHALL still
    be active in the network at this time.
    - When executing the next `freeze` transaction with `freeze_type` set to
    `PREPARE_UPGRADE`, update network configuration and remove the
    node to be deleted from the network. The node to be deleted SHALL NOT
    be active in the network following this upgrade.

    ### For a node update transaction.
    - The node operator SHALL create an `updateNode` transaction.
    - The node operator MUST sign this transaction with the active `key`
    assigned as the `admin_key`.
    - The node operator SHALL submit the transaction to the
    network.  Hedera council approval SHALL NOT be sought for this
    transaction
    - Upon receipt of a valid and signed node update transaction the network
    software SHALL
    - If the transaction modifies the value of the "node account",
    - Validate the signature of the active `key` for the account
    assigned as the _current_ "node account".
    - Validate the signature of the active `key` for the account to be
    assigned as the _new_ "node account".
    - Modify the node information held in network state with the changes
    requested in the update transaction. The node changes SHALL NOT be
    applied to network configuration, and SHALL NOT affect network
    operation at this time.
    - When executing the next `freeze` transaction with `freeze_type` set to
    `PREPARE_UPGRADE`, update network configuration according to the
    modified information in network state. The requested changes SHALL
    affect network operation following this upgrade.
    """

    @staticmethod
    def createNode(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.AddressBookService/createNode',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def deleteNode(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.AddressBookService/deleteNode',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def updateNode(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.AddressBookService/updateNode',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
