# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import query_pb2 as query__pb2
from . import response_pb2 as response__pb2
from . import transaction_pb2 as transaction__pb2
from . import transaction_response_pb2 as transaction__response__pb2

GRPC_GENERATED_VERSION = '1.68.1'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in consensus_service_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class ConsensusServiceStub(object):
    """*
    The Consensus Service provides the ability for Hedera Hashgraph to provide aBFT consensus as to
    the order and validity of messages submitted to a *topic*, as well as a *consensus timestamp* for
    those messages.

    Automatic renewal can be configured via an autoRenewAccount.
    Any time an autoRenewAccount is added to a topic, that createTopic/updateTopic transaction must
    be signed by the autoRenewAccount.

    The autoRenewPeriod on an account must currently be set a value in createTopic between
    MIN_AUTORENEW_PERIOD (6999999 seconds) and MAX_AUTORENEW_PERIOD (8000001 seconds). During
    creation this sets the initial expirationTime of the topic (see more below).

    If no adminKey is on a topic, there may not be an autoRenewAccount on the topic, deleteTopic is
    not allowed, and the only change allowed via an updateTopic is to extend the expirationTime.

    If an adminKey is on a topic, every updateTopic and deleteTopic transaction must be signed by the
    adminKey, except for updateTopics which only extend the topic's expirationTime (no adminKey
    authorization required).

    If an updateTopic modifies the adminKey of a topic, the transaction signatures on the updateTopic
    must fulfill both the pre-update and post-update adminKey signature requirements.

    Mirrornet ConsensusService may be used to subscribe to changes on the topic, including changes to
    the topic definition and the consensus ordering and timestamp of submitted messages.

    Until autoRenew functionality is supported by HAPI, the topic will not expire, the
    autoRenewAccount will not be charged, and the topic will not automatically be deleted.

    Once autoRenew functionality is supported by HAPI:

    1. Once the expirationTime is encountered, if an autoRenewAccount is configured on the topic, the
    account will be charged automatically at the expirationTime, to extend the expirationTime of the
    topic up to the topic's autoRenewPeriod (or as much extension as the account's balance will
    supply).

    2. If the topic expires and is not automatically renewed, the topic will enter the EXPIRED state.
    All transactions on the topic will fail with TOPIC_EXPIRED, except an updateTopic() call that
    modifies only the expirationTime.  getTopicInfo() will succeed. This state will be available for
    a AUTORENEW_GRACE_PERIOD grace period (7 days).

    3. After the grace period, if the topic's expirationTime is not extended, the topic will be
    automatically deleted and no transactions or queries on the topic will succeed after that point.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.createTopic = channel.unary_unary(
                '/proto.ConsensusService/createTopic',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)
        self.updateTopic = channel.unary_unary(
                '/proto.ConsensusService/updateTopic',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)
        self.deleteTopic = channel.unary_unary(
                '/proto.ConsensusService/deleteTopic',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)
        self.getTopicInfo = channel.unary_unary(
                '/proto.ConsensusService/getTopicInfo',
                request_serializer=query__pb2.Query.SerializeToString,
                response_deserializer=response__pb2.Response.FromString,
                _registered_method=True)
        self.submitMessage = channel.unary_unary(
                '/proto.ConsensusService/submitMessage',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)


class ConsensusServiceServicer(object):
    """*
    The Consensus Service provides the ability for Hedera Hashgraph to provide aBFT consensus as to
    the order and validity of messages submitted to a *topic*, as well as a *consensus timestamp* for
    those messages.

    Automatic renewal can be configured via an autoRenewAccount.
    Any time an autoRenewAccount is added to a topic, that createTopic/updateTopic transaction must
    be signed by the autoRenewAccount.

    The autoRenewPeriod on an account must currently be set a value in createTopic between
    MIN_AUTORENEW_PERIOD (6999999 seconds) and MAX_AUTORENEW_PERIOD (8000001 seconds). During
    creation this sets the initial expirationTime of the topic (see more below).

    If no adminKey is on a topic, there may not be an autoRenewAccount on the topic, deleteTopic is
    not allowed, and the only change allowed via an updateTopic is to extend the expirationTime.

    If an adminKey is on a topic, every updateTopic and deleteTopic transaction must be signed by the
    adminKey, except for updateTopics which only extend the topic's expirationTime (no adminKey
    authorization required).

    If an updateTopic modifies the adminKey of a topic, the transaction signatures on the updateTopic
    must fulfill both the pre-update and post-update adminKey signature requirements.

    Mirrornet ConsensusService may be used to subscribe to changes on the topic, including changes to
    the topic definition and the consensus ordering and timestamp of submitted messages.

    Until autoRenew functionality is supported by HAPI, the topic will not expire, the
    autoRenewAccount will not be charged, and the topic will not automatically be deleted.

    Once autoRenew functionality is supported by HAPI:

    1. Once the expirationTime is encountered, if an autoRenewAccount is configured on the topic, the
    account will be charged automatically at the expirationTime, to extend the expirationTime of the
    topic up to the topic's autoRenewPeriod (or as much extension as the account's balance will
    supply).

    2. If the topic expires and is not automatically renewed, the topic will enter the EXPIRED state.
    All transactions on the topic will fail with TOPIC_EXPIRED, except an updateTopic() call that
    modifies only the expirationTime.  getTopicInfo() will succeed. This state will be available for
    a AUTORENEW_GRACE_PERIOD grace period (7 days).

    3. After the grace period, if the topic's expirationTime is not extended, the topic will be
    automatically deleted and no transactions or queries on the topic will succeed after that point.
    """

    def createTopic(self, request, context):
        """*
        Create a topic to be used for consensus.
        If an autoRenewAccount is specified, that account must also sign this transaction.
        If an adminKey is specified, the adminKey must sign the transaction.
        On success, the resulting TransactionReceipt contains the newly created TopicId.
        Request is [ConsensusCreateTopicTransactionBody](#proto.ConsensusCreateTopicTransactionBody)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def updateTopic(self, request, context):
        """*
        Update a topic.
        If there is no adminKey, the only authorized update (available to anyone) is to extend the expirationTime.
        Otherwise transaction must be signed by the adminKey.
        If an adminKey is updated, the transaction must be signed by the pre-update adminKey and post-update adminKey.
        If a new autoRenewAccount is specified (not just being removed), that account must also sign the transaction.
        Request is [ConsensusUpdateTopicTransactionBody](#proto.ConsensusUpdateTopicTransactionBody)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteTopic(self, request, context):
        """*
        Delete a topic. No more transactions or queries on the topic (via HAPI) will succeed.
        If an adminKey is set, this transaction must be signed by that key.
        If there is no adminKey, this transaction will fail UNAUTHORIZED.
        Request is [ConsensusDeleteTopicTransactionBody](#proto.ConsensusDeleteTopicTransactionBody)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getTopicInfo(self, request, context):
        """*
        Retrieve the latest state of a topic. This method is unrestricted and allowed on any topic by any payer account.
        Deleted accounts will not be returned.
        Request is [ConsensusGetTopicInfoQuery](#proto.ConsensusGetTopicInfoQuery)
        Response is [ConsensusGetTopicInfoResponse](#proto.ConsensusGetTopicInfoResponse)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def submitMessage(self, request, context):
        """*
        Submit a message for consensus.
        Valid and authorized messages on valid topics will be ordered by the consensus service, gossipped to the
        mirror net, and published (in order) to all subscribers (from the mirror net) on this topic.
        The submitKey (if any) must sign this transaction.
        On success, the resulting TransactionReceipt contains the topic's updated topicSequenceNumber and
        topicRunningHash.
        Request is [ConsensusSubmitMessageTransactionBody](#proto.ConsensusSubmitMessageTransactionBody)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ConsensusServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'createTopic': grpc.unary_unary_rpc_method_handler(
                    servicer.createTopic,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
            'updateTopic': grpc.unary_unary_rpc_method_handler(
                    servicer.updateTopic,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
            'deleteTopic': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteTopic,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
            'getTopicInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.getTopicInfo,
                    request_deserializer=query__pb2.Query.FromString,
                    response_serializer=response__pb2.Response.SerializeToString,
            ),
            'submitMessage': grpc.unary_unary_rpc_method_handler(
                    servicer.submitMessage,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'proto.ConsensusService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('proto.ConsensusService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class ConsensusService(object):
    """*
    The Consensus Service provides the ability for Hedera Hashgraph to provide aBFT consensus as to
    the order and validity of messages submitted to a *topic*, as well as a *consensus timestamp* for
    those messages.

    Automatic renewal can be configured via an autoRenewAccount.
    Any time an autoRenewAccount is added to a topic, that createTopic/updateTopic transaction must
    be signed by the autoRenewAccount.

    The autoRenewPeriod on an account must currently be set a value in createTopic between
    MIN_AUTORENEW_PERIOD (6999999 seconds) and MAX_AUTORENEW_PERIOD (8000001 seconds). During
    creation this sets the initial expirationTime of the topic (see more below).

    If no adminKey is on a topic, there may not be an autoRenewAccount on the topic, deleteTopic is
    not allowed, and the only change allowed via an updateTopic is to extend the expirationTime.

    If an adminKey is on a topic, every updateTopic and deleteTopic transaction must be signed by the
    adminKey, except for updateTopics which only extend the topic's expirationTime (no adminKey
    authorization required).

    If an updateTopic modifies the adminKey of a topic, the transaction signatures on the updateTopic
    must fulfill both the pre-update and post-update adminKey signature requirements.

    Mirrornet ConsensusService may be used to subscribe to changes on the topic, including changes to
    the topic definition and the consensus ordering and timestamp of submitted messages.

    Until autoRenew functionality is supported by HAPI, the topic will not expire, the
    autoRenewAccount will not be charged, and the topic will not automatically be deleted.

    Once autoRenew functionality is supported by HAPI:

    1. Once the expirationTime is encountered, if an autoRenewAccount is configured on the topic, the
    account will be charged automatically at the expirationTime, to extend the expirationTime of the
    topic up to the topic's autoRenewPeriod (or as much extension as the account's balance will
    supply).

    2. If the topic expires and is not automatically renewed, the topic will enter the EXPIRED state.
    All transactions on the topic will fail with TOPIC_EXPIRED, except an updateTopic() call that
    modifies only the expirationTime.  getTopicInfo() will succeed. This state will be available for
    a AUTORENEW_GRACE_PERIOD grace period (7 days).

    3. After the grace period, if the topic's expirationTime is not extended, the topic will be
    automatically deleted and no transactions or queries on the topic will succeed after that point.
    """

    @staticmethod
    def createTopic(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.ConsensusService/createTopic',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def updateTopic(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.ConsensusService/updateTopic',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def deleteTopic(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.ConsensusService/deleteTopic',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def getTopicInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.ConsensusService/getTopicInfo',
            query__pb2.Query.SerializeToString,
            response__pb2.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def submitMessage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.ConsensusService/submitMessage',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
