# generated by datamodel-codegen:
#   filename:  openapi_flattened.json
#   timestamp: 2025-10-26T21:12:04+00:00

from __future__ import annotations

from typing import Any, Optional, Union

from msgspec import Struct, field

class DecayParams(Struct):
    decay_per_time_unit: Optional[int] = None
    decay_per_time_unit_denom_shift: Optional[int] = None

class Base(Struct):
    amount: Union[str, int]
    nai: str
    precision: int

class Quote(Struct):
    amount: Union[str, int]
    nai: str
    precision: int

class DebugGenerateBlocks(Struct):
    debug_key: str
    """
    The name of the witness account that will generate the blocks.
    """
    count: int
    """
    The number of blocks to generate.
    """
    skip: int
    miss_blocks: int

class DebugGenerateBlocksResponse(Struct):
    blocks: int

class DebugGenerateBlocksUntil(Struct):
    debug_key: str
    """
    The name of the witness account that will generate the blocks.
    """
    head_block_time: str
    """
    The target head block time to generate blocks until.
    """
    generate_sparsely: bool

class DebugGenerateBlocksUntilResponse(Struct):
    blocks: int

class AccountSubsidyRd2(Struct):
    budget_per_time_unit: int
    decay_params: DecayParams
    max_pool_size: Union[str, int]
    min_decay: Union[str, int]
    pool_eq: Union[str, int]
    resource_unit: Union[str, int]

class AccountSubsidyWitnessRd1(Struct):
    budget_per_time_unit: int
    decay_params: DecayParams
    max_pool_size: Union[str, int]
    min_decay: Union[str, int]
    pool_eq: Union[str, int]
    resource_unit: Union[str, int]

class AccountCreationFee(Struct):
    amount: Union[str, int]
    nai: str
    precision: int

class MedianProps1(Struct):
    account_subsidy_budget: int
    """
    The budget for account subsidies.
    """
    account_subsidy_decay: int
    """
    The decay rate for account subsidies.
    """
    hbd_interest_rate: int
    """
    The interest rate for HBD.
    """
    maximum_block_size: int
    """
    The maximum size of a block.
    """
    account_creation_fee: AccountCreationFee
    """
    The fee for creating an account.
    """

class DebugGetFutureWitnessScheduleResponse(Struct):
    account_subsidy_rd: AccountSubsidyRd2
    account_subsidy_witness_rd: AccountSubsidyWitnessRd1
    current_shuffled_witnesses: list[str]
    current_virtual_time: Union[str, int]
    elected_weight: int
    hardfork_required_witnesses: int
    id: int
    majority_version: str
    max_miner_witnesses: int
    max_runner_witnesses: int
    max_voted_witnesses: int
    min_witness_account_subsidy_decay: Union[str, int]
    miner_weight: int
    next_shuffle_block_num: int
    num_scheduled_witnesses: int
    timeshare_weight: int
    witness_pay_normalization_factor: int
    median_props: MedianProps1

class DebugGetHardforkPropertyObjectResponse(Struct):
    current_hardfork_version: str
    """
    The version of the hardfork.
    """
    id: int
    """
    The ID of the hardfork.
    """
    last_hardfork: int
    """
    The last hardfork number.
    """
    next_hardfork: str
    """
    The next hardfork version.
    """
    next_hardfork_time: str
    """
    The time of the next hardfork.
    """
    processed_hardforks: list[str]
    """
    An array of strings representing the processed hardforks.
    """

DebugGetHeadBlockResponse = None

class DebugGetJsonSchemaResponse(Struct):
    schema_: str = field(name='schema')

class AccountSubsidyRd3(Struct):
    budget_per_time_unit: int
    decay_params: DecayParams
    max_pool_size: Union[str, int]
    min_decay: Union[str, int]
    pool_eq: Union[str, int]
    resource_unit: Union[str, int]

class AccountSubsidyWitnessRd2(Struct):
    budget_per_time_unit: int
    decay_params: DecayParams
    max_pool_size: Union[str, int]
    min_decay: Union[str, int]
    pool_eq: Union[str, int]
    resource_unit: Union[str, int]

class MedianProps2(Struct):
    account_subsidy_budget: int
    """
    The budget for account subsidies.
    """
    account_subsidy_decay: int
    """
    The decay rate for account subsidies.
    """
    hbd_interest_rate: int
    """
    The interest rate for HBD.
    """
    maximum_block_size: int
    """
    The maximum size of a block.
    """
    account_creation_fee: AccountCreationFee
    """
    The fee for creating an account.
    """

class DebugGetWitnessScheduleResponse(Struct):
    account_subsidy_rd: AccountSubsidyRd3
    account_subsidy_witness_rd: AccountSubsidyWitnessRd2
    current_shuffled_witnesses: list[str]
    current_virtual_time: Union[str, int]
    elected_weight: int
    hardfork_required_witnesses: int
    id: int
    majority_version: str
    max_miner_witnesses: int
    max_runner_witnesses: int
    max_voted_witnesses: int
    min_witness_account_subsidy_decay: Union[str, int]
    miner_weight: int
    next_shuffle_block_num: int
    num_scheduled_witnesses: int
    timeshare_weight: int
    witness_pay_normalization_factor: int
    median_props: MedianProps2

class DebugHasHardfork(Struct):
    hardfork_id: int

class DebugHasHardforkResponse(Struct):
    has_hardfork: bool

class DebugSetHardfork(Struct):
    hardfork_id: int
    hook_to_tx: Optional[str] = None

class DebugSetHardforkResponse(Struct):
    pass

class VestPrice(Struct):
    base: Base
    """
    The base asset of the price.
    """
    quote: Quote
    """
    The quote asset of the price.
    """

class DebugSetVestPrice(Struct):
    vest_price: VestPrice
    hook_to_tx: Optional[str] = None

class DebugSetVestPriceResponse(Struct):
    pass

class DebugThrowException(Struct):
    throw_exception: bool

class DebugThrowExceptionResponse(Struct):
    pass

debug_node_api_description = {
    "debug_node_api": {
        "debug_generate_blocks": {
            "params": DebugGenerateBlocks,
            "result": DebugGenerateBlocksResponse,
            "description": "",
        },
        "debug_generate_blocks_until": {
            "params": DebugGenerateBlocksUntil,
            "result": DebugGenerateBlocksUntilResponse,
            "description": "",
        },
        "debug_get_future_witness_schedule": {
            "params": None,
            "result": DebugGetFutureWitnessScheduleResponse,
            "description": "",
        },
        "debug_get_hardfork_property_object": {
            "params": None,
            "result": DebugGetHardforkPropertyObjectResponse,
            "description": "",
        },
        "debug_get_head_block": {"params": None, "result": DebugGetHeadBlockResponse, "description": ""},
        "debug_get_json_schema": {"params": None, "result": DebugGetJsonSchemaResponse, "description": ""},
        "debug_get_witness_schedule": {"params": None, "result": DebugGetWitnessScheduleResponse, "description": ""},
        "debug_has_hardfork": {"params": DebugHasHardfork, "result": DebugHasHardforkResponse, "description": ""},
        "debug_set_hardfork": {"params": DebugSetHardfork, "result": DebugSetHardforkResponse, "description": ""},
        "debug_set_vest_price": {"params": DebugSetVestPrice, "result": DebugSetVestPriceResponse, "description": ""},
        "debug_throw_exception": {
            "params": DebugThrowException,
            "result": DebugThrowExceptionResponse,
            "description": "",
        },
    }
}
