import gradio as gr

i18n = gr.I18n(**{
    'en': {
        "title": "hsi-preprocessing-toolkit",
        "load": "Load",
        "upload_instructions": "**Upload one of the following formats:**\n1. One .hdr file + one raw data file without extension\n2. One .mat file",
        "input_format": "Input Image Shape Format",
        "data_files": "Data Files",
        "manual_normalize": "Manual Normalize (affects preview only)",
        "normalize_min": "Normalize Min",
        "normalize_max": "Normalize Max",
        "wavelength_start": "Wavelength Range Start",
        "wavelength_end": "Wavelength Range End",
        "processing": "Processing",
        "crop": "Crop",
        "top": "Top",
        "bottom": "Bottom",
        "left": "Left",
        "right": "Right",
        "rotate": "Rotate",
        "rotate_degree": "Rotate Degree",
        "preview": "Preview",
        "apply_processing": "Apply Processing Effects",
        "mat_data_type": "MAT Data Type",
        "mat_format": "MAT Image Shape Format",
        "mat_key": "Key of MAT file",
        "compress_mat": "Produce Compressed MAT File",
        "spectral_selection": "Spectral Selection",
        "spectral_selection_help": "Click on the image to select pixels for spectral data extraction. The selected pixels will be plotted in the spectral plot below.",
        "spectral_plot": "Spectral Plot",
        "style": "Style",
        "clear": "Clear",
        "download": "Download",
        "output_results": "Output Results",
        "mat_file": "MAT File",
        "info": "Info",
        "same_as_input": "Same",
        "auto_detect": "Auto Detect",
    },
    'zh-CN':{
        "title": "高光谱图像预处理工具箱",
        "load": "加载",
        "upload_instructions": "**应上传以下两种格式中的一种**\n1. 同时上传一个.hdr文件 + 一个无后缀的数据文件\n2. 一个.mat文件",
        "input_format": "输入数据形状",
        "data_files": "数据文件",
        "manual_normalize": "手动归一化(仅影响预览结果)",
        "normalize_min": "归一化最小值",
        "normalize_max": "归一化最大值",
        "wavelength_start": "波长范围起始",
        "wavelength_end": "波长范围结束",
        "processing": "处理",
        "crop": "裁切",
        "top": "上",
        "bottom": "下",
        "left": "左",
        "right": "右",
        "rotate": "旋转",
        "rotate_degree": "旋转角度",
        "preview": "预览",
        "apply_processing": "应用处理效果",
        "mat_data_type": "mat文件数据类型",
        "mat_format": "mat文件格式",
        "mat_key": "mat文件的key",
        "compress_mat": "启用mat文件压缩",
        "spectral_selection": "光谱选择",
        "spectral_selection_help": "点击预览图像图像中的像素进行光谱数据提取。选中的像素将在下方的光谱图中绘制。",
        "spectral_plot": "光谱图",
        "style": "样式",
        "clear": "清空",
        "download": "下载",
        "output_results": "输出结果",
        "mat_file": "MAT文件",
        "info": "信息",
        "same_as_input": "与输入相同",
        "auto_detect": "自动检测",
    }
})