# This code is generated by AI and edited by the developer.

import logging
import html
from typing import Iterable

_RECORD_COLOR_MAP = {
    logging.DEBUG:    "#999999",
    logging.INFO:     "#1E88E5",
    logging.WARNING:  "#FF8F00",
    logging.ERROR:    "#D32F2F",
    logging.CRITICAL: "#B71C1C",
}

_DUMMY_FORMATTER = logging.Formatter(datefmt="%Y-%m-%d %H:%M:%S")

def _record_to_html(record: logging.LogRecord) -> str:
    asctime = _DUMMY_FORMATTER.formatTime(record)
    color = _RECORD_COLOR_MAP.get(record.levelno, "#000")
    line = f"[{record.levelname} {asctime}]: {record.getMessage()}"
    line = html.escape(line)
    return f'<span style="color:{color}">{line}</span>'


def records_to_html(records: Iterable[logging.LogRecord], desc_time: bool = True, with_pre_tag=False) -> str:
    if desc_time:
        records = reversed(records)
    lines = "\n".join([ _record_to_html(r) for r in records ])
    if with_pre_tag:
        lines = "<pre style='height: 20em; overflow: visible;'>" + lines + "</pre>"
    return lines