"""
Module for handling HTTP Informational responses (1xx).

This module provides a class to represent and handle informational HTTP status codes (1xx).
These status codes indicate that the request has been received and the process is continuing.

Attributes:
    VERSION (str): Version of the module.

Classes:
    Continue
    SwitchingProtocols
    Processing
    EarlyHints

"""

VERSION: str = "1.0.0"

from http import HTTPStatus
from typing import Self

import http_status_code_exception.base_class

class Continue(http_status_code_exception.base_class.HTTPException):
    """100 Continue: The server acknowledges the request and instructs the client to continue."""
    def __init__(self: Self, message: str | None = None) -> Self:
        super().__init__(HTTPStatus.CONTINUE, message)


class SwitchingProtocols(http_status_code_exception.base_class.HTTPException):
    """101 Switching Protocols: The server is switching protocols as requested by the client."""
    def __init__(self: Self, message: str | None = None) -> Self:
        super().__init__(HTTPStatus.SWITCHING_PROTOCOLS, message)


class Processing(http_status_code_exception.base_class.HTTPException):
    """102 Processing: The server is processing the request but no response is available yet."""
    def __init__(self: Self, message: str | None = None) -> Self:
        super().__init__(HTTPStatus.PROCESSING, message)
