# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
import json
import re

import requests

from hugegraph.manager.common import HugeGraphBase
from hugegraph.models.respon_data import ResponseData
from hugegraph.utils.exceptions import NotFoundError
from hugegraph.utils.util import authorized


class GremlinManager(HugeGraphBase):
    def __init__(self, ip, port, graph_name, user, pwd, timeout):
        super().__init__(ip, port, graph_name, user, pwd, timeout)

    def exec(self, gremlin):
        gremlin = re.sub("^g", self._graph_name + ".traversal()", gremlin)
        url = self._host + "/gremlin?gremlin=" + gremlin
        response = requests.get(url, auth=self._auth, headers=self._headers)
        if response.status_code == 200 and authorized(response):
            return ResponseData(json.loads(response.content)).result
        else:
            raise NotFoundError("Gremlin can't get results: {}".format(response.content))

