# hwmux-client-python
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.45.0
- Package version: 2.45.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import hwmux_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import hwmux_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import hwmux_client
from pprint import pprint
from hwmux_client.api import token_auth_api
from hwmux_client.model.auth_token import AuthToken
# Defining the host is optional and defaults to https://hwmux.silabs.net
# See configuration.py for a list of all supported configuration parameters.
configuration = hwmux_client.Configuration(
    host = "https://hwmux.silabs.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'

# Configure API key authorization: tokenAuth
configuration.api_key['tokenAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['tokenAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with hwmux_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = token_auth_api.TokenAuthApi(api_client)
    username = "username_example" # str | 
    password = "password_example" # str | 
    token = "token_example" # str | 

    try:
        api_response = api_instance.token_auth_create(username, password, token)
        pprint(api_response)
    except hwmux_client.ApiException as e:
        print("Exception when calling TokenAuthApi->token_auth_create: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://hwmux.silabs.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TokenAuthApi* | [**token_auth_create**](docs/TokenAuthApi.md#token_auth_create) | **POST** /api-token-auth/ | 
*CallbackApi* | [**callback_retrieve**](docs/CallbackApi.md#callback_retrieve) | **GET** /callback/ | 
*DevicesApi* | [**devices_ahs_batch_get_create**](docs/DevicesApi.md#devices_ahs_batch_get_create) | **POST** /api/devices/ahs-batch-get/ | 
*DevicesApi* | [**devices_ahs_retrieve**](docs/DevicesApi.md#devices_ahs_retrieve) | **GET** /api/devices/{id}/ahs/ | 
*DevicesApi* | [**devices_create**](docs/DevicesApi.md#devices_create) | **POST** /api/devices/ | 
*DevicesApi* | [**devices_destroy**](docs/DevicesApi.md#devices_destroy) | **DELETE** /api/devices/{id}/ | 
*DevicesApi* | [**devices_list**](docs/DevicesApi.md#devices_list) | **GET** /api/devices/ | 
*DevicesApi* | [**devices_list_my_list**](docs/DevicesApi.md#devices_list_my_list) | **GET** /api/devices/list_my/ | 
*DevicesApi* | [**devices_location_retrieve**](docs/DevicesApi.md#devices_location_retrieve) | **GET** /api/devices/{device_pk}/location/ | 
*DevicesApi* | [**devices_partial_update**](docs/DevicesApi.md#devices_partial_update) | **PATCH** /api/devices/{id}/ | 
*DevicesApi* | [**devices_permissions_partial_update**](docs/DevicesApi.md#devices_permissions_partial_update) | **PATCH** /api/devices/{id}/permissions/ | 
*DevicesApi* | [**devices_permissions_retrieve**](docs/DevicesApi.md#devices_permissions_retrieve) | **GET** /api/devices/{id}/permissions/ | 
*DevicesApi* | [**devices_permissions_update**](docs/DevicesApi.md#devices_permissions_update) | **PUT** /api/devices/{id}/permissions/ | 
*DevicesApi* | [**devices_release_update**](docs/DevicesApi.md#devices_release_update) | **PUT** /api/devices/{id}/release/ | 
*DevicesApi* | [**devices_reserve_update**](docs/DevicesApi.md#devices_reserve_update) | **PUT** /api/devices/{id}/reserve/ | 
*DevicesApi* | [**devices_retrieve**](docs/DevicesApi.md#devices_retrieve) | **GET** /api/devices/{id}/ | 
*DevicesApi* | [**devices_search_list**](docs/DevicesApi.md#devices_search_list) | **GET** /api/devices/search/ | 
*DevicesApi* | [**devices_set_offline_create**](docs/DevicesApi.md#devices_set_offline_create) | **POST** /api/devices/set_offline/ | 
*DevicesApi* | [**devices_status_create**](docs/DevicesApi.md#devices_status_create) | **POST** /api/devices/{id}/status/ | 
*DevicesApi* | [**devices_update**](docs/DevicesApi.md#devices_update) | **PUT** /api/devices/{id}/ | 
*DevicesApi* | [**devices_update_efr_data_create**](docs/DevicesApi.md#devices_update_efr_data_create) | **POST** /api/devices/{id}/update-efr-data/ | 
*DevicesApi* | [**devices_update_raspi_data_create**](docs/DevicesApi.md#devices_update_raspi_data_create) | **POST** /api/devices/{id}/update-raspi-data/ | 
*DjangoLoginApi* | [**django_login_create**](docs/DjangoLoginApi.md#django_login_create) | **POST** /django_login/ | 
*ExternalSigninApi* | [**external_signin_retrieve**](docs/ExternalSigninApi.md#external_signin_retrieve) | **GET** /external_signin/ | 
*GroupfiltersApi* | [**groupfilters_create**](docs/GroupfiltersApi.md#groupfilters_create) | **POST** /api/groupfilters/ | 
*GroupfiltersApi* | [**groupfilters_destroy**](docs/GroupfiltersApi.md#groupfilters_destroy) | **DELETE** /api/groupfilters/{id}/ | 
*GroupfiltersApi* | [**groupfilters_list**](docs/GroupfiltersApi.md#groupfilters_list) | **GET** /api/groupfilters/ | 
*GroupfiltersApi* | [**groupfilters_partial_update**](docs/GroupfiltersApi.md#groupfilters_partial_update) | **PATCH** /api/groupfilters/{id}/ | 
*GroupfiltersApi* | [**groupfilters_retrieve**](docs/GroupfiltersApi.md#groupfilters_retrieve) | **GET** /api/groupfilters/{id}/ | 
*GroupfiltersApi* | [**groupfilters_update**](docs/GroupfiltersApi.md#groupfilters_update) | **PUT** /api/groupfilters/{id}/ | 
*GroupsApi* | [**groups_analytics_batch_get_create**](docs/GroupsApi.md#groups_analytics_batch_get_create) | **POST** /api/groups/analytics-batch-get/ | 
*GroupsApi* | [**groups_analytics_retrieve**](docs/GroupsApi.md#groups_analytics_retrieve) | **GET** /api/groups/{id}/analytics/ | 
*GroupsApi* | [**groups_available_list**](docs/GroupsApi.md#groups_available_list) | **GET** /api/groups/available/ | 
*GroupsApi* | [**groups_create**](docs/GroupsApi.md#groups_create) | **POST** /api/groups/ | 
*GroupsApi* | [**groups_create_with_devices_create**](docs/GroupsApi.md#groups_create_with_devices_create) | **POST** /api/groups/create-with-devices | 
*GroupsApi* | [**groups_destroy**](docs/GroupsApi.md#groups_destroy) | **DELETE** /api/groups/{id}/ | 
*GroupsApi* | [**groups_list**](docs/GroupsApi.md#groups_list) | **GET** /api/groups/ | 
*GroupsApi* | [**groups_location_retrieve**](docs/GroupsApi.md#groups_location_retrieve) | **GET** /api/groups/{device_group_pk}/location/ | 
*GroupsApi* | [**groups_my_list**](docs/GroupsApi.md#groups_my_list) | **GET** /api/groups/my/ | 
*GroupsApi* | [**groups_partial_update**](docs/GroupsApi.md#groups_partial_update) | **PATCH** /api/groups/{id}/ | 
*GroupsApi* | [**groups_permissions_partial_update**](docs/GroupsApi.md#groups_permissions_partial_update) | **PATCH** /api/groups/{id}/permissions/ | 
*GroupsApi* | [**groups_permissions_retrieve**](docs/GroupsApi.md#groups_permissions_retrieve) | **GET** /api/groups/{id}/permissions/ | 
*GroupsApi* | [**groups_permissions_update**](docs/GroupsApi.md#groups_permissions_update) | **PUT** /api/groups/{id}/permissions/ | 
*GroupsApi* | [**groups_release_by_name_update**](docs/GroupsApi.md#groups_release_by_name_update) | **PUT** /api/groups/{group_name}/release_by_name/ | 
*GroupsApi* | [**groups_release_update**](docs/GroupsApi.md#groups_release_update) | **PUT** /api/groups/{id}/release/ | 
*GroupsApi* | [**groups_reserve_by_name_update**](docs/GroupsApi.md#groups_reserve_by_name_update) | **PUT** /api/groups/{group_name}/reserve_by_name/ | 
*GroupsApi* | [**groups_reserve_update**](docs/GroupsApi.md#groups_reserve_update) | **PUT** /api/groups/{id}/reserve/ | 
*GroupsApi* | [**groups_retrieve**](docs/GroupsApi.md#groups_retrieve) | **GET** /api/groups/{id}/ | 
*GroupsApi* | [**groups_status_create**](docs/GroupsApi.md#groups_status_create) | **POST** /api/groups/{id}/status/ | 
*GroupsApi* | [**groups_update**](docs/GroupsApi.md#groups_update) | **PUT** /api/groups/{id}/ | 
*LabelsApi* | [**labels_analytics_batch_get_create**](docs/LabelsApi.md#labels_analytics_batch_get_create) | **POST** /api/labels/analytics-batch-get/ | 
*LabelsApi* | [**labels_analytics_retrieve**](docs/LabelsApi.md#labels_analytics_retrieve) | **GET** /api/labels/{id}/analytics/ | 
*LabelsApi* | [**labels_create**](docs/LabelsApi.md#labels_create) | **POST** /api/labels/ | 
*LabelsApi* | [**labels_destroy**](docs/LabelsApi.md#labels_destroy) | **DELETE** /api/labels/{id}/ | 
*LabelsApi* | [**labels_list**](docs/LabelsApi.md#labels_list) | **GET** /api/labels/ | 
*LabelsApi* | [**labels_partial_update**](docs/LabelsApi.md#labels_partial_update) | **PATCH** /api/labels/{id}/ | 
*LabelsApi* | [**labels_permissions_partial_update**](docs/LabelsApi.md#labels_permissions_partial_update) | **PATCH** /api/labels/{id}/permissions/ | 
*LabelsApi* | [**labels_permissions_retrieve**](docs/LabelsApi.md#labels_permissions_retrieve) | **GET** /api/labels/{id}/permissions/ | 
*LabelsApi* | [**labels_permissions_update**](docs/LabelsApi.md#labels_permissions_update) | **PUT** /api/labels/{id}/permissions/ | 
*LabelsApi* | [**labels_reserve_any_update**](docs/LabelsApi.md#labels_reserve_any_update) | **PUT** /api/labels/{id}/reserve_any/ | 
*LabelsApi* | [**labels_retrieve**](docs/LabelsApi.md#labels_retrieve) | **GET** /api/labels/{id}/ | 
*LabelsApi* | [**labels_update**](docs/LabelsApi.md#labels_update) | **PUT** /api/labels/{id}/ | 
*LogsApi* | [**logs_destroy**](docs/LogsApi.md#logs_destroy) | **DELETE** /api/logs/{id} | 
*LogsApi* | [**logs_list**](docs/LogsApi.md#logs_list) | **GET** /api/logs/ | 
*LogsApi* | [**logs_retrieve**](docs/LogsApi.md#logs_retrieve) | **GET** /api/logs/{id}/ | 
*OutboxApi* | [**outbox_list**](docs/OutboxApi.md#outbox_list) | **GET** /api/outbox/ | 
*OutboxApi* | [**outbox_retrieve**](docs/OutboxApi.md#outbox_retrieve) | **GET** /api/outbox/{id}/ | 
*PartFamiliesApi* | [**part_families_create**](docs/PartFamiliesApi.md#part_families_create) | **POST** /api/part-families/ | 
*PartFamiliesApi* | [**part_families_destroy**](docs/PartFamiliesApi.md#part_families_destroy) | **DELETE** /api/part-families/{name}/ | 
*PartFamiliesApi* | [**part_families_list**](docs/PartFamiliesApi.md#part_families_list) | **GET** /api/part-families/ | 
*PartFamiliesApi* | [**part_families_partial_update**](docs/PartFamiliesApi.md#part_families_partial_update) | **PATCH** /api/part-families/{name}/ | 
*PartFamiliesApi* | [**part_families_parts_create**](docs/PartFamiliesApi.md#part_families_parts_create) | **POST** /api/part-families/{part_family_pk}/parts/ | 
*PartFamiliesApi* | [**part_families_parts_destroy**](docs/PartFamiliesApi.md#part_families_parts_destroy) | **DELETE** /api/part-families/{part_family_pk}/parts/{id}/ | 
*PartFamiliesApi* | [**part_families_parts_list**](docs/PartFamiliesApi.md#part_families_parts_list) | **GET** /api/part-families/{part_family_pk}/parts/ | 
*PartFamiliesApi* | [**part_families_parts_partial_update**](docs/PartFamiliesApi.md#part_families_parts_partial_update) | **PATCH** /api/part-families/{part_family_pk}/parts/{id}/ | 
*PartFamiliesApi* | [**part_families_parts_retrieve**](docs/PartFamiliesApi.md#part_families_parts_retrieve) | **GET** /api/part-families/{part_family_pk}/parts/{id}/ | 
*PartFamiliesApi* | [**part_families_parts_update**](docs/PartFamiliesApi.md#part_families_parts_update) | **PUT** /api/part-families/{part_family_pk}/parts/{id}/ | 
*PartFamiliesApi* | [**part_families_retrieve**](docs/PartFamiliesApi.md#part_families_retrieve) | **GET** /api/part-families/{name}/ | 
*PartFamiliesApi* | [**part_families_update**](docs/PartFamiliesApi.md#part_families_update) | **PUT** /api/part-families/{name}/ | 
*PartsApi* | [**parts_list**](docs/PartsApi.md#parts_list) | **GET** /api/parts/ | 
*PartsApi* | [**parts_retrieve**](docs/PartsApi.md#parts_retrieve) | **GET** /api/parts/{part_no}/ | 
*PermissionsApi* | [**permissions_groups_create**](docs/PermissionsApi.md#permissions_groups_create) | **POST** /api/permissions/groups/ | 
*PermissionsApi* | [**permissions_groups_destroy**](docs/PermissionsApi.md#permissions_groups_destroy) | **DELETE** /api/permissions/groups/{name_or_id}/ | 
*PermissionsApi* | [**permissions_groups_device_groups_create**](docs/PermissionsApi.md#permissions_groups_device_groups_create) | **POST** /api/permissions/groups/{name_or_id}/device_groups/ | 
*PermissionsApi* | [**permissions_groups_device_groups_destroy**](docs/PermissionsApi.md#permissions_groups_device_groups_destroy) | **DELETE** /api/permissions/groups/{name_or_id}/device_groups/{id}/ | 
*PermissionsApi* | [**permissions_groups_device_groups_list**](docs/PermissionsApi.md#permissions_groups_device_groups_list) | **GET** /api/permissions/groups/{name_or_id}/device_groups/ | 
*PermissionsApi* | [**permissions_groups_device_groups_partial_update**](docs/PermissionsApi.md#permissions_groups_device_groups_partial_update) | **PATCH** /api/permissions/groups/{name_or_id}/device_groups/{id}/ | 
*PermissionsApi* | [**permissions_groups_device_groups_update**](docs/PermissionsApi.md#permissions_groups_device_groups_update) | **PUT** /api/permissions/groups/{name_or_id}/device_groups/{id}/ | 
*PermissionsApi* | [**permissions_groups_devices_create**](docs/PermissionsApi.md#permissions_groups_devices_create) | **POST** /api/permissions/groups/{name_or_id}/devices/ | 
*PermissionsApi* | [**permissions_groups_devices_destroy**](docs/PermissionsApi.md#permissions_groups_devices_destroy) | **DELETE** /api/permissions/groups/{name_or_id}/devices/{id}/ | 
*PermissionsApi* | [**permissions_groups_devices_list**](docs/PermissionsApi.md#permissions_groups_devices_list) | **GET** /api/permissions/groups/{name_or_id}/devices/ | 
*PermissionsApi* | [**permissions_groups_devices_partial_update**](docs/PermissionsApi.md#permissions_groups_devices_partial_update) | **PATCH** /api/permissions/groups/{name_or_id}/devices/{id}/ | 
*PermissionsApi* | [**permissions_groups_devices_update**](docs/PermissionsApi.md#permissions_groups_devices_update) | **PUT** /api/permissions/groups/{name_or_id}/devices/{id}/ | 
*PermissionsApi* | [**permissions_groups_labels_create**](docs/PermissionsApi.md#permissions_groups_labels_create) | **POST** /api/permissions/groups/{name_or_id}/labels/ | 
*PermissionsApi* | [**permissions_groups_labels_destroy**](docs/PermissionsApi.md#permissions_groups_labels_destroy) | **DELETE** /api/permissions/groups/{name_or_id}/labels/{id}/ | 
*PermissionsApi* | [**permissions_groups_labels_list**](docs/PermissionsApi.md#permissions_groups_labels_list) | **GET** /api/permissions/groups/{name_or_id}/labels/ | 
*PermissionsApi* | [**permissions_groups_labels_partial_update**](docs/PermissionsApi.md#permissions_groups_labels_partial_update) | **PATCH** /api/permissions/groups/{name_or_id}/labels/{id}/ | 
*PermissionsApi* | [**permissions_groups_labels_update**](docs/PermissionsApi.md#permissions_groups_labels_update) | **PUT** /api/permissions/groups/{name_or_id}/labels/{id}/ | 
*PermissionsApi* | [**permissions_groups_list**](docs/PermissionsApi.md#permissions_groups_list) | **GET** /api/permissions/groups/ | 
*PermissionsApi* | [**permissions_groups_partial_update**](docs/PermissionsApi.md#permissions_groups_partial_update) | **PATCH** /api/permissions/groups/{name_or_id}/ | 
*PermissionsApi* | [**permissions_groups_retrieve**](docs/PermissionsApi.md#permissions_groups_retrieve) | **GET** /api/permissions/groups/{name_or_id}/ | 
*PermissionsApi* | [**permissions_groups_update**](docs/PermissionsApi.md#permissions_groups_update) | **PUT** /api/permissions/groups/{name_or_id}/ | 
*PermissionsApi* | [**permissions_groups_users_create**](docs/PermissionsApi.md#permissions_groups_users_create) | **POST** /api/permissions/groups/{name_or_id}/users/ | 
*PermissionsApi* | [**permissions_groups_users_destroy**](docs/PermissionsApi.md#permissions_groups_users_destroy) | **DELETE** /api/permissions/groups/{name_or_id}/users/{username_or_id}/ | 
*ReservationsApi* | [**reservations_actionable_list**](docs/ReservationsApi.md#reservations_actionable_list) | **GET** /api/reservations/actionable/ | 
*ReservationsApi* | [**reservations_active_list**](docs/ReservationsApi.md#reservations_active_list) | **GET** /api/reservations/active/ | 
*ReservationsApi* | [**reservations_cancel_update**](docs/ReservationsApi.md#reservations_cancel_update) | **PUT** /api/reservations/{id}/cancel/ | 
*ReservationsApi* | [**reservations_create**](docs/ReservationsApi.md#reservations_create) | **POST** /api/reservations/ | 
*ReservationsApi* | [**reservations_extend_update**](docs/ReservationsApi.md#reservations_extend_update) | **PUT** /api/reservations/{id}/extend/ | 
*ReservationsApi* | [**reservations_list**](docs/ReservationsApi.md#reservations_list) | **GET** /api/reservations/ | 
*ReservationsApi* | [**reservations_metadata_partial_update**](docs/ReservationsApi.md#reservations_metadata_partial_update) | **PATCH** /api/reservations/{id}/metadata/ | 
*ReservationsApi* | [**reservations_metadata_update**](docs/ReservationsApi.md#reservations_metadata_update) | **PUT** /api/reservations/{id}/metadata/ | 
*ReservationsApi* | [**reservations_release_update**](docs/ReservationsApi.md#reservations_release_update) | **PUT** /api/reservations/{id}/release/ | 
*ReservationsApi* | [**reservations_retrieve**](docs/ReservationsApi.md#reservations_retrieve) | **GET** /api/reservations/{id}/ | 
*ReservationsApi* | [**reservations_update**](docs/ReservationsApi.md#reservations_update) | **PUT** /api/reservations/{id}/ | 
*RoomsApi* | [**rooms_list**](docs/RoomsApi.md#rooms_list) | **GET** /api/rooms/ | 
*RoomsApi* | [**rooms_retrieve**](docs/RoomsApi.md#rooms_retrieve) | **GET** /api/rooms/{name}/ | 
*SchemaApi* | [**schema_download_retrieve**](docs/SchemaApi.md#schema_download_retrieve) | **GET** /schema/download | 
*SigninApi* | [**signin_retrieve**](docs/SigninApi.md#signin_retrieve) | **GET** /signin/ | 
*SignoutApi* | [**signout_retrieve**](docs/SignoutApi.md#signout_retrieve) | **GET** /signout/ | 
*SitesApi* | [**sites_create**](docs/SitesApi.md#sites_create) | **POST** /api/sites/ | 
*SitesApi* | [**sites_destroy**](docs/SitesApi.md#sites_destroy) | **DELETE** /api/sites/{name}/ | 
*SitesApi* | [**sites_list**](docs/SitesApi.md#sites_list) | **GET** /api/sites/ | 
*SitesApi* | [**sites_partial_update**](docs/SitesApi.md#sites_partial_update) | **PATCH** /api/sites/{name}/ | 
*SitesApi* | [**sites_retrieve**](docs/SitesApi.md#sites_retrieve) | **GET** /api/sites/{name}/ | 
*SitesApi* | [**sites_rooms_create**](docs/SitesApi.md#sites_rooms_create) | **POST** /api/sites/{site_pk}/rooms/ | 
*SitesApi* | [**sites_rooms_destroy**](docs/SitesApi.md#sites_rooms_destroy) | **DELETE** /api/sites/{site_pk}/rooms/{id}/ | 
*SitesApi* | [**sites_rooms_list**](docs/SitesApi.md#sites_rooms_list) | **GET** /api/sites/{site_pk}/rooms/ | 
*SitesApi* | [**sites_rooms_partial_update**](docs/SitesApi.md#sites_rooms_partial_update) | **PATCH** /api/sites/{site_pk}/rooms/{id}/ | 
*SitesApi* | [**sites_rooms_retrieve**](docs/SitesApi.md#sites_rooms_retrieve) | **GET** /api/sites/{site_pk}/rooms/{id}/ | 
*SitesApi* | [**sites_rooms_update**](docs/SitesApi.md#sites_rooms_update) | **PUT** /api/sites/{site_pk}/rooms/{id}/ | 
*SitesApi* | [**sites_update**](docs/SitesApi.md#sites_update) | **PUT** /api/sites/{name}/ | 
*TerraformApi* | [**terraform_devices_create**](docs/TerraformApi.md#terraform_devices_create) | **POST** /api/terraform/devices/ | 
*TerraformApi* | [**terraform_devices_existing_create**](docs/TerraformApi.md#terraform_devices_existing_create) | **POST** /api/terraform/devices-existing/ | 
*TerraformApi* | [**terraform_existing_groups_create**](docs/TerraformApi.md#terraform_existing_groups_create) | **POST** /api/terraform/existing-groups/ | 
*TerraformApi* | [**terraform_labels_create**](docs/TerraformApi.md#terraform_labels_create) | **POST** /api/terraform/labels/ | 
*TerraformApi* | [**terraform_labels_existing_create**](docs/TerraformApi.md#terraform_labels_existing_create) | **POST** /api/terraform/labels-existing/ | 
*TerraformApi* | [**terraform_nested_group_create**](docs/TerraformApi.md#terraform_nested_group_create) | **POST** /api/terraform/nested-group/ | 
*TerraformApi* | [**terraform_new_group_create**](docs/TerraformApi.md#terraform_new_group_create) | **POST** /api/terraform/new-group/ | 
*TerraformApi* | [**terraform_validation_context_retrieve**](docs/TerraformApi.md#terraform_validation_context_retrieve) | **GET** /api/terraform/validation-context/ | 
*UserApi* | [**user_create**](docs/UserApi.md#user_create) | **POST** /api/user/ | 
*UserApi* | [**user_current_jwt_retrieve**](docs/UserApi.md#user_current_jwt_retrieve) | **GET** /api/user/current/jwt/ | 
*UserApi* | [**user_current_retrieve**](docs/UserApi.md#user_current_retrieve) | **GET** /api/user/current/ | 
*UserApi* | [**user_current_token_create**](docs/UserApi.md#user_current_token_create) | **POST** /api/user/current/token/ | 
*UserApi* | [**user_current_token_retrieve**](docs/UserApi.md#user_current_token_retrieve) | **GET** /api/user/current/token/ | 
*UserApi* | [**user_destroy**](docs/UserApi.md#user_destroy) | **DELETE** /api/user/{username_or_id}/ | 
*UserApi* | [**user_list**](docs/UserApi.md#user_list) | **GET** /api/user/ | 
*UserApi* | [**user_partial_update**](docs/UserApi.md#user_partial_update) | **PATCH** /api/user/{username_or_id}/ | 
*UserApi* | [**user_retrieve**](docs/UserApi.md#user_retrieve) | **GET** /api/user/{username_or_id}/ | 
*UserApi* | [**user_token_create**](docs/UserApi.md#user_token_create) | **POST** /api/user/{username_or_id}/token/ | 
*UserApi* | [**user_token_retrieve**](docs/UserApi.md#user_token_retrieve) | **GET** /api/user/{username_or_id}/token/ | 
*UserApi* | [**user_update**](docs/UserApi.md#user_update) | **PUT** /api/user/{username_or_id}/ | 


## Documentation For Models

 - [AHSData](docs/AHSData.md)
 - [ApiRequestCreateDevices](docs/ApiRequestCreateDevices.md)
 - [ApiRequestCreateLabel](docs/ApiRequestCreateLabel.md)
 - [ApiRequestCreateNewGroup](docs/ApiRequestCreateNewGroup.md)
 - [ApiRequestCreateNewNestedGroup](docs/ApiRequestCreateNewNestedGroup.md)
 - [AuthToken](docs/AuthToken.md)
 - [BlankEnum](docs/BlankEnum.md)
 - [DGAnalyticsMetadata](docs/DGAnalyticsMetadata.md)
 - [DeviceGroup](docs/DeviceGroup.md)
 - [DeviceGroupAnalytics](docs/DeviceGroupAnalytics.md)
 - [DeviceGroupIdList](docs/DeviceGroupIdList.md)
 - [DeviceGroupSerializerWithDevicePk](docs/DeviceGroupSerializerWithDevicePk.md)
 - [DeviceIdList](docs/DeviceIdList.md)
 - [DeviceSerializerPublic](docs/DeviceSerializerPublic.md)
 - [EFRData](docs/EFRData.md)
 - [EventEnum](docs/EventEnum.md)
 - [ExistingDevices](docs/ExistingDevices.md)
 - [ExistingGroups](docs/ExistingGroups.md)
 - [ExistingLabels](docs/ExistingLabels.md)
 - [GetAHSDataResponse](docs/GetAHSDataResponse.md)
 - [GroupFilters](docs/GroupFilters.md)
 - [GroupLocation](docs/GroupLocation.md)
 - [JWTToken](docs/JWTToken.md)
 - [Label](docs/Label.md)
 - [LabelAnalytics](docs/LabelAnalytics.md)
 - [LabelAnalyticsMetadata](docs/LabelAnalyticsMetadata.md)
 - [LabelIdList](docs/LabelIdList.md)
 - [LabelSerializerWithPermissions](docs/LabelSerializerWithPermissions.md)
 - [LightDevice](docs/LightDevice.md)
 - [Location](docs/Location.md)
 - [LocationSerializerWriteOnly](docs/LocationSerializerWriteOnly.md)
 - [Log](docs/Log.md)
 - [LogResourceType](docs/LogResourceType.md)
 - [LogStatusEnum](docs/LogStatusEnum.md)
 - [LoggedInUser](docs/LoggedInUser.md)
 - [MDGAnalyticsWithMeta](docs/MDGAnalyticsWithMeta.md)
 - [MLAnalyticsWithMeta](docs/MLAnalyticsWithMeta.md)
 - [NestedDevice](docs/NestedDevice.md)
 - [NestedDeviceGroup](docs/NestedDeviceGroup.md)
 - [NullEnum](docs/NullEnum.md)
 - [ObjectPermissions](docs/ObjectPermissions.md)
 - [Outbox](docs/Outbox.md)
 - [OutboxReservationStatus](docs/OutboxReservationStatus.md)
 - [OutboxStatusEnum](docs/OutboxStatusEnum.md)
 - [PaginatedDeviceGroupList](docs/PaginatedDeviceGroupList.md)
 - [PaginatedDeviceSerializerPublicList](docs/PaginatedDeviceSerializerPublicList.md)
 - [PaginatedGroupFiltersList](docs/PaginatedGroupFiltersList.md)
 - [PaginatedLabelList](docs/PaginatedLabelList.md)
 - [PaginatedLogList](docs/PaginatedLogList.md)
 - [PaginatedLoggedInUserList](docs/PaginatedLoggedInUserList.md)
 - [PaginatedOutboxList](docs/PaginatedOutboxList.md)
 - [PaginatedPartFamilyList](docs/PaginatedPartFamilyList.md)
 - [PaginatedPartList](docs/PaginatedPartList.md)
 - [PaginatedPermissionGroupList](docs/PaginatedPermissionGroupList.md)
 - [PaginatedReservationSessionSerializerReadOnlyList](docs/PaginatedReservationSessionSerializerReadOnlyList.md)
 - [PaginatedRoomList](docs/PaginatedRoomList.md)
 - [PaginatedSiteList](docs/PaginatedSiteList.md)
 - [Part](docs/Part.md)
 - [PartFamily](docs/PartFamily.md)
 - [PatchedDeviceGroupSerializerWithDevicePk](docs/PatchedDeviceGroupSerializerWithDevicePk.md)
 - [PatchedGroupFilters](docs/PatchedGroupFilters.md)
 - [PatchedLabelSerializerWithPermissions](docs/PatchedLabelSerializerWithPermissions.md)
 - [PatchedLoggedInUser](docs/PatchedLoggedInUser.md)
 - [PatchedObjectPermissions](docs/PatchedObjectPermissions.md)
 - [PatchedPart](docs/PatchedPart.md)
 - [PatchedPartFamily](docs/PatchedPartFamily.md)
 - [PatchedPermissionGroup](docs/PatchedPermissionGroup.md)
 - [PatchedResourcePermissions](docs/PatchedResourcePermissions.md)
 - [PatchedRoom](docs/PatchedRoom.md)
 - [PatchedSite](docs/PatchedSite.md)
 - [PatchedWriteOnlyDevice](docs/PatchedWriteOnlyDevice.md)
 - [PermissionGroup](docs/PermissionGroup.md)
 - [PermissionsEnum](docs/PermissionsEnum.md)
 - [RaspiData](docs/RaspiData.md)
 - [ReservationExtensionRequest](docs/ReservationExtensionRequest.md)
 - [ReservationRequest](docs/ReservationRequest.md)
 - [ReservationSessionSerializerReadOnly](docs/ReservationSessionSerializerReadOnly.md)
 - [ReservationSessionSerializerReadOnlyOwner](docs/ReservationSessionSerializerReadOnlyOwner.md)
 - [ReservationSessionSerializerReadOnlyState](docs/ReservationSessionSerializerReadOnlyState.md)
 - [ReservationStatusEnum](docs/ReservationStatusEnum.md)
 - [ResourcePermissions](docs/ResourcePermissions.md)
 - [ResourceStatusRequest](docs/ResourceStatusRequest.md)
 - [ResourceTypeEnum](docs/ResourceTypeEnum.md)
 - [Room](docs/Room.md)
 - [SDGAnalyticsWithMeta](docs/SDGAnalyticsWithMeta.md)
 - [SLAnalyticsWithMeta](docs/SLAnalyticsWithMeta.md)
 - [SagaStatusEnum](docs/SagaStatusEnum.md)
 - [Site](docs/Site.md)
 - [SourceEnum](docs/SourceEnum.md)
 - [StateEnum](docs/StateEnum.md)
 - [StatusF44Enum](docs/StatusF44Enum.md)
 - [Token](docs/Token.md)
 - [TypeEnum](docs/TypeEnum.md)
 - [UpdateEFRResponse](docs/UpdateEFRResponse.md)
 - [UpdateRaspiResponse](docs/UpdateRaspiResponse.md)
 - [User](docs/User.md)
 - [WriteOnlyDevice](docs/WriteOnlyDevice.md)


## Documentation For Authorization


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## tokenAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in hwmux_client.apis and hwmux_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from hwmux_client.api.default_api import DefaultApi`
- `from hwmux_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import hwmux_client
from hwmux_client.apis import *
from hwmux_client.models import *
```

