"""
    HW Mux Reservation System

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 2.45.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from hwmux_client.api_client import ApiClient, Endpoint as _Endpoint
from hwmux_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from hwmux_client.model.device_id_list import DeviceIdList
from hwmux_client.model.device_serializer_public import DeviceSerializerPublic
from hwmux_client.model.efr_data import EFRData
from hwmux_client.model.get_ahs_data_response import GetAHSDataResponse
from hwmux_client.model.location import Location
from hwmux_client.model.object_permissions import ObjectPermissions
from hwmux_client.model.paginated_device_serializer_public_list import PaginatedDeviceSerializerPublicList
from hwmux_client.model.patched_object_permissions import PatchedObjectPermissions
from hwmux_client.model.patched_write_only_device import PatchedWriteOnlyDevice
from hwmux_client.model.raspi_data import RaspiData
from hwmux_client.model.resource_status_request import ResourceStatusRequest
from hwmux_client.model.update_efr_response import UpdateEFRResponse
from hwmux_client.model.update_raspi_response import UpdateRaspiResponse
from hwmux_client.model.write_only_device import WriteOnlyDevice


class DevicesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.devices_ahs_batch_get_create_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/ahs-batch-get/',
                'operation_id': 'devices_ahs_batch_get_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id_list',
                ],
                'required': [
                    'device_id_list',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_id_list':
                        (DeviceIdList,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'device_id_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.devices_ahs_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (GetAHSDataResponse,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/ahs/',
                'operation_id': 'devices_ahs_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_create_endpoint = _Endpoint(
            settings={
                'response_type': (WriteOnlyDevice,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/',
                'operation_id': 'devices_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'write_only_device',
                ],
                'required': [
                    'write_only_device',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'write_only_device':
                        (WriteOnlyDevice,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'write_only_device': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.devices_destroy_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/',
                'operation_id': 'devices_destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedDeviceSerializerPublicList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/',
                'operation_id': 'devices_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'date_created',
                    'force_mv',
                    'has_latest_system',
                    'id__in',
                    'include_permission_groups',
                    'is_reserved',
                    'is_reserved_filter',
                    'is_wstk',
                    'last_update',
                    'online',
                    'ordering',
                    'page',
                    'part',
                    'part_family',
                    'regex_search',
                    'room',
                    'search',
                    'site',
                    'sn_or_name',
                    'sn_or_name__isnull',
                    'socketed_chip',
                    'source',
                    'status',
                    'uri',
                    'uri__isnull',
                    'wstk_part',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'force_mv',
                    'source',
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('force_mv',): {

                        "DEFAULT": "DEFAULT",
                        "OFF": "OFF",
                        "ON": "ON"
                    },
                    ('source',): {

                        "OTHER": "OTHER",
                        "TERRAFORM": "TERRAFORM",
                        "UI": "UI",
                        "XML": "XML"
                    },
                    ('status',): {

                        "ACTIVE": "ACTIVE",
                        "DISABLED": "DISABLED",
                        "OFFLINE": "OFFLINE"
                    },
                },
                'openapi_types': {
                    'date_created':
                        (datetime,),
                    'force_mv':
                        (str,),
                    'has_latest_system':
                        (bool,),
                    'id__in':
                        ([str],),
                    'include_permission_groups':
                        (bool,),
                    'is_reserved':
                        (bool,),
                    'is_reserved_filter':
                        (bool,),
                    'is_wstk':
                        (bool,),
                    'last_update':
                        (datetime,),
                    'online':
                        (bool,),
                    'ordering':
                        (str,),
                    'page':
                        (int,),
                    'part':
                        (str,),
                    'part_family':
                        (str,),
                    'regex_search':
                        (str,),
                    'room':
                        (str,),
                    'search':
                        (str,),
                    'site':
                        (str,),
                    'sn_or_name':
                        (str,),
                    'sn_or_name__isnull':
                        (bool,),
                    'socketed_chip':
                        (str,),
                    'source':
                        (str,),
                    'status':
                        (str,),
                    'uri':
                        (str,),
                    'uri__isnull':
                        (bool,),
                    'wstk_part':
                        (str,),
                },
                'attribute_map': {
                    'date_created': 'date_created',
                    'force_mv': 'force_mv',
                    'has_latest_system': 'has_latest_system',
                    'id__in': 'id__in',
                    'include_permission_groups': 'include_permission_groups',
                    'is_reserved': 'is_reserved',
                    'is_reserved_filter': 'is_reserved_filter',
                    'is_wstk': 'is_wstk',
                    'last_update': 'last_update',
                    'online': 'online',
                    'ordering': 'ordering',
                    'page': 'page',
                    'part': 'part',
                    'part_family': 'part_family',
                    'regex_search': 'regex_search',
                    'room': 'room',
                    'search': 'search',
                    'site': 'site',
                    'sn_or_name': 'sn_or_name',
                    'sn_or_name__isnull': 'sn_or_name__isnull',
                    'socketed_chip': 'socketed_chip',
                    'source': 'source',
                    'status': 'status',
                    'uri': 'uri',
                    'uri__isnull': 'uri__isnull',
                    'wstk_part': 'wstk_part',
                },
                'location_map': {
                    'date_created': 'query',
                    'force_mv': 'query',
                    'has_latest_system': 'query',
                    'id__in': 'query',
                    'include_permission_groups': 'query',
                    'is_reserved': 'query',
                    'is_reserved_filter': 'query',
                    'is_wstk': 'query',
                    'last_update': 'query',
                    'online': 'query',
                    'ordering': 'query',
                    'page': 'query',
                    'part': 'query',
                    'part_family': 'query',
                    'regex_search': 'query',
                    'room': 'query',
                    'search': 'query',
                    'site': 'query',
                    'sn_or_name': 'query',
                    'sn_or_name__isnull': 'query',
                    'socketed_chip': 'query',
                    'source': 'query',
                    'status': 'query',
                    'uri': 'query',
                    'uri__isnull': 'query',
                    'wstk_part': 'query',
                },
                'collection_format_map': {
                    'id__in': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_list_my_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedDeviceSerializerPublicList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/list_my/',
                'operation_id': 'devices_list_my_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'date_created',
                    'has_latest_system',
                    'id__in',
                    'include_permission_groups',
                    'is_reserved',
                    'is_reserved_filter',
                    'is_wstk',
                    'last_update',
                    'online',
                    'ordering',
                    'page',
                    'part',
                    'part_family',
                    'regex_search',
                    'room',
                    'search',
                    'site',
                    'sn_or_name',
                    'sn_or_name__isnull',
                    'socketed_chip',
                    'source',
                    'status',
                    'uri',
                    'uri__isnull',
                    'wstk_part',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'source',
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('source',): {

                        "OTHER": "OTHER",
                        "TERRAFORM": "TERRAFORM",
                        "UI": "UI",
                        "XML": "XML"
                    },
                    ('status',): {

                        "ACTIVE": "ACTIVE",
                        "DISABLED": "DISABLED",
                        "OFFLINE": "OFFLINE"
                    },
                },
                'openapi_types': {
                    'date_created':
                        (datetime,),
                    'has_latest_system':
                        (bool,),
                    'id__in':
                        ([str],),
                    'include_permission_groups':
                        (bool,),
                    'is_reserved':
                        (bool,),
                    'is_reserved_filter':
                        (bool,),
                    'is_wstk':
                        (bool,),
                    'last_update':
                        (datetime,),
                    'online':
                        (bool,),
                    'ordering':
                        (str,),
                    'page':
                        (int,),
                    'part':
                        (str,),
                    'part_family':
                        (str,),
                    'regex_search':
                        (str,),
                    'room':
                        (str,),
                    'search':
                        (str,),
                    'site':
                        (str,),
                    'sn_or_name':
                        (str,),
                    'sn_or_name__isnull':
                        (bool,),
                    'socketed_chip':
                        (str,),
                    'source':
                        (str,),
                    'status':
                        (str,),
                    'uri':
                        (str,),
                    'uri__isnull':
                        (bool,),
                    'wstk_part':
                        (str,),
                },
                'attribute_map': {
                    'date_created': 'date_created',
                    'has_latest_system': 'has_latest_system',
                    'id__in': 'id__in',
                    'include_permission_groups': 'include_permission_groups',
                    'is_reserved': 'is_reserved',
                    'is_reserved_filter': 'is_reserved_filter',
                    'is_wstk': 'is_wstk',
                    'last_update': 'last_update',
                    'online': 'online',
                    'ordering': 'ordering',
                    'page': 'page',
                    'part': 'part',
                    'part_family': 'part_family',
                    'regex_search': 'regex_search',
                    'room': 'room',
                    'search': 'search',
                    'site': 'site',
                    'sn_or_name': 'sn_or_name',
                    'sn_or_name__isnull': 'sn_or_name__isnull',
                    'socketed_chip': 'socketed_chip',
                    'source': 'source',
                    'status': 'status',
                    'uri': 'uri',
                    'uri__isnull': 'uri__isnull',
                    'wstk_part': 'wstk_part',
                },
                'location_map': {
                    'date_created': 'query',
                    'has_latest_system': 'query',
                    'id__in': 'query',
                    'include_permission_groups': 'query',
                    'is_reserved': 'query',
                    'is_reserved_filter': 'query',
                    'is_wstk': 'query',
                    'last_update': 'query',
                    'online': 'query',
                    'ordering': 'query',
                    'page': 'query',
                    'part': 'query',
                    'part_family': 'query',
                    'regex_search': 'query',
                    'room': 'query',
                    'search': 'query',
                    'site': 'query',
                    'sn_or_name': 'query',
                    'sn_or_name__isnull': 'query',
                    'socketed_chip': 'query',
                    'source': 'query',
                    'status': 'query',
                    'uri': 'query',
                    'uri__isnull': 'query',
                    'wstk_part': 'query',
                },
                'collection_format_map': {
                    'id__in': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_location_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (Location,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{device_pk}/location/',
                'operation_id': 'devices_location_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_pk',
                ],
                'required': [
                    'device_pk',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_pk':
                        (str,),
                },
                'attribute_map': {
                    'device_pk': 'device_pk',
                },
                'location_map': {
                    'device_pk': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (WriteOnlyDevice,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/',
                'operation_id': 'devices_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_write_only_device',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_write_only_device':
                        (PatchedWriteOnlyDevice,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_write_only_device': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.devices_permissions_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectPermissions,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/permissions/',
                'operation_id': 'devices_permissions_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_object_permissions',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_object_permissions':
                        (PatchedObjectPermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_object_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.devices_permissions_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectPermissions,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/permissions/',
                'operation_id': 'devices_permissions_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_permissions_update_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectPermissions,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/permissions/',
                'operation_id': 'devices_permissions_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'object_permissions',
                ],
                'required': [
                    'id',
                    'object_permissions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'object_permissions':
                        (ObjectPermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'object_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.devices_release_update_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceSerializerPublic,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/release/',
                'operation_id': 'devices_release_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_reserve_update_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceSerializerPublic,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/reserve/',
                'operation_id': 'devices_reserve_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'details',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'details':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'details': 'details',
                },
                'location_map': {
                    'id': 'path',
                    'details': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceSerializerPublic,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/',
                'operation_id': 'devices_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'include_permission_groups',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'include_permission_groups':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'include_permission_groups': 'include_permission_groups',
                },
                'location_map': {
                    'id': 'path',
                    'include_permission_groups': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_search_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedDeviceSerializerPublicList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/search/',
                'operation_id': 'devices_search_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'search_key_value_pairs',
                    'date_created',
                    'has_latest_system',
                    'id__in',
                    'is_reserved',
                    'is_reserved_filter',
                    'is_wstk',
                    'last_update',
                    'online',
                    'ordering',
                    'page',
                    'part',
                    'part_family',
                    'room',
                    'search',
                    'site',
                    'sn_or_name',
                    'sn_or_name__isnull',
                    'socketed_chip',
                    'source',
                    'status',
                    'uri',
                    'uri__isnull',
                    'wstk_part',
                ],
                'required': [
                    'search_key_value_pairs',
                ],
                'nullable': [
                ],
                'enum': [
                    'source',
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('source',): {

                        "OTHER": "OTHER",
                        "TERRAFORM": "TERRAFORM",
                        "UI": "UI",
                        "XML": "XML"
                    },
                    ('status',): {

                        "ACTIVE": "ACTIVE",
                        "DISABLED": "DISABLED",
                        "OFFLINE": "OFFLINE"
                    },
                },
                'openapi_types': {
                    'search_key_value_pairs':
                        (str,),
                    'date_created':
                        (datetime,),
                    'has_latest_system':
                        (bool,),
                    'id__in':
                        ([str],),
                    'is_reserved':
                        (bool,),
                    'is_reserved_filter':
                        (bool,),
                    'is_wstk':
                        (bool,),
                    'last_update':
                        (datetime,),
                    'online':
                        (bool,),
                    'ordering':
                        (str,),
                    'page':
                        (int,),
                    'part':
                        (str,),
                    'part_family':
                        (str,),
                    'room':
                        (str,),
                    'search':
                        (str,),
                    'site':
                        (str,),
                    'sn_or_name':
                        (str,),
                    'sn_or_name__isnull':
                        (bool,),
                    'socketed_chip':
                        (str,),
                    'source':
                        (str,),
                    'status':
                        (str,),
                    'uri':
                        (str,),
                    'uri__isnull':
                        (bool,),
                    'wstk_part':
                        (str,),
                },
                'attribute_map': {
                    'search_key_value_pairs': 'search_key_value_pairs',
                    'date_created': 'date_created',
                    'has_latest_system': 'has_latest_system',
                    'id__in': 'id__in',
                    'is_reserved': 'is_reserved',
                    'is_reserved_filter': 'is_reserved_filter',
                    'is_wstk': 'is_wstk',
                    'last_update': 'last_update',
                    'online': 'online',
                    'ordering': 'ordering',
                    'page': 'page',
                    'part': 'part',
                    'part_family': 'part_family',
                    'room': 'room',
                    'search': 'search',
                    'site': 'site',
                    'sn_or_name': 'sn_or_name',
                    'sn_or_name__isnull': 'sn_or_name__isnull',
                    'socketed_chip': 'socketed_chip',
                    'source': 'source',
                    'status': 'status',
                    'uri': 'uri',
                    'uri__isnull': 'uri__isnull',
                    'wstk_part': 'wstk_part',
                },
                'location_map': {
                    'search_key_value_pairs': 'query',
                    'date_created': 'query',
                    'has_latest_system': 'query',
                    'id__in': 'query',
                    'is_reserved': 'query',
                    'is_reserved_filter': 'query',
                    'is_wstk': 'query',
                    'last_update': 'query',
                    'online': 'query',
                    'ordering': 'query',
                    'page': 'query',
                    'part': 'query',
                    'part_family': 'query',
                    'room': 'query',
                    'search': 'query',
                    'site': 'query',
                    'sn_or_name': 'query',
                    'sn_or_name__isnull': 'query',
                    'socketed_chip': 'query',
                    'source': 'query',
                    'status': 'query',
                    'uri': 'query',
                    'uri__isnull': 'query',
                    'wstk_part': 'query',
                },
                'collection_format_map': {
                    'id__in': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.devices_set_offline_create_endpoint = _Endpoint(
            settings={
                'response_type': (WriteOnlyDevice,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/set_offline/',
                'operation_id': 'devices_set_offline_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'write_only_device',
                ],
                'required': [
                    'write_only_device',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'write_only_device':
                        (WriteOnlyDevice,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'write_only_device': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.devices_status_create_endpoint = _Endpoint(
            settings={
                'response_type': (ResourceStatusRequest,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/status/',
                'operation_id': 'devices_status_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'resource_status_request',
                ],
                'required': [
                    'id',
                    'resource_status_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'resource_status_request':
                        (ResourceStatusRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'resource_status_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.devices_update_endpoint = _Endpoint(
            settings={
                'response_type': (WriteOnlyDevice,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/',
                'operation_id': 'devices_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'write_only_device',
                ],
                'required': [
                    'id',
                    'write_only_device',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'write_only_device':
                        (WriteOnlyDevice,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'write_only_device': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.devices_update_efr_data_create_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateEFRResponse,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/update-efr-data/',
                'operation_id': 'devices_update_efr_data_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'efr_data',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'efr_data':
                        (EFRData,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'efr_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.devices_update_raspi_data_create_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateRaspiResponse,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/devices/{id}/update-raspi-data/',
                'operation_id': 'devices_update_raspi_data_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'raspi_data',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'raspi_data':
                        (RaspiData,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'raspi_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def devices_ahs_batch_get_create(
        self,
        device_id_list,
        **kwargs
    ):
        """devices_ahs_batch_get_create  # noqa: E501

        Fetch AHS data for multiple devices with consistent field structure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_ahs_batch_get_create(device_id_list, async_req=True)
        >>> result = thread.get()

        Args:
            device_id_list (DeviceIdList):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id_list'] = \
            device_id_list
        return self.devices_ahs_batch_get_create_endpoint.call_with_http_info(**kwargs)

    def devices_ahs_retrieve(
        self,
        id,
        **kwargs
    ):
        """devices_ahs_retrieve  # noqa: E501

        Retrieve AHS data for a single device. Returns type='unknown' and data=None if no AHS data exists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_ahs_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAHSDataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_ahs_retrieve_endpoint.call_with_http_info(**kwargs)

    def devices_create(
        self,
        write_only_device,
        **kwargs
    ):
        """devices_create  # noqa: E501

        Adds object-level permissions management as detail views  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_create(write_only_device, async_req=True)
        >>> result = thread.get()

        Args:
            write_only_device (WriteOnlyDevice):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            WriteOnlyDevice
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['write_only_device'] = \
            write_only_device
        return self.devices_create_endpoint.call_with_http_info(**kwargs)

    def devices_destroy(
        self,
        id,
        **kwargs
    ):
        """devices_destroy  # noqa: E501

        Adds object-level permissions management as detail views  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_destroy(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_destroy_endpoint.call_with_http_info(**kwargs)

    def devices_list(
        self,
        **kwargs
    ):
        """devices_list  # noqa: E501

        Adds object-level permissions management as detail views  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            date_created (datetime): [optional]
            force_mv (str): Specifies the behavior of the force_mv attribute. DEFAULT : Default condition which retrieve data from the Materialized view unless ax exception occurs where we fall back to postgres. ON : Force the data to be retrieved from the Materialized view. OFF : Force the data to be retrieved from the Postgres database. [optional] if omitted the server will use the default value of "DEFAULT"
            has_latest_system (bool): [optional]
            id__in ([str]): Multiple values may be separated by commas.. [optional]
            include_permission_groups (bool): If set to true, the permission groups associated with this resource will be included in the response. Defaults to false.. [optional] if omitted the server will use the default value of False
            is_reserved (bool): [optional]
            is_reserved_filter (bool): [optional]
            is_wstk (bool): [optional]
            last_update (datetime): [optional]
            online (bool): [optional]
            ordering (str): Which field to use when ordering the results.. [optional]
            page (int): A page number within the paginated result set.. [optional]
            part (str): [optional]
            part_family (str): [optional]
            regex_search (str): Regex pattern to search across Name, Chip, Part, etc.. [optional]
            room (str): [optional]
            search (str): A search term.. [optional]
            site (str): [optional]
            sn_or_name (str): [optional]
            sn_or_name__isnull (bool): [optional]
            socketed_chip (str): [optional]
            source (str): * `TERRAFORM` - Terraform * `XML` - XML * `UI` - UI * `OTHER` - Other. [optional]
            status (str): * `ACTIVE` - Active * `DISABLED` - Disabled * `OFFLINE` - Offline. [optional]
            uri (str): [optional]
            uri__isnull (bool): [optional]
            wstk_part (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedDeviceSerializerPublicList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.devices_list_endpoint.call_with_http_info(**kwargs)

    def devices_list_my_list(
        self,
        **kwargs
    ):
        """devices_list_my_list  # noqa: E501

        Get devices owned by authenticated user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_list_my_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            date_created (datetime): [optional]
            has_latest_system (bool): [optional]
            id__in ([str]): Multiple values may be separated by commas.. [optional]
            include_permission_groups (bool): If set to true, the permission groups associated with this resource will be included in the response. Defaults to false.. [optional] if omitted the server will use the default value of False
            is_reserved (bool): [optional]
            is_reserved_filter (bool): [optional]
            is_wstk (bool): [optional]
            last_update (datetime): [optional]
            online (bool): [optional]
            ordering (str): Which field to use when ordering the results.. [optional]
            page (int): A page number within the paginated result set.. [optional]
            part (str): [optional]
            part_family (str): [optional]
            regex_search (str): Regex pattern to search across Name, Chip, Part, etc.. [optional]
            room (str): [optional]
            search (str): A search term.. [optional]
            site (str): [optional]
            sn_or_name (str): [optional]
            sn_or_name__isnull (bool): [optional]
            socketed_chip (str): [optional]
            source (str): * `TERRAFORM` - Terraform * `XML` - XML * `UI` - UI * `OTHER` - Other. [optional]
            status (str): * `ACTIVE` - Active * `DISABLED` - Disabled * `OFFLINE` - Offline. [optional]
            uri (str): [optional]
            uri__isnull (bool): [optional]
            wstk_part (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedDeviceSerializerPublicList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.devices_list_my_list_endpoint.call_with_http_info(**kwargs)

    def devices_location_retrieve(
        self,
        device_pk,
        **kwargs
    ):
        """devices_location_retrieve  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_location_retrieve(device_pk, async_req=True)
        >>> result = thread.get()

        Args:
            device_pk (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Location
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_pk'] = \
            device_pk
        return self.devices_location_retrieve_endpoint.call_with_http_info(**kwargs)

    def devices_partial_update(
        self,
        id,
        **kwargs
    ):
        """devices_partial_update  # noqa: E501

        Adds object-level permissions management as detail views  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_partial_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            patched_write_only_device (PatchedWriteOnlyDevice): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            WriteOnlyDevice
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_partial_update_endpoint.call_with_http_info(**kwargs)

    def devices_permissions_partial_update(
        self,
        id,
        **kwargs
    ):
        """devices_permissions_partial_update  # noqa: E501

        Partially update the object-level permissions for this resource. Can omit top-level fields to leave unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_permissions_partial_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            patched_object_permissions (PatchedObjectPermissions): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ObjectPermissions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_permissions_partial_update_endpoint.call_with_http_info(**kwargs)

    def devices_permissions_retrieve(
        self,
        id,
        **kwargs
    ):
        """devices_permissions_retrieve  # noqa: E501

        Get the object-level permissions for this resource. Will return user permissions and user group permissions separately. User permissions  will not include those derived from user group membership.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_permissions_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ObjectPermissions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_permissions_retrieve_endpoint.call_with_http_info(**kwargs)

    def devices_permissions_update(
        self,
        id,
        object_permissions,
        **kwargs
    ):
        """devices_permissions_update  # noqa: E501

        Update the object-level permissions for this resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_permissions_update(id, object_permissions, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.
            object_permissions (ObjectPermissions):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ObjectPermissions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['object_permissions'] = \
            object_permissions
        return self.devices_permissions_update_endpoint.call_with_http_info(**kwargs)

    def devices_release_update(
        self,
        id,
        **kwargs
    ):
        """devices_release_update  # noqa: E501

        Release a device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_release_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceSerializerPublic
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_release_update_endpoint.call_with_http_info(**kwargs)

    def devices_reserve_update(
        self,
        id,
        **kwargs
    ):
        """devices_reserve_update  # noqa: E501

        Reserve a device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_reserve_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            details (str): Additional information such as the jenkins job URL. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceSerializerPublic
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_reserve_update_endpoint.call_with_http_info(**kwargs)

    def devices_retrieve(
        self,
        id,
        **kwargs
    ):
        """devices_retrieve  # noqa: E501

        Adds object-level permissions management as detail views  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            include_permission_groups (bool): If set to true, the permission groups associated with this resource will be included in the response. Defaults to false.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceSerializerPublic
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_retrieve_endpoint.call_with_http_info(**kwargs)

    def devices_search_list(
        self,
        search_key_value_pairs,
        **kwargs
    ):
        """devices_search_list  # noqa: E501

        Search by any key-value pair in the device. Search includes nested key-value pairs in the metadata or any other fields in the serialized representation of the device.  Comparison operations can be specified by doing: key__{oper}=value. Supported operations:  eq: equals, neq: not equals, re: regular expression, gt: greater than, gte, greater than or equals, lt: less than, lte, less than or equals, in: contains  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_search_list(search_key_value_pairs, async_req=True)
        >>> result = thread.get()

        Args:
            search_key_value_pairs (str):

        Keyword Args:
            date_created (datetime): [optional]
            has_latest_system (bool): [optional]
            id__in ([str]): Multiple values may be separated by commas.. [optional]
            is_reserved (bool): [optional]
            is_reserved_filter (bool): [optional]
            is_wstk (bool): [optional]
            last_update (datetime): [optional]
            online (bool): [optional]
            ordering (str): Which field to use when ordering the results.. [optional]
            page (int): A page number within the paginated result set.. [optional]
            part (str): [optional]
            part_family (str): [optional]
            room (str): [optional]
            search (str): A search term.. [optional]
            site (str): [optional]
            sn_or_name (str): [optional]
            sn_or_name__isnull (bool): [optional]
            socketed_chip (str): [optional]
            source (str): * `TERRAFORM` - Terraform * `XML` - XML * `UI` - UI * `OTHER` - Other. [optional]
            status (str): * `ACTIVE` - Active * `DISABLED` - Disabled * `OFFLINE` - Offline. [optional]
            uri (str): [optional]
            uri__isnull (bool): [optional]
            wstk_part (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedDeviceSerializerPublicList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['search_key_value_pairs'] = \
            search_key_value_pairs
        return self.devices_search_list_endpoint.call_with_http_info(**kwargs)

    def devices_set_offline_create(
        self,
        write_only_device,
        **kwargs
    ):
        """devices_set_offline_create  # noqa: E501

        Sets all devices offline which haven't been updated in the last hour  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_set_offline_create(write_only_device, async_req=True)
        >>> result = thread.get()

        Args:
            write_only_device (WriteOnlyDevice):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            WriteOnlyDevice
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['write_only_device'] = \
            write_only_device
        return self.devices_set_offline_create_endpoint.call_with_http_info(**kwargs)

    def devices_status_create(
        self,
        id,
        resource_status_request,
        **kwargs
    ):
        """devices_status_create  # noqa: E501

        Modify the device status. A comment is required unless the new status is ACTIVE.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_status_create(id, resource_status_request, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.
            resource_status_request (ResourceStatusRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ResourceStatusRequest
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['resource_status_request'] = \
            resource_status_request
        return self.devices_status_create_endpoint.call_with_http_info(**kwargs)

    def devices_update(
        self,
        id,
        write_only_device,
        **kwargs
    ):
        """devices_update  # noqa: E501

        Adds object-level permissions management as detail views  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_update(id, write_only_device, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.
            write_only_device (WriteOnlyDevice):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            WriteOnlyDevice
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['write_only_device'] = \
            write_only_device
        return self.devices_update_endpoint.call_with_http_info(**kwargs)

    def devices_update_efr_data_create(
        self,
        id,
        **kwargs
    ):
        """devices_update_efr_data_create  # noqa: E501

        Update EFR device data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_update_efr_data_create(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            efr_data (EFRData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateEFRResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_update_efr_data_create_endpoint.call_with_http_info(**kwargs)

    def devices_update_raspi_data_create(
        self,
        id,
        **kwargs
    ):
        """devices_update_raspi_data_create  # noqa: E501

        Update Raspi device data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.devices_update_raspi_data_create(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.

        Keyword Args:
            raspi_data (RaspiData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateRaspiResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.devices_update_raspi_data_create_endpoint.call_with_http_info(**kwargs)

