"""
    HW Mux Reservation System

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 2.45.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from hwmux_client.api_client import ApiClient, Endpoint as _Endpoint
from hwmux_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from hwmux_client.model.device_group import DeviceGroup
from hwmux_client.model.device_group_id_list import DeviceGroupIdList
from hwmux_client.model.device_group_serializer_with_device_pk import DeviceGroupSerializerWithDevicePk
from hwmux_client.model.group_location import GroupLocation
from hwmux_client.model.mdg_analytics_with_meta import MDGAnalyticsWithMeta
from hwmux_client.model.nested_device_group import NestedDeviceGroup
from hwmux_client.model.object_permissions import ObjectPermissions
from hwmux_client.model.paginated_device_group_list import PaginatedDeviceGroupList
from hwmux_client.model.patched_device_group_serializer_with_device_pk import PatchedDeviceGroupSerializerWithDevicePk
from hwmux_client.model.patched_object_permissions import PatchedObjectPermissions
from hwmux_client.model.resource_status_request import ResourceStatusRequest
from hwmux_client.model.sdg_analytics_with_meta import SDGAnalyticsWithMeta


class GroupsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.groups_analytics_batch_get_create_endpoint = _Endpoint(
            settings={
                'response_type': (MDGAnalyticsWithMeta,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/analytics-batch-get/',
                'operation_id': 'groups_analytics_batch_get_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_group_id_list',
                ],
                'required': [
                    'device_group_id_list',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_group_id_list':
                        (DeviceGroupIdList,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'device_group_id_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.groups_analytics_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (SDGAnalyticsWithMeta,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/analytics/',
                'operation_id': 'groups_analytics_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_available_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedDeviceGroupList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/available/',
                'operation_id': 'groups_available_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_no',
                    'devices',
                    'enable_ahs',
                    'enable_ahs_actions',
                    'enable_ahs_cas',
                    'id__in',
                    'is_reserved',
                    'is_reserved_filter',
                    'name',
                    'ordering',
                    'page',
                    'part_family',
                    'part_no',
                    'room',
                    'search',
                    'site',
                    'source',
                    'status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'source',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('source',): {

                        "OTHER": "OTHER",
                        "TERRAFORM": "TERRAFORM",
                        "UI": "UI",
                        "XML": "XML"
                    },
                },
                'openapi_types': {
                    'board_no':
                        (str,),
                    'devices':
                        ([int],),
                    'enable_ahs':
                        (bool,),
                    'enable_ahs_actions':
                        (bool,),
                    'enable_ahs_cas':
                        (bool,),
                    'id__in':
                        ([str],),
                    'is_reserved':
                        (bool,),
                    'is_reserved_filter':
                        (bool,),
                    'name':
                        (str,),
                    'ordering':
                        (str,),
                    'page':
                        (int,),
                    'part_family':
                        (str,),
                    'part_no':
                        (str,),
                    'room':
                        (str,),
                    'search':
                        (str,),
                    'site':
                        (str,),
                    'source':
                        (str,),
                    'status':
                        (str,),
                },
                'attribute_map': {
                    'board_no': 'board_no',
                    'devices': 'devices',
                    'enable_ahs': 'enable_ahs',
                    'enable_ahs_actions': 'enable_ahs_actions',
                    'enable_ahs_cas': 'enable_ahs_cas',
                    'id__in': 'id__in',
                    'is_reserved': 'is_reserved',
                    'is_reserved_filter': 'is_reserved_filter',
                    'name': 'name',
                    'ordering': 'ordering',
                    'page': 'page',
                    'part_family': 'part_family',
                    'part_no': 'part_no',
                    'room': 'room',
                    'search': 'search',
                    'site': 'site',
                    'source': 'source',
                    'status': 'status',
                },
                'location_map': {
                    'board_no': 'query',
                    'devices': 'query',
                    'enable_ahs': 'query',
                    'enable_ahs_actions': 'query',
                    'enable_ahs_cas': 'query',
                    'id__in': 'query',
                    'is_reserved': 'query',
                    'is_reserved_filter': 'query',
                    'name': 'query',
                    'ordering': 'query',
                    'page': 'query',
                    'part_family': 'query',
                    'part_no': 'query',
                    'room': 'query',
                    'search': 'query',
                    'site': 'query',
                    'source': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                    'devices': 'multi',
                    'id__in': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_create_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceGroupSerializerWithDevicePk,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/',
                'operation_id': 'groups_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_group_serializer_with_device_pk',
                ],
                'required': [
                    'device_group_serializer_with_device_pk',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_group_serializer_with_device_pk':
                        (DeviceGroupSerializerWithDevicePk,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'device_group_serializer_with_device_pk': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.groups_create_with_devices_create_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/create-with-devices',
                'operation_id': 'groups_create_with_devices_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'nested_device_group',
                ],
                'required': [
                    'nested_device_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'nested_device_group':
                        (NestedDeviceGroup,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'nested_device_group': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.groups_destroy_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/',
                'operation_id': 'groups_destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedDeviceGroupList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/',
                'operation_id': 'groups_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_no',
                    'devices',
                    'enable_ahs',
                    'enable_ahs_actions',
                    'enable_ahs_cas',
                    'force_mv',
                    'id__in',
                    'include_permission_groups',
                    'is_reserved',
                    'is_reserved_filter',
                    'name',
                    'ordering',
                    'page',
                    'part_family',
                    'part_no',
                    'regex_search',
                    'room',
                    'search',
                    'site',
                    'source',
                    'status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'force_mv',
                    'source',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('force_mv',): {

                        "DEFAULT": "DEFAULT",
                        "OFF": "OFF",
                        "ON": "ON"
                    },
                    ('source',): {

                        "OTHER": "OTHER",
                        "TERRAFORM": "TERRAFORM",
                        "UI": "UI",
                        "XML": "XML"
                    },
                },
                'openapi_types': {
                    'board_no':
                        (str,),
                    'devices':
                        ([int],),
                    'enable_ahs':
                        (bool,),
                    'enable_ahs_actions':
                        (bool,),
                    'enable_ahs_cas':
                        (bool,),
                    'force_mv':
                        (str,),
                    'id__in':
                        ([str],),
                    'include_permission_groups':
                        (bool,),
                    'is_reserved':
                        (bool,),
                    'is_reserved_filter':
                        (bool,),
                    'name':
                        (str,),
                    'ordering':
                        (str,),
                    'page':
                        (int,),
                    'part_family':
                        (str,),
                    'part_no':
                        (str,),
                    'regex_search':
                        (str,),
                    'room':
                        (str,),
                    'search':
                        (str,),
                    'site':
                        (str,),
                    'source':
                        (str,),
                    'status':
                        (str,),
                },
                'attribute_map': {
                    'board_no': 'board_no',
                    'devices': 'devices',
                    'enable_ahs': 'enable_ahs',
                    'enable_ahs_actions': 'enable_ahs_actions',
                    'enable_ahs_cas': 'enable_ahs_cas',
                    'force_mv': 'force_mv',
                    'id__in': 'id__in',
                    'include_permission_groups': 'include_permission_groups',
                    'is_reserved': 'is_reserved',
                    'is_reserved_filter': 'is_reserved_filter',
                    'name': 'name',
                    'ordering': 'ordering',
                    'page': 'page',
                    'part_family': 'part_family',
                    'part_no': 'part_no',
                    'regex_search': 'regex_search',
                    'room': 'room',
                    'search': 'search',
                    'site': 'site',
                    'source': 'source',
                    'status': 'status',
                },
                'location_map': {
                    'board_no': 'query',
                    'devices': 'query',
                    'enable_ahs': 'query',
                    'enable_ahs_actions': 'query',
                    'enable_ahs_cas': 'query',
                    'force_mv': 'query',
                    'id__in': 'query',
                    'include_permission_groups': 'query',
                    'is_reserved': 'query',
                    'is_reserved_filter': 'query',
                    'name': 'query',
                    'ordering': 'query',
                    'page': 'query',
                    'part_family': 'query',
                    'part_no': 'query',
                    'regex_search': 'query',
                    'room': 'query',
                    'search': 'query',
                    'site': 'query',
                    'source': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                    'devices': 'multi',
                    'id__in': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_location_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (GroupLocation,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{device_group_pk}/location/',
                'operation_id': 'groups_location_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_group_pk',
                ],
                'required': [
                    'device_group_pk',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_group_pk':
                        (str,),
                },
                'attribute_map': {
                    'device_group_pk': 'device_group_pk',
                },
                'location_map': {
                    'device_group_pk': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_my_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedDeviceGroupList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/my/',
                'operation_id': 'groups_my_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_no',
                    'devices',
                    'enable_ahs',
                    'enable_ahs_actions',
                    'enable_ahs_cas',
                    'id__in',
                    'is_reserved',
                    'is_reserved_filter',
                    'name',
                    'ordering',
                    'page',
                    'part_family',
                    'part_no',
                    'regex_search',
                    'room',
                    'search',
                    'site',
                    'source',
                    'status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'source',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('source',): {

                        "OTHER": "OTHER",
                        "TERRAFORM": "TERRAFORM",
                        "UI": "UI",
                        "XML": "XML"
                    },
                },
                'openapi_types': {
                    'board_no':
                        (str,),
                    'devices':
                        ([int],),
                    'enable_ahs':
                        (bool,),
                    'enable_ahs_actions':
                        (bool,),
                    'enable_ahs_cas':
                        (bool,),
                    'id__in':
                        ([str],),
                    'is_reserved':
                        (bool,),
                    'is_reserved_filter':
                        (bool,),
                    'name':
                        (str,),
                    'ordering':
                        (str,),
                    'page':
                        (int,),
                    'part_family':
                        (str,),
                    'part_no':
                        (str,),
                    'regex_search':
                        (str,),
                    'room':
                        (str,),
                    'search':
                        (str,),
                    'site':
                        (str,),
                    'source':
                        (str,),
                    'status':
                        (str,),
                },
                'attribute_map': {
                    'board_no': 'board_no',
                    'devices': 'devices',
                    'enable_ahs': 'enable_ahs',
                    'enable_ahs_actions': 'enable_ahs_actions',
                    'enable_ahs_cas': 'enable_ahs_cas',
                    'id__in': 'id__in',
                    'is_reserved': 'is_reserved',
                    'is_reserved_filter': 'is_reserved_filter',
                    'name': 'name',
                    'ordering': 'ordering',
                    'page': 'page',
                    'part_family': 'part_family',
                    'part_no': 'part_no',
                    'regex_search': 'regex_search',
                    'room': 'room',
                    'search': 'search',
                    'site': 'site',
                    'source': 'source',
                    'status': 'status',
                },
                'location_map': {
                    'board_no': 'query',
                    'devices': 'query',
                    'enable_ahs': 'query',
                    'enable_ahs_actions': 'query',
                    'enable_ahs_cas': 'query',
                    'id__in': 'query',
                    'is_reserved': 'query',
                    'is_reserved_filter': 'query',
                    'name': 'query',
                    'ordering': 'query',
                    'page': 'query',
                    'part_family': 'query',
                    'part_no': 'query',
                    'regex_search': 'query',
                    'room': 'query',
                    'search': 'query',
                    'site': 'query',
                    'source': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                    'devices': 'multi',
                    'id__in': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceGroupSerializerWithDevicePk,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/',
                'operation_id': 'groups_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_device_group_serializer_with_device_pk',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_device_group_serializer_with_device_pk':
                        (PatchedDeviceGroupSerializerWithDevicePk,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_device_group_serializer_with_device_pk': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.groups_permissions_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectPermissions,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/permissions/',
                'operation_id': 'groups_permissions_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_object_permissions',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_object_permissions':
                        (PatchedObjectPermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_object_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.groups_permissions_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectPermissions,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/permissions/',
                'operation_id': 'groups_permissions_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_permissions_update_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectPermissions,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/permissions/',
                'operation_id': 'groups_permissions_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'object_permissions',
                ],
                'required': [
                    'id',
                    'object_permissions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'object_permissions':
                        (ObjectPermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'object_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.groups_release_by_name_update_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{group_name}/release_by_name/',
                'operation_id': 'groups_release_by_name_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_name',
                ],
                'required': [
                    'group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_name':
                        (str,),
                },
                'attribute_map': {
                    'group_name': 'group_name',
                },
                'location_map': {
                    'group_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_release_update_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/release/',
                'operation_id': 'groups_release_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_reserve_by_name_update_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{group_name}/reserve_by_name/',
                'operation_id': 'groups_reserve_by_name_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_name',
                    'details',
                ],
                'required': [
                    'group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_name':
                        (str,),
                    'details':
                        (str,),
                },
                'attribute_map': {
                    'group_name': 'group_name',
                    'details': 'details',
                },
                'location_map': {
                    'group_name': 'path',
                    'details': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_reserve_update_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/reserve/',
                'operation_id': 'groups_reserve_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'details',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'details':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'details': 'details',
                },
                'location_map': {
                    'id': 'path',
                    'details': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/',
                'operation_id': 'groups_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'include_permission_groups',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'include_permission_groups':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'include_permission_groups': 'include_permission_groups',
                },
                'location_map': {
                    'id': 'path',
                    'include_permission_groups': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.groups_status_create_endpoint = _Endpoint(
            settings={
                'response_type': (ResourceStatusRequest,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/status/',
                'operation_id': 'groups_status_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'resource_status_request',
                ],
                'required': [
                    'id',
                    'resource_status_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'resource_status_request':
                        (ResourceStatusRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'resource_status_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.groups_update_endpoint = _Endpoint(
            settings={
                'response_type': (DeviceGroupSerializerWithDevicePk,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/groups/{id}/',
                'operation_id': 'groups_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'device_group_serializer_with_device_pk',
                ],
                'required': [
                    'id',
                    'device_group_serializer_with_device_pk',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'device_group_serializer_with_device_pk':
                        (DeviceGroupSerializerWithDevicePk,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'device_group_serializer_with_device_pk': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def groups_analytics_batch_get_create(
        self,
        device_group_id_list,
        **kwargs
    ):
        """groups_analytics_batch_get_create  # noqa: E501

        Get usage analytics for multiple device groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_analytics_batch_get_create(device_group_id_list, async_req=True)
        >>> result = thread.get()

        Args:
            device_group_id_list (DeviceGroupIdList):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MDGAnalyticsWithMeta
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_group_id_list'] = \
            device_group_id_list
        return self.groups_analytics_batch_get_create_endpoint.call_with_http_info(**kwargs)

    def groups_analytics_retrieve(
        self,
        id,
        **kwargs
    ):
        """groups_analytics_retrieve  # noqa: E501

        Get usage analytics for a device group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_analytics_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group analytics.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SDGAnalyticsWithMeta
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.groups_analytics_retrieve_endpoint.call_with_http_info(**kwargs)

    def groups_available_list(
        self,
        **kwargs
    ):
        """groups_available_list  # noqa: E501

        Viewset for DeviceGroup model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_available_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            board_no (str): [optional]
            devices ([int]): [optional]
            enable_ahs (bool): [optional]
            enable_ahs_actions (bool): [optional]
            enable_ahs_cas (bool): [optional]
            id__in ([str]): Multiple values may be separated by commas.. [optional]
            is_reserved (bool): [optional]
            is_reserved_filter (bool): [optional]
            name (str): [optional]
            ordering (str): Which field to use when ordering the results.. [optional]
            page (int): A page number within the paginated result set.. [optional]
            part_family (str): [optional]
            part_no (str): [optional]
            room (str): [optional]
            search (str): A search term.. [optional]
            site (str): [optional]
            source (str): * `TERRAFORM` - Terraform * `XML` - XML * `UI` - UI * `OTHER` - Other. [optional]
            status (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedDeviceGroupList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.groups_available_list_endpoint.call_with_http_info(**kwargs)

    def groups_create(
        self,
        device_group_serializer_with_device_pk,
        **kwargs
    ):
        """groups_create  # noqa: E501

        Viewset for DeviceGroup model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_create(device_group_serializer_with_device_pk, async_req=True)
        >>> result = thread.get()

        Args:
            device_group_serializer_with_device_pk (DeviceGroupSerializerWithDevicePk):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceGroupSerializerWithDevicePk
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_group_serializer_with_device_pk'] = \
            device_group_serializer_with_device_pk
        return self.groups_create_endpoint.call_with_http_info(**kwargs)

    def groups_create_with_devices_create(
        self,
        nested_device_group,
        **kwargs
    ):
        """groups_create_with_devices_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_create_with_devices_create(nested_device_group, async_req=True)
        >>> result = thread.get()

        Args:
            nested_device_group (NestedDeviceGroup):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['nested_device_group'] = \
            nested_device_group
        return self.groups_create_with_devices_create_endpoint.call_with_http_info(**kwargs)

    def groups_destroy(
        self,
        id,
        **kwargs
    ):
        """groups_destroy  # noqa: E501

        Viewset for DeviceGroup model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_destroy(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.groups_destroy_endpoint.call_with_http_info(**kwargs)

    def groups_list(
        self,
        **kwargs
    ):
        """groups_list  # noqa: E501

        Viewset for DeviceGroup model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            board_no (str): [optional]
            devices ([int]): [optional]
            enable_ahs (bool): [optional]
            enable_ahs_actions (bool): [optional]
            enable_ahs_cas (bool): [optional]
            force_mv (str): Specifies the behavior of the force_mv attribute. DEFAULT : Default condition which retrieve data from the Materialized view unless ax exception occurs where we fall back to postgres. ON : Force the data to be retrieved from the Materialized view. OFF : Force the data to be retrieved from the Postgres database. [optional] if omitted the server will use the default value of "DEFAULT"
            id__in ([str]): Multiple values may be separated by commas.. [optional]
            include_permission_groups (bool): If set to true, the permission groups associated with this resource will be included in the response. Defaults to false.. [optional] if omitted the server will use the default value of False
            is_reserved (bool): [optional]
            is_reserved_filter (bool): [optional]
            name (str): [optional]
            ordering (str): Which field to use when ordering the results.. [optional]
            page (int): A page number within the paginated result set.. [optional]
            part_family (str): [optional]
            part_no (str): [optional]
            regex_search (str): Regex pattern to search across Name, Metadata, Device Name, Device Part, Device Site.. [optional]
            room (str): [optional]
            search (str): A search term.. [optional]
            site (str): [optional]
            source (str): * `TERRAFORM` - Terraform * `XML` - XML * `UI` - UI * `OTHER` - Other. [optional]
            status (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedDeviceGroupList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.groups_list_endpoint.call_with_http_info(**kwargs)

    def groups_location_retrieve(
        self,
        device_group_pk,
        **kwargs
    ):
        """groups_location_retrieve  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_location_retrieve(device_group_pk, async_req=True)
        >>> result = thread.get()

        Args:
            device_group_pk (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupLocation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_group_pk'] = \
            device_group_pk
        return self.groups_location_retrieve_endpoint.call_with_http_info(**kwargs)

    def groups_my_list(
        self,
        **kwargs
    ):
        """groups_my_list  # noqa: E501

        Returns device groups reserved by the current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_my_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            board_no (str): [optional]
            devices ([int]): [optional]
            enable_ahs (bool): [optional]
            enable_ahs_actions (bool): [optional]
            enable_ahs_cas (bool): [optional]
            id__in ([str]): Multiple values may be separated by commas.. [optional]
            is_reserved (bool): [optional]
            is_reserved_filter (bool): [optional]
            name (str): [optional]
            ordering (str): Which field to use when ordering the results.. [optional]
            page (int): A page number within the paginated result set.. [optional]
            part_family (str): [optional]
            part_no (str): [optional]
            regex_search (str): Regex pattern to search across Name, Metadata, Device Name, Device Part, Device Site.. [optional]
            room (str): [optional]
            search (str): A search term.. [optional]
            site (str): [optional]
            source (str): * `TERRAFORM` - Terraform * `XML` - XML * `UI` - UI * `OTHER` - Other. [optional]
            status (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedDeviceGroupList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.groups_my_list_endpoint.call_with_http_info(**kwargs)

    def groups_partial_update(
        self,
        id,
        **kwargs
    ):
        """groups_partial_update  # noqa: E501

        Viewset for DeviceGroup model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_partial_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.

        Keyword Args:
            patched_device_group_serializer_with_device_pk (PatchedDeviceGroupSerializerWithDevicePk): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceGroupSerializerWithDevicePk
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.groups_partial_update_endpoint.call_with_http_info(**kwargs)

    def groups_permissions_partial_update(
        self,
        id,
        **kwargs
    ):
        """groups_permissions_partial_update  # noqa: E501

        Partially update the object-level permissions for this resource. Can omit top-level fields to leave unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_permissions_partial_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.

        Keyword Args:
            patched_object_permissions (PatchedObjectPermissions): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ObjectPermissions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.groups_permissions_partial_update_endpoint.call_with_http_info(**kwargs)

    def groups_permissions_retrieve(
        self,
        id,
        **kwargs
    ):
        """groups_permissions_retrieve  # noqa: E501

        Get the object-level permissions for this resource. Will return user permissions and user group permissions separately. User permissions  will not include those derived from user group membership.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_permissions_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ObjectPermissions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.groups_permissions_retrieve_endpoint.call_with_http_info(**kwargs)

    def groups_permissions_update(
        self,
        id,
        object_permissions,
        **kwargs
    ):
        """groups_permissions_update  # noqa: E501

        Update the object-level permissions for this resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_permissions_update(id, object_permissions, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.
            object_permissions (ObjectPermissions):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ObjectPermissions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['object_permissions'] = \
            object_permissions
        return self.groups_permissions_update_endpoint.call_with_http_info(**kwargs)

    def groups_release_by_name_update(
        self,
        group_name,
        **kwargs
    ):
        """groups_release_by_name_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_release_by_name_update(group_name, async_req=True)
        >>> result = thread.get()

        Args:
            group_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['group_name'] = \
            group_name
        return self.groups_release_by_name_update_endpoint.call_with_http_info(**kwargs)

    def groups_release_update(
        self,
        id,
        **kwargs
    ):
        """groups_release_update  # noqa: E501

        Viewset for DeviceGroup model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_release_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.groups_release_update_endpoint.call_with_http_info(**kwargs)

    def groups_reserve_by_name_update(
        self,
        group_name,
        **kwargs
    ):
        """groups_reserve_by_name_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_reserve_by_name_update(group_name, async_req=True)
        >>> result = thread.get()

        Args:
            group_name (str):

        Keyword Args:
            details (str): Additional information such as the jenkins job URL. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['group_name'] = \
            group_name
        return self.groups_reserve_by_name_update_endpoint.call_with_http_info(**kwargs)

    def groups_reserve_update(
        self,
        id,
        **kwargs
    ):
        """groups_reserve_update  # noqa: E501

        Viewset for DeviceGroup model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_reserve_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.

        Keyword Args:
            details (str): Additional information such as the jenkins job URL. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.groups_reserve_update_endpoint.call_with_http_info(**kwargs)

    def groups_retrieve(
        self,
        id,
        **kwargs
    ):
        """groups_retrieve  # noqa: E501

        Viewset for DeviceGroup model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.

        Keyword Args:
            include_permission_groups (bool): If set to true, the permission groups associated with this resource will be included in the response. Defaults to false.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.groups_retrieve_endpoint.call_with_http_info(**kwargs)

    def groups_status_create(
        self,
        id,
        resource_status_request,
        **kwargs
    ):
        """groups_status_create  # noqa: E501

        Modify the device status. A comment is required unless the new status is ACTIVE.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_status_create(id, resource_status_request, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.
            resource_status_request (ResourceStatusRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ResourceStatusRequest
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['resource_status_request'] = \
            resource_status_request
        return self.groups_status_create_endpoint.call_with_http_info(**kwargs)

    def groups_update(
        self,
        id,
        device_group_serializer_with_device_pk,
        **kwargs
    ):
        """groups_update  # noqa: E501

        Viewset for DeviceGroup model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.groups_update(id, device_group_serializer_with_device_pk, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.
            device_group_serializer_with_device_pk (DeviceGroupSerializerWithDevicePk):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeviceGroupSerializerWithDevicePk
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['device_group_serializer_with_device_pk'] = \
            device_group_serializer_with_device_pk
        return self.groups_update_endpoint.call_with_http_info(**kwargs)

