"""
    HW Mux Reservation System

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 2.45.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from hwmux_client.api_client import ApiClient, Endpoint as _Endpoint
from hwmux_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from hwmux_client.model.paginated_device_group_list import PaginatedDeviceGroupList
from hwmux_client.model.paginated_device_serializer_public_list import PaginatedDeviceSerializerPublicList
from hwmux_client.model.paginated_label_list import PaginatedLabelList
from hwmux_client.model.paginated_permission_group_list import PaginatedPermissionGroupList
from hwmux_client.model.patched_permission_group import PatchedPermissionGroup
from hwmux_client.model.patched_resource_permissions import PatchedResourcePermissions
from hwmux_client.model.permission_group import PermissionGroup
from hwmux_client.model.resource_permissions import ResourcePermissions
from hwmux_client.model.user import User


class PermissionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.permissions_groups_create_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/',
                'operation_id': 'permissions_groups_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'permission_group',
                ],
                'required': [
                    'permission_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'permission_group':
                        (PermissionGroup,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'permission_group': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_destroy_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/',
                'operation_id': 'permissions_groups_destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                ],
                'required': [
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name_or_id',
                ]
            },
            root_map={
                'validations': {
                    ('name_or_id',): {

                        'regex': {
                            'pattern': r'^[^\/]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'name_or_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.permissions_groups_device_groups_create_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/device_groups/',
                'operation_id': 'permissions_groups_device_groups_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'resource_permissions',
                ],
                'required': [
                    'name_or_id',
                    'resource_permissions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'resource_permissions':
                        ([ResourcePermissions],),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'resource_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_device_groups_destroy_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/device_groups/{id}/',
                'operation_id': 'permissions_groups_device_groups_destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'name_or_id',
                ],
                'required': [
                    'id',
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'name_or_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'id': 'path',
                    'name_or_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.permissions_groups_device_groups_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedDeviceGroupList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/device_groups/',
                'operation_id': 'permissions_groups_device_groups_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'page',
                    'perms',
                ],
                'required': [
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'perms',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('perms',): {

                        "ADD": "add",
                        "ADD,DELETE": "add,delete",
                        "CHANGE": "change",
                        "CHANGE,ADD": "change,add",
                        "CHANGE,ADD,DELETE": "change,add,delete",
                        "CHANGE,DELETE": "change,delete",
                        "DELETE": "delete",
                        "VIEW": "view",
                        "VIEW,ADD": "view,add",
                        "VIEW,ADD,DELETE": "view,add,delete",
                        "VIEW,CHANGE": "view,change",
                        "VIEW,CHANGE,ADD": "view,change,add",
                        "VIEW,CHANGE,ADD,DELETE": "view,change,add,delete",
                        "VIEW,CHANGE,DELETE": "view,change,delete",
                        "VIEW,DELETE": "view,delete"
                    },
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'page':
                        (int,),
                    'perms':
                        (str,),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                    'page': 'page',
                    'perms': 'perms',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'page': 'query',
                    'perms': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.permissions_groups_device_groups_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (ResourcePermissions,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/device_groups/{id}/',
                'operation_id': 'permissions_groups_device_groups_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'name_or_id',
                    'patched_resource_permissions',
                ],
                'required': [
                    'id',
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'name_or_id':
                        (str,),
                    'patched_resource_permissions':
                        (PatchedResourcePermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'id': 'path',
                    'name_or_id': 'path',
                    'patched_resource_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_device_groups_update_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/device_groups/{id}/',
                'operation_id': 'permissions_groups_device_groups_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'name_or_id',
                    'resource_permissions',
                ],
                'required': [
                    'id',
                    'name_or_id',
                    'resource_permissions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'name_or_id':
                        (str,),
                    'resource_permissions':
                        (ResourcePermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'id': 'path',
                    'name_or_id': 'path',
                    'resource_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_devices_create_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/devices/',
                'operation_id': 'permissions_groups_devices_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'resource_permissions',
                ],
                'required': [
                    'name_or_id',
                    'resource_permissions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'resource_permissions':
                        ([ResourcePermissions],),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'resource_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_devices_destroy_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/devices/{id}/',
                'operation_id': 'permissions_groups_devices_destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'name_or_id',
                ],
                'required': [
                    'id',
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'name_or_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'id': 'path',
                    'name_or_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.permissions_groups_devices_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedDeviceSerializerPublicList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/devices/',
                'operation_id': 'permissions_groups_devices_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'page',
                    'perms',
                ],
                'required': [
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'perms',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('perms',): {

                        "ADD": "add",
                        "ADD,DELETE": "add,delete",
                        "CHANGE": "change",
                        "CHANGE,ADD": "change,add",
                        "CHANGE,ADD,DELETE": "change,add,delete",
                        "CHANGE,DELETE": "change,delete",
                        "DELETE": "delete",
                        "VIEW": "view",
                        "VIEW,ADD": "view,add",
                        "VIEW,ADD,DELETE": "view,add,delete",
                        "VIEW,CHANGE": "view,change",
                        "VIEW,CHANGE,ADD": "view,change,add",
                        "VIEW,CHANGE,ADD,DELETE": "view,change,add,delete",
                        "VIEW,CHANGE,DELETE": "view,change,delete",
                        "VIEW,DELETE": "view,delete"
                    },
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'page':
                        (int,),
                    'perms':
                        (str,),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                    'page': 'page',
                    'perms': 'perms',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'page': 'query',
                    'perms': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.permissions_groups_devices_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (ResourcePermissions,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/devices/{id}/',
                'operation_id': 'permissions_groups_devices_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'name_or_id',
                    'patched_resource_permissions',
                ],
                'required': [
                    'id',
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'name_or_id':
                        (str,),
                    'patched_resource_permissions':
                        (PatchedResourcePermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'id': 'path',
                    'name_or_id': 'path',
                    'patched_resource_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_devices_update_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/devices/{id}/',
                'operation_id': 'permissions_groups_devices_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'name_or_id',
                    'resource_permissions',
                ],
                'required': [
                    'id',
                    'name_or_id',
                    'resource_permissions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'name_or_id':
                        (str,),
                    'resource_permissions':
                        (ResourcePermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'id': 'path',
                    'name_or_id': 'path',
                    'resource_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_labels_create_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/labels/',
                'operation_id': 'permissions_groups_labels_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'resource_permissions',
                ],
                'required': [
                    'name_or_id',
                    'resource_permissions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'resource_permissions':
                        ([ResourcePermissions],),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'resource_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_labels_destroy_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/labels/{id}/',
                'operation_id': 'permissions_groups_labels_destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'name_or_id',
                ],
                'required': [
                    'id',
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'name_or_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'id': 'path',
                    'name_or_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.permissions_groups_labels_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedLabelList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/labels/',
                'operation_id': 'permissions_groups_labels_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'page',
                    'perms',
                ],
                'required': [
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'perms',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('perms',): {

                        "ADD": "add",
                        "ADD,DELETE": "add,delete",
                        "CHANGE": "change",
                        "CHANGE,ADD": "change,add",
                        "CHANGE,ADD,DELETE": "change,add,delete",
                        "CHANGE,DELETE": "change,delete",
                        "DELETE": "delete",
                        "VIEW": "view",
                        "VIEW,ADD": "view,add",
                        "VIEW,ADD,DELETE": "view,add,delete",
                        "VIEW,CHANGE": "view,change",
                        "VIEW,CHANGE,ADD": "view,change,add",
                        "VIEW,CHANGE,ADD,DELETE": "view,change,add,delete",
                        "VIEW,CHANGE,DELETE": "view,change,delete",
                        "VIEW,DELETE": "view,delete"
                    },
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'page':
                        (int,),
                    'perms':
                        (str,),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                    'page': 'page',
                    'perms': 'perms',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'page': 'query',
                    'perms': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.permissions_groups_labels_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (ResourcePermissions,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/labels/{id}/',
                'operation_id': 'permissions_groups_labels_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'name_or_id',
                    'patched_resource_permissions',
                ],
                'required': [
                    'id',
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'name_or_id':
                        (str,),
                    'patched_resource_permissions':
                        (PatchedResourcePermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'id': 'path',
                    'name_or_id': 'path',
                    'patched_resource_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_labels_update_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/labels/{id}/',
                'operation_id': 'permissions_groups_labels_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'name_or_id',
                    'resource_permissions',
                ],
                'required': [
                    'id',
                    'name_or_id',
                    'resource_permissions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'name_or_id':
                        (str,),
                    'resource_permissions':
                        (ResourcePermissions,),
                },
                'attribute_map': {
                    'id': 'id',
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'id': 'path',
                    'name_or_id': 'path',
                    'resource_permissions': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedPermissionGroupList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/',
                'operation_id': 'permissions_groups_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ordering',
                    'page',
                    'search',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ordering':
                        (str,),
                    'page':
                        (int,),
                    'search':
                        (str,),
                },
                'attribute_map': {
                    'ordering': 'ordering',
                    'page': 'page',
                    'search': 'search',
                },
                'location_map': {
                    'ordering': 'query',
                    'page': 'query',
                    'search': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.permissions_groups_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/',
                'operation_id': 'permissions_groups_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'patched_permission_group',
                ],
                'required': [
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name_or_id',
                ]
            },
            root_map={
                'validations': {
                    ('name_or_id',): {

                        'regex': {
                            'pattern': r'^[^\/]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'patched_permission_group':
                        (PatchedPermissionGroup,),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'patched_permission_group': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/',
                'operation_id': 'permissions_groups_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                ],
                'required': [
                    'name_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name_or_id',
                ]
            },
            root_map={
                'validations': {
                    ('name_or_id',): {

                        'regex': {
                            'pattern': r'^[^\/]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'name_or_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.permissions_groups_update_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/',
                'operation_id': 'permissions_groups_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'permission_group',
                ],
                'required': [
                    'name_or_id',
                    'permission_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name_or_id',
                ]
            },
            root_map={
                'validations': {
                    ('name_or_id',): {

                        'regex': {
                            'pattern': r'^[^\/]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'permission_group':
                        (PermissionGroup,),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'permission_group': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_users_create_endpoint = _Endpoint(
            settings={
                'response_type': (PermissionGroup,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/users/',
                'operation_id': 'permissions_groups_users_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'user',
                ],
                'required': [
                    'name_or_id',
                    'user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'user':
                        ([User],),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'user': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.permissions_groups_users_destroy_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/permissions/groups/{name_or_id}/users/{username_or_id}/',
                'operation_id': 'permissions_groups_users_destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'name_or_id',
                    'username_or_id',
                ],
                'required': [
                    'name_or_id',
                    'username_or_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name_or_id':
                        (str,),
                    'username_or_id':
                        (str,),
                },
                'attribute_map': {
                    'name_or_id': 'name_or_id',
                    'username_or_id': 'username_or_id',
                },
                'location_map': {
                    'name_or_id': 'path',
                    'username_or_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )

    def permissions_groups_create(
        self,
        permission_group,
        **kwargs
    ):
        """permissions_groups_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_create(permission_group, async_req=True)
        >>> result = thread.get()

        Args:
            permission_group (PermissionGroup):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['permission_group'] = \
            permission_group
        return self.permissions_groups_create_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_destroy(
        self,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_destroy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_destroy(name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_destroy_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_device_groups_create(
        self,
        name_or_id,
        resource_permissions,
        **kwargs
    ):
        """permissions_groups_device_groups_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_device_groups_create(name_or_id, resource_permissions, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):
            resource_permissions ([ResourcePermissions]):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        kwargs['resource_permissions'] = \
            resource_permissions
        return self.permissions_groups_device_groups_create_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_device_groups_destroy(
        self,
        id,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_device_groups_destroy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_device_groups_destroy(id, name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.
            name_or_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_device_groups_destroy_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_device_groups_list(
        self,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_device_groups_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_device_groups_list(name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):

        Keyword Args:
            page (int): A page number within the paginated result set.. [optional]
            perms (str): Permission types. Only entities with all permissions defined here will be fetched. Defaults to all permissions.. [optional] if omitted the server will use the default value of "view,change,add,delete"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedDeviceGroupList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_device_groups_list_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_device_groups_partial_update(
        self,
        id,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_device_groups_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_device_groups_partial_update(id, name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.
            name_or_id (str):

        Keyword Args:
            patched_resource_permissions (PatchedResourcePermissions): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ResourcePermissions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_device_groups_partial_update_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_device_groups_update(
        self,
        id,
        name_or_id,
        resource_permissions,
        **kwargs
    ):
        """permissions_groups_device_groups_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_device_groups_update(id, name_or_id, resource_permissions, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group.
            name_or_id (str):
            resource_permissions (ResourcePermissions):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['name_or_id'] = \
            name_or_id
        kwargs['resource_permissions'] = \
            resource_permissions
        return self.permissions_groups_device_groups_update_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_devices_create(
        self,
        name_or_id,
        resource_permissions,
        **kwargs
    ):
        """permissions_groups_devices_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_devices_create(name_or_id, resource_permissions, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):
            resource_permissions ([ResourcePermissions]):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        kwargs['resource_permissions'] = \
            resource_permissions
        return self.permissions_groups_devices_create_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_devices_destroy(
        self,
        id,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_devices_destroy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_devices_destroy(id, name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.
            name_or_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_devices_destroy_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_devices_list(
        self,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_devices_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_devices_list(name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):

        Keyword Args:
            page (int): A page number within the paginated result set.. [optional]
            perms (str): Permission types. Only entities with all permissions defined here will be fetched. Defaults to all permissions.. [optional] if omitted the server will use the default value of "view,change,add,delete"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedDeviceSerializerPublicList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_devices_list_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_devices_partial_update(
        self,
        id,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_devices_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_devices_partial_update(id, name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.
            name_or_id (str):

        Keyword Args:
            patched_resource_permissions (PatchedResourcePermissions): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ResourcePermissions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_devices_partial_update_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_devices_update(
        self,
        id,
        name_or_id,
        resource_permissions,
        **kwargs
    ):
        """permissions_groups_devices_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_devices_update(id, name_or_id, resource_permissions, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device.
            name_or_id (str):
            resource_permissions (ResourcePermissions):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['name_or_id'] = \
            name_or_id
        kwargs['resource_permissions'] = \
            resource_permissions
        return self.permissions_groups_devices_update_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_labels_create(
        self,
        name_or_id,
        resource_permissions,
        **kwargs
    ):
        """permissions_groups_labels_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_labels_create(name_or_id, resource_permissions, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):
            resource_permissions ([ResourcePermissions]):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        kwargs['resource_permissions'] = \
            resource_permissions
        return self.permissions_groups_labels_create_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_labels_destroy(
        self,
        id,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_labels_destroy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_labels_destroy(id, name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group label.
            name_or_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_labels_destroy_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_labels_list(
        self,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_labels_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_labels_list(name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):

        Keyword Args:
            page (int): A page number within the paginated result set.. [optional]
            perms (str): Permission types. Only entities with all permissions defined here will be fetched. Defaults to all permissions.. [optional] if omitted the server will use the default value of "view,change,add,delete"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedLabelList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_labels_list_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_labels_partial_update(
        self,
        id,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_labels_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_labels_partial_update(id, name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group label.
            name_or_id (str):

        Keyword Args:
            patched_resource_permissions (PatchedResourcePermissions): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ResourcePermissions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_labels_partial_update_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_labels_update(
        self,
        id,
        name_or_id,
        resource_permissions,
        **kwargs
    ):
        """permissions_groups_labels_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_labels_update(id, name_or_id, resource_permissions, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this device group label.
            name_or_id (str):
            resource_permissions (ResourcePermissions):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['name_or_id'] = \
            name_or_id
        kwargs['resource_permissions'] = \
            resource_permissions
        return self.permissions_groups_labels_update_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_list(
        self,
        **kwargs
    ):
        """permissions_groups_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            ordering (str): Which field to use when ordering the results.. [optional]
            page (int): A page number within the paginated result set.. [optional]
            search (str): A search term.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedPermissionGroupList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.permissions_groups_list_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_partial_update(
        self,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_partial_update(name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):

        Keyword Args:
            patched_permission_group (PatchedPermissionGroup): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_partial_update_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_retrieve(
        self,
        name_or_id,
        **kwargs
    ):
        """permissions_groups_retrieve  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_retrieve(name_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        return self.permissions_groups_retrieve_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_update(
        self,
        name_or_id,
        permission_group,
        **kwargs
    ):
        """permissions_groups_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_update(name_or_id, permission_group, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):
            permission_group (PermissionGroup):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        kwargs['permission_group'] = \
            permission_group
        return self.permissions_groups_update_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_users_create(
        self,
        name_or_id,
        user,
        **kwargs
    ):
        """permissions_groups_users_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_users_create(name_or_id, user, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):
            user ([User]):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PermissionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        kwargs['user'] = \
            user
        return self.permissions_groups_users_create_endpoint.call_with_http_info(**kwargs)

    def permissions_groups_users_destroy(
        self,
        name_or_id,
        username_or_id,
        **kwargs
    ):
        """permissions_groups_users_destroy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permissions_groups_users_destroy(name_or_id, username_or_id, async_req=True)
        >>> result = thread.get()

        Args:
            name_or_id (str):
            username_or_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['name_or_id'] = \
            name_or_id
        kwargs['username_or_id'] = \
            username_or_id
        return self.permissions_groups_users_destroy_endpoint.call_with_http_info(**kwargs)

