"""
    HW Mux Reservation System

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 2.45.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from hwmux_client.api_client import ApiClient, Endpoint as _Endpoint
from hwmux_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from hwmux_client.model.paginated_reservation_session_serializer_read_only_list import PaginatedReservationSessionSerializerReadOnlyList
from hwmux_client.model.reservation_extension_request import ReservationExtensionRequest
from hwmux_client.model.reservation_request import ReservationRequest
from hwmux_client.model.reservation_session_serializer_read_only import ReservationSessionSerializerReadOnly


class ReservationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.reservations_actionable_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedReservationSessionSerializerReadOnlyList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/actionable/',
                'operation_id': 'reservations_actionable_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'a_device_groups',
                    'a_devices',
                    'cancel_existing',
                    'details',
                    'device',
                    'device_group',
                    'id',
                    'include_resource_data',
                    'invert_priority',
                    'label',
                    'lease_duration_s',
                    'max_history',
                    'ordering',
                    'owner',
                    'page',
                    'queue_position',
                    'r_device_group_labels',
                    'r_device_groups',
                    'r_devices',
                    'regex_search',
                    'reservation_wait_time',
                    'search',
                    'state',
                    'status',
                    't_completed',
                    't_completed__after',
                    't_completed__before',
                    't_completed__isnull',
                    't_lease_expires',
                    't_lease_expires__after',
                    't_lease_expires__before',
                    't_lease_expires__isnull',
                    't_queue_position_updated',
                    't_requested',
                    't_requested__after',
                    't_requested__before',
                    't_satisfied',
                    't_satisfied__after',
                    't_satisfied__before',
                    't_satisfied__isnull',
                    'use_watchdog',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'state',
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('state',): {

                        "ACT": "ACT",
                        "CAN_PEND": "CAN_PEND",
                        "CRE_PEND": "CRE_PEND",
                        "EXP": "EXP",
                        "EXP_PEND": "EXP_PEND",
                        "FAIL": "FAIL",
                        "FIN": "FIN",
                        "QUE": "QUE",
                        "REL_PEND": "REL_PEND",
                        "RES_PEND": "RES_PEND"
                    },
                    ('status',): {

                        "EMPTY": "",
                        "ACT": "ACT",
                        "EXP": "EXP",
                        "FIN": "FIN",
                        "QUE": "QUE"
                    },
                },
                'openapi_types': {
                    'a_device_groups':
                        ([int],),
                    'a_devices':
                        ([int],),
                    'cancel_existing':
                        (bool,),
                    'details':
                        (str,),
                    'device':
                        (float,),
                    'device_group':
                        (float,),
                    'id':
                        (str,),
                    'include_resource_data':
                        (bool,),
                    'invert_priority':
                        (bool,),
                    'label':
                        (float,),
                    'lease_duration_s':
                        (int,),
                    'max_history':
                        (datetime,),
                    'ordering':
                        (str,),
                    'owner':
                        (int,),
                    'page':
                        (int,),
                    'queue_position':
                        (int,),
                    'r_device_group_labels':
                        ([int],),
                    'r_device_groups':
                        ([int],),
                    'r_devices':
                        ([int],),
                    'regex_search':
                        (str,),
                    'reservation_wait_time':
                        (int,),
                    'search':
                        (str,),
                    'state':
                        (str,),
                    'status':
                        (str,),
                    't_completed':
                        (datetime,),
                    't_completed__after':
                        (datetime,),
                    't_completed__before':
                        (datetime,),
                    't_completed__isnull':
                        (bool,),
                    't_lease_expires':
                        (datetime,),
                    't_lease_expires__after':
                        (datetime,),
                    't_lease_expires__before':
                        (datetime,),
                    't_lease_expires__isnull':
                        (bool,),
                    't_queue_position_updated':
                        (datetime,),
                    't_requested':
                        (datetime,),
                    't_requested__after':
                        (datetime,),
                    't_requested__before':
                        (datetime,),
                    't_satisfied':
                        (datetime,),
                    't_satisfied__after':
                        (datetime,),
                    't_satisfied__before':
                        (datetime,),
                    't_satisfied__isnull':
                        (bool,),
                    'use_watchdog':
                        (bool,),
                },
                'attribute_map': {
                    'a_device_groups': 'a_device_groups',
                    'a_devices': 'a_devices',
                    'cancel_existing': 'cancel_existing',
                    'details': 'details',
                    'device': 'device',
                    'device_group': 'device_group',
                    'id': 'id',
                    'include_resource_data': 'include_resource_data',
                    'invert_priority': 'invert_priority',
                    'label': 'label',
                    'lease_duration_s': 'lease_duration_s',
                    'max_history': 'max_history',
                    'ordering': 'ordering',
                    'owner': 'owner',
                    'page': 'page',
                    'queue_position': 'queue_position',
                    'r_device_group_labels': 'r_device_group_labels',
                    'r_device_groups': 'r_device_groups',
                    'r_devices': 'r_devices',
                    'regex_search': 'regex_search',
                    'reservation_wait_time': 'reservation_wait_time',
                    'search': 'search',
                    'state': 'state',
                    'status': 'status',
                    't_completed': 't_completed',
                    't_completed__after': 't_completed__after',
                    't_completed__before': 't_completed__before',
                    't_completed__isnull': 't_completed__isnull',
                    't_lease_expires': 't_lease_expires',
                    't_lease_expires__after': 't_lease_expires__after',
                    't_lease_expires__before': 't_lease_expires__before',
                    't_lease_expires__isnull': 't_lease_expires__isnull',
                    't_queue_position_updated': 't_queue_position_updated',
                    't_requested': 't_requested',
                    't_requested__after': 't_requested__after',
                    't_requested__before': 't_requested__before',
                    't_satisfied': 't_satisfied',
                    't_satisfied__after': 't_satisfied__after',
                    't_satisfied__before': 't_satisfied__before',
                    't_satisfied__isnull': 't_satisfied__isnull',
                    'use_watchdog': 'use_watchdog',
                },
                'location_map': {
                    'a_device_groups': 'query',
                    'a_devices': 'query',
                    'cancel_existing': 'query',
                    'details': 'query',
                    'device': 'query',
                    'device_group': 'query',
                    'id': 'query',
                    'include_resource_data': 'query',
                    'invert_priority': 'query',
                    'label': 'query',
                    'lease_duration_s': 'query',
                    'max_history': 'query',
                    'ordering': 'query',
                    'owner': 'query',
                    'page': 'query',
                    'queue_position': 'query',
                    'r_device_group_labels': 'query',
                    'r_device_groups': 'query',
                    'r_devices': 'query',
                    'regex_search': 'query',
                    'reservation_wait_time': 'query',
                    'search': 'query',
                    'state': 'query',
                    'status': 'query',
                    't_completed': 'query',
                    't_completed__after': 'query',
                    't_completed__before': 'query',
                    't_completed__isnull': 'query',
                    't_lease_expires': 'query',
                    't_lease_expires__after': 'query',
                    't_lease_expires__before': 'query',
                    't_lease_expires__isnull': 'query',
                    't_queue_position_updated': 'query',
                    't_requested': 'query',
                    't_requested__after': 'query',
                    't_requested__before': 'query',
                    't_satisfied': 'query',
                    't_satisfied__after': 'query',
                    't_satisfied__before': 'query',
                    't_satisfied__isnull': 'query',
                    'use_watchdog': 'query',
                },
                'collection_format_map': {
                    'a_device_groups': 'multi',
                    'a_devices': 'multi',
                    'r_device_group_labels': 'multi',
                    'r_device_groups': 'multi',
                    'r_devices': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reservations_active_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedReservationSessionSerializerReadOnlyList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/active/',
                'operation_id': 'reservations_active_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'a_device_groups',
                    'a_devices',
                    'cancel_existing',
                    'details',
                    'device',
                    'device_group',
                    'id',
                    'include_resource_data',
                    'invert_priority',
                    'label',
                    'lease_duration_s',
                    'max_history',
                    'ordering',
                    'owner',
                    'page',
                    'queue_position',
                    'r_device_group_labels',
                    'r_device_groups',
                    'r_devices',
                    'regex_search',
                    'reservation_wait_time',
                    'search',
                    'state',
                    'status',
                    't_completed',
                    't_completed__after',
                    't_completed__before',
                    't_completed__isnull',
                    't_lease_expires',
                    't_lease_expires__after',
                    't_lease_expires__before',
                    't_lease_expires__isnull',
                    't_queue_position_updated',
                    't_requested',
                    't_requested__after',
                    't_requested__before',
                    't_satisfied',
                    't_satisfied__after',
                    't_satisfied__before',
                    't_satisfied__isnull',
                    'use_watchdog',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'state',
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('state',): {

                        "ACT": "ACT",
                        "CAN_PEND": "CAN_PEND",
                        "CRE_PEND": "CRE_PEND",
                        "EXP": "EXP",
                        "EXP_PEND": "EXP_PEND",
                        "FAIL": "FAIL",
                        "FIN": "FIN",
                        "QUE": "QUE",
                        "REL_PEND": "REL_PEND",
                        "RES_PEND": "RES_PEND"
                    },
                    ('status',): {

                        "EMPTY": "",
                        "ACT": "ACT",
                        "EXP": "EXP",
                        "FIN": "FIN",
                        "QUE": "QUE"
                    },
                },
                'openapi_types': {
                    'a_device_groups':
                        ([int],),
                    'a_devices':
                        ([int],),
                    'cancel_existing':
                        (bool,),
                    'details':
                        (str,),
                    'device':
                        (float,),
                    'device_group':
                        (float,),
                    'id':
                        (str,),
                    'include_resource_data':
                        (bool,),
                    'invert_priority':
                        (bool,),
                    'label':
                        (float,),
                    'lease_duration_s':
                        (int,),
                    'max_history':
                        (datetime,),
                    'ordering':
                        (str,),
                    'owner':
                        (int,),
                    'page':
                        (int,),
                    'queue_position':
                        (int,),
                    'r_device_group_labels':
                        ([int],),
                    'r_device_groups':
                        ([int],),
                    'r_devices':
                        ([int],),
                    'regex_search':
                        (str,),
                    'reservation_wait_time':
                        (int,),
                    'search':
                        (str,),
                    'state':
                        (str,),
                    'status':
                        (str,),
                    't_completed':
                        (datetime,),
                    't_completed__after':
                        (datetime,),
                    't_completed__before':
                        (datetime,),
                    't_completed__isnull':
                        (bool,),
                    't_lease_expires':
                        (datetime,),
                    't_lease_expires__after':
                        (datetime,),
                    't_lease_expires__before':
                        (datetime,),
                    't_lease_expires__isnull':
                        (bool,),
                    't_queue_position_updated':
                        (datetime,),
                    't_requested':
                        (datetime,),
                    't_requested__after':
                        (datetime,),
                    't_requested__before':
                        (datetime,),
                    't_satisfied':
                        (datetime,),
                    't_satisfied__after':
                        (datetime,),
                    't_satisfied__before':
                        (datetime,),
                    't_satisfied__isnull':
                        (bool,),
                    'use_watchdog':
                        (bool,),
                },
                'attribute_map': {
                    'a_device_groups': 'a_device_groups',
                    'a_devices': 'a_devices',
                    'cancel_existing': 'cancel_existing',
                    'details': 'details',
                    'device': 'device',
                    'device_group': 'device_group',
                    'id': 'id',
                    'include_resource_data': 'include_resource_data',
                    'invert_priority': 'invert_priority',
                    'label': 'label',
                    'lease_duration_s': 'lease_duration_s',
                    'max_history': 'max_history',
                    'ordering': 'ordering',
                    'owner': 'owner',
                    'page': 'page',
                    'queue_position': 'queue_position',
                    'r_device_group_labels': 'r_device_group_labels',
                    'r_device_groups': 'r_device_groups',
                    'r_devices': 'r_devices',
                    'regex_search': 'regex_search',
                    'reservation_wait_time': 'reservation_wait_time',
                    'search': 'search',
                    'state': 'state',
                    'status': 'status',
                    't_completed': 't_completed',
                    't_completed__after': 't_completed__after',
                    't_completed__before': 't_completed__before',
                    't_completed__isnull': 't_completed__isnull',
                    't_lease_expires': 't_lease_expires',
                    't_lease_expires__after': 't_lease_expires__after',
                    't_lease_expires__before': 't_lease_expires__before',
                    't_lease_expires__isnull': 't_lease_expires__isnull',
                    't_queue_position_updated': 't_queue_position_updated',
                    't_requested': 't_requested',
                    't_requested__after': 't_requested__after',
                    't_requested__before': 't_requested__before',
                    't_satisfied': 't_satisfied',
                    't_satisfied__after': 't_satisfied__after',
                    't_satisfied__before': 't_satisfied__before',
                    't_satisfied__isnull': 't_satisfied__isnull',
                    'use_watchdog': 'use_watchdog',
                },
                'location_map': {
                    'a_device_groups': 'query',
                    'a_devices': 'query',
                    'cancel_existing': 'query',
                    'details': 'query',
                    'device': 'query',
                    'device_group': 'query',
                    'id': 'query',
                    'include_resource_data': 'query',
                    'invert_priority': 'query',
                    'label': 'query',
                    'lease_duration_s': 'query',
                    'max_history': 'query',
                    'ordering': 'query',
                    'owner': 'query',
                    'page': 'query',
                    'queue_position': 'query',
                    'r_device_group_labels': 'query',
                    'r_device_groups': 'query',
                    'r_devices': 'query',
                    'regex_search': 'query',
                    'reservation_wait_time': 'query',
                    'search': 'query',
                    'state': 'query',
                    'status': 'query',
                    't_completed': 'query',
                    't_completed__after': 'query',
                    't_completed__before': 'query',
                    't_completed__isnull': 'query',
                    't_lease_expires': 'query',
                    't_lease_expires__after': 'query',
                    't_lease_expires__before': 'query',
                    't_lease_expires__isnull': 'query',
                    't_queue_position_updated': 'query',
                    't_requested': 'query',
                    't_requested__after': 'query',
                    't_requested__before': 'query',
                    't_satisfied': 'query',
                    't_satisfied__after': 'query',
                    't_satisfied__before': 'query',
                    't_satisfied__isnull': 'query',
                    'use_watchdog': 'query',
                },
                'collection_format_map': {
                    'a_device_groups': 'multi',
                    'a_devices': 'multi',
                    'r_device_group_labels': 'multi',
                    'r_device_groups': 'multi',
                    'r_devices': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reservations_cancel_update_endpoint = _Endpoint(
            settings={
                'response_type': (ReservationSessionSerializerReadOnly,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/{id}/cancel/',
                'operation_id': 'reservations_cancel_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reservations_create_endpoint = _Endpoint(
            settings={
                'response_type': (ReservationSessionSerializerReadOnly,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/',
                'operation_id': 'reservations_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'reservation_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'reservation_request':
                        (ReservationRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'reservation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.reservations_extend_update_endpoint = _Endpoint(
            settings={
                'response_type': (ReservationSessionSerializerReadOnly,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/{id}/extend/',
                'operation_id': 'reservations_extend_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'reservation_extension_request',
                ],
                'required': [
                    'id',
                    'reservation_extension_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'reservation_extension_request':
                        (ReservationExtensionRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'reservation_extension_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.reservations_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedReservationSessionSerializerReadOnlyList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/',
                'operation_id': 'reservations_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'a_device_groups',
                    'a_devices',
                    'cancel_existing',
                    'details',
                    'device',
                    'device_group',
                    'id',
                    'include_resource_data',
                    'invert_priority',
                    'label',
                    'lease_duration_s',
                    'ordering',
                    'owner',
                    'page',
                    'queue_position',
                    'r_device_group_labels',
                    'r_device_groups',
                    'r_devices',
                    'regex_search',
                    'reservation_wait_time',
                    'search',
                    'state',
                    'status',
                    't_completed',
                    't_completed__after',
                    't_completed__before',
                    't_completed__isnull',
                    't_lease_expires',
                    't_lease_expires__after',
                    't_lease_expires__before',
                    't_lease_expires__isnull',
                    't_queue_position_updated',
                    't_requested',
                    't_requested__after',
                    't_requested__before',
                    't_satisfied',
                    't_satisfied__after',
                    't_satisfied__before',
                    't_satisfied__isnull',
                    'use_watchdog',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'state',
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('state',): {

                        "ACT": "ACT",
                        "CAN_PEND": "CAN_PEND",
                        "CRE_PEND": "CRE_PEND",
                        "EXP": "EXP",
                        "EXP_PEND": "EXP_PEND",
                        "FAIL": "FAIL",
                        "FIN": "FIN",
                        "QUE": "QUE",
                        "REL_PEND": "REL_PEND",
                        "RES_PEND": "RES_PEND"
                    },
                    ('status',): {

                        "EMPTY": "",
                        "ACT": "ACT",
                        "EXP": "EXP",
                        "FIN": "FIN",
                        "QUE": "QUE"
                    },
                },
                'openapi_types': {
                    'a_device_groups':
                        ([int],),
                    'a_devices':
                        ([int],),
                    'cancel_existing':
                        (bool,),
                    'details':
                        (str,),
                    'device':
                        (float,),
                    'device_group':
                        (float,),
                    'id':
                        (str,),
                    'include_resource_data':
                        (bool,),
                    'invert_priority':
                        (bool,),
                    'label':
                        (float,),
                    'lease_duration_s':
                        (int,),
                    'ordering':
                        (str,),
                    'owner':
                        (int,),
                    'page':
                        (int,),
                    'queue_position':
                        (int,),
                    'r_device_group_labels':
                        ([int],),
                    'r_device_groups':
                        ([int],),
                    'r_devices':
                        ([int],),
                    'regex_search':
                        (str,),
                    'reservation_wait_time':
                        (int,),
                    'search':
                        (str,),
                    'state':
                        (str,),
                    'status':
                        (str,),
                    't_completed':
                        (datetime,),
                    't_completed__after':
                        (datetime,),
                    't_completed__before':
                        (datetime,),
                    't_completed__isnull':
                        (bool,),
                    't_lease_expires':
                        (datetime,),
                    't_lease_expires__after':
                        (datetime,),
                    't_lease_expires__before':
                        (datetime,),
                    't_lease_expires__isnull':
                        (bool,),
                    't_queue_position_updated':
                        (datetime,),
                    't_requested':
                        (datetime,),
                    't_requested__after':
                        (datetime,),
                    't_requested__before':
                        (datetime,),
                    't_satisfied':
                        (datetime,),
                    't_satisfied__after':
                        (datetime,),
                    't_satisfied__before':
                        (datetime,),
                    't_satisfied__isnull':
                        (bool,),
                    'use_watchdog':
                        (bool,),
                },
                'attribute_map': {
                    'a_device_groups': 'a_device_groups',
                    'a_devices': 'a_devices',
                    'cancel_existing': 'cancel_existing',
                    'details': 'details',
                    'device': 'device',
                    'device_group': 'device_group',
                    'id': 'id',
                    'include_resource_data': 'include_resource_data',
                    'invert_priority': 'invert_priority',
                    'label': 'label',
                    'lease_duration_s': 'lease_duration_s',
                    'ordering': 'ordering',
                    'owner': 'owner',
                    'page': 'page',
                    'queue_position': 'queue_position',
                    'r_device_group_labels': 'r_device_group_labels',
                    'r_device_groups': 'r_device_groups',
                    'r_devices': 'r_devices',
                    'regex_search': 'regex_search',
                    'reservation_wait_time': 'reservation_wait_time',
                    'search': 'search',
                    'state': 'state',
                    'status': 'status',
                    't_completed': 't_completed',
                    't_completed__after': 't_completed__after',
                    't_completed__before': 't_completed__before',
                    't_completed__isnull': 't_completed__isnull',
                    't_lease_expires': 't_lease_expires',
                    't_lease_expires__after': 't_lease_expires__after',
                    't_lease_expires__before': 't_lease_expires__before',
                    't_lease_expires__isnull': 't_lease_expires__isnull',
                    't_queue_position_updated': 't_queue_position_updated',
                    't_requested': 't_requested',
                    't_requested__after': 't_requested__after',
                    't_requested__before': 't_requested__before',
                    't_satisfied': 't_satisfied',
                    't_satisfied__after': 't_satisfied__after',
                    't_satisfied__before': 't_satisfied__before',
                    't_satisfied__isnull': 't_satisfied__isnull',
                    'use_watchdog': 'use_watchdog',
                },
                'location_map': {
                    'a_device_groups': 'query',
                    'a_devices': 'query',
                    'cancel_existing': 'query',
                    'details': 'query',
                    'device': 'query',
                    'device_group': 'query',
                    'id': 'query',
                    'include_resource_data': 'query',
                    'invert_priority': 'query',
                    'label': 'query',
                    'lease_duration_s': 'query',
                    'ordering': 'query',
                    'owner': 'query',
                    'page': 'query',
                    'queue_position': 'query',
                    'r_device_group_labels': 'query',
                    'r_device_groups': 'query',
                    'r_devices': 'query',
                    'regex_search': 'query',
                    'reservation_wait_time': 'query',
                    'search': 'query',
                    'state': 'query',
                    'status': 'query',
                    't_completed': 'query',
                    't_completed__after': 'query',
                    't_completed__before': 'query',
                    't_completed__isnull': 'query',
                    't_lease_expires': 'query',
                    't_lease_expires__after': 'query',
                    't_lease_expires__before': 'query',
                    't_lease_expires__isnull': 'query',
                    't_queue_position_updated': 'query',
                    't_requested': 'query',
                    't_requested__after': 'query',
                    't_requested__before': 'query',
                    't_satisfied': 'query',
                    't_satisfied__after': 'query',
                    't_satisfied__before': 'query',
                    't_satisfied__isnull': 'query',
                    'use_watchdog': 'query',
                },
                'collection_format_map': {
                    'a_device_groups': 'multi',
                    'a_devices': 'multi',
                    'r_device_group_labels': 'multi',
                    'r_device_groups': 'multi',
                    'r_devices': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reservations_metadata_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (ReservationSessionSerializerReadOnly,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/{id}/metadata/',
                'operation_id': 'reservations_metadata_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'request_body',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'request_body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.reservations_metadata_update_endpoint = _Endpoint(
            settings={
                'response_type': (ReservationSessionSerializerReadOnly,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/{id}/metadata/',
                'operation_id': 'reservations_metadata_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'request_body',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'request_body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.reservations_release_update_endpoint = _Endpoint(
            settings={
                'response_type': (ReservationSessionSerializerReadOnly,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/{id}/release/',
                'operation_id': 'reservations_release_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reservations_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (ReservationSessionSerializerReadOnly,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/{id}/',
                'operation_id': 'reservations_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reservations_update_endpoint = _Endpoint(
            settings={
                'response_type': (ReservationSessionSerializerReadOnly,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/reservations/{id}/',
                'operation_id': 'reservations_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def reservations_actionable_list(
        self,
        **kwargs
    ):
        """reservations_actionable_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_actionable_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            a_device_groups ([int]): [optional]
            a_devices ([int]): [optional]
            cancel_existing (bool): [optional]
            details (str): [optional]
            device (float): [optional]
            device_group (float): [optional]
            id (str): [optional]
            include_resource_data (bool): Whether to include the detailed data for all resources related to the reservation.. [optional] if omitted the server will use the default value of False
            invert_priority (bool): [optional]
            label (float): [optional]
            lease_duration_s (int): [optional]
            max_history (datetime): Filter out reservations that expired before the specified datetime. Defaults to 24 hours prior.. [optional]
            ordering (str): Which field to use when ordering the results.. [optional]
            owner (int): [optional]
            page (int): A page number within the paginated result set.. [optional]
            queue_position (int): [optional]
            r_device_group_labels ([int]): [optional]
            r_device_groups ([int]): [optional]
            r_devices ([int]): [optional]
            regex_search (str): Regex pattern to search across Owner, Device, Group, Label, and Metadata.. [optional]
            reservation_wait_time (int): [optional]
            search (str): A search term.. [optional]
            state (str): * `CRE_PEND` - create_pending * `QUE` - queued * `RES_PEND` - reservation_pending * `ACT` - active * `CAN_PEND` - cancel_pending * `REL_PEND` - release_pending * `FIN` - finished * `EXP_PEND` - expire_pending * `EXP` - expired * `FAIL` - failed. [optional]
            status (str): * `ACT` - Active * `FIN` - Finished * `QUE` - Queued * `EXP` - Expired * `` - Any. [optional]
            t_completed (datetime): [optional]
            t_completed__after (datetime): [optional]
            t_completed__before (datetime): [optional]
            t_completed__isnull (bool): [optional]
            t_lease_expires (datetime): [optional]
            t_lease_expires__after (datetime): [optional]
            t_lease_expires__before (datetime): [optional]
            t_lease_expires__isnull (bool): [optional]
            t_queue_position_updated (datetime): [optional]
            t_requested (datetime): [optional]
            t_requested__after (datetime): [optional]
            t_requested__before (datetime): [optional]
            t_satisfied (datetime): [optional]
            t_satisfied__after (datetime): [optional]
            t_satisfied__before (datetime): [optional]
            t_satisfied__isnull (bool): [optional]
            use_watchdog (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedReservationSessionSerializerReadOnlyList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.reservations_actionable_list_endpoint.call_with_http_info(**kwargs)

    def reservations_active_list(
        self,
        **kwargs
    ):
        """reservations_active_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_active_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            a_device_groups ([int]): [optional]
            a_devices ([int]): [optional]
            cancel_existing (bool): [optional]
            details (str): [optional]
            device (float): [optional]
            device_group (float): [optional]
            id (str): [optional]
            include_resource_data (bool): Whether to include the detailed data for all resources related to the reservation.. [optional] if omitted the server will use the default value of False
            invert_priority (bool): [optional]
            label (float): [optional]
            lease_duration_s (int): [optional]
            max_history (datetime): Filter out reservations that expired before the specified datetime. Defaults to 24 hours prior.. [optional]
            ordering (str): Which field to use when ordering the results.. [optional]
            owner (int): [optional]
            page (int): A page number within the paginated result set.. [optional]
            queue_position (int): [optional]
            r_device_group_labels ([int]): [optional]
            r_device_groups ([int]): [optional]
            r_devices ([int]): [optional]
            regex_search (str): Regex pattern to search across Owner, Device, Group, Label, and Metadata.. [optional]
            reservation_wait_time (int): [optional]
            search (str): A search term.. [optional]
            state (str): * `CRE_PEND` - create_pending * `QUE` - queued * `RES_PEND` - reservation_pending * `ACT` - active * `CAN_PEND` - cancel_pending * `REL_PEND` - release_pending * `FIN` - finished * `EXP_PEND` - expire_pending * `EXP` - expired * `FAIL` - failed. [optional]
            status (str): * `ACT` - Active * `FIN` - Finished * `QUE` - Queued * `EXP` - Expired * `` - Any. [optional]
            t_completed (datetime): [optional]
            t_completed__after (datetime): [optional]
            t_completed__before (datetime): [optional]
            t_completed__isnull (bool): [optional]
            t_lease_expires (datetime): [optional]
            t_lease_expires__after (datetime): [optional]
            t_lease_expires__before (datetime): [optional]
            t_lease_expires__isnull (bool): [optional]
            t_queue_position_updated (datetime): [optional]
            t_requested (datetime): [optional]
            t_requested__after (datetime): [optional]
            t_requested__before (datetime): [optional]
            t_satisfied (datetime): [optional]
            t_satisfied__after (datetime): [optional]
            t_satisfied__before (datetime): [optional]
            t_satisfied__isnull (bool): [optional]
            use_watchdog (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedReservationSessionSerializerReadOnlyList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.reservations_active_list_endpoint.call_with_http_info(**kwargs)

    def reservations_cancel_update(
        self,
        id,
        **kwargs
    ):
        """reservations_cancel_update  # noqa: E501

        Release the reservation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_cancel_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this reservation session.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ReservationSessionSerializerReadOnly
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.reservations_cancel_update_endpoint.call_with_http_info(**kwargs)

    def reservations_create(
        self,
        **kwargs
    ):
        """reservations_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_create(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            reservation_request (ReservationRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ReservationSessionSerializerReadOnly
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.reservations_create_endpoint.call_with_http_info(**kwargs)

    def reservations_extend_update(
        self,
        id,
        reservation_extension_request,
        **kwargs
    ):
        """reservations_extend_update  # noqa: E501

        Extend an Active or Queue reservation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_extend_update(id, reservation_extension_request, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this reservation session.
            reservation_extension_request (ReservationExtensionRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ReservationSessionSerializerReadOnly
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['reservation_extension_request'] = \
            reservation_extension_request
        return self.reservations_extend_update_endpoint.call_with_http_info(**kwargs)

    def reservations_list(
        self,
        **kwargs
    ):
        """reservations_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            a_device_groups ([int]): [optional]
            a_devices ([int]): [optional]
            cancel_existing (bool): [optional]
            details (str): [optional]
            device (float): [optional]
            device_group (float): [optional]
            id (str): [optional]
            include_resource_data (bool): Whether to include the detailed data for all resources related to the reservation.. [optional] if omitted the server will use the default value of False
            invert_priority (bool): [optional]
            label (float): [optional]
            lease_duration_s (int): [optional]
            ordering (str): Which field to use when ordering the results.. [optional]
            owner (int): [optional]
            page (int): A page number within the paginated result set.. [optional]
            queue_position (int): [optional]
            r_device_group_labels ([int]): [optional]
            r_device_groups ([int]): [optional]
            r_devices ([int]): [optional]
            regex_search (str): Regex pattern to search across fields. [optional]
            reservation_wait_time (int): [optional]
            search (str): A search term.. [optional]
            state (str): * `CRE_PEND` - create_pending * `QUE` - queued * `RES_PEND` - reservation_pending * `ACT` - active * `CAN_PEND` - cancel_pending * `REL_PEND` - release_pending * `FIN` - finished * `EXP_PEND` - expire_pending * `EXP` - expired * `FAIL` - failed. [optional]
            status (str): * `ACT` - Active * `FIN` - Finished * `QUE` - Queued * `EXP` - Expired * `` - Any. [optional]
            t_completed (datetime): [optional]
            t_completed__after (datetime): [optional]
            t_completed__before (datetime): [optional]
            t_completed__isnull (bool): [optional]
            t_lease_expires (datetime): [optional]
            t_lease_expires__after (datetime): [optional]
            t_lease_expires__before (datetime): [optional]
            t_lease_expires__isnull (bool): [optional]
            t_queue_position_updated (datetime): [optional]
            t_requested (datetime): [optional]
            t_requested__after (datetime): [optional]
            t_requested__before (datetime): [optional]
            t_satisfied (datetime): [optional]
            t_satisfied__after (datetime): [optional]
            t_satisfied__before (datetime): [optional]
            t_satisfied__isnull (bool): [optional]
            use_watchdog (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedReservationSessionSerializerReadOnlyList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.reservations_list_endpoint.call_with_http_info(**kwargs)

    def reservations_metadata_partial_update(
        self,
        id,
        **kwargs
    ):
        """reservations_metadata_partial_update  # noqa: E501

        Update the reservation metadata. Use PUT to replace the existing data entirely and PATCH to update without deleting existing values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_metadata_partial_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this reservation session.

        Keyword Args:
            request_body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ReservationSessionSerializerReadOnly
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.reservations_metadata_partial_update_endpoint.call_with_http_info(**kwargs)

    def reservations_metadata_update(
        self,
        id,
        **kwargs
    ):
        """reservations_metadata_update  # noqa: E501

        Update the reservation metadata. Use PUT to replace the existing data entirely and PATCH to update without deleting existing values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_metadata_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this reservation session.

        Keyword Args:
            request_body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ReservationSessionSerializerReadOnly
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.reservations_metadata_update_endpoint.call_with_http_info(**kwargs)

    def reservations_release_update(
        self,
        id,
        **kwargs
    ):
        """reservations_release_update  # noqa: E501

        Release the reservation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_release_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this reservation session.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ReservationSessionSerializerReadOnly
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.reservations_release_update_endpoint.call_with_http_info(**kwargs)

    def reservations_retrieve(
        self,
        id,
        **kwargs
    ):
        """reservations_retrieve  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this reservation session.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ReservationSessionSerializerReadOnly
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.reservations_retrieve_endpoint.call_with_http_info(**kwargs)

    def reservations_update(
        self,
        id,
        **kwargs
    ):
        """reservations_update  # noqa: E501

        Check queue status or renew lease if reservation is ongoing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reservations_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this reservation session.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ReservationSessionSerializerReadOnly
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.reservations_update_endpoint.call_with_http_info(**kwargs)

