#  Hydrogram - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-2023 Dan <https://github.com/delivrance>
#  Copyright (C) 2023-present Hydrogram <https://hydrogram.org>
#
#  This file is part of Hydrogram.
#
#  Hydrogram is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Hydrogram is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with Hydrogram.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import annotations

from typing import ClassVar

from .exceptions import (
    AboutTooLong,
    AccessTokenExpired,
    AccessTokenInvalid,
    ActiveUserRequired,
    AdminRankEmojiNotAllowed,
    AdminRankInvalid,
    AdminsTooMuch,
    AlbumPhotosTooMany,
    ApiCallError,
    ApiIdInvalid,
    ApiIdPublishedFlood,
    ArticleTitleEmpty,
    AudioTitleEmpty,
    AuthBytesInvalid,
    AuthKeyDuplicated,
    AuthKeyInvalid,
    AuthKeyPermEmpty,
    AuthKeyUnregistered,
    AuthRestart,
    AuthTokenAlreadyAccepted,
    AuthTokenExpired,
    AuthTokenInvalid,
    AutoarchiveNotAvailable,
    BadRequest,
    BankCardNumberInvalid,
    BannedRightsInvalid,
    BasePortLocInvalid,
    BotChannelsNa,
    BotCommandDescriptionInvalid,
    BotDomainInvalid,
    BotGamesDisabled,
    BotGroupsBlocked,
    BotInlineDisabled,
    BotInvalid,
    BotMethodInvalid,
    BotMissing,
    BotOnesideNotAvail,
    BotPaymentsDisabled,
    BotPollsDisabled,
    BotResponseTimeout,
    BotScoreNotModified,
    BotsTooMuch,
    BroadcastForbidden,
    BroadcastIdInvalid,
    BroadcastPublicVotersForbidden,
    BroadcastRequired,
    ButtonDataInvalid,
    ButtonTypeInvalid,
    ButtonUrlInvalid,
    ButtonUserPrivacyRestricted,
    CallAlreadyAccepted,
    CallAlreadyDeclined,
    CallOccupyFailed,
    CallPeerInvalid,
    CallProtocolFlagsInvalid,
    CdnMethodInvalid,
    ChannelAddInvalid,
    ChannelBanned,
    ChannelInvalid,
    ChannelPrivate,
    ChannelPublicGroupNa,
    ChannelsAdminPublicTooMuch,
    ChannelsTooMuch,
    ChannelTooLarge,
    ChatAboutNotModified,
    ChatAboutTooLong,
    ChatAdminInviteRequired,
    ChatAdminRequired,
    ChatDiscussionUnallowed,
    ChatForbidden,
    ChatForwardsRestricted,
    ChatIdEmpty,
    ChatIdGenerateFailed,
    ChatIdInvalid,
    ChatInvalid,
    ChatInvitePermanent,
    ChatLinkExists,
    ChatNotModified,
    ChatOccupyLocFailed,
    ChatOccupyUsernameFailed,
    ChatRestricted,
    ChatSendGifsForbidden,
    ChatSendInlineForbidden,
    ChatSendMediaForbidden,
    ChatSendPollForbidden,
    ChatSendStickersForbidden,
    ChatTitleEmpty,
    ChatTooBig,
    ChatWriteForbidden,
    ChpCallFail,
    CodeEmpty,
    CodeHashInvalid,
    CodeInvalid,
    ConnectionApiIdInvalid,
    ConnectionAppVersionEmpty,
    ConnectionDeviceModelEmpty,
    ConnectionLangPackInvalid,
    ConnectionLayerInvalid,
    ConnectionNotInited,
    ConnectionSystemEmpty,
    ConnectionSystemLangCodeEmpty,
    ContactAddMissing,
    ContactIdInvalid,
    ContactNameEmpty,
    ContactReqMissing,
    DataInvalid,
    DataJsonInvalid,
    DataTooLong,
    DateEmpty,
    DcIdInvalid,
    DhGAInvalid,
    DocumentInvalid,
    EditBotInviteForbidden,
    EmailHashExpired,
    EmailInvalid,
    EmailUnconfirmed,
    EmailVerifyExpired,
    EmoticonEmpty,
    EmoticonInvalid,
    EmoticonStickerpackMissing,
    EncryptedMessageInvalid,
    EncryptionAlreadyAccepted,
    EncryptionAlreadyDeclined,
    EncryptionDeclined,
    EncryptionIdInvalid,
    EncryptionOccupyAdminFailed,
    EncryptionOccupyFailed,
    EntitiesTooLong,
    EntityBoundsInvalid,
    EntityMentionUserInvalid,
    ErrorTextEmpty,
    ExpireDateInvalid,
    ExportCardInvalid,
    ExternalUrlInvalid,
    FieldNameEmpty,
    FieldNameInvalid,
    FileIdInvalid,
    FileMigrate,
    FilePartEmpty,
    FilePartInvalid,
    FilePartLengthInvalid,
    FilePartMissing,
    FilePartsInvalid,
    FilePartSizeChanged,
    FilePartSizeInvalid,
    FilePartTooBig,
    FileReferenceEmpty,
    FileReferenceExpired,
    FileReferenceInvalid,
    FilerefUpgradeNeeded,
    FilterIdInvalid,
    FirstnameInvalid,
    Flood,
    FloodTestPhoneWait,
    FloodWait,
    FolderDeacAutofixAll,
    FolderIdEmpty,
    FolderIdInvalid,
    Forbidden,
    FreshChangeAdminsForbidden,
    FreshChangePhoneForbidden,
    FreshResetAuthorisationForbidden,
    FromMessageBotDisabled,
    FromPeerInvalid,
    GameBotInvalid,
    GeoPointInvalid,
    GifContentTypeInvalid,
    GifIdInvalid,
    GraphInvalidReload,
    GraphOutdatedReload,
    GroupcallAddParticipantsFailed,
    GroupCallInvalid,
    GroupcallSsrcDuplicateMuch,
    GroupedIdOccupyFailed,
    GroupedMediaInvalid,
    HashInvalid,
    HistoryGetFailed,
    ImageEngineDown,
    ImageProcessFailed,
    ImportFileInvalid,
    ImportFormatUnrecognized,
    ImportIdInvalid,
    InlineBotRequired,
    InlineResultExpired,
    InputConstructorInvalid,
    InputFetchError,
    InputFetchFail,
    InputFilterInvalid,
    InputLayerInvalid,
    InputMethodInvalid,
    InputRequestTooLong,
    InputUserDeactivated,
    InterdcCallError,
    InterdcCallRichError,
    InternalServerError,
    InviteHashEmpty,
    InviteHashExpired,
    InviteHashInvalid,
    InviteRequestSent,
    InviteRevokedMissing,
    LangPackInvalid,
    LastnameInvalid,
    LimitInvalid,
    LinkNotModified,
    LocationInvalid,
    MaxIdInvalid,
    MaxQtsInvalid,
    Md5ChecksumInvalid,
    MediaCaptionTooLong,
    MediaEmpty,
    MediaFileInvalid,
    MediaInvalid,
    MediaNewInvalid,
    MediaPrevInvalid,
    MediaTtlInvalid,
    MediaVideoStoryMissing,
    MegagroupIdInvalid,
    MegagroupPrehistoryHidden,
    MegagroupRequired,
    MemberFetchFailed,
    MemberNoLocation,
    MemberOccupyPrimaryLocFailed,
    MemberOccupyUsernameFailed,
    MessageAuthorRequired,
    MessageDeleteForbidden,
    MessageEditTimeExpired,
    MessageEmpty,
    MessageIdInvalid,
    MessageIdsEmpty,
    MessageNotModified,
    MessagePollClosed,
    MessageTooLong,
    MethodInvalid,
    MsgidDecreaseRetry,
    MsgIdInvalid,
    MsgRangeUnsync,
    MsgVoiceMissing,
    MsgWaitFailed,
    MtSendQueueTooLong,
    MultiMediaTooLong,
    NeedChatInvalid,
    NeedMemberInvalid,
    NetworkMigrate,
    NewSaltInvalid,
    NewSettingsInvalid,
    NextOffsetInvalid,
    NotAcceptable,
    NoWorkersRunning,
    OffsetInvalid,
    OffsetPeerIdInvalid,
    OptionInvalid,
    OptionsTooMuch,
    PackShortNameInvalid,
    PackShortNameOccupied,
    PackTitleInvalid,
    ParticipantCallFailed,
    ParticipantsTooFew,
    ParticipantVersionOutdated,
    PasswordEmpty,
    PasswordHashInvalid,
    PasswordMissing,
    PasswordRecoveryNa,
    PasswordRequired,
    PasswordTooFresh,
    PaymentProviderInvalid,
    PeerFlood,
    PeerIdInvalid,
    PeerIdNotSupported,
    PersistentTimestampEmpty,
    PersistentTimestampInvalid,
    PersistentTimestampOutdated,
    PhoneCodeEmpty,
    PhoneCodeExpired,
    PhoneCodeHashEmpty,
    PhoneCodeInvalid,
    PhoneMigrate,
    PhoneNumberAppSignupForbidden,
    PhoneNumberBanned,
    PhoneNumberFlood,
    PhoneNumberInvalid,
    PhoneNumberOccupied,
    PhoneNumberUnoccupied,
    PhonePasswordFlood,
    PhonePasswordProtected,
    PhotoContentTypeInvalid,
    PhotoContentUrlEmpty,
    PhotoCreateFailed,
    PhotoCropFileMissing,
    PhotoCropSizeSmall,
    PhotoExtInvalid,
    PhotoFileMissing,
    PhotoIdInvalid,
    PhotoInvalid,
    PhotoInvalidDimensions,
    PhotoSaveFileInvalid,
    PhotoThumbUrlEmpty,
    PhotoThumbUrlInvalid,
    PinnedDialogsTooMuch,
    PinRestricted,
    PollAnswersInvalid,
    PollOptionDuplicate,
    PollOptionInvalid,
    PollQuestionInvalid,
    PollUnsupported,
    PollVoteRequired,
    PostponedTimeout,
    PremiumAccountRequired,
    PrivacyKeyInvalid,
    PrivacyTooLong,
    PrivacyValueInvalid,
    PtsChangeEmpty,
    QueryIdEmpty,
    QueryIdInvalid,
    QueryTooShort,
    QuizCorrectAnswerInvalid,
    QuizCorrectAnswersEmpty,
    QuizCorrectAnswersTooMuch,
    QuizMultipleInvalid,
    RandomIdDuplicate,
    RandomIdEmpty,
    RandomIdInvalid,
    RandomLengthInvalid,
    RangesInvalid,
    ReactionEmpty,
    ReactionInvalid,
    ReflectorNotAvailable,
    RegIdGenerateFailed,
    ReplyMarkupBuyEmpty,
    ReplyMarkupGameEmpty,
    ReplyMarkupInvalid,
    ReplyMarkupTooLong,
    ResultIdDuplicate,
    ResultIdEmpty,
    ResultIdInvalid,
    ResultsTooMuch,
    ResultTypeInvalid,
    RevoteNotAllowed,
    RightForbidden,
    RpcCallFail,
    RpcConnectFailed,
    RPCError,
    RpcMcgetFail,
    RsaDecryptFailed,
    ScheduleBotNotAllowed,
    ScheduleDateInvalid,
    ScheduleDateTooLate,
    ScheduleStatusPrivate,
    ScheduleTooMuch,
    SearchQueryEmpty,
    SecondsInvalid,
    SeeOther,
    SendMessageMediaInvalid,
    SendMessageTypeInvalid,
    SensitiveChangeForbidden,
    ServiceUnavailable,
    SessionExpired,
    SessionPasswordNeeded,
    SessionRevoked,
    SessionTooFresh,
    SettingsInvalid,
    Sha256HashInvalid,
    ShortnameOccupyFailed,
    SignInFailed,
    SlowmodeMultiMsgsDisabled,
    SlowmodeWait,
    SmsCodeCreateFailed,
    SrpIdInvalid,
    SrpPasswordChanged,
    StartParamEmpty,
    StartParamInvalid,
    StartParamTooLong,
    StatsMigrate,
    StickerDocumentInvalid,
    StickerEmojiInvalid,
    StickerFileInvalid,
    StickerIdInvalid,
    StickerInvalid,
    StickerPngDimensions,
    StickerPngNopng,
    StickersEmpty,
    StickersetInvalid,
    StickersetNotModified,
    StickersetOwnerAnonymous,
    StickersTooMuch,
    StickerTgsNotgs,
    StickerThumbPngNopng,
    StickerVideoNowebm,
    StorageCheckFailed,
    StoreInvalidScalarType,
    StoriesTooMuch,
    TakeoutInitDelay,
    TakeoutInvalid,
    TakeoutRequired,
    TempAuthKeyEmpty,
    ThemeFileInvalid,
    ThemeFormatInvalid,
    ThemeInvalid,
    ThemeMimeInvalid,
    Timeout,
    TmpPasswordDisabled,
    TmpPasswordInvalid,
    TokenInvalid,
    TopicClosed,
    TopicDeleted,
    TranscriptionFailed,
    TtlDaysInvalid,
    TtlMediaInvalid,
    TtlPeriodInvalid,
    TwoFaConfirmWait,
    TypeConstructorInvalid,
    TypesEmpty,
    Unauthorized,
    UnknownMethod,
    UntilDateInvalid,
    UploadNoVolume,
    UrlInvalid,
    UsageLimitInvalid,
    UserAdminInvalid,
    UserAlreadyParticipant,
    UserBannedInChannel,
    UserBlocked,
    UserBot,
    UserBotInvalid,
    UserBotRequired,
    UserChannelsTooMuch,
    UserCreator,
    UserDeactivated,
    UserDeactivatedBan,
    UserIdInvalid,
    UserInvalid,
    UserIsBlocked,
    UserIsBot,
    UserKicked,
    UserMigrate,
    UsernameInvalid,
    UsernameNotModified,
    UsernameNotOccupied,
    UsernameOccupied,
    UserNotMutualContact,
    UserNotParticipant,
    UserpicUploadRequired,
    UserPrivacyRestricted,
    UserRestricted,
    UsersTooFew,
    UsersTooMuch,
    VideoContentTypeInvalid,
    VideoFileInvalid,
    VoiceMessagesForbidden,
    VolumeLocNotFound,
    WallpaperFileInvalid,
    WallpaperInvalid,
    WallpaperMimeInvalid,
    WcConvertUrlInvalid,
    WebdocumentInvalid,
    WebdocumentMimeInvalid,
    WebdocumentSizeTooBig,
    WebdocumentUrlEmpty,
    WebdocumentUrlInvalid,
    WebpageCurlFailed,
    WebpageMediaEmpty,
    WorkerBusyTooLongRetry,
    WpIdGenerateFailed,
    YouBlockedUser,
    all,
    bad_request_400,
    flood_420,
    forbidden_403,
    internal_server_error_500,
    not_acceptable_406,
    see_other_303,
    service_unavailable_503,
    unauthorized_401,
)
from .pyromod import ListenerStopped, ListenerTimeout
from .rpc_error import UnknownError


class BadMsgNotification(Exception):  # noqa: N818
    descriptions: ClassVar = {
        16: "The msg_id is too low, the client time has to be synchronized.",
        17: "The msg_id is too high, the client time has to be synchronized.",
        18: "Incorrect two lower order of the msg_id bits, the server expects the client message "
        "msg_id to be divisible by 4.",
        19: "The container msg_id is the same as the msg_id of a previously received message.",
        20: "The message is too old, it cannot be verified by the server.",
        32: "The msg_seqno is too low.",
        33: "The msg_seqno is too high.",
        34: "An even msg_seqno was expected, but an odd one was received.",
        35: "An odd msg_seqno was expected, but an even one was received.",
        48: "Incorrect server salt.",
        64: "Invalid container.",
    }

    def __init__(self, code):
        description = self.descriptions.get(code, "Unknown error code")
        super().__init__(f"[{code}] {description}")


class SecurityError(Exception):
    """Generic security error."""

    @classmethod
    def check(cls, cond: bool, msg: str):
        """Raises this exception if the condition is false"""
        if not cond:
            raise cls(f"Check failed: {msg}")


class SecurityCheckMismatch(SecurityError):  # noqa: N818
    """Raised when a security check mismatch occurs."""

    def __init__(self, msg: str | None = None):
        super().__init__("A security check mismatch has occurred." if msg is None else msg)


class CDNFileHashMismatch(SecurityError):  # noqa: N818
    """Raised when a CDN file hash mismatch occurs."""

    def __init__(self, msg: str | None = None):
        super().__init__("A CDN file hash mismatch has occurred." if msg is None else msg)


__all__ = [
    "AboutTooLong",
    "AccessTokenExpired",
    "AccessTokenInvalid",
    "ActiveUserRequired",
    "AdminRankEmojiNotAllowed",
    "AdminRankInvalid",
    "AdminsTooMuch",
    "AlbumPhotosTooMany",
    "ApiCallError",
    "ApiIdInvalid",
    "ApiIdPublishedFlood",
    "ArticleTitleEmpty",
    "AudioTitleEmpty",
    "AuthBytesInvalid",
    "AuthKeyDuplicated",
    "AuthKeyInvalid",
    "AuthKeyPermEmpty",
    "AuthKeyUnregistered",
    "AuthRestart",
    "AuthTokenAlreadyAccepted",
    "AuthTokenExpired",
    "AuthTokenInvalid",
    "AutoarchiveNotAvailable",
    "BadRequest",
    "BankCardNumberInvalid",
    "BannedRightsInvalid",
    "BasePortLocInvalid",
    "BotChannelsNa",
    "BotCommandDescriptionInvalid",
    "BotDomainInvalid",
    "BotGamesDisabled",
    "BotGroupsBlocked",
    "BotInlineDisabled",
    "BotInvalid",
    "BotMethodInvalid",
    "BotMissing",
    "BotOnesideNotAvail",
    "BotPaymentsDisabled",
    "BotPollsDisabled",
    "BotResponseTimeout",
    "BotScoreNotModified",
    "BotsTooMuch",
    "BroadcastForbidden",
    "BroadcastIdInvalid",
    "BroadcastPublicVotersForbidden",
    "BroadcastRequired",
    "ButtonDataInvalid",
    "ButtonTypeInvalid",
    "ButtonUrlInvalid",
    "ButtonUserPrivacyRestricted",
    "CallAlreadyAccepted",
    "CallAlreadyDeclined",
    "CallOccupyFailed",
    "CallPeerInvalid",
    "CallProtocolFlagsInvalid",
    "CdnMethodInvalid",
    "ChannelAddInvalid",
    "ChannelBanned",
    "ChannelInvalid",
    "ChannelPrivate",
    "ChannelPublicGroupNa",
    "ChannelTooLarge",
    "ChannelsAdminPublicTooMuch",
    "ChannelsTooMuch",
    "ChatAboutNotModified",
    "ChatAboutTooLong",
    "ChatAdminInviteRequired",
    "ChatAdminRequired",
    "ChatDiscussionUnallowed",
    "ChatForbidden",
    "ChatForwardsRestricted",
    "ChatIdEmpty",
    "ChatIdGenerateFailed",
    "ChatIdInvalid",
    "ChatInvalid",
    "ChatInvitePermanent",
    "ChatLinkExists",
    "ChatNotModified",
    "ChatOccupyLocFailed",
    "ChatOccupyUsernameFailed",
    "ChatRestricted",
    "ChatSendGifsForbidden",
    "ChatSendInlineForbidden",
    "ChatSendMediaForbidden",
    "ChatSendPollForbidden",
    "ChatSendStickersForbidden",
    "ChatTitleEmpty",
    "ChatTooBig",
    "ChatWriteForbidden",
    "ChpCallFail",
    "CodeEmpty",
    "CodeHashInvalid",
    "CodeInvalid",
    "ConnectionApiIdInvalid",
    "ConnectionAppVersionEmpty",
    "ConnectionDeviceModelEmpty",
    "ConnectionLangPackInvalid",
    "ConnectionLayerInvalid",
    "ConnectionNotInited",
    "ConnectionSystemEmpty",
    "ConnectionSystemLangCodeEmpty",
    "ContactAddMissing",
    "ContactIdInvalid",
    "ContactNameEmpty",
    "ContactReqMissing",
    "DataInvalid",
    "DataJsonInvalid",
    "DataTooLong",
    "DateEmpty",
    "DcIdInvalid",
    "DhGAInvalid",
    "DocumentInvalid",
    "EditBotInviteForbidden",
    "EmailHashExpired",
    "EmailInvalid",
    "EmailUnconfirmed",
    "EmailVerifyExpired",
    "EmoticonEmpty",
    "EmoticonInvalid",
    "EmoticonStickerpackMissing",
    "EncryptedMessageInvalid",
    "EncryptionAlreadyAccepted",
    "EncryptionAlreadyDeclined",
    "EncryptionDeclined",
    "EncryptionIdInvalid",
    "EncryptionOccupyAdminFailed",
    "EncryptionOccupyFailed",
    "EntitiesTooLong",
    "EntityBoundsInvalid",
    "EntityMentionUserInvalid",
    "ErrorTextEmpty",
    "ExpireDateInvalid",
    "ExportCardInvalid",
    "ExternalUrlInvalid",
    "FieldNameEmpty",
    "FieldNameInvalid",
    "FileIdInvalid",
    "FileMigrate",
    "FilePartEmpty",
    "FilePartInvalid",
    "FilePartLengthInvalid",
    "FilePartMissing",
    "FilePartSizeChanged",
    "FilePartSizeInvalid",
    "FilePartTooBig",
    "FilePartsInvalid",
    "FileReferenceEmpty",
    "FileReferenceExpired",
    "FileReferenceInvalid",
    "FilerefUpgradeNeeded",
    "FilterIdInvalid",
    "FirstnameInvalid",
    "Flood",
    "FloodTestPhoneWait",
    "FloodWait",
    "FolderDeacAutofixAll",
    "FolderIdEmpty",
    "FolderIdInvalid",
    "Forbidden",
    "FreshChangeAdminsForbidden",
    "FreshChangePhoneForbidden",
    "FreshResetAuthorisationForbidden",
    "FromMessageBotDisabled",
    "FromPeerInvalid",
    "GameBotInvalid",
    "GeoPointInvalid",
    "GifContentTypeInvalid",
    "GifIdInvalid",
    "GraphInvalidReload",
    "GraphOutdatedReload",
    "GroupCallInvalid",
    "GroupcallAddParticipantsFailed",
    "GroupcallSsrcDuplicateMuch",
    "GroupedIdOccupyFailed",
    "GroupedMediaInvalid",
    "HashInvalid",
    "HistoryGetFailed",
    "ImageEngineDown",
    "ImageProcessFailed",
    "ImportFileInvalid",
    "ImportFormatUnrecognized",
    "ImportIdInvalid",
    "InlineBotRequired",
    "InlineResultExpired",
    "InputConstructorInvalid",
    "InputFetchError",
    "InputFetchFail",
    "InputFilterInvalid",
    "InputLayerInvalid",
    "InputMethodInvalid",
    "InputRequestTooLong",
    "InputUserDeactivated",
    "InterdcCallError",
    "InterdcCallRichError",
    "InternalServerError",
    "InviteHashEmpty",
    "InviteHashExpired",
    "InviteHashInvalid",
    "InviteRequestSent",
    "InviteRevokedMissing",
    "LangPackInvalid",
    "LastnameInvalid",
    "LimitInvalid",
    "LinkNotModified",
    "ListenerStopped",
    "ListenerTimeout",
    "LocationInvalid",
    "MaxIdInvalid",
    "MaxQtsInvalid",
    "Md5ChecksumInvalid",
    "MediaCaptionTooLong",
    "MediaEmpty",
    "MediaFileInvalid",
    "MediaInvalid",
    "MediaNewInvalid",
    "MediaPrevInvalid",
    "MediaTtlInvalid",
    "MediaVideoStoryMissing",
    "MegagroupIdInvalid",
    "MegagroupPrehistoryHidden",
    "MegagroupRequired",
    "MemberFetchFailed",
    "MemberNoLocation",
    "MemberOccupyPrimaryLocFailed",
    "MemberOccupyUsernameFailed",
    "MessageAuthorRequired",
    "MessageDeleteForbidden",
    "MessageEditTimeExpired",
    "MessageEmpty",
    "MessageIdInvalid",
    "MessageIdsEmpty",
    "MessageNotModified",
    "MessagePollClosed",
    "MessageTooLong",
    "MethodInvalid",
    "MsgIdInvalid",
    "MsgRangeUnsync",
    "MsgVoiceMissing",
    "MsgWaitFailed",
    "MsgidDecreaseRetry",
    "MtSendQueueTooLong",
    "MultiMediaTooLong",
    "NeedChatInvalid",
    "NeedMemberInvalid",
    "NetworkMigrate",
    "NewSaltInvalid",
    "NewSettingsInvalid",
    "NextOffsetInvalid",
    "NoWorkersRunning",
    "NotAcceptable",
    "OffsetInvalid",
    "OffsetPeerIdInvalid",
    "OptionInvalid",
    "OptionsTooMuch",
    "PackShortNameInvalid",
    "PackShortNameOccupied",
    "PackTitleInvalid",
    "ParticipantCallFailed",
    "ParticipantVersionOutdated",
    "ParticipantsTooFew",
    "PasswordEmpty",
    "PasswordHashInvalid",
    "PasswordMissing",
    "PasswordRecoveryNa",
    "PasswordRequired",
    "PasswordTooFresh",
    "PaymentProviderInvalid",
    "PeerFlood",
    "PeerIdInvalid",
    "PeerIdNotSupported",
    "PersistentTimestampEmpty",
    "PersistentTimestampInvalid",
    "PersistentTimestampOutdated",
    "PhoneCodeEmpty",
    "PhoneCodeExpired",
    "PhoneCodeHashEmpty",
    "PhoneCodeInvalid",
    "PhoneMigrate",
    "PhoneNumberAppSignupForbidden",
    "PhoneNumberBanned",
    "PhoneNumberFlood",
    "PhoneNumberInvalid",
    "PhoneNumberOccupied",
    "PhoneNumberUnoccupied",
    "PhonePasswordFlood",
    "PhonePasswordProtected",
    "PhotoContentTypeInvalid",
    "PhotoContentUrlEmpty",
    "PhotoCreateFailed",
    "PhotoCropFileMissing",
    "PhotoCropSizeSmall",
    "PhotoExtInvalid",
    "PhotoFileMissing",
    "PhotoIdInvalid",
    "PhotoInvalid",
    "PhotoInvalidDimensions",
    "PhotoSaveFileInvalid",
    "PhotoThumbUrlEmpty",
    "PhotoThumbUrlInvalid",
    "PinRestricted",
    "PinnedDialogsTooMuch",
    "PollAnswersInvalid",
    "PollOptionDuplicate",
    "PollOptionInvalid",
    "PollQuestionInvalid",
    "PollUnsupported",
    "PollVoteRequired",
    "PostponedTimeout",
    "PremiumAccountRequired",
    "PrivacyKeyInvalid",
    "PrivacyTooLong",
    "PrivacyValueInvalid",
    "PtsChangeEmpty",
    "QueryIdEmpty",
    "QueryIdInvalid",
    "QueryTooShort",
    "QuizCorrectAnswerInvalid",
    "QuizCorrectAnswersEmpty",
    "QuizCorrectAnswersTooMuch",
    "QuizMultipleInvalid",
    "RPCError",
    "RandomIdDuplicate",
    "RandomIdEmpty",
    "RandomIdInvalid",
    "RandomLengthInvalid",
    "RangesInvalid",
    "ReactionEmpty",
    "ReactionInvalid",
    "ReflectorNotAvailable",
    "RegIdGenerateFailed",
    "ReplyMarkupBuyEmpty",
    "ReplyMarkupGameEmpty",
    "ReplyMarkupInvalid",
    "ReplyMarkupTooLong",
    "ResultIdDuplicate",
    "ResultIdEmpty",
    "ResultIdInvalid",
    "ResultTypeInvalid",
    "ResultsTooMuch",
    "RevoteNotAllowed",
    "RightForbidden",
    "RpcCallFail",
    "RpcConnectFailed",
    "RpcMcgetFail",
    "RsaDecryptFailed",
    "ScheduleBotNotAllowed",
    "ScheduleDateInvalid",
    "ScheduleDateTooLate",
    "ScheduleStatusPrivate",
    "ScheduleTooMuch",
    "SearchQueryEmpty",
    "SecondsInvalid",
    "SeeOther",
    "SendMessageMediaInvalid",
    "SendMessageTypeInvalid",
    "SensitiveChangeForbidden",
    "ServiceUnavailable",
    "SessionExpired",
    "SessionPasswordNeeded",
    "SessionRevoked",
    "SessionTooFresh",
    "SettingsInvalid",
    "Sha256HashInvalid",
    "ShortnameOccupyFailed",
    "SignInFailed",
    "SlowmodeMultiMsgsDisabled",
    "SlowmodeWait",
    "SmsCodeCreateFailed",
    "SrpIdInvalid",
    "SrpPasswordChanged",
    "StartParamEmpty",
    "StartParamInvalid",
    "StartParamTooLong",
    "StatsMigrate",
    "StickerDocumentInvalid",
    "StickerEmojiInvalid",
    "StickerFileInvalid",
    "StickerIdInvalid",
    "StickerInvalid",
    "StickerPngDimensions",
    "StickerPngNopng",
    "StickerTgsNotgs",
    "StickerThumbPngNopng",
    "StickerVideoNowebm",
    "StickersEmpty",
    "StickersTooMuch",
    "StickersetInvalid",
    "StickersetNotModified",
    "StickersetOwnerAnonymous",
    "StorageCheckFailed",
    "StoreInvalidScalarType",
    "StoriesTooMuch",
    "TakeoutInitDelay",
    "TakeoutInvalid",
    "TakeoutRequired",
    "TempAuthKeyEmpty",
    "ThemeFileInvalid",
    "ThemeFormatInvalid",
    "ThemeInvalid",
    "ThemeMimeInvalid",
    "Timeout",
    "TmpPasswordDisabled",
    "TmpPasswordInvalid",
    "TokenInvalid",
    "TopicClosed",
    "TopicDeleted",
    "TranscriptionFailed",
    "TtlDaysInvalid",
    "TtlMediaInvalid",
    "TtlPeriodInvalid",
    "TwoFaConfirmWait",
    "TypeConstructorInvalid",
    "TypesEmpty",
    "Unauthorized",
    "UnknownError",
    "UnknownMethod",
    "UntilDateInvalid",
    "UploadNoVolume",
    "UrlInvalid",
    "UsageLimitInvalid",
    "UserAdminInvalid",
    "UserAlreadyParticipant",
    "UserBannedInChannel",
    "UserBlocked",
    "UserBot",
    "UserBotInvalid",
    "UserBotRequired",
    "UserChannelsTooMuch",
    "UserCreator",
    "UserDeactivated",
    "UserDeactivatedBan",
    "UserIdInvalid",
    "UserInvalid",
    "UserIsBlocked",
    "UserIsBot",
    "UserKicked",
    "UserMigrate",
    "UserNotMutualContact",
    "UserNotParticipant",
    "UserPrivacyRestricted",
    "UserRestricted",
    "UsernameInvalid",
    "UsernameNotModified",
    "UsernameNotOccupied",
    "UsernameOccupied",
    "UserpicUploadRequired",
    "UsersTooFew",
    "UsersTooMuch",
    "VideoContentTypeInvalid",
    "VideoFileInvalid",
    "VoiceMessagesForbidden",
    "VolumeLocNotFound",
    "WallpaperFileInvalid",
    "WallpaperInvalid",
    "WallpaperMimeInvalid",
    "WcConvertUrlInvalid",
    "WebdocumentInvalid",
    "WebdocumentMimeInvalid",
    "WebdocumentSizeTooBig",
    "WebdocumentUrlEmpty",
    "WebdocumentUrlInvalid",
    "WebpageCurlFailed",
    "WebpageMediaEmpty",
    "WorkerBusyTooLongRetry",
    "WpIdGenerateFailed",
    "YouBlockedUser",
    "all",
    "bad_request_400",
    "flood_420",
    "forbidden_403",
    "internal_server_error_500",
    "not_acceptable_406",
    "see_other_303",
    "service_unavailable_503",
    "unauthorized_401",
]
