# 快速发布到 PyPI

## ✅ 当前状态

包已成功构建并通过检查！

```
✅ hyperliquid_mcp_python-0.1.0-py3-none-any.whl (13K)
✅ hyperliquid_mcp_python-0.1.0.tar.gz (153K)
```

## 🚀 现在就可以发布！

### 步骤 1: 注册 PyPI 账号（如果还没有）

1. **测试 PyPI**（推荐先用这个）
   - 注册：https://test.pypi.org/account/register/
   - 生成 Token：https://test.pypi.org/manage/account/token/

2. **正式 PyPI**
   - 注册：https://pypi.org/account/register/
   - 生成 Token：https://pypi.org/manage/account/token/

生成 Token 时：
- 选择 "Scope: Entire account"
- 复制保存 token（格式：`pypi-AgEIcHlwaS5vcmc...`）

### 步骤 2: 发布到测试 PyPI（推荐先测试）

```bash
# 上传到测试 PyPI
uv run twine upload --repository testpypi dist/*

# 会提示输入：
# Username: __token__
# Password: [粘贴你的测试 PyPI token]
```

### 步骤 3: 测试安装

```bash
# 从测试 PyPI 安装
pip install --index-url https://test.pypi.org/simple/ --extra-index-url https://pypi.org/simple/ hyperliquid-mcp-python

# 测试命令
hyperliquid-mcp --help
```

### 步骤 4: 发布到正式 PyPI

如果测试没问题：

```bash
# 上传到正式 PyPI
uv run twine upload dist/*

# 会提示输入：
# Username: __token__
# Password: [粘贴你的正式 PyPI token]
```

### 步骤 5: 验证安装

```bash
# 从正式 PyPI 安装
pip install hyperliquid-mcp-python

# 或使用 uv
uv pip install hyperliquid-mcp-python

# 测试
hyperliquid-mcp --version
```

## 🔧 使用自动脚本

我也准备了自动化脚本：

```bash
./publish.sh
```

会引导你完成整个发布流程。

## 📦 包信息

- **包名**: hyperliquid-mcp-python
- **版本**: 0.1.0
- **大小**: ~13KB (wheel) + ~153KB (源码)
- **Python**: >=3.11
- **License**: MIT

## 🎉 发布后

发布成功后，包可以通过以下方式安装：

```bash
# pip
pip install hyperliquid-mcp-python

# uv
uv pip install hyperliquid-mcp-python

# uvx (无需安装)
uvx --from hyperliquid-mcp-python hyperliquid-mcp
```

## 📝 发布新版本

当需要发布新版本时：

1. 更新 `pyproject.toml` 中的版本号
2. 更新 `cli.py` 中的版本号
3. 提交代码并打标签：
   ```bash
   git add -A
   git commit -m "chore: bump version to 0.1.1"
   git tag v0.1.1
   git push origin main --tags
   ```
4. 重新构建并发布：
   ```bash
   rm -rf dist/
   uv run python -m build
   uv run twine upload dist/*
   ```

## ⚠️ 重要提示

1. **版本号不可重复**：一旦发布某个版本号，就不能再使用相同的版本号
2. **先测试后发布**：强烈建议先发布到 test.pypi.org 测试
3. **保管好 Token**：API token 等同于密码，不要泄露
4. **检查 .gitignore**：确保 `.env` 和私钥不会被包含在包中

## 🆘 遇到问题？

查看详细文档：
- `PUBLISHING.md` - 完整发布指南
- `RELEASE_CHECKLIST.md` - 发布检查清单

或查看 PyPI 文档：https://packaging.python.org/
