# uvx 使用说明和故障排除

## ⚠️ 当前已知问题

由于 `eth-account` 依赖的 `ckzg` 包在某些环境下需要编译，使用 `uvx` 可能会遇到编译错误。

## ✅ 推荐的运行方式

### 方式 1: 使用 pip 安装（最可靠）

```bash
# 安装
pip install hyperliquid-mcp-python

# 运行
hyperliquid-mcp --help
hyperliquid-mcp stdio
```

### 方式 2: 使用 uv 安装（推荐）

```bash
# 安装
uv pip install hyperliquid-mcp-python

# 运行
hyperliquid-mcp --help
hyperliquid-mcp stdio
```

### 方式 3: 从源码运行（开发者）

```bash
# 克隆仓库
git clone https://github.com/jamiesun/hyperliquid-mcp.git
cd hyperliquid-mcp

# 安装依赖
uv sync

# 运行
uv run hyperliquid-mcp --help
uv run hyperliquid-mcp stdio
```

## 🔧 uvx 替代方案

如果你坚持使用 uvx（无需安装），可以从 GitHub 直接运行：

```bash
# 方式 1: 使用 --with 预安装依赖
uvx --with hyperliquid-python-sdk --with fastmcp --with python-dotenv --with pydantic hyperliquid-mcp-python

# 方式 2: 从 GitHub 运行（绕过 PyPI 的编译问题）
uvx --from git+https://github.com/jamiesun/hyperliquid-mcp.git hyperliquid-mcp
```

## 📦 Claude Desktop 配置

### 推荐配置（使用 pip 安装）

1. 先安装包：
```bash
pip install hyperliquid-mcp-python
```

2. 配置 Claude Desktop (`~/Library/Application Support/Claude/claude_desktop_config.json`):

```json
{
  "mcpServers": {
    "hyperliquid": {
      "command": "hyperliquid-mcp",
      "args": ["stdio"],
      "env": {
        "HYPERLIQUID_PRIVATE_KEY": "0x...",
        "HYPERLIQUID_TESTNET": "true"
      }
    }
  }
}
```

### 替代配置（从 GitHub 运行）

```json
{
  "mcpServers": {
    "hyperliquid": {
      "command": "uvx",
      "args": [
        "--from",
        "git+https://github.com/jamiesun/hyperliquid-mcp.git",
        "hyperliquid-mcp",
        "stdio"
      ],
      "env": {
        "HYPERLIQUID_PRIVATE_KEY": "0x...",
        "HYPERLIQUID_TESTNET": "true"
      }
    }
  }
}
```

## 🐛 ckzg 编译错误解决方案

如果遇到 `ckzg` 编译错误：

### macOS
```bash
# 安装编译工具
brew install make

# 或使用预编译的 wheel
pip install --only-binary :all: eth-account
```

### Linux
```bash
# Ubuntu/Debian
sudo apt-get install build-essential

# 然后重试安装
pip install hyperliquid-mcp-python
```

## 💡 最佳实践

1. **生产环境**：使用 `pip install hyperliquid-mcp-python`
2. **开发环境**：从源码克隆并使用 `uv run`
3. **快速测试**：使用 `uvx --from git+https://...`

## 📊 性能对比

| 方式 | 首次运行 | 后续运行 | 离线可用 | 稳定性 |
|------|---------|---------|---------|--------|
| pip install | ✅ 快 | ✅ 极快 | ✅ 是 | ⭐⭐⭐⭐⭐ |
| uv pip install | ✅ 快 | ✅ 极快 | ✅ 是 | ⭐⭐⭐⭐⭐ |
| uvx PyPI | ❌ 慢（编译） | ✅ 快 | ❌ 否 | ⭐⭐ |
| uvx GitHub | ✅ 中等 | ✅ 快 | ❌ 否 | ⭐⭐⭐⭐ |
| 源码 | ✅ 快 | ✅ 极快 | ✅ 是 | ⭐⭐⭐⭐⭐ |

## 🔄 未来计划

我们正在考虑以下解决方案：

1. 使用预编译的二进制 wheel
2. 移除对 `eth-account` 的强依赖
3. 提供 Docker 镜像
4. 创建独立可执行文件

## 📚 更多帮助

- [Installation Guide](INSTALLATION.md)
- [GitHub Issues](https://github.com/jamiesun/hyperliquid-mcp/issues)
- [PyPI Package](https://pypi.org/project/hyperliquid-mcp-python/)
