# 使用 uvx 运行 HyperLiquid MCP

`uvx` 允许你直接运行 Python 包，无需安装！

## 🚀 快速开始

### 方式 1: 直接从 PyPI 运行（推荐）

```bash
# 设置环境变量
export HYPERLIQUID_PRIVATE_KEY="0x..."
export HYPERLIQUID_TESTNET="true"

# 运行 HTTP 模式（默认）
uvx hyperliquid-mcp-python

# 运行 stdio 模式（用于 MCP 客户端）
uvx hyperliquid-mcp-python stdio

# 查看帮助
uvx hyperliquid-mcp-python --help

# 查看版本
uvx hyperliquid-mcp-python --version
```

### 方式 2: 指定包名运行

```bash
uvx --from hyperliquid-mcp-python hyperliquid-mcp
uvx --from hyperliquid-mcp-python hyperliquid-mcp stdio
uvx --from hyperliquid-mcp-python hyperliquid-mcp --help
```

### 方式 3: 从 GitHub 运行（开发版本）

```bash
uvx --from git+https://github.com/jamiesun/hyperliquid-mcp.git hyperliquid-mcp
```

## 📝 配置环境变量

### 临时配置（单次运行）

```bash
HYPERLIQUID_PRIVATE_KEY="0x..." \
HYPERLIQUID_TESTNET="true" \
uvx hyperliquid-mcp-python
```

### 永久配置（推荐）

添加到 `~/.zshrc` 或 `~/.bashrc`：

```bash
export HYPERLIQUID_PRIVATE_KEY="0x..."
export HYPERLIQUID_TESTNET="true"  # 可选
export HYPERLIQUID_ACCOUNT_ADDRESS="0x..."  # 可选，会自动派生
```

然后：
```bash
source ~/.zshrc  # 或 source ~/.bashrc
uvx hyperliquid-mcp-python
```

## 🔧 Claude Desktop 集成

在 `~/Library/Application Support/Claude/claude_desktop_config.json` 中配置：

### 方式 1: 使用 uvx（推荐，无需本地安装）

```json
{
  "mcpServers": {
    "hyperliquid": {
      "command": "uvx",
      "args": ["hyperliquid-mcp-python", "stdio"],
      "env": {
        "HYPERLIQUID_PRIVATE_KEY": "0x...",
        "HYPERLIQUID_TESTNET": "true"
      }
    }
  }
}
```

### 方式 2: 使用本地安装

```json
{
  "mcpServers": {
    "hyperliquid": {
      "command": "hyperliquid-mcp",
      "args": ["stdio"],
      "env": {
        "HYPERLIQUID_PRIVATE_KEY": "0x...",
        "HYPERLIQUID_TESTNET": "true"
      }
    }
  }
}
```

### 方式 3: 从 GitHub 运行

```json
{
  "mcpServers": {
    "hyperliquid": {
      "command": "uvx",
      "args": [
        "--from",
        "git+https://github.com/jamiesun/hyperliquid-mcp.git",
        "hyperliquid-mcp",
        "stdio"
      ],
      "env": {
        "HYPERLIQUID_PRIVATE_KEY": "0x...",
        "HYPERLIQUID_TESTNET": "true"
      }
    }
  }
}
```

## ✨ uvx 的优势

1. **无需安装**：直接运行，不污染全局环境
2. **自动缓存**：首次运行后会缓存，下次更快
3. **版本隔离**：每个项目可以使用不同版本
4. **始终最新**：可以轻松运行最新版本

## 📦 安装 vs uvx

### 使用 uvx（推荐用于试用）
```bash
uvx hyperliquid-mcp-python
```
✅ 无需安装  
✅ 自动管理依赖  
✅ 适合一次性运行  

### 全局安装（推荐用于频繁使用）
```bash
pip install hyperliquid-mcp-python
# 或
uv pip install hyperliquid-mcp-python
```
✅ 运行更快（已安装）  
✅ 离线可用  
✅ 适合频繁使用  

## 🔄 更新到最新版本

### uvx 方式
```bash
# uvx 会自动检查更新，或强制重新安装
uvx --reinstall hyperliquid-mcp-python
```

### pip 方式
```bash
pip install --upgrade hyperliquid-mcp-python
```

## 🧪 运行测试

```bash
# 检查是否可以连接
uvx hyperliquid-mcp-python --help

# 运行 HTTP 服务器（测试网）
HYPERLIQUID_TESTNET=true uvx hyperliquid-mcp-python

# 查看日志
tail -f hyperliquid_mcp.log
```

## 💡 实用技巧

### 1. 创建快捷别名

添加到 `~/.zshrc`：
```bash
alias hl-mcp='uvx hyperliquid-mcp-python'
alias hl-mcp-test='HYPERLIQUID_TESTNET=true uvx hyperliquid-mcp-python'
```

使用：
```bash
hl-mcp --help
hl-mcp-test  # 使用测试网
```

### 2. 使用配置文件

创建 `~/.hyperliquid_mcp.env`：
```bash
export HYPERLIQUID_PRIVATE_KEY="0x..."
export HYPERLIQUID_TESTNET="true"
```

运行时：
```bash
source ~/.hyperliquid_mcp.env && uvx hyperliquid-mcp-python
```

### 3. 在特定目录运行

```bash
cd ~/my-trading-bot
# 在当前目录创建 .env 文件
echo 'HYPERLIQUID_PRIVATE_KEY=0x...' > .env
echo 'HYPERLIQUID_TESTNET=true' >> .env

# 运行（会自动读取 .env）
uvx hyperliquid-mcp-python
```

## 🆘 故障排除

### 错误: command not found: uvx
安装 uv：
```bash
curl -LsSf https://astral.sh/uv/install.sh | sh
```

### 错误: 找不到包
确保包名正确：
```bash
uvx hyperliquid-mcp-python  # 正确 ✅
uvx hyperliquid-mcp         # 错误 ❌（这是命令名，不是包名）
```

### 错误: 配置未找到
检查环境变量：
```bash
echo $HYPERLIQUID_PRIVATE_KEY
echo $HYPERLIQUID_TESTNET
```

如果为空，需要设置：
```bash
export HYPERLIQUID_PRIVATE_KEY="0x..."
```

## 📚 更多信息

- [uv 文档](https://docs.astral.sh/uv/)
- [uvx 使用指南](https://docs.astral.sh/uv/guides/tools/)
- [PyPI 包页面](https://pypi.org/project/hyperliquid-mcp-python/)
- [GitHub 仓库](https://github.com/jamiesun/hyperliquid-mcp)

## 🎯 快速参考

```bash
# 最简单的方式
uvx hyperliquid-mcp-python

# 带环境变量
HYPERLIQUID_PRIVATE_KEY="0x..." HYPERLIQUID_TESTNET="true" uvx hyperliquid-mcp-python

# stdio 模式
uvx hyperliquid-mcp-python stdio

# 查看帮助
uvx hyperliquid-mcp-python --help

# 从 GitHub 运行最新代码
uvx --from git+https://github.com/jamiesun/hyperliquid-mcp.git hyperliquid-mcp
```
