# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class OrganizationLevelBillingHistoryResponseMetrics(BaseModel):
    """
    OrganizationLevelBillingHistoryResponseMetrics
    """ # noqa: E501
    contract_cost: Optional[Union[StrictFloat, StrictInt]] = None
    incurred_bill: Optional[Union[StrictFloat, StrictInt]] = None
    non_discounted_bill: Optional[Union[StrictFloat, StrictInt]] = None
    snapshot_cost: Optional[Union[StrictFloat, StrictInt]] = None
    vm_cost: Optional[Union[StrictFloat, StrictInt]] = None
    volume_cost: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["contract_cost", "incurred_bill", "non_discounted_bill", "snapshot_cost", "vm_cost", "volume_cost"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationLevelBillingHistoryResponseMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationLevelBillingHistoryResponseMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "contract_cost": obj.get("contract_cost"),
            "incurred_bill": obj.get("incurred_bill"),
            "non_discounted_bill": obj.get("non_discounted_bill"),
            "snapshot_cost": obj.get("snapshot_cost"),
            "vm_cost": obj.get("vm_cost"),
            "volume_cost": obj.get("volume_cost")
        })
        return _obj


