# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SecurityGroupRuleFields(BaseModel):
    """
    SecurityGroupRuleFields
    """ # noqa: E501
    created_at: Optional[datetime] = None
    direction: Optional[StrictStr] = None
    ethertype: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    port_range_max: Optional[StrictInt] = None
    port_range_min: Optional[StrictInt] = None
    protocol: Optional[StrictStr] = None
    remote_ip_prefix: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["created_at", "direction", "ethertype", "id", "port_range_max", "port_range_min", "protocol", "remote_ip_prefix", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecurityGroupRuleFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecurityGroupRuleFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "direction": obj.get("direction"),
            "ethertype": obj.get("ethertype"),
            "id": obj.get("id"),
            "port_range_max": obj.get("port_range_max"),
            "port_range_min": obj.get("port_range_min"),
            "protocol": obj.get("protocol"),
            "remote_ip_prefix": obj.get("remote_ip_prefix"),
            "status": obj.get("status")
        })
        return _obj


