# hyperstack
Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources. 

Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.

To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: v1.41.2-alpha
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/NexGenCloud/hyperstack-sdk-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/NexGenCloud/hyperstack-sdk-python.git`)

Then import the package:
```python
import hyperstack
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import hyperstack
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import hyperstack
from hyperstack.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://infrahub-api.nexgencloud.com/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = hyperstack.Configuration(
    host = "https://infrahub-api.nexgencloud.com/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: apiKey
configuration.api_key['apiKey'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['apiKey'] = 'Bearer'


# Enter a context with an instance of the API client
with hyperstack.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = hyperstack.CalculateApi(api_client)
    resource_type = 'resource_type_example' # str | 
    id = 56 # int | 

    try:
        # Retrieve Billing Rate for Resource
        api_response = api_instance.get_calculate2(resource_type, id)
        print("The response of CalculateApi->get_calculate2:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CalculateApi->get_calculate2: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://infrahub-api.nexgencloud.com/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CalculateApi* | [**get_calculate2**](docs/CalculateApi.md#get_calculate2) | **GET** /pricebook/calculate/resource/{resource_type}/{id} | Retrieve Billing Rate for Resource
*CustomerContractApi* | [**get_customer_contract**](docs/CustomerContractApi.md#get_customer_contract) | **GET** /pricebook/contracts | List Contracts
*CustomerContractApi* | [**get_customer_contract_details**](docs/CustomerContractApi.md#get_customer_contract_details) | **GET** /pricebook/contracts/{contract_id} | Retrieve Contract Details
*CustomerContractApi* | [**get_customer_contract_gpu_allocation_graph**](docs/CustomerContractApi.md#get_customer_contract_gpu_allocation_graph) | **GET** /pricebook/contracts/{contract_id}/gpu_allocation_graph | Retrieve GPU Allocation Graph for Contract
*PricebookApi* | [**get_pricebook**](docs/PricebookApi.md#get_pricebook) | **GET** /pricebook | 
*SnapshotsApi* | [**create_a_new_custom_image**](docs/SnapshotsApi.md#create_a_new_custom_image) | **POST** /core/snapshots/{snapshot_id}/image | Create an image from a snapshot
*SnapshotsApi* | [**delete_snapshot**](docs/SnapshotsApi.md#delete_snapshot) | **DELETE** /core/snapshots/{id} | Delete snapshot
*SnapshotsApi* | [**fetch_snapshot_name_availability**](docs/SnapshotsApi.md#fetch_snapshot_name_availability) | **GET** /core/snapshots/name-availability/{name} | Fetch snapshot name availability
*SnapshotsApi* | [**get_snapshot**](docs/SnapshotsApi.md#get_snapshot) | **GET** /core/snapshots/{id} | Retrieve a snapshot
*SnapshotsApi* | [**get_snapshots**](docs/SnapshotsApi.md#get_snapshots) | **GET** /core/snapshots | Retrieve list of snapshots with pagination
*SnapshotsApi* | [**post_snapshot_restore**](docs/SnapshotsApi.md#post_snapshot_restore) | **POST** /core/snapshots/{id}/restore | Restore a snapshot
*AliveApi* | [**get_alive**](docs/AliveApi.md#get_alive) | **GET** /billing/alive | GET: Alive
*AliveApi* | [**get_doc**](docs/AliveApi.md#get_doc) | **GET** /billing/alive/doc | 
*ApiKeyApi* | [**delete_api_key**](docs/ApiKeyApi.md#delete_api_key) | **DELETE** /api-key/{api_key_id} | Delete API Key
*ApiKeyApi* | [**generate_api_key**](docs/ApiKeyApi.md#generate_api_key) | **POST** /api-key/generate | Generate API Key
*ApiKeyApi* | [**retrieve_api_key**](docs/ApiKeyApi.md#retrieve_api_key) | **GET** /api-key | Retrieve API Keys
*ApiKeyApi* | [**update_api_key**](docs/ApiKeyApi.md#update_api_key) | **PUT** /api-key/{api_key_id} | Update API Key
*AssigningMemberRoleApi* | [**assign_rbac_role_to_user**](docs/AssigningMemberRoleApi.md#assign_rbac_role_to_user) | **PUT** /auth/users/{user_id}/assign-roles | Assign RBAC Role
*AssigningMemberRoleApi* | [**remove_rbac_role_from_user**](docs/AssigningMemberRoleApi.md#remove_rbac_role_from_user) | **DELETE** /auth/users/{user_id}/roles | Remove RBAC Role From User
*AuthApi* | [**change_organization_for_token**](docs/AuthApi.md#change_organization_for_token) | **GET** /auth/token/change-org/{org_id} | 
*AuthApi* | [**disable_mfa**](docs/AuthApi.md#disable_mfa) | **GET** /auth/me/mfa/disable | 
*AuthApi* | [**get_user_mfa_status**](docs/AuthApi.md#get_user_mfa_status) | **GET** /auth/me/mfa | Get MFA status for authenticated user
*AuthApi* | [**get_user_organizations**](docs/AuthApi.md#get_user_organizations) | **GET** /auth/me/organizations | Get User Organizations
*AuthApi* | [**retrieve_authenticated_user_details**](docs/AuthApi.md#retrieve_authenticated_user_details) | **GET** /auth/me | Retrieve Authenticated User Details
*BetaAccessApi* | [**create_a_beta_access_request**](docs/BetaAccessApi.md#create_a_beta_access_request) | **POST** /auth/beta-access/requests | Create a new beta access request
*BetaAccessApi* | [**get_beta_access_status**](docs/BetaAccessApi.md#get_beta_access_status) | **GET** /auth/beta-access/requests | Check the status of all beta access requests
*BetaAccessApi* | [**get_beta_access_status2**](docs/BetaAccessApi.md#get_beta_access_status2) | **GET** /auth/beta-access/requests/{program} | Check the status of beta access requests
*BillingApi* | [**get_last_day_cost**](docs/BillingApi.md#get_last_day_cost) | **GET** /billing/billing/last-day-cost | GET: Last Day Cost
*BillingApi* | [**get_organization_threshold**](docs/BillingApi.md#get_organization_threshold) | **GET** /billing/billing/threshold | GET: All Thresholds for Organization
*BillingApi* | [**get_usage2**](docs/BillingApi.md#get_usage2) | **GET** /billing/billing/usage | GET: Billing usage
*BillingApi* | [**get_user_billing_bucket_details_graph**](docs/BillingApi.md#get_user_billing_bucket_details_graph) | **GET** /billing/billing/history/bucket/{bucket_id}/graph | Retrieve hourly cost datapoints of a Specific Bucket for a specific billing cycle
*BillingApi* | [**get_user_billing_cluster_details_graph**](docs/BillingApi.md#get_user_billing_cluster_details_graph) | **GET** /billing/billing/history/cluster/{cluster_id}/graph | Retrieve hourly cost datapoints of a specific Cluster for a specific billing cycle
*BillingApi* | [**get_user_billing_data_synthesis_details_graph**](docs/BillingApi.md#get_user_billing_data_synthesis_details_graph) | **GET** /billing/billing/history/data_synthesis/{resource_id}/graph | Retrieve hourly cost datapoints of a Specific Data Synthesis for a specific
*BillingApi* | [**get_user_billing_fine_tuning_details_graph**](docs/BillingApi.md#get_user_billing_fine_tuning_details_graph) | **GET** /billing/billing/history/fine_tuning/{resource_id}/graph | Retrieve hourly cost datapoints of a Specific Fine Tuning for a specific billing cycle
*BillingApi* | [**get_user_billing_history2**](docs/BillingApi.md#get_user_billing_history2) | **GET** /billing/billing/history | Retrieve Billing History for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_bucket2**](docs/BillingApi.md#get_user_billing_history_bucket2) | **GET** /billing/billing/history/bucket | Retrieve Billing History of Volume for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_bucket_details**](docs/BillingApi.md#get_user_billing_history_bucket_details) | **GET** /billing/billing/history/bucket/{bucket_id} | Retrieve Billing History of a Specific Snapshot for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_cluster**](docs/BillingApi.md#get_user_billing_history_cluster) | **GET** /billing/billing/history/cluster | Retrieve Billing History of Clusters for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_cluster_details**](docs/BillingApi.md#get_user_billing_history_cluster_details) | **GET** /billing/billing/history/cluster/{cluster_id} | Retrieve Billing History of a Specific Cluster for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_contract**](docs/BillingApi.md#get_user_billing_history_contract) | **GET** /billing/billing/history/contract | Retrieve Billing History of Contract for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_data_synthesis**](docs/BillingApi.md#get_user_billing_history_data_synthesis) | **GET** /billing/billing/history/data_synthesis | Retrieve Billing History of data synthesis for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_data_synthesis_details**](docs/BillingApi.md#get_user_billing_history_data_synthesis_details) | **GET** /billing/billing/history/data_synthesis/{resource_id} | 
*BillingApi* | [**get_user_billing_history_fine_tuning**](docs/BillingApi.md#get_user_billing_history_fine_tuning) | **GET** /billing/billing/history/fine_tuning | Retrieve Billing History of model evaluation for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_fine_tuning_details**](docs/BillingApi.md#get_user_billing_history_fine_tuning_details) | **GET** /billing/billing/history/fine_tuning/{resource_id} | Retrieve Billing History of a Specific Fine Tuning for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_model_evaluation**](docs/BillingApi.md#get_user_billing_history_model_evaluation) | **GET** /billing/billing/history/model_evaluation | Retrieve Billing History of model evaluation for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_model_evaluation_details**](docs/BillingApi.md#get_user_billing_history_model_evaluation_details) | **GET** /billing/billing/history/model_evaluation/{resource_id} | 
*BillingApi* | [**get_user_billing_history_serverless_inference**](docs/BillingApi.md#get_user_billing_history_serverless_inference) | **GET** /billing/billing/history/serverless_inference | Retrieve Billing History of serverless inference for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_serverless_inference_details**](docs/BillingApi.md#get_user_billing_history_serverless_inference_details) | **GET** /billing/billing/history/serverless_inference/{resource_id} | 
*BillingApi* | [**get_user_billing_history_snapshot**](docs/BillingApi.md#get_user_billing_history_snapshot) | **GET** /billing/billing/history/snapshot | Retrieve Billing History of Snapshot for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_snapshot_details**](docs/BillingApi.md#get_user_billing_history_snapshot_details) | **GET** /billing/billing/history/snapshot/{snapshot_id} | Retrieve Billing History of a Specific Snapshot for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_vm2**](docs/BillingApi.md#get_user_billing_history_vm2) | **GET** /billing/billing/history/virtual-machine | Retrieve Billing History of Virtual Machine for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_vm_details2**](docs/BillingApi.md#get_user_billing_history_vm_details2) | **GET** /billing/billing/history/virtual-machine/{vm_id} | Retrieve Billing History of a Specific Virtual Machine for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_vm_sub_resource_graph2**](docs/BillingApi.md#get_user_billing_history_vm_sub_resource_graph2) | **GET** /billing/billing/virtual-machine/{vm_id}/sub-resource/graph | Retrieve Sub-Resources Historical Cost datapoints of a Virtual
*BillingApi* | [**get_user_billing_history_vm_total_costs**](docs/BillingApi.md#get_user_billing_history_vm_total_costs) | **GET** /billing/billing/virtual-machine/{vm_id}/sub-resource | Retrieve Total Costs and Non Discount Costs for Sub Resources
*BillingApi* | [**get_user_billing_history_volume2**](docs/BillingApi.md#get_user_billing_history_volume2) | **GET** /billing/billing/history/volume | Retrieve Billing History of Volume for a specific Billing Cycle
*BillingApi* | [**get_user_billing_history_volume_details2**](docs/BillingApi.md#get_user_billing_history_volume_details2) | **GET** /billing/billing/history/volume/{volume_id} | Retrieve Billing History of a Specific Volume for a specific Billing Cycle
*BillingApi* | [**get_user_billing_model_evaluation_details_graph**](docs/BillingApi.md#get_user_billing_model_evaluation_details_graph) | **GET** /billing/billing/history/model_evaluation/{resource_id}/graph | Retrieve hourly cost datapoints of a Specific Model Evaluation for a specific
*BillingApi* | [**get_user_billing_serverless_inference_details_graph**](docs/BillingApi.md#get_user_billing_serverless_inference_details_graph) | **GET** /billing/billing/history/serverless_inference/{resource_id}/graph | Retrieve hourly cost datapoints of a Specific Serverless Inference for a specific
*BillingApi* | [**get_user_billing_snapshot_details_graph**](docs/BillingApi.md#get_user_billing_snapshot_details_graph) | **GET** /billing/billing/history/snapshot/{snapshot_id}/graph | Retrieve hourly cost datapoints of a Specific Snapshot for a specific billing cycle
*BillingApi* | [**get_user_billing_vm_details_graph2**](docs/BillingApi.md#get_user_billing_vm_details_graph2) | **GET** /billing/billing/history/virtual-machine/{vm_id}/graph | Retrieve hourly cost datapoints of a Specific Virtual Machine for a specific billing cycle
*BillingApi* | [**get_user_billing_volume_details_graph**](docs/BillingApi.md#get_user_billing_volume_details_graph) | **GET** /billing/billing/history/volume/{volume_id}/graph | Retrieve hourly cost datapoints of a Specific Volume for a specific billing cycle
*BillingApi* | [**get_user_vm_billing_events**](docs/BillingApi.md#get_user_vm_billing_events) | **GET** /billing/billing/virtual-machine/{vm_id}/billing-events | Retrieve VM billing events history
*BillingApi* | [**get_user_volume_billing_events**](docs/BillingApi.md#get_user_volume_billing_events) | **GET** /billing/billing/volume/{volume_id}/billing-events | Retrieve Volume billing events history
*BillingApi* | [**put_organization_threshold**](docs/BillingApi.md#put_organization_threshold) | **PUT** /billing/billing/threshold/{threshold_id} | Update: Subscribe or Unsubscribe Notification Threshold
*CallbacksApi* | [**attach_callback_to_virtual_machine**](docs/CallbacksApi.md#attach_callback_to_virtual_machine) | **POST** /core/virtual-machines/{vm_id}/attach-callback | Attach callback to virtual machine
*CallbacksApi* | [**attach_callback_to_volume**](docs/CallbacksApi.md#attach_callback_to_volume) | **POST** /core/volumes/{volume_id}/attach-callback | Attach callback to volume
*CallbacksApi* | [**delete_virtual_machine_callback**](docs/CallbacksApi.md#delete_virtual_machine_callback) | **DELETE** /core/virtual-machines/{vm_id}/delete-callback | Delete virtual machine callback
*CallbacksApi* | [**delete_volume_callback**](docs/CallbacksApi.md#delete_volume_callback) | **DELETE** /core/volumes/{volume_id}/delete-callback | Delete volume callback
*CallbacksApi* | [**update_virtual_machine_callback**](docs/CallbacksApi.md#update_virtual_machine_callback) | **PUT** /core/virtual-machines/{vm_id}/update-callback | Update virtual machine callback
*CallbacksApi* | [**update_volume_callback**](docs/CallbacksApi.md#update_volume_callback) | **PUT** /core/volumes/{volume_id}/update-callback | Update volume callback
*ClusterEventsApi* | [**fetch_all_of_a_cluster_events**](docs/ClusterEventsApi.md#fetch_all_of_a_cluster_events) | **GET** /core/clusters/{cluster_id}/events | Fetch all of a cluster events
*ClustersApi* | [**attempt_to_manually_reconcile_a_cluster**](docs/ClustersApi.md#attempt_to_manually_reconcile_a_cluster) | **POST** /core/clusters/{cluster_id}/reconcile | Reconcile a cluster
*ClustersApi* | [**create_cluster**](docs/ClustersApi.md#create_cluster) | **POST** /core/clusters | Create Cluster
*ClustersApi* | [**create_node**](docs/ClustersApi.md#create_node) | **POST** /core/clusters/{cluster_id}/nodes | Create Node
*ClustersApi* | [**create_node_group**](docs/ClustersApi.md#create_node_group) | **POST** /core/clusters/{cluster_id}/node-groups | Create a node group in a cluster
*ClustersApi* | [**delete_a_cluster**](docs/ClustersApi.md#delete_a_cluster) | **DELETE** /core/clusters/{id} | Delete a cluster
*ClustersApi* | [**delete_a_node_group**](docs/ClustersApi.md#delete_a_node_group) | **DELETE** /core/clusters/{cluster_id}/node-groups/{node_group_id} | Delete a node group
*ClustersApi* | [**delete_cluster_node**](docs/ClustersApi.md#delete_cluster_node) | **DELETE** /core/clusters/{cluster_id}/nodes/{node_id} | Delete Cluster Node
*ClustersApi* | [**fetch_cluster_name_availability**](docs/ClustersApi.md#fetch_cluster_name_availability) | **GET** /core/clusters/name-availability/{name} | Fetch cluster name availability
*ClustersApi* | [**get_cluster_master_flavors**](docs/ClustersApi.md#get_cluster_master_flavors) | **GET** /core/clusters/master-flavors | Get Cluster Master Flavors
*ClustersApi* | [**get_cluster_nodes**](docs/ClustersApi.md#get_cluster_nodes) | **GET** /core/clusters/{cluster_id}/nodes | Get Cluster Nodes
*ClustersApi* | [**get_cluster_versions**](docs/ClustersApi.md#get_cluster_versions) | **GET** /core/clusters/versions | List Cluster Versions
*ClustersApi* | [**getting_cluster_detail**](docs/ClustersApi.md#getting_cluster_detail) | **GET** /core/clusters/{id} | Getting Cluster Detail
*ClustersApi* | [**list_clusters**](docs/ClustersApi.md#list_clusters) | **GET** /core/clusters | List Clusters
*ClustersApi* | [**list_node_groups**](docs/ClustersApi.md#list_node_groups) | **GET** /core/clusters/{cluster_id}/node-groups | List node groups for a cluster
*ClustersApi* | [**retrieve_a_node_group**](docs/ClustersApi.md#retrieve_a_node_group) | **GET** /core/clusters/{cluster_id}/node-groups/{node_group_id} | Retrieve a node group in a cluster
*ComplianceApi* | [**create_compliance**](docs/ComplianceApi.md#create_compliance) | **POST** /core/compliance | Create compliance
*ComplianceApi* | [**delete_a_compliance**](docs/ComplianceApi.md#delete_a_compliance) | **DELETE** /core/compliance/{gpu_model} | Delete a compliance
*ComplianceApi* | [**retrieve_compliance**](docs/ComplianceApi.md#retrieve_compliance) | **GET** /core/compliance | Retrieve GPU compliance
*ComplianceApi* | [**update_a_compliance**](docs/ComplianceApi.md#update_a_compliance) | **PUT** /core/compliance | Update a compliance
*CreditApi* | [**get_credit2**](docs/CreditApi.md#get_credit2) | **GET** /billing/user-credit/credit | GET: View credit and threshold
*DashboardApi* | [**retrieve_dashboard**](docs/DashboardApi.md#retrieve_dashboard) | **GET** /core/dashboard | Retrieve Dashboard
*DeploymentApi* | [**delete_deployment**](docs/DeploymentApi.md#delete_deployment) | **DELETE** /core/marketplace/deployments/{id} | Delete Deployment
*DeploymentApi* | [**details_of_deployment_by_id**](docs/DeploymentApi.md#details_of_deployment_by_id) | **GET** /core/marketplace/deployments/{id} | Details of Deployment by ID
*DeploymentApi* | [**list_deployments**](docs/DeploymentApi.md#list_deployments) | **GET** /core/marketplace/deployments | List Deployments
*DeploymentApi* | [**start_deployment**](docs/DeploymentApi.md#start_deployment) | **POST** /core/marketplace/deployments | Start Deployment
*EnvironmentApi* | [**create_environment**](docs/EnvironmentApi.md#create_environment) | **POST** /core/environments | Create environment
*EnvironmentApi* | [**delete_environment**](docs/EnvironmentApi.md#delete_environment) | **DELETE** /core/environments/{id} | Delete environment
*EnvironmentApi* | [**fetch_environment_name_availability**](docs/EnvironmentApi.md#fetch_environment_name_availability) | **GET** /core/environments/name-availability/{name} | Fetch environment name availability
*EnvironmentApi* | [**list_environments**](docs/EnvironmentApi.md#list_environments) | **GET** /core/environments | List environments
*EnvironmentApi* | [**retrieve_environment**](docs/EnvironmentApi.md#retrieve_environment) | **GET** /core/environments/{id} | Retrieve environment
*EnvironmentApi* | [**update_environment**](docs/EnvironmentApi.md#update_environment) | **PUT** /core/environments/{id} | Update environment
*FirewallAttachmentApi* | [**post_attach_security_groups**](docs/FirewallAttachmentApi.md#post_attach_security_groups) | **POST** /core/firewalls/{firewall_id}/update-attachments | Attach Firewalls to VMs
*FirewallsApi* | [**delete_security_group_details**](docs/FirewallsApi.md#delete_security_group_details) | **DELETE** /core/firewalls/{id} | Delete firewall
*FirewallsApi* | [**delete_security_group_rule_delete**](docs/FirewallsApi.md#delete_security_group_rule_delete) | **DELETE** /core/firewalls/{firewall_id}/firewall-rules/{firewall_rule_id} | Delete firewall rules from firewall
*FirewallsApi* | [**get_security_group**](docs/FirewallsApi.md#get_security_group) | **GET** /core/firewalls | List firewalls
*FirewallsApi* | [**get_security_group_details**](docs/FirewallsApi.md#get_security_group_details) | **GET** /core/firewalls/{id} | Retrieve firewall details
*FirewallsApi* | [**post_security_group**](docs/FirewallsApi.md#post_security_group) | **POST** /core/firewalls | Create firewall
*FirewallsApi* | [**post_security_group_rules**](docs/FirewallsApi.md#post_security_group_rules) | **POST** /core/firewalls/{firewall_id}/firewall-rules | Add firewall rule to firewall
*FlavorApi* | [**list_flavors**](docs/FlavorApi.md#list_flavors) | **GET** /core/flavors | List Flavors
*FloatingIpApi* | [**attach_public_ipto_virtual_machine**](docs/FloatingIpApi.md#attach_public_ipto_virtual_machine) | **POST** /core/virtual-machines/{vm_id}/attach-floatingip | Attach public IP to virtual machine
*FloatingIpApi* | [**detach_public_ip_from_virtual_machine**](docs/FloatingIpApi.md#detach_public_ip_from_virtual_machine) | **POST** /core/virtual-machines/{vm_id}/detach-floatingip | Detach public IP from virtual machine
*GpuApi* | [**list_gpus**](docs/GpuApi.md#list_gpus) | **GET** /core/gpus | List GPUs
*ImageApi* | [**delete_image**](docs/ImageApi.md#delete_image) | **DELETE** /core/images/{id} | Delete an image
*ImageApi* | [**fetch_image_name_availability**](docs/ImageApi.md#fetch_image_name_availability) | **GET** /core/image/name-availability/{name} | Fetch name availability for Images
*ImageApi* | [**get_image_details**](docs/ImageApi.md#get_image_details) | **GET** /core/images/{id} | Get Private Image Details
*ImageApi* | [**list_images2**](docs/ImageApi.md#list_images2) | **GET** /core/images | List Images
*InviteApi* | [**accept_invite**](docs/InviteApi.md#accept_invite) | **GET** /auth/invites/{id}/accept | Accept Invite
*InviteApi* | [**delete_invite**](docs/InviteApi.md#delete_invite) | **DELETE** /auth/invites/{id} | Accept Invite
*InviteApi* | [**invite_user_to_organization**](docs/InviteApi.md#invite_user_to_organization) | **POST** /auth/invites | Invite User to Organization
*InviteApi* | [**list_invites**](docs/InviteApi.md#list_invites) | **GET** /auth/invites | List Invites
*KeypairApi* | [**delete_key_pair**](docs/KeypairApi.md#delete_key_pair) | **DELETE** /core/keypair/{id} | Delete key pair
*KeypairApi* | [**import_key_pair**](docs/KeypairApi.md#import_key_pair) | **POST** /core/keypairs | Import key pair
*KeypairApi* | [**list_key_pairs**](docs/KeypairApi.md#list_key_pairs) | **GET** /core/keypairs | List key pairs
*KeypairApi* | [**update_key_pair_name**](docs/KeypairApi.md#update_key_pair_name) | **PUT** /core/keypair/{id} | Update key pair name
*OrganizationApi* | [**remove_organization_member**](docs/OrganizationApi.md#remove_organization_member) | **POST** /auth/organizations/remove-member | Remove Organization Member
*OrganizationApi* | [**retrieve_organization_information**](docs/OrganizationApi.md#retrieve_organization_information) | **GET** /auth/organizations | Retrieve Organization Information
*OrganizationApi* | [**update_organization_information**](docs/OrganizationApi.md#update_organization_information) | **PUT** /auth/organizations/update | Update Organization Information
*PartnerConfigApi* | [**get_partner_config**](docs/PartnerConfigApi.md#get_partner_config) | **GET** /auth/partner-config | Get partner config
*PartnerConfigApi* | [**get_partner_config_by_domain**](docs/PartnerConfigApi.md#get_partner_config_by_domain) | **GET** /auth/partner-config/docs | 
*PaymentApi* | [**get_details**](docs/PaymentApi.md#get_details) | **GET** /billing/payment/payment-details | GET: View payment details
*PaymentApi* | [**get_payment_receipt2**](docs/PaymentApi.md#get_payment_receipt2) | **GET** /billing/payment/receipt/{payment_id} | Retrieve Payment Receipt
*PaymentApi* | [**post_payment**](docs/PaymentApi.md#post_payment) | **POST** /billing/payment/payment-initiate | POST: Initiate payment
*PermissionApi* | [**list_permissions**](docs/PermissionApi.md#list_permissions) | **GET** /auth/permissions | List Permissions
*PolicyApi* | [**list_policies**](docs/PolicyApi.md#list_policies) | **GET** /auth/policies | List Policies
*ProfileApi* | [**create_profile**](docs/ProfileApi.md#create_profile) | **POST** /core/profiles | Create profile
*ProfileApi* | [**delete_profile**](docs/ProfileApi.md#delete_profile) | **DELETE** /core/profiles/{id} | Delete profile
*ProfileApi* | [**list_profiles**](docs/ProfileApi.md#list_profiles) | **GET** /core/profiles | List profiles
*ProfileApi* | [**retrieve_profile_details**](docs/ProfileApi.md#retrieve_profile_details) | **GET** /core/profiles/{id} | Retrieve profile details
*RbacRoleApi* | [**create_rbac_role**](docs/RbacRoleApi.md#create_rbac_role) | **POST** /auth/roles | Create RBAC Role
*RbacRoleApi* | [**delete_rbac_role**](docs/RbacRoleApi.md#delete_rbac_role) | **DELETE** /auth/roles/{id} | Delete RBAC Role
*RbacRoleApi* | [**list_rbac_roles**](docs/RbacRoleApi.md#list_rbac_roles) | **GET** /auth/roles | List RBAC Roles
*RbacRoleApi* | [**retrieve_rbac_role_details**](docs/RbacRoleApi.md#retrieve_rbac_role_details) | **GET** /auth/roles/{id} | Retrieve RBAC Role Details
*RbacRoleApi* | [**update_rbac_role**](docs/RbacRoleApi.md#update_rbac_role) | **PUT** /auth/roles/{id} | Update RBAC Role
*RegionApi* | [**list_regions**](docs/RegionApi.md#list_regions) | **GET** /core/regions | List Regions
*SecurityRulesApi* | [**list_firewall_rule_protocols**](docs/SecurityRulesApi.md#list_firewall_rule_protocols) | **GET** /core/sg-rules-protocols | List firewall rule protocols
*SnapshotEventsApi* | [**fetch_all_events_for_a_snapshot**](docs/SnapshotEventsApi.md#fetch_all_events_for_a_snapshot) | **GET** /core/snapshots/{snapshot_id}/events | Fetch all events for a snapshot
*StockApi* | [**retrieve_gpu_stocks**](docs/StockApi.md#retrieve_gpu_stocks) | **GET** /core/stocks | Retrieve GPU stocks
*TemplateApi* | [**create_template**](docs/TemplateApi.md#create_template) | **POST** /core/marketplace/templates | Create template
*TemplateApi* | [**delete_template**](docs/TemplateApi.md#delete_template) | **DELETE** /core/marketplace/templates/{id} | Delete template
*TemplateApi* | [**list_templates**](docs/TemplateApi.md#list_templates) | **GET** /core/marketplace/templates | List templates
*TemplateApi* | [**retrieve_template_details**](docs/TemplateApi.md#retrieve_template_details) | **GET** /core/marketplace/templates/{id} | Retrieve template details
*TemplateApi* | [**update_template**](docs/TemplateApi.md#update_template) | **PUT** /core/marketplace/templates/{id} | Update template
*UserApi* | [**get_user**](docs/UserApi.md#get_user) | **GET** /billing/user/info | GET: Retrieve billing info
*UserApi* | [**post_user**](docs/UserApi.md#post_user) | **POST** /billing/user/info | POST: Insert billing info
*UserApi* | [**put_user**](docs/UserApi.md#put_user) | **PUT** /billing/user/info | PUT: Update billing info
*UserDetailChoiceApi* | [**retrieve_default_flavors_and_images**](docs/UserDetailChoiceApi.md#retrieve_default_flavors_and_images) | **GET** /core/user/resources/defaults | Retrieve Default Flavors and Images
*UserPermissionApi* | [**list_my_user_permissions**](docs/UserPermissionApi.md#list_my_user_permissions) | **GET** /auth/users/me/permissions | List My User Permissions
*UserPermissionApi* | [**list_user_permissions**](docs/UserPermissionApi.md#list_user_permissions) | **GET** /auth/users/{id}/permissions | List User Permissions
*VirtualMachineApi* | [**delete_instance**](docs/VirtualMachineApi.md#delete_instance) | **DELETE** /core/virtual-machines/{vm_id} | Delete virtual machine
*VirtualMachineApi* | [**delete_security_rule**](docs/VirtualMachineApi.md#delete_security_rule) | **DELETE** /core/virtual-machines/{vm_id}/sg-rules/{sg_rule_id} | Delete firewall rule from virtual machine
*VirtualMachineApi* | [**fetch_virtual_machine_name_availability**](docs/VirtualMachineApi.md#fetch_virtual_machine_name_availability) | **GET** /core/virtual-machines/name-availability/{name} | Fetch virtual machine name availability
*VirtualMachineApi* | [**get_contract_instances**](docs/VirtualMachineApi.md#get_contract_instances) | **GET** /core/virtual-machines/contract/{contract_id}/virtual-machines | Retrieve virtual machines associated with a contract
*VirtualMachineApi* | [**get_instance**](docs/VirtualMachineApi.md#get_instance) | **GET** /core/virtual-machines | List virtual machines
*VirtualMachineApi* | [**get_instance2**](docs/VirtualMachineApi.md#get_instance2) | **GET** /core/virtual-machines/{vm_id} | Retrieve virtual machine details
*VirtualMachineApi* | [**get_instance3**](docs/VirtualMachineApi.md#get_instance3) | **GET** /core/virtual-machines/{vm_id}/hard-reboot | Hard reboot virtual machine
*VirtualMachineApi* | [**get_instance4**](docs/VirtualMachineApi.md#get_instance4) | **GET** /core/virtual-machines/{vm_id}/start | Start virtual machine
*VirtualMachineApi* | [**get_instance5**](docs/VirtualMachineApi.md#get_instance5) | **GET** /core/virtual-machines/{vm_id}/stop | Stop virtual machine
*VirtualMachineApi* | [**get_instance_hibernate**](docs/VirtualMachineApi.md#get_instance_hibernate) | **GET** /core/virtual-machines/{vm_id}/hibernate | Hibernate virtual machine
*VirtualMachineApi* | [**get_instance_hibernate_restore**](docs/VirtualMachineApi.md#get_instance_hibernate_restore) | **GET** /core/virtual-machines/{vm_id}/hibernate-restore | Restore virtual machine from hibernation
*VirtualMachineApi* | [**get_instance_logs**](docs/VirtualMachineApi.md#get_instance_logs) | **GET** /core/virtual-machines/{vm_id}/logs | Get virtual machine logs
*VirtualMachineApi* | [**get_instance_metrics**](docs/VirtualMachineApi.md#get_instance_metrics) | **GET** /core/virtual-machines/{vm_id}/metrics | Retrieve virtual machine performance metrics
*VirtualMachineApi* | [**post_instance**](docs/VirtualMachineApi.md#post_instance) | **POST** /core/virtual-machines | Create virtual machines
*VirtualMachineApi* | [**post_instance_attach_firewalls**](docs/VirtualMachineApi.md#post_instance_attach_firewalls) | **POST** /core/virtual-machines/{vm_id}/attach-firewalls | Attach firewalls to a virtual machine
*VirtualMachineApi* | [**post_instance_logs**](docs/VirtualMachineApi.md#post_instance_logs) | **POST** /core/virtual-machines/{vm_id}/logs | Request virtual machine logs
*VirtualMachineApi* | [**post_instance_resize**](docs/VirtualMachineApi.md#post_instance_resize) | **POST** /core/virtual-machines/{vm_id}/resize | Resize virtual machine
*VirtualMachineApi* | [**post_security_rule**](docs/VirtualMachineApi.md#post_security_rule) | **POST** /core/virtual-machines/{vm_id}/sg-rules | Add firewall rule to virtual machine
*VirtualMachineApi* | [**post_snapshots**](docs/VirtualMachineApi.md#post_snapshots) | **POST** /core/virtual-machines/{vm_id}/snapshots | Create snapshot from a virtual machine
*VirtualMachineApi* | [**put_labels**](docs/VirtualMachineApi.md#put_labels) | **PUT** /core/virtual-machines/{vm_id}/label | Edit virtual machine labels
*VirtualMachineEventsApi* | [**list_virtual_machine_events**](docs/VirtualMachineEventsApi.md#list_virtual_machine_events) | **GET** /core/virtual-machines/{vm_id}/events | List virtual machine events
*VncUrlApi* | [**get_vnc_url**](docs/VncUrlApi.md#get_vnc_url) | **GET** /core/virtual-machines/{vm_id}/console/{job_id} | Get VNC Console Link
*VncUrlApi* | [**get_vnc_url2**](docs/VncUrlApi.md#get_vnc_url2) | **GET** /core/virtual-machines/{vm_id}/request-console | Request Instance Console
*VolumeApi* | [**create_volume**](docs/VolumeApi.md#create_volume) | **POST** /core/volumes | Create volume
*VolumeApi* | [**delete_volume**](docs/VolumeApi.md#delete_volume) | **DELETE** /core/volumes/{volume_id} | Delete volume
*VolumeApi* | [**fetch_volume_details**](docs/VolumeApi.md#fetch_volume_details) | **GET** /core/volumes/{volume_id} | Fetch Volume Details
*VolumeApi* | [**fetch_volume_name_availability**](docs/VolumeApi.md#fetch_volume_name_availability) | **GET** /core/volume/name-availability/{name} | Fetch volume name availability
*VolumeApi* | [**list_volume_types**](docs/VolumeApi.md#list_volume_types) | **GET** /core/volume-types | List volume types
*VolumeApi* | [**list_volumes**](docs/VolumeApi.md#list_volumes) | **GET** /core/volumes | List volumes
*VolumeApi* | [**update_volume**](docs/VolumeApi.md#update_volume) | **PATCH** /core/volumes/{volume_id} | Update volume fields
*VolumeAttachmentApi* | [**attach_volumes_to_virtual_machine**](docs/VolumeAttachmentApi.md#attach_volumes_to_virtual_machine) | **POST** /core/virtual-machines/{vm_id}/attach-volumes | Attach volumes to virtual machine
*VolumeAttachmentApi* | [**detach_volumes_from_virtual_machine**](docs/VolumeAttachmentApi.md#detach_volumes_from_virtual_machine) | **POST** /core/virtual-machines/{vm_id}/detach-volumes | Detach volumes from virtual machine
*VolumeAttachmentApi* | [**update_a_volume_attachment**](docs/VolumeAttachmentApi.md#update_a_volume_attachment) | **PATCH** /core/volume-attachments/{volume_attachment_id} | Update a volume attachment


## Documentation For Models

 - [AccessTokenField](docs/AccessTokenField.md)
 - [AddUserInfoSuccessResponseModel](docs/AddUserInfoSuccessResponseModel.md)
 - [AllocatedGPUCountGraph](docs/AllocatedGPUCountGraph.md)
 - [ApiKeyFields](docs/ApiKeyFields.md)
 - [AssignRbacRolePayload](docs/AssignRbacRolePayload.md)
 - [AttachCallbackPayload](docs/AttachCallbackPayload.md)
 - [AttachCallbackResponse](docs/AttachCallbackResponse.md)
 - [AttachFirewallWithVM](docs/AttachFirewallWithVM.md)
 - [AttachFirewallsToVMPayload](docs/AttachFirewallsToVMPayload.md)
 - [AttachVolumeFields](docs/AttachVolumeFields.md)
 - [AttachVolumes](docs/AttachVolumes.md)
 - [AttachVolumesPayload](docs/AttachVolumesPayload.md)
 - [AttachmentsFieldsForVolume](docs/AttachmentsFieldsForVolume.md)
 - [Attributes](docs/Attributes.md)
 - [AuthGetTokenResponseModel](docs/AuthGetTokenResponseModel.md)
 - [AuthUserFields](docs/AuthUserFields.md)
 - [AuthUserInfoResponseModel](docs/AuthUserInfoResponseModel.md)
 - [BetaAccessRequestFields](docs/BetaAccessRequestFields.md)
 - [BetaAccessRequestPayload](docs/BetaAccessRequestPayload.md)
 - [BetaAccessRequestResponseModel](docs/BetaAccessRequestResponseModel.md)
 - [BetaAccessStatusItem](docs/BetaAccessStatusItem.md)
 - [BetaAccessStatusResponseModel](docs/BetaAccessStatusResponseModel.md)
 - [BillingHistory](docs/BillingHistory.md)
 - [BillingHistoryDataSynthesisDetails](docs/BillingHistoryDataSynthesisDetails.md)
 - [BillingHistoryFineTuning](docs/BillingHistoryFineTuning.md)
 - [BillingHistoryModelEvalutationDetails](docs/BillingHistoryModelEvalutationDetails.md)
 - [BillingHistoryServerlessInference](docs/BillingHistoryServerlessInference.md)
 - [BillingHistoryServerlessInferenceDetails](docs/BillingHistoryServerlessInferenceDetails.md)
 - [BillingMetricesFields](docs/BillingMetricesFields.md)
 - [BillingMetricesResponse](docs/BillingMetricesResponse.md)
 - [ClusterEvents](docs/ClusterEvents.md)
 - [ClusterEventsFields](docs/ClusterEventsFields.md)
 - [ClusterFields](docs/ClusterFields.md)
 - [ClusterFlavorFields](docs/ClusterFlavorFields.md)
 - [ClusterListResponse](docs/ClusterListResponse.md)
 - [ClusterNodeFields](docs/ClusterNodeFields.md)
 - [ClusterNodeGroupFields](docs/ClusterNodeGroupFields.md)
 - [ClusterNodeGroupsCreateResponse](docs/ClusterNodeGroupsCreateResponse.md)
 - [ClusterNodeGroupsGetResponse](docs/ClusterNodeGroupsGetResponse.md)
 - [ClusterNodeGroupsListResponse](docs/ClusterNodeGroupsListResponse.md)
 - [ClusterNodeInstanceFields](docs/ClusterNodeInstanceFields.md)
 - [ClusterNodesListResponse](docs/ClusterNodesListResponse.md)
 - [ClusterResponse](docs/ClusterResponse.md)
 - [ClusterVersion](docs/ClusterVersion.md)
 - [ClusterVersions](docs/ClusterVersions.md)
 - [Colors](docs/Colors.md)
 - [CommonResponseModel](docs/CommonResponseModel.md)
 - [ComplianceFields](docs/ComplianceFields.md)
 - [ComplianceModelFields](docs/ComplianceModelFields.md)
 - [CompliancePayload](docs/CompliancePayload.md)
 - [ComplianceResponse](docs/ComplianceResponse.md)
 - [ContainerOverviewFields](docs/ContainerOverviewFields.md)
 - [Contract](docs/Contract.md)
 - [ContractDiscountPlanFields](docs/ContractDiscountPlanFields.md)
 - [ContractGPUAllocationGraphResponse](docs/ContractGPUAllocationGraphResponse.md)
 - [ContractInstanceFields](docs/ContractInstanceFields.md)
 - [ContractInstancesResponse](docs/ContractInstancesResponse.md)
 - [CreateClusterNodeFields](docs/CreateClusterNodeFields.md)
 - [CreateClusterNodeGroupPayload](docs/CreateClusterNodeGroupPayload.md)
 - [CreateClusterPayload](docs/CreateClusterPayload.md)
 - [CreateEnvironment](docs/CreateEnvironment.md)
 - [CreateFirewallPayload](docs/CreateFirewallPayload.md)
 - [CreateFirewallRulePayload](docs/CreateFirewallRulePayload.md)
 - [CreateImage](docs/CreateImage.md)
 - [CreateImagePayload](docs/CreateImagePayload.md)
 - [CreateInstancesPayload](docs/CreateInstancesPayload.md)
 - [CreateInstancesResponse](docs/CreateInstancesResponse.md)
 - [CreateProfilePayload](docs/CreateProfilePayload.md)
 - [CreateProfileResponse](docs/CreateProfileResponse.md)
 - [CreateSecurityRulePayload](docs/CreateSecurityRulePayload.md)
 - [CreateSnapshotPayload](docs/CreateSnapshotPayload.md)
 - [CreateSnapshotResponse](docs/CreateSnapshotResponse.md)
 - [CreateUpdateComplianceResponse](docs/CreateUpdateComplianceResponse.md)
 - [CreateUpdateRbacRolePayload](docs/CreateUpdateRbacRolePayload.md)
 - [CreateVolumePayload](docs/CreateVolumePayload.md)
 - [CustomerContractDetailResponseModel](docs/CustomerContractDetailResponseModel.md)
 - [CustomerContractFields](docs/CustomerContractFields.md)
 - [DashboardInfoResponse](docs/DashboardInfoResponse.md)
 - [DataSynthesisBillingHistoryDetailsResponseSchema](docs/DataSynthesisBillingHistoryDetailsResponseSchema.md)
 - [DeploymentFields](docs/DeploymentFields.md)
 - [DeploymentFieldsForStartDeployments](docs/DeploymentFieldsForStartDeployments.md)
 - [Deployments](docs/Deployments.md)
 - [DetachVolumes](docs/DetachVolumes.md)
 - [DetachVolumesPayload](docs/DetachVolumesPayload.md)
 - [EditLabelOfAnExistingVMPayload](docs/EditLabelOfAnExistingVMPayload.md)
 - [Environment](docs/Environment.md)
 - [EnvironmentFeatures](docs/EnvironmentFeatures.md)
 - [EnvironmentFields](docs/EnvironmentFields.md)
 - [EnvironmentFieldsForVolume](docs/EnvironmentFieldsForVolume.md)
 - [Environments](docs/Environments.md)
 - [ErrorResponseModel](docs/ErrorResponseModel.md)
 - [FirewallAttachmentModel](docs/FirewallAttachmentModel.md)
 - [FirewallAttachmentVMModel](docs/FirewallAttachmentVMModel.md)
 - [FirewallDetailFields](docs/FirewallDetailFields.md)
 - [FirewallDetailResponse](docs/FirewallDetailResponse.md)
 - [FirewallEnvironmentFields](docs/FirewallEnvironmentFields.md)
 - [FirewallFields](docs/FirewallFields.md)
 - [FirewallResponse](docs/FirewallResponse.md)
 - [FirewallRule](docs/FirewallRule.md)
 - [FirewallsListResponse](docs/FirewallsListResponse.md)
 - [FlavorFields](docs/FlavorFields.md)
 - [FlavorItemGetResponse](docs/FlavorItemGetResponse.md)
 - [FlavorLabelFields](docs/FlavorLabelFields.md)
 - [FlavorListResponse](docs/FlavorListResponse.md)
 - [FlavorObjectFields](docs/FlavorObjectFields.md)
 - [GPUFields](docs/GPUFields.md)
 - [GPUList](docs/GPUList.md)
 - [GPURegionFields](docs/GPURegionFields.md)
 - [GenerateUpdateApiKeyPayload](docs/GenerateUpdateApiKeyPayload.md)
 - [GenerateUpdateApiKeyResponseModel](docs/GenerateUpdateApiKeyResponseModel.md)
 - [GetApiKeysResponseModel](docs/GetApiKeysResponseModel.md)
 - [GetCreditAndThresholdInfo](docs/GetCreditAndThresholdInfo.md)
 - [GetCreditAndThresholdInfoInResponse](docs/GetCreditAndThresholdInfoInResponse.md)
 - [GetCustomerContractsListResponseModel](docs/GetCustomerContractsListResponseModel.md)
 - [GetInstanceLogsResponse](docs/GetInstanceLogsResponse.md)
 - [GetInvitesResponseModel](docs/GetInvitesResponseModel.md)
 - [GetOrganizationResponseModel](docs/GetOrganizationResponseModel.md)
 - [GetPermissionsResponseModel](docs/GetPermissionsResponseModel.md)
 - [GetPoliciesResponseModel](docs/GetPoliciesResponseModel.md)
 - [GetRbacRolesResponseModel](docs/GetRbacRolesResponseModel.md)
 - [GetUserPermissionsResponseModel](docs/GetUserPermissionsResponseModel.md)
 - [GraphDatetimeValueModel](docs/GraphDatetimeValueModel.md)
 - [Image](docs/Image.md)
 - [ImageFields](docs/ImageFields.md)
 - [ImageGetResponse](docs/ImageGetResponse.md)
 - [Images](docs/Images.md)
 - [ImportKeypairPayload](docs/ImportKeypairPayload.md)
 - [ImportKeypairResponse](docs/ImportKeypairResponse.md)
 - [InfrahubResourceObjectResponseForCustomer](docs/InfrahubResourceObjectResponseForCustomer.md)
 - [Instance](docs/Instance.md)
 - [InstanceEnvironmentFields](docs/InstanceEnvironmentFields.md)
 - [InstanceEvents](docs/InstanceEvents.md)
 - [InstanceEventsFields](docs/InstanceEventsFields.md)
 - [InstanceFields](docs/InstanceFields.md)
 - [InstanceFlavorFields](docs/InstanceFlavorFields.md)
 - [InstanceImageFields](docs/InstanceImageFields.md)
 - [InstanceKeypairFields](docs/InstanceKeypairFields.md)
 - [InstanceOverviewFields](docs/InstanceOverviewFields.md)
 - [InstanceResizePayload](docs/InstanceResizePayload.md)
 - [Instances](docs/Instances.md)
 - [InviteFields](docs/InviteFields.md)
 - [InviteUserPayload](docs/InviteUserPayload.md)
 - [InviteUserResponseModel](docs/InviteUserResponseModel.md)
 - [KeypairEnvironmentFeatures](docs/KeypairEnvironmentFeatures.md)
 - [KeypairEnvironmentFields](docs/KeypairEnvironmentFields.md)
 - [KeypairFields](docs/KeypairFields.md)
 - [Keypairs](docs/Keypairs.md)
 - [LableResonse](docs/LableResonse.md)
 - [LastDayCostFields](docs/LastDayCostFields.md)
 - [LastDayCostResponse](docs/LastDayCostResponse.md)
 - [Logos](docs/Logos.md)
 - [MFAStatusFields](docs/MFAStatusFields.md)
 - [MFAStatusResponse](docs/MFAStatusResponse.md)
 - [ManualReconciliationModel](docs/ManualReconciliationModel.md)
 - [MasterFlavorsResponse](docs/MasterFlavorsResponse.md)
 - [MetricItemFields](docs/MetricItemFields.md)
 - [MetricsFields](docs/MetricsFields.md)
 - [ModelEvaluationBillingHistoryDetailsResponseSchema](docs/ModelEvaluationBillingHistoryDetailsResponseSchema.md)
 - [NameAvailableModel](docs/NameAvailableModel.md)
 - [NewConfigurationsResponse](docs/NewConfigurationsResponse.md)
 - [NewModelResponse](docs/NewModelResponse.md)
 - [NewStockResponse](docs/NewStockResponse.md)
 - [NewStockRetriveResponse](docs/NewStockRetriveResponse.md)
 - [OrganizationFields](docs/OrganizationFields.md)
 - [OrganizationLevelBillingHistory](docs/OrganizationLevelBillingHistory.md)
 - [OrganizationLevelBillingHistoryResources](docs/OrganizationLevelBillingHistoryResources.md)
 - [OrganizationLevelBillingHistoryResponseAttributes](docs/OrganizationLevelBillingHistoryResponseAttributes.md)
 - [OrganizationLevelBillingHistoryResponseMetrics](docs/OrganizationLevelBillingHistoryResponseMetrics.md)
 - [OrganizationLevelBillingHistoryResponseModel](docs/OrganizationLevelBillingHistoryResponseModel.md)
 - [OrganizationThresholdFields](docs/OrganizationThresholdFields.md)
 - [OrganizationThresholdUpdateResponse](docs/OrganizationThresholdUpdateResponse.md)
 - [OrganizationThresholdsResponse](docs/OrganizationThresholdsResponse.md)
 - [OrganizationUserResponseModel](docs/OrganizationUserResponseModel.md)
 - [OverviewInfo](docs/OverviewInfo.md)
 - [Pagination](docs/Pagination.md)
 - [PaginationData](docs/PaginationData.md)
 - [PartnerConfig](docs/PartnerConfig.md)
 - [PaymentDetailsFields](docs/PaymentDetailsFields.md)
 - [PaymentDetailsResponse](docs/PaymentDetailsResponse.md)
 - [PaymentInitiateFields](docs/PaymentInitiateFields.md)
 - [PaymentInitiatePayload](docs/PaymentInitiatePayload.md)
 - [PaymentInitiateResponse](docs/PaymentInitiateResponse.md)
 - [PermissionFields](docs/PermissionFields.md)
 - [PolicyFields](docs/PolicyFields.md)
 - [PolicyPermissionFields](docs/PolicyPermissionFields.md)
 - [PricebookModel](docs/PricebookModel.md)
 - [PricebookResourceObjectResponseForCustomer](docs/PricebookResourceObjectResponseForCustomer.md)
 - [PrimaryColor](docs/PrimaryColor.md)
 - [ProfileFields](docs/ProfileFields.md)
 - [ProfileListResponse](docs/ProfileListResponse.md)
 - [ProfileObjectFields](docs/ProfileObjectFields.md)
 - [RbacRoleDetailResponseModel](docs/RbacRoleDetailResponseModel.md)
 - [RbacRoleDetailResponseModelFixed](docs/RbacRoleDetailResponseModelFixed.md)
 - [RbacRoleField](docs/RbacRoleField.md)
 - [RbacRoleFields](docs/RbacRoleFields.md)
 - [RegionFields](docs/RegionFields.md)
 - [Regions](docs/Regions.md)
 - [RemoveMemberFromOrganizationResponseModel](docs/RemoveMemberFromOrganizationResponseModel.md)
 - [RemoveMemberPayload](docs/RemoveMemberPayload.md)
 - [RequestConsole](docs/RequestConsole.md)
 - [RequestInstanceLogsPayload](docs/RequestInstanceLogsPayload.md)
 - [RequestInstanceLogsResponse](docs/RequestInstanceLogsResponse.md)
 - [ResourceBillingEventsHistoryMetrics](docs/ResourceBillingEventsHistoryMetrics.md)
 - [ResourceBillingEventsHistoryResponse](docs/ResourceBillingEventsHistoryResponse.md)
 - [ResourceBillingResponseForCustomer](docs/ResourceBillingResponseForCustomer.md)
 - [ResourceLevelBillingBucketDetailsResources](docs/ResourceLevelBillingBucketDetailsResources.md)
 - [ResourceLevelBillingDetailsAttributes](docs/ResourceLevelBillingDetailsAttributes.md)
 - [ResourceLevelBillingDetailsMetrics](docs/ResourceLevelBillingDetailsMetrics.md)
 - [ResourceLevelBillingDetailsVM](docs/ResourceLevelBillingDetailsVM.md)
 - [ResourceLevelBillingDetailsVolume](docs/ResourceLevelBillingDetailsVolume.md)
 - [ResourceLevelBillingDetailsVolumeAttributes](docs/ResourceLevelBillingDetailsVolumeAttributes.md)
 - [ResourceLevelBillingDetailsVolumeMetrics](docs/ResourceLevelBillingDetailsVolumeMetrics.md)
 - [ResourceLevelBillingHistory](docs/ResourceLevelBillingHistory.md)
 - [ResourceLevelBillingHistoryResources](docs/ResourceLevelBillingHistoryResources.md)
 - [ResourceLevelBillingHistoryResourcesCluster](docs/ResourceLevelBillingHistoryResourcesCluster.md)
 - [ResourceLevelBillingHistoryResponseAttributes](docs/ResourceLevelBillingHistoryResponseAttributes.md)
 - [ResourceLevelBillingHistoryResponseMetrics](docs/ResourceLevelBillingHistoryResponseMetrics.md)
 - [ResourceLevelBillingVMDetailsResources](docs/ResourceLevelBillingVMDetailsResources.md)
 - [ResourceLevelBillingVolumeDetailsResources](docs/ResourceLevelBillingVolumeDetailsResources.md)
 - [ResourceLevelBucketBillingDetailsResponseModel](docs/ResourceLevelBucketBillingDetailsResponseModel.md)
 - [ResourceLevelBucketBillingHistoryResponseModel](docs/ResourceLevelBucketBillingHistoryResponseModel.md)
 - [ResourceLevelClusterBillingDetailsResponseModel](docs/ResourceLevelClusterBillingDetailsResponseModel.md)
 - [ResourceLevelClusterBillingHistoryResponseModel](docs/ResourceLevelClusterBillingHistoryResponseModel.md)
 - [ResourceLevelClusterGraphBillingDetailsResponseModel](docs/ResourceLevelClusterGraphBillingDetailsResponseModel.md)
 - [ResourceLevelGraphBillingDetailVolume](docs/ResourceLevelGraphBillingDetailVolume.md)
 - [ResourceLevelGraphBillingDetailsAttributes](docs/ResourceLevelGraphBillingDetailsAttributes.md)
 - [ResourceLevelGraphBillingDetailsBucket](docs/ResourceLevelGraphBillingDetailsBucket.md)
 - [ResourceLevelGraphBillingDetailsMetrics](docs/ResourceLevelGraphBillingDetailsMetrics.md)
 - [ResourceLevelGraphBillingDetailsVM](docs/ResourceLevelGraphBillingDetailsVM.md)
 - [ResourceLevelGraphBillingVMDetailsResources](docs/ResourceLevelGraphBillingVMDetailsResources.md)
 - [ResourceLevelGraphBillingVolumeDetailsResources](docs/ResourceLevelGraphBillingVolumeDetailsResources.md)
 - [ResourceLevelVMBillingDetailsResponseModel](docs/ResourceLevelVMBillingDetailsResponseModel.md)
 - [ResourceLevelVmBillingHistoryResponseModel](docs/ResourceLevelVmBillingHistoryResponseModel.md)
 - [ResourceLevelVmGraphBillingDetailsResponseModel](docs/ResourceLevelVmGraphBillingDetailsResponseModel.md)
 - [ResourceLevelVolumeBillingDetailsResponseModel](docs/ResourceLevelVolumeBillingDetailsResponseModel.md)
 - [ResourceLevelVolumeBillingHistoryResponseModel](docs/ResourceLevelVolumeBillingHistoryResponseModel.md)
 - [ResourceLevelVolumeGraphBillingDetailsResponseModel](docs/ResourceLevelVolumeGraphBillingDetailsResponseModel.md)
 - [ResourceObjectResponseForCustomer](docs/ResourceObjectResponseForCustomer.md)
 - [ResponseModel](docs/ResponseModel.md)
 - [RolePermissionFields](docs/RolePermissionFields.md)
 - [RolePolicyFields](docs/RolePolicyFields.md)
 - [SecondaryColor](docs/SecondaryColor.md)
 - [SecurityGroupRule](docs/SecurityGroupRule.md)
 - [SecurityGroupRuleFields](docs/SecurityGroupRuleFields.md)
 - [SecurityRulesFieldsForInstance](docs/SecurityRulesFieldsForInstance.md)
 - [SecurityRulesProtocolFields](docs/SecurityRulesProtocolFields.md)
 - [ServerlessInferencedBillingHistoryDetailsResponseSchema](docs/ServerlessInferencedBillingHistoryDetailsResponseSchema.md)
 - [SnapshotFields](docs/SnapshotFields.md)
 - [SnapshotRestoreRequest](docs/SnapshotRestoreRequest.md)
 - [SnapshotRetrieve](docs/SnapshotRetrieve.md)
 - [SnapshotRetrieveFields](docs/SnapshotRetrieveFields.md)
 - [Snapshots](docs/Snapshots.md)
 - [StartDeployment](docs/StartDeployment.md)
 - [StartDeploymentPayload](docs/StartDeploymentPayload.md)
 - [SubResourceGraphBillingDetailsMetrics](docs/SubResourceGraphBillingDetailsMetrics.md)
 - [SubResourcesCostsResponseModel](docs/SubResourcesCostsResponseModel.md)
 - [SubResourcesGraphBillingHistoryFields](docs/SubResourcesGraphBillingHistoryFields.md)
 - [SubResourcesGraphResponseModel](docs/SubResourcesGraphResponseModel.md)
 - [SubscribeOrUnsubscribeUpdatePayload](docs/SubscribeOrUnsubscribeUpdatePayload.md)
 - [Template](docs/Template.md)
 - [TemplateFields](docs/TemplateFields.md)
 - [Templates](docs/Templates.md)
 - [TokenBasedBillingHistoryResponse](docs/TokenBasedBillingHistoryResponse.md)
 - [URIs](docs/URIs.md)
 - [UpdateEnvironment](docs/UpdateEnvironment.md)
 - [UpdateKeypairName](docs/UpdateKeypairName.md)
 - [UpdateKeypairNameResponse](docs/UpdateKeypairNameResponse.md)
 - [UpdateOrganizationPayload](docs/UpdateOrganizationPayload.md)
 - [UpdateOrganizationResponseModel](docs/UpdateOrganizationResponseModel.md)
 - [UpdateTemplate](docs/UpdateTemplate.md)
 - [UpdateVolumeAttachmentPayload](docs/UpdateVolumeAttachmentPayload.md)
 - [UpdateVolumePayload](docs/UpdateVolumePayload.md)
 - [UpdateVolumeResponse](docs/UpdateVolumeResponse.md)
 - [UserDefaultChoiceForUserFields](docs/UserDefaultChoiceForUserFields.md)
 - [UserDefaultChoicesForUserResponse](docs/UserDefaultChoicesForUserResponse.md)
 - [UserInfoPostPayload](docs/UserInfoPostPayload.md)
 - [UserOrganizationsResponse](docs/UserOrganizationsResponse.md)
 - [UserPermissionFields](docs/UserPermissionFields.md)
 - [UsersInfoFields](docs/UsersInfoFields.md)
 - [UsersInfoListResponse](docs/UsersInfoListResponse.md)
 - [VNCURL](docs/VNCURL.md)
 - [VNCURLFields](docs/VNCURLFields.md)
 - [Volume](docs/Volume.md)
 - [VolumeAttachmentFields](docs/VolumeAttachmentFields.md)
 - [VolumeFields](docs/VolumeFields.md)
 - [VolumeFieldsForInstance](docs/VolumeFieldsForInstance.md)
 - [VolumeOverviewFields](docs/VolumeOverviewFields.md)
 - [VolumeTypes](docs/VolumeTypes.md)
 - [Volumes](docs/Volumes.md)
 - [VolumesFields](docs/VolumesFields.md)
 - [WorkloadBillingHistoryResponse](docs/WorkloadBillingHistoryResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="apiKey"></a>
### apiKey

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


## Author




