# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ..models.instance_environment_fields import InstanceEnvironmentFields
from ..models.instance_flavor_fields import InstanceFlavorFields
from ..models.instance_image_fields import InstanceImageFields
from ..models.instance_keypair_fields import InstanceKeypairFields
from ..models.security_rules_fields_for_instance import SecurityRulesFieldsForInstance
from ..models.volume_attachment_fields import VolumeAttachmentFields
from typing import Optional, Set
from typing_extensions import Self

class InstanceFields(BaseModel):
    """
    InstanceFields
    """ # noqa: E501
    callback_url: Optional[StrictStr] = None
    contract_id: Optional[StrictInt] = None
    created_at: Optional[datetime] = None
    environment: Optional[InstanceEnvironmentFields] = None
    features: Optional[Dict[str, Any]] = None
    fixed_ip: Optional[StrictStr] = None
    flavor: Optional[InstanceFlavorFields] = None
    floating_ip: Optional[StrictStr] = None
    floating_ip_status: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    image: Optional[InstanceImageFields] = None
    keypair: Optional[InstanceKeypairFields] = None
    labels: Optional[List[StrictStr]] = None
    locked: Optional[StrictBool] = None
    name: Optional[StrictStr] = None
    os: Optional[StrictStr] = None
    port_randomization: Optional[StrictBool] = None
    port_randomization_status: Optional[StrictStr] = None
    power_state: Optional[StrictStr] = None
    requires_public_ip: Optional[StrictBool] = None
    security_rules: Optional[List[SecurityRulesFieldsForInstance]] = None
    status: Optional[StrictStr] = None
    vm_state: Optional[StrictStr] = None
    volume_attachments: Optional[List[VolumeAttachmentFields]] = None
    __properties: ClassVar[List[str]] = ["callback_url", "contract_id", "created_at", "environment", "features", "fixed_ip", "flavor", "floating_ip", "floating_ip_status", "id", "image", "keypair", "labels", "locked", "name", "os", "port_randomization", "port_randomization_status", "power_state", "requires_public_ip", "security_rules", "status", "vm_state", "volume_attachments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstanceFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of flavor
        if self.flavor:
            _dict['flavor'] = self.flavor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image
        if self.image:
            _dict['image'] = self.image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of keypair
        if self.keypair:
            _dict['keypair'] = self.keypair.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in security_rules (list)
        _items = []
        if self.security_rules:
            for _item_security_rules in self.security_rules:
                if _item_security_rules:
                    _items.append(_item_security_rules.to_dict())
            _dict['security_rules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in volume_attachments (list)
        _items = []
        if self.volume_attachments:
            for _item_volume_attachments in self.volume_attachments:
                if _item_volume_attachments:
                    _items.append(_item_volume_attachments.to_dict())
            _dict['volume_attachments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstanceFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "callback_url": obj.get("callback_url"),
            "contract_id": obj.get("contract_id"),
            "created_at": obj.get("created_at"),
            "environment": InstanceEnvironmentFields.from_dict(obj["environment"]) if obj.get("environment") is not None else None,
            "features": obj.get("features"),
            "fixed_ip": obj.get("fixed_ip"),
            "flavor": InstanceFlavorFields.from_dict(obj["flavor"]) if obj.get("flavor") is not None else None,
            "floating_ip": obj.get("floating_ip"),
            "floating_ip_status": obj.get("floating_ip_status"),
            "id": obj.get("id"),
            "image": InstanceImageFields.from_dict(obj["image"]) if obj.get("image") is not None else None,
            "keypair": InstanceKeypairFields.from_dict(obj["keypair"]) if obj.get("keypair") is not None else None,
            "labels": obj.get("labels"),
            "locked": obj.get("locked"),
            "name": obj.get("name"),
            "os": obj.get("os"),
            "port_randomization": obj.get("port_randomization"),
            "port_randomization_status": obj.get("port_randomization_status"),
            "power_state": obj.get("power_state"),
            "requires_public_ip": obj.get("requires_public_ip"),
            "security_rules": [SecurityRulesFieldsForInstance.from_dict(_item) for _item in obj["security_rules"]] if obj.get("security_rules") is not None else None,
            "status": obj.get("status"),
            "vm_state": obj.get("vm_state"),
            "volume_attachments": [VolumeAttachmentFields.from_dict(_item) for _item in obj["volume_attachments"]] if obj.get("volume_attachments") is not None else None
        })
        return _obj


