# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PaymentDetailsFields(BaseModel):
    """
    PaymentDetailsFields
    """ # noqa: E501
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    created_at: Optional[datetime] = None
    currency: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    gateway_response: Optional[StrictStr] = None
    invoice: Optional[StrictStr] = None
    paid_from: Optional[StrictStr] = None
    payment_id: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    tax_amount: Optional[Union[StrictFloat, StrictInt]] = None
    transaction_id: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["amount", "created_at", "currency", "description", "gateway_response", "invoice", "paid_from", "payment_id", "status", "tax_amount", "transaction_id", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentDetailsFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentDetailsFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "created_at": obj.get("created_at"),
            "currency": obj.get("currency"),
            "description": obj.get("description"),
            "gateway_response": obj.get("gateway_response"),
            "invoice": obj.get("invoice"),
            "paid_from": obj.get("paid_from"),
            "payment_id": obj.get("payment_id"),
            "status": obj.get("status"),
            "tax_amount": obj.get("tax_amount"),
            "transaction_id": obj.get("transaction_id"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


