# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from ..models.create_security_rule_payload import CreateSecurityRulePayload
from ..models.flavor_object_fields import FlavorObjectFields
from ..models.profile_object_fields import ProfileObjectFields
from typing import Optional, Set
from typing_extensions import Self

class CreateInstancesPayload(BaseModel):
    """
    CreateInstancesPayload
    """ # noqa: E501
    assign_floating_ip: Optional[StrictBool] = Field(default=None, description="When this field is set to `true`, it attaches a [public IP address](https://docs...cloud/docs/api-reference/core-resources/virtual-machines/floating-ip/) to the virtual machine, enabling internet accessibility.")
    callback_url: Optional[Annotated[str, Field(strict=True, max_length=250)]] = Field(default=None, description="An optional URL where actions performed on the virtual machine will be sent. For additional information on event callbacks, [**click here**](https://docs...cloud/docs/api-reference/core-resources/virtual-machines/callbacks-vms/).")
    count: StrictInt = Field(description="The number of virtual machines to be created.")
    create_bootable_volume: Optional[StrictBool] = Field(default=None, description="Indicates whether to create a bootable volume for the virtual machine. When set to `true`, a bootable volume will be created; the default value is `false`.")
    enable_port_randomization: Optional[StrictBool] = Field(default=True, description="Indicates whether to enable port randomization.This setting is only effective if 'assign_floating_ip' is true. Defaults to true.")
    environment_name: StrictStr = Field(description="The name of the [environment](https://docs...cloud/docs/api-reference/core-resources/environments/) in which the virtual machine is to be created.")
    flavor: Optional[FlavorObjectFields] = None
    flavor_name: StrictStr = Field(description="The name of the GPU hardware configuration ([flavor](https://docs...cloud/docs/hardware/flavors)) for the virtual machines being created.")
    image_name: Optional[StrictStr] = Field(default=None, description="The [operating system (OS) image](https://docs...cloud/docs/virtual-machines/images) name designated for installation on the virtual machine.It also accepts custom, private images, created from [existing snapshots](https://docs.hyperstack.cloud/docs/virtual-machines/custom-images).")
    key_name: StrictStr = Field(description="The name of the existing SSH key pair to be used for secure access to the virtual machine. For additional information on SSH key pairs, [**click here**](https://docs...cloud/docs/api-reference/core-resources/keypairs/).")
    labels: Optional[List[StrictStr]] = None
    name: Annotated[str, Field(strict=True, max_length=50)] = Field(description="The name of the virtual machine being created.")
    profile: Optional[ProfileObjectFields] = None
    security_rules: Optional[List[CreateSecurityRulePayload]] = None
    user_data: Optional[StrictStr] = Field(default=None, description="Optional initialization configuration commands to manage the configuration of a virtual machine at launch using cloud-init scripts. For more information about custom VM configuration using cloud-init, [**click here**](https://docs...cloud/docs/virtual-machines/initialization-configuration).")
    volume_name: Optional[StrictStr] = Field(default=None, description="The names of the volume(s) to be attached to the virtual machine being created.")
    __properties: ClassVar[List[str]] = ["assign_floating_ip", "callback_url", "count", "create_bootable_volume", "enable_port_randomization", "environment_name", "flavor", "flavor_name", "image_name", "key_name", "labels", "name", "profile", "security_rules", "user_data", "volume_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInstancesPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of flavor
        if self.flavor:
            _dict['flavor'] = self.flavor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profile
        if self.profile:
            _dict['profile'] = self.profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in security_rules (list)
        _items = []
        if self.security_rules:
            for _item_security_rules in self.security_rules:
                if _item_security_rules:
                    _items.append(_item_security_rules.to_dict())
            _dict['security_rules'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInstancesPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assign_floating_ip": obj.get("assign_floating_ip"),
            "callback_url": obj.get("callback_url"),
            "count": obj.get("count"),
            "create_bootable_volume": obj.get("create_bootable_volume"),
            "enable_port_randomization": obj.get("enable_port_randomization") if obj.get("enable_port_randomization") is not None else True,
            "environment_name": obj.get("environment_name"),
            "flavor": FlavorObjectFields.from_dict(obj["flavor"]) if obj.get("flavor") is not None else None,
            "flavor_name": obj.get("flavor_name"),
            "image_name": obj.get("image_name"),
            "key_name": obj.get("key_name"),
            "labels": obj.get("labels"),
            "name": obj.get("name"),
            "profile": ProfileObjectFields.from_dict(obj["profile"]) if obj.get("profile") is not None else None,
            "security_rules": [CreateSecurityRulePayload.from_dict(_item) for _item in obj["security_rules"]] if obj.get("security_rules") is not None else None,
            "user_data": obj.get("user_data"),
            "volume_name": obj.get("volume_name")
        })
        return _obj


