# hyperstack
Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources. 

Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.

To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: v1.46.4-alpha
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/NexGenCloud/hyperstack-sdk-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/NexGenCloud/hyperstack-sdk-python.git`)

Then import the package:
```python
import hyperstack
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import hyperstack
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import hyperstack
from hyperstack.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://infrahub-api.nexgencloud.com/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = hyperstack.Configuration(
    host = "https://infrahub-api.nexgencloud.com/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: apiKey
configuration.api_key['apiKey'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['apiKey'] = 'Bearer'


# Enter a context with an instance of the API client
with hyperstack.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = hyperstack.AccessKeysApi(api_client)
    body = hyperstack.ObjectStorageAccessKeyCreateRequest() # ObjectStorageAccessKeyCreateRequest |  (optional)

    try:
        # Generate a new access key
        api_response = api_instance.create_access_key_endpoint(body=body)
        print("The response of AccessKeysApi->create_access_key_endpoint:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccessKeysApi->create_access_key_endpoint: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://infrahub-api.nexgencloud.com/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessKeysApi* | [**create_access_key_endpoint**](docs/AccessKeysApi.md#create_access_key_endpoint) | **POST** /object-storage/access-keys | Generate a new access key
*AccessKeysApi* | [**delete_access_key_endpoint**](docs/AccessKeysApi.md#delete_access_key_endpoint) | **DELETE** /object-storage/access-keys/{access_key_id} | Remove an existing access key
*AccessKeysApi* | [**list_access_keys_endpoint**](docs/AccessKeysApi.md#list_access_keys_endpoint) | **GET** /object-storage/access-keys | List access keys
*BucketsApi* | [**delete_bucket_endpoint**](docs/BucketsApi.md#delete_bucket_endpoint) | **DELETE** /object-storage/buckets/{bucket_name} | Delete a bucket
*BucketsApi* | [**list_buckets_endpoint**](docs/BucketsApi.md#list_buckets_endpoint) | **GET** /object-storage/buckets | List buckets
*BucketsApi* | [**retrieve_bucket_endpoint**](docs/BucketsApi.md#retrieve_bucket_endpoint) | **GET** /object-storage/buckets/{bucket_name} | Retrieve a bucket
*CalculateApi* | [**calculate_resource_billing_rate**](docs/CalculateApi.md#calculate_resource_billing_rate) | **GET** /pricebook/calculate/resource/{resource_type}/{id} | Retrieve Billing Rate for Resource
*CustomerContractApi* | [**get_contract_gpu_allocation_graph**](docs/CustomerContractApi.md#get_contract_gpu_allocation_graph) | **GET** /pricebook/contracts/{contract_id}/gpu_allocation_graph | Retrieve GPU Allocation Graph for Contract
*CustomerContractApi* | [**list_customer_contracts**](docs/CustomerContractApi.md#list_customer_contracts) | **GET** /pricebook/contracts | List Contracts
*CustomerContractApi* | [**retrieve_contract**](docs/CustomerContractApi.md#retrieve_contract) | **GET** /pricebook/contracts/{contract_id} | Retrieve Contract Details
*FIPExclusionsApi* | [**check_if_org_is_excluded_from_floating_ip_detachment**](docs/FIPExclusionsApi.md#check_if_org_is_excluded_from_floating_ip_detachment) | **GET** /core/fip-detachment-exclusions/org/{org_id} | 
*HealthApi* | [**healthz_endpoint**](docs/HealthApi.md#healthz_endpoint) | **GET** /object-storage/healthz | Healthcheck
*PricebookApi* | [**get_pricebook**](docs/PricebookApi.md#get_pricebook) | **GET** /pricebook | 
*RegionsApi* | [**list_regions_endpoint**](docs/RegionsApi.md#list_regions_endpoint) | **GET** /object-storage/regions | Get a list of supported regions
*SnapshotsApi* | [**create_custom_image**](docs/SnapshotsApi.md#create_custom_image) | **POST** /core/snapshots/{snapshot_id}/image | Create an image from a snapshot
*SnapshotsApi* | [**delete_snapshot**](docs/SnapshotsApi.md#delete_snapshot) | **DELETE** /core/snapshots/{id} | Delete snapshot
*SnapshotsApi* | [**fetch_snapshot_name_availability**](docs/SnapshotsApi.md#fetch_snapshot_name_availability) | **GET** /core/snapshots/name-availability/{name} | Fetch snapshot name availability
*SnapshotsApi* | [**get_snapshot**](docs/SnapshotsApi.md#get_snapshot) | **GET** /core/snapshots/{id} | Retrieve a snapshot
*SnapshotsApi* | [**list_snapshots**](docs/SnapshotsApi.md#list_snapshots) | **GET** /core/snapshots | Retrieve list of snapshots with pagination
*SnapshotsApi* | [**restore_snapshot**](docs/SnapshotsApi.md#restore_snapshot) | **POST** /core/snapshots/{id}/restore | Restore a snapshot
*AliveApi* | [**get_alive**](docs/AliveApi.md#get_alive) | **GET** /billing/alive | GET: Alive
*AliveApi* | [**get_alive_doc**](docs/AliveApi.md#get_alive_doc) | **GET** /billing/alive/doc | 
*ApiKeyApi* | [**delete_api_key**](docs/ApiKeyApi.md#delete_api_key) | **DELETE** /api-key/{api_key_id} | Delete API Key
*ApiKeyApi* | [**generate_api_key**](docs/ApiKeyApi.md#generate_api_key) | **POST** /api-key/generate | Generate API Key
*ApiKeyApi* | [**get_api_key**](docs/ApiKeyApi.md#get_api_key) | **GET** /api-key | Retrieve API Keys
*ApiKeyApi* | [**update_api_key**](docs/ApiKeyApi.md#update_api_key) | **PUT** /api-key/{api_key_id} | Update API Key
*AssigningMemberRoleApi* | [**assign_rbac_role_to_user**](docs/AssigningMemberRoleApi.md#assign_rbac_role_to_user) | **PUT** /auth/users/{user_id}/assign-roles | Assign RBAC Role
*AssigningMemberRoleApi* | [**remove_rbac_role_from_user**](docs/AssigningMemberRoleApi.md#remove_rbac_role_from_user) | **DELETE** /auth/users/{user_id}/roles | Remove RBAC Role From User
*AuthApi* | [**change_organization_for_token**](docs/AuthApi.md#change_organization_for_token) | **GET** /auth/token/change-org/{org_id} | 
*AuthApi* | [**disable_mfa**](docs/AuthApi.md#disable_mfa) | **GET** /auth/me/mfa/disable | 
*AuthApi* | [**get_user_mfa_status**](docs/AuthApi.md#get_user_mfa_status) | **GET** /auth/me/mfa | Get MFA status for authenticated user
*AuthApi* | [**get_user_organizations**](docs/AuthApi.md#get_user_organizations) | **GET** /auth/me/organizations | Get User Organizations
*AuthApi* | [**retrieve_authenticated_user_details**](docs/AuthApi.md#retrieve_authenticated_user_details) | **GET** /auth/me | Retrieve Authenticated User Details
*BetaAccessApi* | [**create_beta_access_request**](docs/BetaAccessApi.md#create_beta_access_request) | **POST** /auth/beta-access/requests | Create a new beta access request
*BetaAccessApi* | [**get_beta_access_requests**](docs/BetaAccessApi.md#get_beta_access_requests) | **GET** /auth/beta-access/requests/{program} | Check the status of beta access requests
*BetaAccessApi* | [**get_beta_access_status**](docs/BetaAccessApi.md#get_beta_access_status) | **GET** /auth/beta-access/requests | Check the status of all beta access requests
*BillingApi* | [**buckets_billing_history_hourly_chart**](docs/BillingApi.md#buckets_billing_history_hourly_chart) | **GET** /billing/billing/history/bucket/{bucket_id}/graph | Retrieve hourly cost datapoints of a Specific Bucket for a specific billing cycle
*BillingApi* | [**get_bucket_billing_history**](docs/BillingApi.md#get_bucket_billing_history) | **GET** /billing/billing/history/bucket/{bucket_id} | Retrieve Billing History of a Specific Snapshot for a specific Billing Cycle
*BillingApi* | [**get_cluster_billing_history**](docs/BillingApi.md#get_cluster_billing_history) | **GET** /billing/billing/history/cluster/{cluster_id} | Retrieve Billing History of a Specific Cluster for a specific Billing Cycle
*BillingApi* | [**get_cluster_billing_history_graph**](docs/BillingApi.md#get_cluster_billing_history_graph) | **GET** /billing/billing/history/cluster/{cluster_id}/graph | Retrieve hourly cost datapoints of a specific Cluster for a specific billing cycle
*BillingApi* | [**get_data_synthesis_billing_history**](docs/BillingApi.md#get_data_synthesis_billing_history) | **GET** /billing/billing/history/data_synthesis | Retrieve Billing History of data synthesis for a specific Billing Cycle
*BillingApi* | [**get_data_synthesis_billing_history_graph**](docs/BillingApi.md#get_data_synthesis_billing_history_graph) | **GET** /billing/billing/history/data_synthesis/{resource_id}/graph | Retrieve hourly cost datapoints of a Specific Data Synthesis for a specific
*BillingApi* | [**get_data_synthesis_history_for_resource**](docs/BillingApi.md#get_data_synthesis_history_for_resource) | **GET** /billing/billing/history/data_synthesis/{resource_id} | 
*BillingApi* | [**get_fine_tuning_billing_history**](docs/BillingApi.md#get_fine_tuning_billing_history) | **GET** /billing/billing/history/fine_tuning | Retrieve Billing History of model evaluation for a specific Billing Cycle
*BillingApi* | [**get_fine_tuning_billing_history_graph**](docs/BillingApi.md#get_fine_tuning_billing_history_graph) | **GET** /billing/billing/history/fine_tuning/{resource_id}/graph | Retrieve hourly cost datapoints of a Specific Fine Tuning for a specific billing cycle
*BillingApi* | [**get_last_day_cost**](docs/BillingApi.md#get_last_day_cost) | **GET** /billing/billing/last-day-cost | GET: Last Day Cost
*BillingApi* | [**get_model_evaluation_billing_history**](docs/BillingApi.md#get_model_evaluation_billing_history) | **GET** /billing/billing/history/model_evaluation | Retrieve Billing History of model evaluation for a specific Billing Cycle
*BillingApi* | [**get_model_evaluation_billing_history_graph**](docs/BillingApi.md#get_model_evaluation_billing_history_graph) | **GET** /billing/billing/history/model_evaluation/{resource_id}/graph | Retrieve hourly cost datapoints of a Specific Model Evaluation for a specific
*BillingApi* | [**get_notification_threshold**](docs/BillingApi.md#get_notification_threshold) | **PUT** /billing/billing/threshold/{threshold_id} | Update: Subscribe or Unsubscribe Notification Threshold
*BillingApi* | [**get_resource_fine_tuning_billing_history**](docs/BillingApi.md#get_resource_fine_tuning_billing_history) | **GET** /billing/billing/history/fine_tuning/{resource_id} | Retrieve Billing History of a Specific Fine Tuning for a specific Billing Cycle
*BillingApi* | [**get_resource_model_evaluation_billing_history**](docs/BillingApi.md#get_resource_model_evaluation_billing_history) | **GET** /billing/billing/history/model_evaluation/{resource_id} | 
*BillingApi* | [**get_serverless_inference_billing_history_graph**](docs/BillingApi.md#get_serverless_inference_billing_history_graph) | **GET** /billing/billing/history/serverless_inference/{resource_id}/graph | Retrieve hourly cost datapoints of a Specific Serverless Inference for a specific
*BillingApi* | [**get_serverless_inferences_billing_history**](docs/BillingApi.md#get_serverless_inferences_billing_history) | **GET** /billing/billing/history/serverless_inference/{resource_id} | 
*BillingApi* | [**get_snapshot_billing_history**](docs/BillingApi.md#get_snapshot_billing_history) | **GET** /billing/billing/history/snapshot/{snapshot_id} | Retrieve Billing History of a Specific Snapshot for a specific Billing Cycle
*BillingApi* | [**get_snapshot_billing_history_graph**](docs/BillingApi.md#get_snapshot_billing_history_graph) | **GET** /billing/billing/history/snapshot/{snapshot_id}/graph | Retrieve hourly cost datapoints of a Specific Snapshot for a specific billing cycle
*BillingApi* | [**get_usage**](docs/BillingApi.md#get_usage) | **GET** /billing/billing/usage | GET: Billing usage
*BillingApi* | [**get_user_billing_history**](docs/BillingApi.md#get_user_billing_history) | **GET** /billing/billing/history | Retrieve Billing History for a specific Billing Cycle
*BillingApi* | [**get_vm_billing_details**](docs/BillingApi.md#get_vm_billing_details) | **GET** /billing/billing/history/virtual-machine/{vm_id} | Retrieve Billing History of a Specific Virtual Machine for a specific Billing Cycle
*BillingApi* | [**get_vm_billing_events**](docs/BillingApi.md#get_vm_billing_events) | **GET** /billing/billing/virtual-machine/{vm_id}/billing-events | Retrieve VM billing events history
*BillingApi* | [**get_vm_billing_graph**](docs/BillingApi.md#get_vm_billing_graph) | **GET** /billing/billing/history/virtual-machine/{vm_id}/graph | Retrieve hourly cost datapoints of a Specific Virtual Machine for a specific billing cycle
*BillingApi* | [**get_vm_billing_history**](docs/BillingApi.md#get_vm_billing_history) | **GET** /billing/billing/history/virtual-machine | Retrieve Billing History of Virtual Machine for a specific Billing Cycle
*BillingApi* | [**get_vm_sub_resource_costs**](docs/BillingApi.md#get_vm_sub_resource_costs) | **GET** /billing/billing/virtual-machine/{vm_id}/sub-resource | Retrieve Total Costs and Non Discount Costs for Sub Resources
*BillingApi* | [**get_vm_sub_resource_graph**](docs/BillingApi.md#get_vm_sub_resource_graph) | **GET** /billing/billing/virtual-machine/{vm_id}/sub-resource/graph | Retrieve Sub-Resources Historical Cost datapoints of a Virtual
*BillingApi* | [**get_volume_billing_details**](docs/BillingApi.md#get_volume_billing_details) | **GET** /billing/billing/history/volume/{volume_id} | Retrieve Billing History of a Specific Volume for a specific Billing Cycle
*BillingApi* | [**get_volume_billing_events**](docs/BillingApi.md#get_volume_billing_events) | **GET** /billing/billing/volume/{volume_id}/billing-events | Retrieve Volume billing events history
*BillingApi* | [**get_volume_billing_history**](docs/BillingApi.md#get_volume_billing_history) | **GET** /billing/billing/history/volume | Retrieve Billing History of Volume for a specific Billing Cycle
*BillingApi* | [**get_volume_billing_history_graph**](docs/BillingApi.md#get_volume_billing_history_graph) | **GET** /billing/billing/history/volume/{volume_id}/graph | Retrieve hourly cost datapoints of a Specific Volume for a specific billing cycle
*BillingApi* | [**list_billing_contract_history**](docs/BillingApi.md#list_billing_contract_history) | **GET** /billing/billing/history/contract | Retrieve Billing History of Contract for a specific Billing Cycle
*BillingApi* | [**list_bucket_billing_history**](docs/BillingApi.md#list_bucket_billing_history) | **GET** /billing/billing/history/bucket | Retrieve Billing History of a Bucket for a specific Billing Cycle
*BillingApi* | [**list_clusters_billing_history**](docs/BillingApi.md#list_clusters_billing_history) | **GET** /billing/billing/history/cluster | Retrieve Billing History of Clusters for a specific Billing Cycle
*BillingApi* | [**list_org_notification_thresholds**](docs/BillingApi.md#list_org_notification_thresholds) | **GET** /billing/billing/threshold | GET: All Thresholds for Organization
*BillingApi* | [**list_serverless_inference_billing_history**](docs/BillingApi.md#list_serverless_inference_billing_history) | **GET** /billing/billing/history/serverless_inference | Retrieve Billing History of serverless inference for a specific Billing Cycle
*BillingApi* | [**list_snapshot_billing_history**](docs/BillingApi.md#list_snapshot_billing_history) | **GET** /billing/billing/history/snapshot | Retrieve Billing History of Snapshot for a specific Billing Cycle
*CallbacksApi* | [**attach_callback_to_vm**](docs/CallbacksApi.md#attach_callback_to_vm) | **POST** /core/virtual-machines/{vm_id}/attach-callback | Attach callback to virtual machine
*CallbacksApi* | [**attach_callback_to_volume**](docs/CallbacksApi.md#attach_callback_to_volume) | **POST** /core/volumes/{volume_id}/attach-callback | Attach callback to volume
*CallbacksApi* | [**delete_vm_callback**](docs/CallbacksApi.md#delete_vm_callback) | **DELETE** /core/virtual-machines/{vm_id}/delete-callback | Delete virtual machine callback
*CallbacksApi* | [**delete_volume_callback**](docs/CallbacksApi.md#delete_volume_callback) | **DELETE** /core/volumes/{volume_id}/delete-callback | Delete volume callback
*CallbacksApi* | [**update_vm_callback**](docs/CallbacksApi.md#update_vm_callback) | **PUT** /core/virtual-machines/{vm_id}/update-callback | Update virtual machine callback
*CallbacksApi* | [**update_volume_callback**](docs/CallbacksApi.md#update_volume_callback) | **PUT** /core/volumes/{volume_id}/update-callback | Update volume callback
*ClusterEventsApi* | [**list_cluster_events**](docs/ClusterEventsApi.md#list_cluster_events) | **GET** /core/clusters/{cluster_id}/events | Fetch all of a cluster events
*ClustersApi* | [**create_cluster**](docs/ClustersApi.md#create_cluster) | **POST** /core/clusters | Create Cluster
*ClustersApi* | [**create_node**](docs/ClustersApi.md#create_node) | **POST** /core/clusters/{cluster_id}/nodes | Create Node
*ClustersApi* | [**create_node_group**](docs/ClustersApi.md#create_node_group) | **POST** /core/clusters/{cluster_id}/node-groups | Create a node group in a cluster
*ClustersApi* | [**delete_cluster**](docs/ClustersApi.md#delete_cluster) | **DELETE** /core/clusters/{id} | Delete a cluster
*ClustersApi* | [**delete_cluster_node**](docs/ClustersApi.md#delete_cluster_node) | **DELETE** /core/clusters/{cluster_id}/nodes/{node_id} | Delete Cluster Node
*ClustersApi* | [**delete_cluster_nodes**](docs/ClustersApi.md#delete_cluster_nodes) | **POST** /core/clusters/{cluster_id}/nodes/delete | Delete Multiple Cluster Nodes
*ClustersApi* | [**delete_node_group**](docs/ClustersApi.md#delete_node_group) | **DELETE** /core/clusters/{cluster_id}/node-groups/{node_group_id} | Delete a node group
*ClustersApi* | [**fetch_cluster_name_availability**](docs/ClustersApi.md#fetch_cluster_name_availability) | **GET** /core/clusters/name-availability/{name} | Fetch cluster name availability
*ClustersApi* | [**get_cluster_master_flavors**](docs/ClustersApi.md#get_cluster_master_flavors) | **GET** /core/clusters/master-flavors | Get Cluster Master Flavors
*ClustersApi* | [**get_cluster_nodes**](docs/ClustersApi.md#get_cluster_nodes) | **GET** /core/clusters/{cluster_id}/nodes | Get Cluster Nodes
*ClustersApi* | [**get_cluster_versions**](docs/ClustersApi.md#get_cluster_versions) | **GET** /core/clusters/versions | List Cluster Versions
*ClustersApi* | [**get_node_group**](docs/ClustersApi.md#get_node_group) | **GET** /core/clusters/{cluster_id}/node-groups/{node_group_id} | Retrieve a node group in a cluster
*ClustersApi* | [**getting_cluster_detail**](docs/ClustersApi.md#getting_cluster_detail) | **GET** /core/clusters/{id} | Getting Cluster Detail
*ClustersApi* | [**list_clusters**](docs/ClustersApi.md#list_clusters) | **GET** /core/clusters | List Clusters
*ClustersApi* | [**list_node_groups**](docs/ClustersApi.md#list_node_groups) | **GET** /core/clusters/{cluster_id}/node-groups | List node groups for a cluster
*ClustersApi* | [**reconcile_cluster**](docs/ClustersApi.md#reconcile_cluster) | **POST** /core/clusters/{cluster_id}/reconcile | Reconcile a cluster
*ClustersApi* | [**update_node_group**](docs/ClustersApi.md#update_node_group) | **PATCH** /core/clusters/{cluster_id}/node-groups/{node_group_id} | Update a node group in a cluster
*ComplianceApi* | [**create_compliance**](docs/ComplianceApi.md#create_compliance) | **POST** /core/compliance | Create compliance
*ComplianceApi* | [**delete_compliance**](docs/ComplianceApi.md#delete_compliance) | **DELETE** /core/compliance/{gpu_model} | Delete a compliance
*ComplianceApi* | [**get_compliance**](docs/ComplianceApi.md#get_compliance) | **GET** /core/compliance | Retrieve GPU compliance
*ComplianceApi* | [**update_compliance**](docs/ComplianceApi.md#update_compliance) | **PUT** /core/compliance | Update a compliance
*CreditApi* | [**get_user_credit**](docs/CreditApi.md#get_user_credit) | **GET** /billing/user-credit/credit | GET: View credit and threshold
*DashboardApi* | [**get_dashboard**](docs/DashboardApi.md#get_dashboard) | **GET** /core/dashboard | Retrieve Dashboard
*DeploymentApi* | [**delete_deployment**](docs/DeploymentApi.md#delete_deployment) | **DELETE** /core/marketplace/deployments/{id} | Delete Deployment
*DeploymentApi* | [**get_deployment**](docs/DeploymentApi.md#get_deployment) | **GET** /core/marketplace/deployments/{id} | Details of Deployment by ID
*DeploymentApi* | [**list_deployments**](docs/DeploymentApi.md#list_deployments) | **GET** /core/marketplace/deployments | List Deployments
*DeploymentApi* | [**start_deployment**](docs/DeploymentApi.md#start_deployment) | **POST** /core/marketplace/deployments | Start Deployment
*EnvironmentApi* | [**create_environment**](docs/EnvironmentApi.md#create_environment) | **POST** /core/environments | Create environment
*EnvironmentApi* | [**delete_environment**](docs/EnvironmentApi.md#delete_environment) | **DELETE** /core/environments/{id} | Delete environment
*EnvironmentApi* | [**fetch_environment_name_availability**](docs/EnvironmentApi.md#fetch_environment_name_availability) | **GET** /core/environments/name-availability/{name} | Fetch environment name availability
*EnvironmentApi* | [**get_environment**](docs/EnvironmentApi.md#get_environment) | **GET** /core/environments/{id} | Retrieve environment
*EnvironmentApi* | [**list_environments**](docs/EnvironmentApi.md#list_environments) | **GET** /core/environments | List environments
*EnvironmentApi* | [**update_environment**](docs/EnvironmentApi.md#update_environment) | **PUT** /core/environments/{id} | Update environment
*FirewallAttachmentApi* | [**attach_firewall_to_vms**](docs/FirewallAttachmentApi.md#attach_firewall_to_vms) | **POST** /core/firewalls/{firewall_id}/update-attachments | Attach Firewalls to VMs
*FirewallsApi* | [**add_rule_to_firewall**](docs/FirewallsApi.md#add_rule_to_firewall) | **POST** /core/firewalls/{firewall_id}/firewall-rules | Add firewall rule to firewall
*FirewallsApi* | [**create_firewall**](docs/FirewallsApi.md#create_firewall) | **POST** /core/firewalls | Create firewall
*FirewallsApi* | [**delete_existing_firewall**](docs/FirewallsApi.md#delete_existing_firewall) | **DELETE** /core/firewalls/{id} | Delete firewall
*FirewallsApi* | [**delete_rule_from_firewall**](docs/FirewallsApi.md#delete_rule_from_firewall) | **DELETE** /core/firewalls/{firewall_id}/firewall-rules/{firewall_rule_id} | Delete firewall rules from firewall
*FirewallsApi* | [**get_firewall**](docs/FirewallsApi.md#get_firewall) | **GET** /core/firewalls/{id} | Retrieve firewall details
*FirewallsApi* | [**list_existing_firewalls**](docs/FirewallsApi.md#list_existing_firewalls) | **GET** /core/firewalls | List firewalls
*FlavorApi* | [**list_flavors**](docs/FlavorApi.md#list_flavors) | **GET** /core/flavors | List Flavors
*FloatingIpApi* | [**attach_public_ipto_vm**](docs/FloatingIpApi.md#attach_public_ipto_vm) | **POST** /core/virtual-machines/{vm_id}/attach-floatingip | Attach public IP to virtual machine
*FloatingIpApi* | [**detach_public_ip_from_vm**](docs/FloatingIpApi.md#detach_public_ip_from_vm) | **POST** /core/virtual-machines/{vm_id}/detach-floatingip | Detach public IP from virtual machine
*GpuApi* | [**list_gpus**](docs/GpuApi.md#list_gpus) | **GET** /core/gpus | List GPUs
*ImageApi* | [**delete_image**](docs/ImageApi.md#delete_image) | **DELETE** /core/images/{id} | Delete an image
*ImageApi* | [**fetch_image_name_availability**](docs/ImageApi.md#fetch_image_name_availability) | **GET** /core/image/name-availability/{name} | Fetch name availability for Images
*ImageApi* | [**get_image**](docs/ImageApi.md#get_image) | **GET** /core/images/{id} | Get Private Image Details
*ImageApi* | [**list_images**](docs/ImageApi.md#list_images) | **GET** /core/images | List Images
*InviteApi* | [**accept_invite**](docs/InviteApi.md#accept_invite) | **GET** /auth/invites/{id}/accept | Accept Invite
*InviteApi* | [**delete_invite**](docs/InviteApi.md#delete_invite) | **DELETE** /auth/invites/{id} | Accept Invite
*InviteApi* | [**invite_user_to_organization**](docs/InviteApi.md#invite_user_to_organization) | **POST** /auth/invites | Invite User to Organization
*InviteApi* | [**list_invites**](docs/InviteApi.md#list_invites) | **GET** /auth/invites | List Invites
*KeypairApi* | [**delete_key_pair**](docs/KeypairApi.md#delete_key_pair) | **DELETE** /core/keypair/{id} | Delete key pair
*KeypairApi* | [**import_key_pair**](docs/KeypairApi.md#import_key_pair) | **POST** /core/keypairs | Import key pair
*KeypairApi* | [**list_key_pairs**](docs/KeypairApi.md#list_key_pairs) | **GET** /core/keypairs | List key pairs
*KeypairApi* | [**update_key_pair_name**](docs/KeypairApi.md#update_key_pair_name) | **PUT** /core/keypair/{id} | Update key pair name
*OrganizationApi* | [**remove_organization_member**](docs/OrganizationApi.md#remove_organization_member) | **POST** /auth/organizations/remove-member | Remove Organization Member
*OrganizationApi* | [**retrieve_organization_information**](docs/OrganizationApi.md#retrieve_organization_information) | **GET** /auth/organizations | Retrieve Organization Information
*OrganizationApi* | [**update_organization_information**](docs/OrganizationApi.md#update_organization_information) | **PUT** /auth/organizations/update | Update Organization Information
*PartnerConfigApi* | [**get_partner_config**](docs/PartnerConfigApi.md#get_partner_config) | **GET** /auth/partner-config | Get partner config
*PartnerConfigApi* | [**get_partner_config_by_domain**](docs/PartnerConfigApi.md#get_partner_config_by_domain) | **GET** /auth/partner-config/docs | 
*PaymentApi* | [**get_payment_receipt**](docs/PaymentApi.md#get_payment_receipt) | **GET** /billing/payment/receipt/{payment_id} | Retrieve Payment Receipt
*PaymentApi* | [**initiate_payment**](docs/PaymentApi.md#initiate_payment) | **POST** /billing/payment/payment-initiate | POST: Initiate payment
*PaymentApi* | [**list_payment_details**](docs/PaymentApi.md#list_payment_details) | **GET** /billing/payment/payment-details | GET: View payment details
*PermissionApi* | [**list_permissions**](docs/PermissionApi.md#list_permissions) | **GET** /auth/permissions | List Permissions
*PolicyApi* | [**list_policies**](docs/PolicyApi.md#list_policies) | **GET** /auth/policies | List Policies
*ProfileApi* | [**create_profile**](docs/ProfileApi.md#create_profile) | **POST** /core/profiles | Create profile
*ProfileApi* | [**delete_profile**](docs/ProfileApi.md#delete_profile) | **DELETE** /core/profiles/{id} | Delete profile
*ProfileApi* | [**get_profile**](docs/ProfileApi.md#get_profile) | **GET** /core/profiles/{id} | Retrieve profile details
*ProfileApi* | [**list_profiles**](docs/ProfileApi.md#list_profiles) | **GET** /core/profiles | List profiles
*RbacRoleApi* | [**create_rbac_role**](docs/RbacRoleApi.md#create_rbac_role) | **POST** /auth/roles | Create RBAC Role
*RbacRoleApi* | [**delete_rbac_role**](docs/RbacRoleApi.md#delete_rbac_role) | **DELETE** /auth/roles/{id} | Delete RBAC Role
*RbacRoleApi* | [**list_rbac_roles**](docs/RbacRoleApi.md#list_rbac_roles) | **GET** /auth/roles | List RBAC Roles
*RbacRoleApi* | [**retrieve_rbac_role_details**](docs/RbacRoleApi.md#retrieve_rbac_role_details) | **GET** /auth/roles/{id} | Retrieve RBAC Role Details
*RbacRoleApi* | [**update_rbac_role**](docs/RbacRoleApi.md#update_rbac_role) | **PUT** /auth/roles/{id} | Update RBAC Role
*RegionApi* | [**list_regions**](docs/RegionApi.md#list_regions) | **GET** /core/regions | List Regions
*SecurityRulesApi* | [**list_firewall_rule_protocols**](docs/SecurityRulesApi.md#list_firewall_rule_protocols) | **GET** /core/sg-rules-protocols | List firewall rule protocols
*SnapshotEventsApi* | [**list_snapshot_events**](docs/SnapshotEventsApi.md#list_snapshot_events) | **GET** /core/snapshots/{snapshot_id}/events | Fetch all events for a snapshot
*StockApi* | [**get_gpu_stock**](docs/StockApi.md#get_gpu_stock) | **GET** /core/stocks | Retrieve GPU stocks
*TemplateApi* | [**create_template**](docs/TemplateApi.md#create_template) | **POST** /core/marketplace/templates | Create template
*TemplateApi* | [**delete_template**](docs/TemplateApi.md#delete_template) | **DELETE** /core/marketplace/templates/{id} | Delete template
*TemplateApi* | [**get_template**](docs/TemplateApi.md#get_template) | **GET** /core/marketplace/templates/{id} | Retrieve template details
*TemplateApi* | [**list_templates**](docs/TemplateApi.md#list_templates) | **GET** /core/marketplace/templates | List templates
*TemplateApi* | [**update_template**](docs/TemplateApi.md#update_template) | **PUT** /core/marketplace/templates/{id} | Update template
*UserApi* | [**add_user_billing_info**](docs/UserApi.md#add_user_billing_info) | **POST** /billing/user/info | POST: Insert billing info
*UserApi* | [**get_user_billing_info**](docs/UserApi.md#get_user_billing_info) | **GET** /billing/user/info | GET: Retrieve billing info
*UserApi* | [**update_user_billing_info**](docs/UserApi.md#update_user_billing_info) | **PUT** /billing/user/info | PUT: Update billing info
*UserDetailChoiceApi* | [**list_default_flavors_and_images**](docs/UserDetailChoiceApi.md#list_default_flavors_and_images) | **GET** /core/user/resources/defaults | Retrieve Default Flavors and Images
*UserPermissionApi* | [**list_my_user_permissions**](docs/UserPermissionApi.md#list_my_user_permissions) | **GET** /auth/users/me/permissions | List My User Permissions
*UserPermissionApi* | [**list_user_permissions**](docs/UserPermissionApi.md#list_user_permissions) | **GET** /auth/users/{id}/permissions | List User Permissions
*VirtualMachineApi* | [**add_vm_label**](docs/VirtualMachineApi.md#add_vm_label) | **PUT** /core/virtual-machines/{vm_id}/label | Edit virtual machine labels
*VirtualMachineApi* | [**attach_firewalls_to_vm**](docs/VirtualMachineApi.md#attach_firewalls_to_vm) | **POST** /core/virtual-machines/{vm_id}/attach-firewalls | Attach firewalls to a virtual machine
*VirtualMachineApi* | [**check_vm_name_availability**](docs/VirtualMachineApi.md#check_vm_name_availability) | **GET** /core/virtual-machines/name-availability/{name} | Fetch virtual machine name availability
*VirtualMachineApi* | [**create_firewall_rule_for_vm**](docs/VirtualMachineApi.md#create_firewall_rule_for_vm) | **POST** /core/virtual-machines/{vm_id}/sg-rules | Add firewall rule to virtual machine
*VirtualMachineApi* | [**create_snapshot_for_vm**](docs/VirtualMachineApi.md#create_snapshot_for_vm) | **POST** /core/virtual-machines/{vm_id}/snapshots | Create snapshot from a virtual machine
*VirtualMachineApi* | [**create_vms**](docs/VirtualMachineApi.md#create_vms) | **POST** /core/virtual-machines | Create virtual machines
*VirtualMachineApi* | [**delete_firewall_rule_for_vm**](docs/VirtualMachineApi.md#delete_firewall_rule_for_vm) | **DELETE** /core/virtual-machines/{vm_id}/sg-rules/{sg_rule_id} | Delete firewall rule from virtual machine
*VirtualMachineApi* | [**delete_vm**](docs/VirtualMachineApi.md#delete_vm) | **DELETE** /core/virtual-machines/{vm_id} | Delete virtual machine
*VirtualMachineApi* | [**get_contract_vms**](docs/VirtualMachineApi.md#get_contract_vms) | **GET** /core/virtual-machines/contract/{contract_id}/virtual-machines | Retrieve virtual machines associated with a contract
*VirtualMachineApi* | [**get_vm**](docs/VirtualMachineApi.md#get_vm) | **GET** /core/virtual-machines/{vm_id} | Retrieve virtual machine details
*VirtualMachineApi* | [**get_vm_logs**](docs/VirtualMachineApi.md#get_vm_logs) | **GET** /core/virtual-machines/{vm_id}/logs | Get virtual machine logs
*VirtualMachineApi* | [**get_vm_metrics**](docs/VirtualMachineApi.md#get_vm_metrics) | **GET** /core/virtual-machines/{vm_id}/metrics | Retrieve virtual machine performance metrics
*VirtualMachineApi* | [**hard_reboot_vm**](docs/VirtualMachineApi.md#hard_reboot_vm) | **GET** /core/virtual-machines/{vm_id}/hard-reboot | Hard reboot virtual machine
*VirtualMachineApi* | [**hibernate_vm**](docs/VirtualMachineApi.md#hibernate_vm) | **GET** /core/virtual-machines/{vm_id}/hibernate | Hibernate virtual machine
*VirtualMachineApi* | [**list_vms**](docs/VirtualMachineApi.md#list_vms) | **GET** /core/virtual-machines | List virtual machines
*VirtualMachineApi* | [**request_vm_logs**](docs/VirtualMachineApi.md#request_vm_logs) | **POST** /core/virtual-machines/{vm_id}/logs | Request virtual machine logs
*VirtualMachineApi* | [**resize_vm**](docs/VirtualMachineApi.md#resize_vm) | **POST** /core/virtual-machines/{vm_id}/resize | Resize virtual machine
*VirtualMachineApi* | [**restore_vm_from_hibernation**](docs/VirtualMachineApi.md#restore_vm_from_hibernation) | **GET** /core/virtual-machines/{vm_id}/hibernate-restore | Restore virtual machine from hibernation
*VirtualMachineApi* | [**start_vm**](docs/VirtualMachineApi.md#start_vm) | **GET** /core/virtual-machines/{vm_id}/start | Start virtual machine
*VirtualMachineApi* | [**stop_vm**](docs/VirtualMachineApi.md#stop_vm) | **GET** /core/virtual-machines/{vm_id}/stop | Stop virtual machine
*VirtualMachineEventsApi* | [**list_vm_events**](docs/VirtualMachineEventsApi.md#list_vm_events) | **GET** /core/virtual-machines/{vm_id}/events | List virtual machine events
*VncUrlApi* | [**get_vncurl**](docs/VncUrlApi.md#get_vncurl) | **GET** /core/virtual-machines/{vm_id}/console/{job_id} | Get VNC Console Link
*VncUrlApi* | [**request_vm_console**](docs/VncUrlApi.md#request_vm_console) | **GET** /core/virtual-machines/{vm_id}/request-console | Request Instance Console
*VolumeApi* | [**create_volume**](docs/VolumeApi.md#create_volume) | **POST** /core/volumes | Create volume
*VolumeApi* | [**delete_volume**](docs/VolumeApi.md#delete_volume) | **DELETE** /core/volumes/{volume_id} | Delete volume
*VolumeApi* | [**fetch_volume_name_availability**](docs/VolumeApi.md#fetch_volume_name_availability) | **GET** /core/volume/name-availability/{name} | Fetch volume name availability
*VolumeApi* | [**get_volume**](docs/VolumeApi.md#get_volume) | **GET** /core/volumes/{volume_id} | Fetch Volume Details
*VolumeApi* | [**list_volume_types**](docs/VolumeApi.md#list_volume_types) | **GET** /core/volume-types | List volume types
*VolumeApi* | [**list_volumes**](docs/VolumeApi.md#list_volumes) | **GET** /core/volumes | List volumes
*VolumeApi* | [**update_volume**](docs/VolumeApi.md#update_volume) | **PATCH** /core/volumes/{volume_id} | Update volume fields
*VolumeAttachmentApi* | [**attach_volumes_to_vm**](docs/VolumeAttachmentApi.md#attach_volumes_to_vm) | **POST** /core/virtual-machines/{vm_id}/attach-volumes | Attach volumes to virtual machine
*VolumeAttachmentApi* | [**detach_volumes_from_vm**](docs/VolumeAttachmentApi.md#detach_volumes_from_vm) | **POST** /core/virtual-machines/{vm_id}/detach-volumes | Detach volumes from virtual machine
*VolumeAttachmentApi* | [**update_volume_attachment**](docs/VolumeAttachmentApi.md#update_volume_attachment) | **PATCH** /core/volume-attachments/{volume_attachment_id} | Update a volume attachment
*VouchersApi* | [**redeem_a_voucher**](docs/VouchersApi.md#redeem_a_voucher) | **POST** /billing/billing/vouchers/redeem | Redeem a voucher with a voucher_code


## Documentation For Models

 - [AccessTokenField](docs/AccessTokenField.md)
 - [AddUserInfoSuccessResponseModel](docs/AddUserInfoSuccessResponseModel.md)
 - [AllocatedGPUCountGraph](docs/AllocatedGPUCountGraph.md)
 - [ApiKeyFields](docs/ApiKeyFields.md)
 - [AssignRbacRolePayload](docs/AssignRbacRolePayload.md)
 - [AttachCallbackPayload](docs/AttachCallbackPayload.md)
 - [AttachCallbackResponse](docs/AttachCallbackResponse.md)
 - [AttachFirewallWithVM](docs/AttachFirewallWithVM.md)
 - [AttachFirewallsToVMPayload](docs/AttachFirewallsToVMPayload.md)
 - [AttachVolumeFields](docs/AttachVolumeFields.md)
 - [AttachVolumes](docs/AttachVolumes.md)
 - [AttachVolumesPayload](docs/AttachVolumesPayload.md)
 - [AttachmentsFieldsForVolume](docs/AttachmentsFieldsForVolume.md)
 - [Attributes](docs/Attributes.md)
 - [AuthGetTokenResponseModel](docs/AuthGetTokenResponseModel.md)
 - [AuthUserFields](docs/AuthUserFields.md)
 - [AuthUserInfoResponseModel](docs/AuthUserInfoResponseModel.md)
 - [BetaAccessRequestFields](docs/BetaAccessRequestFields.md)
 - [BetaAccessRequestPayload](docs/BetaAccessRequestPayload.md)
 - [BetaAccessRequestResponseModel](docs/BetaAccessRequestResponseModel.md)
 - [BetaAccessStatusItem](docs/BetaAccessStatusItem.md)
 - [BetaAccessStatusResponseModel](docs/BetaAccessStatusResponseModel.md)
 - [BillingHistory](docs/BillingHistory.md)
 - [BillingHistoryDataSynthesisDetails](docs/BillingHistoryDataSynthesisDetails.md)
 - [BillingHistoryFineTuning](docs/BillingHistoryFineTuning.md)
 - [BillingHistoryModelEvalutationDetails](docs/BillingHistoryModelEvalutationDetails.md)
 - [BillingHistoryServerlessInference](docs/BillingHistoryServerlessInference.md)
 - [BillingHistoryServerlessInferenceDetails](docs/BillingHistoryServerlessInferenceDetails.md)
 - [BillingMetricesFields](docs/BillingMetricesFields.md)
 - [BillingMetricesResponse](docs/BillingMetricesResponse.md)
 - [ClusterEvents](docs/ClusterEvents.md)
 - [ClusterEventsFields](docs/ClusterEventsFields.md)
 - [ClusterFields](docs/ClusterFields.md)
 - [ClusterFlavorFields](docs/ClusterFlavorFields.md)
 - [ClusterListResponse](docs/ClusterListResponse.md)
 - [ClusterNodeFields](docs/ClusterNodeFields.md)
 - [ClusterNodeGroupFields](docs/ClusterNodeGroupFields.md)
 - [ClusterNodeGroupsCreateResponse](docs/ClusterNodeGroupsCreateResponse.md)
 - [ClusterNodeGroupsGetResponse](docs/ClusterNodeGroupsGetResponse.md)
 - [ClusterNodeGroupsListResponse](docs/ClusterNodeGroupsListResponse.md)
 - [ClusterNodeInstanceFields](docs/ClusterNodeInstanceFields.md)
 - [ClusterNodesListResponse](docs/ClusterNodesListResponse.md)
 - [ClusterResponse](docs/ClusterResponse.md)
 - [ClusterVersion](docs/ClusterVersion.md)
 - [ClusterVersions](docs/ClusterVersions.md)
 - [Colors](docs/Colors.md)
 - [CommonResponseModel](docs/CommonResponseModel.md)
 - [ComplianceFields](docs/ComplianceFields.md)
 - [ComplianceModelFields](docs/ComplianceModelFields.md)
 - [CompliancePayload](docs/CompliancePayload.md)
 - [ComplianceResponse](docs/ComplianceResponse.md)
 - [ContainerOverviewFields](docs/ContainerOverviewFields.md)
 - [Contract](docs/Contract.md)
 - [ContractDiscountPlanFields](docs/ContractDiscountPlanFields.md)
 - [ContractGPUAllocationGraphResponse](docs/ContractGPUAllocationGraphResponse.md)
 - [ContractInstanceFields](docs/ContractInstanceFields.md)
 - [ContractInstancesResponse](docs/ContractInstancesResponse.md)
 - [CreateClusterNodeFields](docs/CreateClusterNodeFields.md)
 - [CreateClusterNodeGroupPayload](docs/CreateClusterNodeGroupPayload.md)
 - [CreateClusterPayload](docs/CreateClusterPayload.md)
 - [CreateEnvironment](docs/CreateEnvironment.md)
 - [CreateFirewallPayload](docs/CreateFirewallPayload.md)
 - [CreateFirewallRulePayload](docs/CreateFirewallRulePayload.md)
 - [CreateImage](docs/CreateImage.md)
 - [CreateImagePayload](docs/CreateImagePayload.md)
 - [CreateInstancesPayload](docs/CreateInstancesPayload.md)
 - [CreateInstancesResponse](docs/CreateInstancesResponse.md)
 - [CreateProfilePayload](docs/CreateProfilePayload.md)
 - [CreateProfileResponse](docs/CreateProfileResponse.md)
 - [CreateSecurityRulePayload](docs/CreateSecurityRulePayload.md)
 - [CreateSnapshotPayload](docs/CreateSnapshotPayload.md)
 - [CreateSnapshotResponse](docs/CreateSnapshotResponse.md)
 - [CreateUpdateComplianceResponse](docs/CreateUpdateComplianceResponse.md)
 - [CreateUpdateRbacRolePayload](docs/CreateUpdateRbacRolePayload.md)
 - [CreateVolumePayload](docs/CreateVolumePayload.md)
 - [CustomerContractDetailResponseModel](docs/CustomerContractDetailResponseModel.md)
 - [CustomerContractFields](docs/CustomerContractFields.md)
 - [DashboardInfoResponse](docs/DashboardInfoResponse.md)
 - [DataSynthesisBillingHistoryDetailsResponseSchema](docs/DataSynthesisBillingHistoryDetailsResponseSchema.md)
 - [DeleteClusterNodesFields](docs/DeleteClusterNodesFields.md)
 - [DeploymentFields](docs/DeploymentFields.md)
 - [DeploymentFieldsForStartDeployments](docs/DeploymentFieldsForStartDeployments.md)
 - [Deployments](docs/Deployments.md)
 - [DetachVolumes](docs/DetachVolumes.md)
 - [DetachVolumesPayload](docs/DetachVolumesPayload.md)
 - [EditLabelOfAnExistingVMPayload](docs/EditLabelOfAnExistingVMPayload.md)
 - [Environment](docs/Environment.md)
 - [EnvironmentFeatures](docs/EnvironmentFeatures.md)
 - [EnvironmentFields](docs/EnvironmentFields.md)
 - [EnvironmentFieldsForVolume](docs/EnvironmentFieldsForVolume.md)
 - [Environments](docs/Environments.md)
 - [ErrorResponseModel](docs/ErrorResponseModel.md)
 - [FirewallAttachmentModel](docs/FirewallAttachmentModel.md)
 - [FirewallAttachmentVMModel](docs/FirewallAttachmentVMModel.md)
 - [FirewallDetailFields](docs/FirewallDetailFields.md)
 - [FirewallDetailResponse](docs/FirewallDetailResponse.md)
 - [FirewallEnvironmentFields](docs/FirewallEnvironmentFields.md)
 - [FirewallFields](docs/FirewallFields.md)
 - [FirewallResponse](docs/FirewallResponse.md)
 - [FirewallRule](docs/FirewallRule.md)
 - [FirewallsListResponse](docs/FirewallsListResponse.md)
 - [FlavorFields](docs/FlavorFields.md)
 - [FlavorItemGetResponse](docs/FlavorItemGetResponse.md)
 - [FlavorLabelFields](docs/FlavorLabelFields.md)
 - [FlavorListResponse](docs/FlavorListResponse.md)
 - [FlavorObjectFields](docs/FlavorObjectFields.md)
 - [GPUFields](docs/GPUFields.md)
 - [GPUList](docs/GPUList.md)
 - [GPURegionFields](docs/GPURegionFields.md)
 - [GenerateUpdateApiKeyPayload](docs/GenerateUpdateApiKeyPayload.md)
 - [GenerateUpdateApiKeyResponseModel](docs/GenerateUpdateApiKeyResponseModel.md)
 - [GetApiKeysResponseModel](docs/GetApiKeysResponseModel.md)
 - [GetCreditAndThresholdInfo](docs/GetCreditAndThresholdInfo.md)
 - [GetCreditAndThresholdInfoInResponse](docs/GetCreditAndThresholdInfoInResponse.md)
 - [GetCustomerContractsListResponseModel](docs/GetCustomerContractsListResponseModel.md)
 - [GetInstanceLogsResponse](docs/GetInstanceLogsResponse.md)
 - [GetInvitesResponseModel](docs/GetInvitesResponseModel.md)
 - [GetOrganizationResponseModel](docs/GetOrganizationResponseModel.md)
 - [GetPermissionsResponseModel](docs/GetPermissionsResponseModel.md)
 - [GetPoliciesResponseModel](docs/GetPoliciesResponseModel.md)
 - [GetRbacRolesResponseModel](docs/GetRbacRolesResponseModel.md)
 - [GetUserPermissionsResponseModel](docs/GetUserPermissionsResponseModel.md)
 - [GraphDatetimeValueModel](docs/GraphDatetimeValueModel.md)
 - [Image](docs/Image.md)
 - [ImageFields](docs/ImageFields.md)
 - [ImageGetResponse](docs/ImageGetResponse.md)
 - [Images](docs/Images.md)
 - [ImportKeypairPayload](docs/ImportKeypairPayload.md)
 - [ImportKeypairResponse](docs/ImportKeypairResponse.md)
 - [InfrahubResourceObjectResponseForCustomer](docs/InfrahubResourceObjectResponseForCustomer.md)
 - [Instance](docs/Instance.md)
 - [InstanceEnvironmentFields](docs/InstanceEnvironmentFields.md)
 - [InstanceEvents](docs/InstanceEvents.md)
 - [InstanceEventsFields](docs/InstanceEventsFields.md)
 - [InstanceFields](docs/InstanceFields.md)
 - [InstanceFlavorFields](docs/InstanceFlavorFields.md)
 - [InstanceImageFields](docs/InstanceImageFields.md)
 - [InstanceKeypairFields](docs/InstanceKeypairFields.md)
 - [InstanceOverviewFields](docs/InstanceOverviewFields.md)
 - [InstanceResizePayload](docs/InstanceResizePayload.md)
 - [Instances](docs/Instances.md)
 - [InviteFields](docs/InviteFields.md)
 - [InviteUserPayload](docs/InviteUserPayload.md)
 - [InviteUserResponseModel](docs/InviteUserResponseModel.md)
 - [KeypairEnvironmentFeatures](docs/KeypairEnvironmentFeatures.md)
 - [KeypairEnvironmentFields](docs/KeypairEnvironmentFields.md)
 - [KeypairFields](docs/KeypairFields.md)
 - [Keypairs](docs/Keypairs.md)
 - [LableResonse](docs/LableResonse.md)
 - [LastDayCostFields](docs/LastDayCostFields.md)
 - [LastDayCostResponse](docs/LastDayCostResponse.md)
 - [Logos](docs/Logos.md)
 - [MFAStatusFields](docs/MFAStatusFields.md)
 - [MFAStatusResponse](docs/MFAStatusResponse.md)
 - [ManualReconciliationModel](docs/ManualReconciliationModel.md)
 - [MasterFlavorsResponse](docs/MasterFlavorsResponse.md)
 - [MetricItemFields](docs/MetricItemFields.md)
 - [MetricsFields](docs/MetricsFields.md)
 - [ModelEvaluationBillingHistoryDetailsResponseSchema](docs/ModelEvaluationBillingHistoryDetailsResponseSchema.md)
 - [NameAvailableModel](docs/NameAvailableModel.md)
 - [NewConfigurationsResponse](docs/NewConfigurationsResponse.md)
 - [NewModelResponse](docs/NewModelResponse.md)
 - [NewStockResponse](docs/NewStockResponse.md)
 - [NewStockRetriveResponse](docs/NewStockRetriveResponse.md)
 - [ObjectStorageAccessKeyCreateRequest](docs/ObjectStorageAccessKeyCreateRequest.md)
 - [ObjectStorageAccessKeyCreateResponse](docs/ObjectStorageAccessKeyCreateResponse.md)
 - [ObjectStorageAccessKeyListResponse](docs/ObjectStorageAccessKeyListResponse.md)
 - [ObjectStorageAccessKeyResponse](docs/ObjectStorageAccessKeyResponse.md)
 - [ObjectStorageBucketListResponse](docs/ObjectStorageBucketListResponse.md)
 - [ObjectStorageBucketResponse](docs/ObjectStorageBucketResponse.md)
 - [ObjectStorageDeleteResponse](docs/ObjectStorageDeleteResponse.md)
 - [ObjectStorageErrorResponse](docs/ObjectStorageErrorResponse.md)
 - [ObjectStorageHealthResponse](docs/ObjectStorageHealthResponse.md)
 - [ObjectStoragePaginationMeta](docs/ObjectStoragePaginationMeta.md)
 - [ObjectStorageRegionListResponse](docs/ObjectStorageRegionListResponse.md)
 - [ObjectStorageRegionResponse](docs/ObjectStorageRegionResponse.md)
 - [ObjectStorageRegionsEnum](docs/ObjectStorageRegionsEnum.md)
 - [OrganizationFields](docs/OrganizationFields.md)
 - [OrganizationLevelBillingHistory](docs/OrganizationLevelBillingHistory.md)
 - [OrganizationLevelBillingHistoryResources](docs/OrganizationLevelBillingHistoryResources.md)
 - [OrganizationLevelBillingHistoryResponseAttributes](docs/OrganizationLevelBillingHistoryResponseAttributes.md)
 - [OrganizationLevelBillingHistoryResponseMetrics](docs/OrganizationLevelBillingHistoryResponseMetrics.md)
 - [OrganizationLevelBillingHistoryResponseModel](docs/OrganizationLevelBillingHistoryResponseModel.md)
 - [OrganizationThresholdFields](docs/OrganizationThresholdFields.md)
 - [OrganizationThresholdUpdateResponse](docs/OrganizationThresholdUpdateResponse.md)
 - [OrganizationThresholdsResponse](docs/OrganizationThresholdsResponse.md)
 - [OrganizationUserResponseModel](docs/OrganizationUserResponseModel.md)
 - [OverviewInfo](docs/OverviewInfo.md)
 - [Pagination](docs/Pagination.md)
 - [PaginationData](docs/PaginationData.md)
 - [PartnerConfig](docs/PartnerConfig.md)
 - [PaymentDetailsFields](docs/PaymentDetailsFields.md)
 - [PaymentDetailsResponse](docs/PaymentDetailsResponse.md)
 - [PaymentInitiateFields](docs/PaymentInitiateFields.md)
 - [PaymentInitiatePayload](docs/PaymentInitiatePayload.md)
 - [PaymentInitiateResponse](docs/PaymentInitiateResponse.md)
 - [PermissionFields](docs/PermissionFields.md)
 - [PolicyFields](docs/PolicyFields.md)
 - [PolicyPermissionFields](docs/PolicyPermissionFields.md)
 - [PricebookModel](docs/PricebookModel.md)
 - [PricebookResourceObjectResponseForCustomer](docs/PricebookResourceObjectResponseForCustomer.md)
 - [PrimaryColor](docs/PrimaryColor.md)
 - [ProfileFields](docs/ProfileFields.md)
 - [ProfileListResponse](docs/ProfileListResponse.md)
 - [ProfileObjectFields](docs/ProfileObjectFields.md)
 - [RbacRoleDetailResponseModel](docs/RbacRoleDetailResponseModel.md)
 - [RbacRoleDetailResponseModelFixed](docs/RbacRoleDetailResponseModelFixed.md)
 - [RbacRoleField](docs/RbacRoleField.md)
 - [RbacRoleFields](docs/RbacRoleFields.md)
 - [RedeemVoucherPayload](docs/RedeemVoucherPayload.md)
 - [RegionFields](docs/RegionFields.md)
 - [Regions](docs/Regions.md)
 - [RemoveMemberFromOrganizationResponseModel](docs/RemoveMemberFromOrganizationResponseModel.md)
 - [RemoveMemberPayload](docs/RemoveMemberPayload.md)
 - [RequestConsole](docs/RequestConsole.md)
 - [RequestInstanceLogsPayload](docs/RequestInstanceLogsPayload.md)
 - [RequestInstanceLogsResponse](docs/RequestInstanceLogsResponse.md)
 - [ResourceBillingEventsHistoryMetrics](docs/ResourceBillingEventsHistoryMetrics.md)
 - [ResourceBillingEventsHistoryResponse](docs/ResourceBillingEventsHistoryResponse.md)
 - [ResourceBillingResponseForCustomer](docs/ResourceBillingResponseForCustomer.md)
 - [ResourceLevelBillingBucketDetailsResources](docs/ResourceLevelBillingBucketDetailsResources.md)
 - [ResourceLevelBillingDetailsAttributes](docs/ResourceLevelBillingDetailsAttributes.md)
 - [ResourceLevelBillingDetailsMetrics](docs/ResourceLevelBillingDetailsMetrics.md)
 - [ResourceLevelBillingDetailsVM](docs/ResourceLevelBillingDetailsVM.md)
 - [ResourceLevelBillingDetailsVolume](docs/ResourceLevelBillingDetailsVolume.md)
 - [ResourceLevelBillingDetailsVolumeAttributes](docs/ResourceLevelBillingDetailsVolumeAttributes.md)
 - [ResourceLevelBillingDetailsVolumeMetrics](docs/ResourceLevelBillingDetailsVolumeMetrics.md)
 - [ResourceLevelBillingHistory](docs/ResourceLevelBillingHistory.md)
 - [ResourceLevelBillingHistoryResources](docs/ResourceLevelBillingHistoryResources.md)
 - [ResourceLevelBillingHistoryResourcesCluster](docs/ResourceLevelBillingHistoryResourcesCluster.md)
 - [ResourceLevelBillingHistoryResponseAttributes](docs/ResourceLevelBillingHistoryResponseAttributes.md)
 - [ResourceLevelBillingHistoryResponseMetrics](docs/ResourceLevelBillingHistoryResponseMetrics.md)
 - [ResourceLevelBillingVMDetailsResources](docs/ResourceLevelBillingVMDetailsResources.md)
 - [ResourceLevelBillingVolumeDetailsResources](docs/ResourceLevelBillingVolumeDetailsResources.md)
 - [ResourceLevelBucketBillingDetailsResponseModel](docs/ResourceLevelBucketBillingDetailsResponseModel.md)
 - [ResourceLevelBucketBillingHistoryResponseModel](docs/ResourceLevelBucketBillingHistoryResponseModel.md)
 - [ResourceLevelClusterBillingDetailsResponseModel](docs/ResourceLevelClusterBillingDetailsResponseModel.md)
 - [ResourceLevelClusterBillingHistoryResponseModel](docs/ResourceLevelClusterBillingHistoryResponseModel.md)
 - [ResourceLevelClusterGraphBillingDetailsResponseModel](docs/ResourceLevelClusterGraphBillingDetailsResponseModel.md)
 - [ResourceLevelGraphBillingDetailVolume](docs/ResourceLevelGraphBillingDetailVolume.md)
 - [ResourceLevelGraphBillingDetailsAttributes](docs/ResourceLevelGraphBillingDetailsAttributes.md)
 - [ResourceLevelGraphBillingDetailsBucket](docs/ResourceLevelGraphBillingDetailsBucket.md)
 - [ResourceLevelGraphBillingDetailsMetrics](docs/ResourceLevelGraphBillingDetailsMetrics.md)
 - [ResourceLevelGraphBillingDetailsVM](docs/ResourceLevelGraphBillingDetailsVM.md)
 - [ResourceLevelGraphBillingVMDetailsResources](docs/ResourceLevelGraphBillingVMDetailsResources.md)
 - [ResourceLevelGraphBillingVolumeDetailsResources](docs/ResourceLevelGraphBillingVolumeDetailsResources.md)
 - [ResourceLevelVMBillingDetailsResponseModel](docs/ResourceLevelVMBillingDetailsResponseModel.md)
 - [ResourceLevelVmBillingHistoryResponseModel](docs/ResourceLevelVmBillingHistoryResponseModel.md)
 - [ResourceLevelVmGraphBillingDetailsResponseModel](docs/ResourceLevelVmGraphBillingDetailsResponseModel.md)
 - [ResourceLevelVolumeBillingDetailsResponseModel](docs/ResourceLevelVolumeBillingDetailsResponseModel.md)
 - [ResourceLevelVolumeBillingHistoryResponseModel](docs/ResourceLevelVolumeBillingHistoryResponseModel.md)
 - [ResourceLevelVolumeGraphBillingDetailsResponseModel](docs/ResourceLevelVolumeGraphBillingDetailsResponseModel.md)
 - [ResourceObjectResponseForCustomer](docs/ResourceObjectResponseForCustomer.md)
 - [ResponseModel](docs/ResponseModel.md)
 - [RolePermissionFields](docs/RolePermissionFields.md)
 - [RolePolicyFields](docs/RolePolicyFields.md)
 - [SecondaryColor](docs/SecondaryColor.md)
 - [SecurityGroupRule](docs/SecurityGroupRule.md)
 - [SecurityGroupRuleFields](docs/SecurityGroupRuleFields.md)
 - [SecurityRulesFieldsForInstance](docs/SecurityRulesFieldsForInstance.md)
 - [SecurityRulesProtocolFields](docs/SecurityRulesProtocolFields.md)
 - [ServerlessInferencedBillingHistoryDetailsResponseSchema](docs/ServerlessInferencedBillingHistoryDetailsResponseSchema.md)
 - [SnapshotFields](docs/SnapshotFields.md)
 - [SnapshotRestoreRequest](docs/SnapshotRestoreRequest.md)
 - [SnapshotRetrieve](docs/SnapshotRetrieve.md)
 - [SnapshotRetrieveFields](docs/SnapshotRetrieveFields.md)
 - [Snapshots](docs/Snapshots.md)
 - [StartDeployment](docs/StartDeployment.md)
 - [StartDeploymentPayload](docs/StartDeploymentPayload.md)
 - [SubResourceGraphBillingDetailsMetrics](docs/SubResourceGraphBillingDetailsMetrics.md)
 - [SubResourcesCostsResponseModel](docs/SubResourcesCostsResponseModel.md)
 - [SubResourcesGraphBillingHistoryFields](docs/SubResourcesGraphBillingHistoryFields.md)
 - [SubResourcesGraphResponseModel](docs/SubResourcesGraphResponseModel.md)
 - [SubscribeOrUnsubscribeUpdatePayload](docs/SubscribeOrUnsubscribeUpdatePayload.md)
 - [Template](docs/Template.md)
 - [TemplateFields](docs/TemplateFields.md)
 - [Templates](docs/Templates.md)
 - [TokenBasedBillingHistoryResponse](docs/TokenBasedBillingHistoryResponse.md)
 - [URIs](docs/URIs.md)
 - [UpdateClusterNodeGroupPayload](docs/UpdateClusterNodeGroupPayload.md)
 - [UpdateEnvironment](docs/UpdateEnvironment.md)
 - [UpdateKeypairName](docs/UpdateKeypairName.md)
 - [UpdateKeypairNameResponse](docs/UpdateKeypairNameResponse.md)
 - [UpdateOrganizationPayload](docs/UpdateOrganizationPayload.md)
 - [UpdateOrganizationResponseModel](docs/UpdateOrganizationResponseModel.md)
 - [UpdateTemplate](docs/UpdateTemplate.md)
 - [UpdateVolumeAttachmentPayload](docs/UpdateVolumeAttachmentPayload.md)
 - [UpdateVolumePayload](docs/UpdateVolumePayload.md)
 - [UpdateVolumeResponse](docs/UpdateVolumeResponse.md)
 - [UserDefaultChoiceForUserFields](docs/UserDefaultChoiceForUserFields.md)
 - [UserDefaultChoicesForUserResponse](docs/UserDefaultChoicesForUserResponse.md)
 - [UserInfoPostPayload](docs/UserInfoPostPayload.md)
 - [UserOrganizationsResponse](docs/UserOrganizationsResponse.md)
 - [UserPermissionFields](docs/UserPermissionFields.md)
 - [UsersInfoFields](docs/UsersInfoFields.md)
 - [UsersInfoListResponse](docs/UsersInfoListResponse.md)
 - [VNCURL](docs/VNCURL.md)
 - [VNCURLFields](docs/VNCURLFields.md)
 - [Volume](docs/Volume.md)
 - [VolumeAttachmentFields](docs/VolumeAttachmentFields.md)
 - [VolumeFields](docs/VolumeFields.md)
 - [VolumeFieldsForInstance](docs/VolumeFieldsForInstance.md)
 - [VolumeOverviewFields](docs/VolumeOverviewFields.md)
 - [VolumeTypes](docs/VolumeTypes.md)
 - [Volumes](docs/Volumes.md)
 - [VolumesFields](docs/VolumesFields.md)
 - [Voucher](docs/Voucher.md)
 - [VoucherRedeemResponseSchema](docs/VoucherRedeemResponseSchema.md)
 - [WorkloadBillingHistoryResponse](docs/WorkloadBillingHistoryResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="apiKey"></a>
### apiKey

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


## Author




