# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ..models.cluster_flavor_fields import ClusterFlavorFields
from ..models.cluster_node_fields import ClusterNodeFields
from ..models.cluster_node_group_fields import ClusterNodeGroupFields
from typing import Optional, Set
from typing_extensions import Self

class ClusterFields(BaseModel):
    """
    ClusterFields
    """ # noqa: E501
    api_address: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    environment_name: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    is_reconciling: Optional[StrictBool] = None
    keypair_name: Optional[StrictStr] = None
    kube_config: Optional[StrictStr] = None
    kubernetes_version: Optional[StrictStr] = None
    master_flavor: Optional[ClusterFlavorFields] = None
    name: Optional[StrictStr] = None
    node_groups: Optional[List[ClusterNodeGroupFields]] = None
    nodes: Optional[List[ClusterNodeFields]] = None
    status: Optional[StrictStr] = None
    status_reason: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["api_address", "created_at", "environment_name", "id", "is_reconciling", "keypair_name", "kube_config", "kubernetes_version", "master_flavor", "name", "node_groups", "nodes", "status", "status_reason"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of master_flavor
        if self.master_flavor:
            _dict['master_flavor'] = self.master_flavor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in node_groups (list)
        _items = []
        if self.node_groups:
            for _item_node_groups in self.node_groups:
                if _item_node_groups:
                    _items.append(_item_node_groups.to_dict())
            _dict['node_groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in nodes (list)
        _items = []
        if self.nodes:
            for _item_nodes in self.nodes:
                if _item_nodes:
                    _items.append(_item_nodes.to_dict())
            _dict['nodes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "api_address": obj.get("api_address"),
            "created_at": obj.get("created_at"),
            "environment_name": obj.get("environment_name"),
            "id": obj.get("id"),
            "is_reconciling": obj.get("is_reconciling"),
            "keypair_name": obj.get("keypair_name"),
            "kube_config": obj.get("kube_config"),
            "kubernetes_version": obj.get("kubernetes_version"),
            "master_flavor": ClusterFlavorFields.from_dict(obj["master_flavor"]) if obj.get("master_flavor") is not None else None,
            "name": obj.get("name"),
            "node_groups": [ClusterNodeGroupFields.from_dict(_item) for _item in obj["node_groups"]] if obj.get("node_groups") is not None else None,
            "nodes": [ClusterNodeFields.from_dict(_item) for _item in obj["nodes"]] if obj.get("nodes") is not None else None,
            "status": obj.get("status"),
            "status_reason": obj.get("status_reason")
        })
        return _obj


