# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from ..models.object_storage_access_key_response import ObjectStorageAccessKeyResponse
from ..models.object_storage_pagination_meta import ObjectStoragePaginationMeta
from typing import Optional, Set
from typing_extensions import Self

class ObjectStorageAccessKeyListResponse(BaseModel):
    """
    ObjectStorageAccessKeyListResponse
    """ # noqa: E501
    access_keys: List[ObjectStorageAccessKeyResponse]
    meta: ObjectStoragePaginationMeta
    __properties: ClassVar[List[str]] = ["access_keys", "meta"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ObjectStorageAccessKeyListResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in access_keys (list)
        _items = []
        if self.access_keys:
            for _item_access_keys in self.access_keys:
                if _item_access_keys:
                    _items.append(_item_access_keys.to_dict())
            _dict['access_keys'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ObjectStorageAccessKeyListResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "access_keys": [ObjectStorageAccessKeyResponse.from_dict(_item) for _item in obj["access_keys"]] if obj.get("access_keys") is not None else None,
            "meta": ObjectStoragePaginationMeta.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


