/*
    Toolbar component for Mac OS API

    Sergei L. Kosakovsky Pond, May 2000-December 2002
*/

#include "HYButtonBar.h"
#include "HYPullDown.h"
#include "errorfns.h"
#include "HYPlatformWindow.h"
#include "commctrl.h"
#include "HYGraphicPane.h"


extern bool forceUpdateForScrolling;

//__________________________________________________________________

HBRUSH      blackIconFill = CreateSolidBrush (RGB(0,0,0)),
            dimIconFill   = CreatePatternBrush (LoadBitmap (GetModuleHandle(NULL),MAKEINTRESOURCE(333)));

HPEN        buttonBorder1 = CreatePen        (PS_SOLID, 1, RGB(0,0,0));


//__________________________________________________________________

_HYPlatformButtonBar::_HYPlatformButtonBar(void)
{
    backFill = CreateSolidBrush(RGB(0xff,0xff,0xff));
    if (!backFill) {
        warnError (-108);
    }
    pushed = -1;
    lastMouseDown = -1;
    ttCtl = nil;

}

//__________________________________________________________________

_HYPlatformButtonBar::~_HYPlatformButtonBar(void)
{
    if (backFill) {
        DeleteObject (backFill);
    }
    DestroyWindow (ttCtl);
}


//__________________________________________________________________

void    _HYPlatformButtonBar::_DisposeButtons(void)
{
    _HYButtonBar* theParent = (_HYButtonBar*)this;
    for (long i=0; i<theParent->ButtonCount(); i++) {
        DeleteObject ((HBITMAP)theParent->buttons.lData[i]);
    }
}

//__________________________________________________________________

void    _HYPlatformButtonBar::_DisposeButton(long k)
{
    _HYButtonBar* theParent = (_HYButtonBar*)this;
    if ((k<theParent->ButtonCount())&&(k>=0)) {
        DeleteObject ((HBITMAP)theParent->buttons.lData[k]);
    }
}

//__________________________________________________________________

void        _HYPlatformButtonBar::_SetBackColor (_HYColor& c)
{
    if (backFill)   {
        DeleteObject(backFill);
    }
    backFill = CreateSolidBrush(RGB(c.R,c.G,c.B));
}


//__________________________________________________________________
void        _HYPlatformButtonBar::_SetVisibleSize (_HYRect rel)
{
    _HYButtonBar* theParent = (_HYButtonBar*) this;
    buttonRect.left=rel.left;
    buttonRect.top = rel.top;
    _HYRect s = theParent->_SuggestDimensions();
    buttonRect.right = buttonRect.left+s.right;
    buttonRect.bottom = buttonRect.top+s.bottom;
    AlignRectangle (rel, buttonRect, theParent->GetAlignFlags());
    if (ttCtl) {
        TOOLINFO ti;
        ti.cbSize = sizeof (TOOLINFO);
        ti.uFlags = TTF_SUBCLASS;
        ti.hwnd   = theParent->parentWindow;
        ti.hinst  = ProgramInstance;
        for (long k=0; k<theParent->buttons.lLength; k++) {
            _String * tt = (_String*)theParent->toolTips(k);
            if (tt->sLength) {
                ti.uId = k;
                int    h, v;
                theParent->GetButtonLoc (k,h,v,false);
                ti.rect.left   = h;
                ti.rect.top    = v;
                ti.rect.right  = h+theParent->GetButtonDim();
                ti.rect.bottom = v+theParent->GetButtonDim();
                //printf ("Added: %s %d %d %d %d\n", tt->sData, ti.rect.left, ti.rect.top, ti.rect.right, ti.rect.bottom);
                SendMessage(ttCtl, TTM_NEWTOOLRECT, 0, (LPARAM) (LPTOOLINFO) &ti);
            }
        }
    }
}

//__________________________________________________________________

void        _HYButtonBar::_Activate (void)
{
    if (!activationFlag)
        for (long k=0; k<enabledButtons.lLength; k++) {
            _MarkButtonForUpdate (enabledButtons.lData[k]);
        }

    //SendMessage (ttCtl, TTM_ACTIVATE, 1, 0);
    if (ttCtl) {
        DestroyWindow (ttCtl);
    }

    ttCtl = CreateWindowEx (WS_EX_TOPMOST, TOOLTIPS_CLASS, NULL, WS_POPUP|TTS_NOPREFIX|TTS_ALWAYSTIP,
                            CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,parentWindow,
                            NULL,ProgramInstance, NULL);

    checkPointer (ttCtl);
    SetWindowPos (ttCtl, HWND_TOPMOST, 0, 0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);

//  if (SendMessage (ttCtl, TTM_GETTOOLCOUNT, 0, 0) == 0)
    {

        TOOLINFO ti;
        ti.cbSize = sizeof (TOOLINFO);
        ti.uFlags = TTF_SUBCLASS;
        ti.hwnd   = parentWindow;
        ti.hinst  = ProgramInstance;

        //long k = 0;
        for (long k=0; k<buttons.lLength; k++) {
            _String * tt = (_String*)toolTips(k);
            if (tt->sLength) {
                ti.uId = k;
                int    h, v;
                GetButtonLoc (k,h,v,false);
                ti.rect.left   = h;
                ti.rect.top    = v;
                ti.rect.right  = h+GetButtonDim();
                ti.rect.bottom = v+GetButtonDim();
                ti.lpszText    = tt->sData;
                //printf ("Added: %s %d %d %d %d\n", tt->sData, ti.rect.left, ti.rect.top, ti.rect.right, ti.rect.bottom);
                SendMessage(ttCtl, TTM_ADDTOOL, 0, (LPARAM) (LPTOOLINFO) &ti);
            }
        }
    }
    _HYPlatformComponent::_Activate();
}

//__________________________________________________________________

void        _HYButtonBar::_Deactivate (void)
{
    if (activationFlag) {
        for (long k=0; k<enabledButtons.lLength; k++) {
            _MarkButtonForUpdate (enabledButtons.lData[k]);
        }
    }
    //SendMessage (ttCtl, TTM_ACTIVATE, 0, 0);
    if (ttCtl) {
        DestroyWindow (ttCtl);
    }
    ttCtl = nil;
    _HYPlatformComponent::_Deactivate();
}

//__________________________________________________________________

void        _HYButtonBar::_ComponentMouseExit (void)
{
    _UnpushButton();
}


//__________________________________________________________________
void        _HYPlatformButtonBar::_Paint (Ptr p)
{
    _HYButtonBar * theParent = (_HYButtonBar*)this;
    _HYRect * relRect = (_HYRect*)p;
    HDC     theContext = (HDC)relRect->width;
    RECT    cRect,iRect;
    cRect.left = relRect->left;
    cRect.right = relRect->right;
    cRect.top = relRect->top;
    cRect.bottom = relRect->bottom;

    if (!(theParent->settings.width&HY_COMPONENT_TRANSP_BG)) {
        FillRect (theContext,&cRect,backFill);
    }

    HRGN clipRgn   = CreateRectRgn (cRect.left,cRect.top,cRect.right,cRect.bottom);
    HPEN savePen   = (HPEN)SelectObject (theContext,buttonBorder1);

    if (!clipRgn) {
        warnError (-108);
    }
    SelectClipRgn (theContext,clipRgn);
    cRect.left = buttonRect.left;
    cRect.top = buttonRect.top;
    int   step = theParent->GetButtonDim()+2*HY_BUTTONBAR_BORDER;
    cRect.right = cRect.left+step;
    cRect.bottom = cRect.top+step;

    if (theParent->ButtonCount()) {
        if (otherDC) {
            for (long i=0; i<theParent->ButtonCount(); i++) {
                if (i&&(i%theParent->BarWidth()==0)) {
                    cRect.left = buttonRect.left;
                    cRect.top +=step;
                    cRect.bottom +=step;
                    cRect.right = cRect.left+step;
                }
                iRect = cRect;
                InflateRect (&iRect,-HY_BUTTONBAR_BORDER,-HY_BUTTONBAR_BORDER);
                RECT iRect2 = iRect;
                iRect2.right++;
                iRect2.bottom++;

                bool        paintDimmed = false;

                BITMAP    theBM;
                GetObject ((HBITMAP)theParent->buttons(i), sizeof (BITMAP), &theBM);

                SelectObject (otherDC, (HBITMAP)theParent->buttons(i));

                if (theParent->activationFlag) {
                    if (i==pushed) {
                        FillRect (theContext, &iRect2, blackIconFill);

                        //TransparentBlt     (theContext, iRect.left, iRect.top, iRect.right-iRect.left+1, iRect.bottom-iRect.top+1,
                        // otherDC, 0, 0, theBM.bmWidth, theBM.bmHeight, RGB(255,255,255));
                        DrawTransparentBitmap (theContext,(HBITMAP)theParent->buttons(i),iRect.left, iRect.top, iRect.right-iRect.left+1, iRect.bottom-iRect.top+1,RGB(255,255,255));
                    } else {
                        if (theParent->enabledButtons.Find(i)>=0)
                            StretchBlt   (theContext, iRect.left, iRect.top, iRect.right-iRect.left+1, iRect.bottom-iRect.top+1,
                                          otherDC, 0, 0, theBM.bmWidth, theBM.bmHeight, SRCCOPY);
                        else {
                            paintDimmed = true;
                        }
                    }
                } else {
                    paintDimmed = true;
                }

                if (paintDimmed) {

                    FillRect (theContext, &iRect2, dimIconFill);

                    StretchBlt   (theContext, iRect.left, iRect.top, iRect.right-iRect.left+1, iRect.bottom-iRect.top+1,
                                  otherDC, 0, 0, theBM.bmWidth, theBM.bmHeight, SRCPAINT);
                }

                MoveToEx (theContext,iRect.left-1,iRect.top-1,NULL);
                LineTo (theContext,iRect.right+1,iRect.top-1);
                LineTo (theContext,iRect.right+1,iRect.bottom+1);
                LineTo (theContext,iRect.left-1,iRect.bottom+1);
                LineTo (theContext,iRect.left-1,iRect.top-1);

                cRect.left +=step;
                cRect.right +=step;
            }

            SelectObject (otherDC, oDCBM);
        } else {
            _String errMsg = _String ("Failed to make CompatibleDC in _HYPlatformButtonBar::_Paint");
            ReportWarning (errMsg);
        }
    }
    SelectObject (theContext,savePen);
    SelectClipRgn (theContext,NULL);
    DeleteObject (clipRgn);

    (*theParent)._HYPlatformComponent::_Paint(p);
}
//__________________________________________________________________
_HYRect _HYPlatformButtonBar::_GetButtonRect (bool conv)
{
    _HYButtonBar* theParent = (_HYButtonBar*)this;
    _HYRect res;
    res.left   = buttonRect.left;
    res.right  = buttonRect.right;
    res.top    = buttonRect.top;
    res.bottom = buttonRect.bottom;
    if (conv) {
        POINT loc = {res.left, res.top};
        ClientToScreen (theParent->parentWindow, &loc);
        res.right += loc.x-res.left;
        res.bottom += loc.y-res.top;
        res.left   = loc.x;
        res.top    = loc.y;
    }
    return res;
}



//__________________________________________________________________
void        _HYPlatformButtonBar::_Update (Ptr p)
{
    _Paint (p);
}

//__________________________________________________________________
void        _HYPlatformButtonBar::_MarkButtonForUpdate (int i)
{
    _HYButtonBar* theParent = (_HYButtonBar*)this;
    RECT invRect;
    if ((i>=0)&&(i<theParent->ButtonCount())) {
        int hR = i%theParent->BarWidth(),
            vR = i/theParent->BarWidth(),
            step = 2*HY_BUTTONBAR_BORDER+theParent->GetButtonDim();

        invRect.left = buttonRect.left+hR*step;
        invRect.right = invRect.left+step;
        invRect.top = buttonRect.top+vR*step;
        invRect.bottom = invRect.top+step;
        if (forceUpdateForScrolling) {
            RECT    rel = HYRect2Rect (theParent->rel);
            RECT           tempRect;
            IntersectRect (&tempRect,&rel,&invRect);
            RedrawWindow (theParent->parentWindow, &tempRect, nil, RDW_UPDATENOW|RDW_NOCHILDREN);
        } else {
            InvalidateRect (theParent->parentWindow,&invRect,false);
        }
    }
}

//__________________________________________________________________
void        _HYPlatformButtonBar::_UnpushButton (void)
{
    if (pushed>=0) {
        _MarkButtonForUpdate(pushed);
        pushed = -1;
        lastMouseDown = -1;
    }
}


//__________________________________________________________________
void        _HYPlatformButtonBar::_SetDimensions (_HYRect r, _HYRect rel)
{
    _HYButtonBar* theParent = (_HYButtonBar*) this;
    theParent->_HYPlatformComponent::_SetDimensions (r,rel);
    _SetVisibleSize (rel);
}

//__________________________________________________________________
int         _HYPlatformButtonBar::_FindClickedButton (int h, int v)
{
    POINT localClick = {v,h};
    _HYButtonBar * parent = (_HYButtonBar*)this;
    if (PtInRect (&buttonRect, localClick)) {
        int v = localClick.y-buttonRect.top,
            h = localClick.x-buttonRect.left,
            step = 2*HY_BUTTONBAR_BORDER+parent->buttonDim,
            hR = h/step,
            vR = v/step;

        v-=vR*step;
        h-=hR*step;
        if ((v>HY_BUTTONBAR_BORDER)&&(v<step-HY_BUTTONBAR_BORDER)&&
                (h>HY_BUTTONBAR_BORDER)&&(h<step-HY_BUTTONBAR_BORDER)) {
            return hR+vR*parent->barW;
        }
    }
    return -1;

}

//__________________________________________________________________
void        _HYButtonBar::_DisplayToolTip      (void)
{
    //TBI
}


//__________________________________________________________________

bool _HYButtonBar::_ProcessOSEvent (Ptr vEvent)
{
    _HYWindowsUIMessage * theEvent = (_HYWindowsUIMessage *)vEvent;
    if (buttons.lLength) {
        switch (theEvent->iMsg) {
        case WM_LBUTTONDOWN: {
            POINT localClick;
            localClick.x = LOWORD (theEvent->lParam);
            localClick.y = HIWORD (theEvent->lParam);
            int h = _FindClickedButton (localClick.y,localClick.x);
            if ((h>=0)&&(enabledButtons.Find(h)>=0)) {
                if (pullDownButtons.Find (h)>=0) {
                    lastMouseDown = -1;
                    SendButtonPush(h);
                } else {
                    pushed = h;
                    lastMouseDown = h;
                    _MarkButtonForUpdate (h);
                }
            }
            return true;
        }
        case WM_LBUTTONUP: {
            if (pushed>=0) {
                POINT localClick;
                localClick.x = LOWORD (theEvent->lParam);
                localClick.y = HIWORD (theEvent->lParam);
                int h = _FindClickedButton (localClick.y,localClick.x);
                if (h==pushed) {
                    _MarkButtonForUpdate (h);
                    SendButtonPush (h);
                    pushed = -1;
                    lastMouseDown = -1;
                    _MarkButtonForUpdate (h);
                }
            }
            return true;
        }
        case WM_MOUSEMOVE : {
            if (lastMouseDown>=0) {
                POINT localClick;
                localClick.x = LOWORD (theEvent->lParam);
                localClick.y = HIWORD (theEvent->lParam);
                int h = _FindClickedButton (localClick.y,localClick.x);
                if (h!=lastMouseDown) {
                    if (pushed>=0) {
                        pushed = -1;
                        _MarkButtonForUpdate (lastMouseDown);
                    }
                } else {
                    if (pushed==-1) {
                        pushed = lastMouseDown;
                        _MarkButtonForUpdate (lastMouseDown);
                    }

                }
            }
            return true;
        }
        }
    }

    return _HYPlatformComponent::_ProcessOSEvent (vEvent);
}

//EOF