/*
    Button component for Win32.

    Sergei L. Kosakovsky Pond, May 2000 - December 2002
*/

#include "HYLabel.h"
#include "HYUtils.h"
#include "HYGraphicPane.h"

//__________________________________________________________________

_HYPlatformLabel::_HYPlatformLabel(void)
{

    backFill = CreateSolidBrush(RGB(0xff,0xff,0xff));
    if (!backFill) {
        warnError (-108);
    }
    fc = 0;
    pLabelFont = nil;
    labelPen = nil;
}

//__________________________________________________________________

_HYPlatformLabel::~_HYPlatformLabel(void)
{
    if (backFill) {
        DeleteObject (backFill);
    }

    if (pLabelFont) {
        DeleteObject (pLabelFont);
    }

    if (labelPen) {
        DeleteObject (labelPen);
    }

}

//__________________________________________________________________

void        _HYPlatformLabel::_SetBackColor (_HYColor& c)
{
    if (backFill) {
        DeleteObject(backFill);
    }

    backFill = CreateSolidBrush(RGB(c.R,c.G,c.B));
}

//__________________________________________________________________

void        _HYPlatformLabel::_SetText (void)
{
}


//__________________________________________________________________

void        _HYPlatformLabel::_SetForeColor (_HYColor& c)
{
    HDC  theDC = GetDC(((_HYLabel*)this)->parentWindow);
    fc = HYColor2ColorRef (c,theDC);
    ReleaseDC (((_HYLabel*)this)->parentWindow, theDC);
    if (labelPen) {
        DeleteObject(labelPen);
    }
    labelPen = (HPEN)CreatePen (PS_SOLID,1,fc);
}

//__________________________________________________________________

void        _HYPlatformLabel::_SetFont (_HYFont& f)
{
    if (pLabelFont) {
        DeleteObject(pLabelFont);
    }
    pLabelFont = CreateFont (f.size,0,0,0,(f.style&HY_FONT_BOLD)?FW_BOLD:FW_NORMAL,f.style&HY_FONT_ITALIC,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
                             CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,f.face.sData);
}

//__________________________________________________________________
void        _HYPlatformLabel::_Update (Ptr p)
{
    _Paint (p);
}

//__________________________________________________________________
void        _HYPlatformLabel::_SetDimensions (_HYRect r, _HYRect rel)
{
    _HYLabel* theParent = (_HYLabel*) this;
    theParent->_HYPlatformComponent::_SetDimensions (r,rel);
    _SetVisibleSize (rel);
}

//__________________________________________________________________
void        _HYPlatformLabel::_SetVisibleSize (_HYRect rel)
{
    _HYLabel* theParent = (_HYLabel*) this;
    labelRect.left=rel.left;
    labelRect.top = rel.top;
    _HYRect s = theParent->_SuggestDimensions();
    labelRect.right = labelRect.left+s.right;
    labelRect.bottom = labelRect.top+s.bottom;
    AlignRectangle (rel, labelRect, theParent->GetAlignFlags());
}



//__________________________________________________________________
void        _HYPlatformLabel::_Paint (Ptr p)
{

    _HYLabel * theParent = (_HYLabel*)this;

    _HYRect * relRect = (_HYRect*)p;
    HDC     theContext = (HDC)relRect->width;
    RECT    cRect;
    cRect.left = relRect->left;
    cRect.right = relRect->right;
    cRect.top = relRect->top;
    cRect.bottom = relRect->bottom;

    if (!(theParent->settings.width&HY_COMPONENT_TRANSP_BG)) {
        FillRect (theContext,&cRect,backFill);
    }

    if (!(theParent->settings.width&HY_COMPONENT_WELL)) {
        InflateRect (&cRect,-2,-2);
    }

    HPEN     savePen = (HPEN)SelectObject (theContext,labelPen);
    HFONT    saveFont = (HFONT)SelectObject (theContext,pLabelFont);
    COLORREF saveColor = GetTextColor (theContext);
    SetBkMode (theContext,TRANSPARENT);
    SetTextAlign (theContext,TA_BASELINE);
    if (theParent->HasShadow()) {
        _HYColor fcc = theParent->GetForeColor(),sc;
        sc.R = fcc.R/4;
        sc.B  = fcc.B/4;
        sc.G = fcc.G/4;
        SetTextColor (theContext,HYColor2ColorRef(sc,theContext));
        ExtTextOut(theContext,labelRect.left+3,labelRect.bottom-3,ETO_CLIPPED,&cRect,theParent->GetText().sData,theParent->GetText().sLength,NULL);
        sc.R = fcc.R/2;
        sc.B  = fcc.B/2;
        sc.G = fcc.G/2;
        SetTextColor (theContext,HYColor2ColorRef(sc,theContext));
        ExtTextOut(theContext,labelRect.left+1,labelRect.bottom-1,ETO_CLIPPED,&cRect,theParent->GetText().sData,theParent->GetText().sLength,NULL);

    }
    SetTextColor (theContext,fc);
    ExtTextOut(theContext,labelRect.left+2,labelRect.bottom-2,ETO_CLIPPED,&cRect,theParent->GetText().sData,theParent->GetText().sLength,NULL);
    SelectObject (theContext,savePen);
    SelectObject (theContext,saveFont);
    SetTextColor (theContext,saveColor);

    (*theParent)._HYPlatformComponent::_Paint(p);
}

//__________________________________________________________________
_HYRect _HYLabel::_SuggestDimensions (void)
{
    _HYRect res = {10,100,10,100,HY_COMPONENT_NO_SCROLL};
    HFONT lF, cF;
    lF = CreateFont (labelFont.size,0,0,0,(labelFont.style&HY_FONT_BOLD)?FW_BOLD:FW_NORMAL,labelFont.style&HY_FONT_ITALIC,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
                     CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,labelFont.face.sData);
    HDC  parentDC = GetDC (parentWindow);
    cF = (HFONT)SelectObject (parentDC,lF);
    SIZE textSize;
    if(GetTextExtentPoint32(parentDC,labelText.sData,labelText.sLength,&textSize)) {
        res.left = res.right = textSize.cx+5;
    }
    if (cF) {
        SelectObject (parentDC,cF);
    }
    DeleteObject(lF);
    ReleaseDC (parentWindow, parentDC);
    return res;
}


// EOF