/*
    Win32 Portions of the model window

    Sergei L. Kosakovsky Pond, Spring 2000 - February 2003.
*/

#include "HYModelWindow.h"
#include "HYUtils.h"

#define     HY_MDL_WIN32_MENU_BASE  9200

//__________________________________________________________________

void _HYModelWindow::_SetMenuBar(void)
{
    _HYWindow::_SetMenuBar();

    HMENU     windowMenu = GetMenu (theWindow),
              ptMenu     = GetSubMenu(windowMenu,2);

    if (!ptMenu) {
        ptMenu = CreateMenu();

        HMENU        rateMenu = ListToPopUpMenu (rateOptions, HY_MDL_WIN32_MENU_BASE+99),
                     saveMenu = CreatePopupMenu ();

        checkPointer (ptMenu);
        checkPointer (rateMenu);
        checkPointer (saveMenu);

        CheckMenuItem (rateMenu, rateChoice, MF_BYPOSITION|MF_CHECKED);


        InsertMenu      (ptMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_MDL_WIN32_MENU_BASE, "&Model Name");
        InsertMenu      (ptMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_POPUP, (UINT)rateMenu, "&View Options");

        InsertMenu      (windowMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_POPUP, (UINT)ptMenu, "&Model");

        InsertMenu      (saveMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_WINDOW_MENU_ID_FILE+1, "&Save\tCtrl-S");
        InsertMenu      (saveMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_WINDOW_MENU_ID_FILE+3, "Save &As...");

        ModifyMenu   (GetSubMenu(windowMenu,0), 0, MF_BYPOSITION|MF_POPUP, (UINT) saveMenu , "&Save");

        _AddStandardAccels();
        _BuildAccelTable  (true);
        accels.Clear();

    }

    ptMenu = GetSubMenu (windowMenu,1);
    EnableMenuItem (ptMenu,6,MF_BYPOSITION|MF_ENABLED);
    EnableMenuItem (ptMenu,2,MF_BYPOSITION|MF_ENABLED);

    DrawMenuBar(theWindow);
}


//__________________________________________________________________

void _HYModelWindow::_UnsetMenuBar(void)
{
}

//__________________________________________________________________


bool        _HYModelWindow::_ProcessMenuSelection (long msel)
{
    switch (msel) {
    case HY_WINDOW_MENU_ID_FILE+1: // save menu
    case HY_WINDOW_MENU_ID_FILE+3: { // save as menu
        DoSave (msel-HY_WINDOW_MENU_ID_FILE-2);
        return true;
    }

    case HY_WINDOW_MENU_ID_FILE+2: { // print
        _HYTable* t = (_HYTable*)GetCellObject (MODEL_MATRIX_ROW,4);
        t->_PrintTable((_HYTable*)GetCellObject (MODEL_MATRIX_ROW-1,4));
        return true;
    }

    case HY_WINDOW_MENU_ID_EDIT+1: { // copy
        DoCopyCell ();
        return true;
    }

    case HY_WINDOW_MENU_ID_EDIT+3: { // paste
        DoPasteToCells();
        return true;
    }

    case HY_WINDOW_MENU_ID_EDIT+5: { // select all
        DoSelectAll();
        return true;
    }

    case HY_MDL_WIN32_MENU_BASE: { // model menu
        DoEditModelName ();
        return true;
    }

    default: { // rate menu
        msel -= HY_MDL_WIN32_MENU_BASE+100;
        if (msel>=0) {
            if (msel!=rateChoice) {
                HMENU           rateMenu = GetSubMenu (GetSubMenu (GetMenu (theWindow),2),1);
                CheckMenuItem   (rateMenu,rateChoice,MF_BYPOSITION|MF_UNCHECKED);
                rateChoice = msel;
                CheckMenuItem   (rateMenu,rateChoice,MF_BYPOSITION|MF_CHECKED);
                taint = true;
                DrawMenuBar(theWindow);
            }
        }
        return true;
    }
    }

    if (_HYTWindow::_ProcessMenuSelection(msel)) {
        return true;
    }

    return false;
}

//__________________________________________________________________

void _HYModelWindow::_UpdateEditMenu (bool c, bool p)
{
    HMENU  t = GetSubMenu (GetMenu (theWindow),2);
    if (c) {
        EnableMenuItem (t,2,MF_BYPOSITION|MF_ENABLED);
    } else {
        EnableMenuItem (t,2,MF_BYPOSITION|MF_GRAYED);
    }
    if (p) {
        EnableMenuItem (t,4,MF_BYPOSITION|MF_ENABLED);
    } else {
        EnableMenuItem (t,4,MF_BYPOSITION|MF_GRAYED);
    }

    DrawMenuBar(theWindow);
}

//__________________________________________________________________

bool _HYModelWindow::_CheckClipboard (void)
{
    clipboardString = empty;
    HANDLE  scrapHandle = GetClipboardData (CF_TEXT);

    if (scrapHandle) {
        _String cText ((char*)scrapHandle);
        skipWarningMessages = true;
        _Formula f (cText,nil,false);
        skipWarningMessages = false;
        if (f.GetList().lLength) {
            clipboardString = cText;
            SyncEditBox ();
        }
    }
    return clipboardString.sLength;
}

//__________________________________________________________________

void _HYModelWindow::_SetClipboard (void)
{
    if (clipboardString.sLength) {
        PlaceStringInClipboard (clipboardString, (Ptr)theWindow);
    }
}

//EOF