/*
    A painting canvas with double buffer. Windows.

    Sergei L. Kosakovsky Pond, May 2000-June 2002
*/

#ifndef _HYPGRAPHICPANE_
#define _HYPGRAPHICPANE_
#pragma once

#include <windows.h>
#include "HYBaseGUI.h"

//__________________________________________________________________

class  _HYPlatformGraphicPane
{

public:

    _HYPlatformGraphicPane(int, int,int);
    // initial size

    virtual ~_HYPlatformGraphicPane();

    virtual void        _SetPaneSize  (int,int,int);
    virtual void        _DrawLine    (_HYRect);
    virtual void        _DrawHatchedLine     (_HYRect);
    // from, to , width
    virtual void        _DisplayText (_String,int,int,bool);
    // text, where, left-right or top-bottom
    virtual void        _DrawRect    (_HYRect);
    virtual void        _FillRect    (_HYRect);
    virtual void        _EraseRect   (_HYRect);
    virtual void        _DrawOval    (_HYRect);
    virtual void        _FillOval    (_HYRect);
    virtual void        _EraseOval   (_HYRect);
    virtual void        _DrawArc     (_HYRect,int,int);
    virtual void        _FillArc     (_HYRect,int,int);
    virtual void        _EraseArc    (_HYRect,int,int);
    virtual void        _SetColor    (_HYColor);
    virtual void        _SetFont     (_HYFont);
    virtual void        _StartDraw   (void);
    virtual void        _EndDraw     (void);
    virtual void        _SetPort     (Ptr);
    virtual void        _DrawPicRes  (_HYRect&, long);

// new

    virtual void        _SetBColor   (_HYColor);
    virtual void        _DisplayText  (_String&,_HYRect&, char);
    virtual void        _DisplayChar  (char,int,int);
    virtual void        _SetFontSize (long);
    virtual void        _SlidePane   (int dv, int dh);
    virtual void        _SlideRect   (_HYRect&r ,int dv, int dh);
    virtual void        _InvertRect  (_HYRect&);
    virtual void        _SavePicture (_String);
    virtual Ptr         _DefinePolygon
    (_SimpleList&);
    virtual void        _KillPolygon (Ptr);
    virtual void        _DrawPolygon (Ptr,long = 1);
    virtual void        _FillPolygon (Ptr);
    virtual void        _ErasePolygon(Ptr);
    virtual void        _SetDialogBG (void);
    virtual void        _CopyToClipboard
    (void);

    HDC          thePane;
    int          lastPenSize;

    HBITMAP      paneBitMap,
                 oldMap;

protected:

    void         CheckPen (_HYRect&, bool force = false);
    HBRUSH       fillColor,
                 backColor,
                 oldBrush;


    HPEN         oldPen;
    HFONT        oldFont;

};

extern   HINSTANCE    ProgramInstance;

POINT                 DrawTransparentBitmap(HDC, HBITMAP, short,short,short,short, COLORREF);

extern   HDC          otherDC;
extern   HBITMAP      oDCBM;


#endif

//EOF