/*
    A Windows window object - a window/title/size-box/scroll-bars handler.

    Sergei L. Kosakovsky Pond, June 2000-June 2002.
*/

#ifndef _HYPWINDOW_
#define _HYPWINDOW_
#pragma once

#define  MAX_CONTROL_VALUE      100000000

#define  HY_WINDOW_MENU_ID_FILE 5000
#define  HY_WINDOW_MENU_ID_EDIT 5050

#include "hy_strings.h"
#include <windows.h>
#include <commdlg.h>
#include "HYBaseGUI.h"

struct  _HYWindowsUIMessage {
    UINT    iMsg;
    WPARAM  wParam;
    LPARAM  lParam;
    LRESULT res;
};

//__________________________________________________________________

class _HYPlatformWindow
{

public:

    _HYPlatformWindow(unsigned char,_String,bool,Ptr);
    // flags, title, visibility

    virtual ~_HYPlatformWindow();

    void        _SetTitle               (_String);
    void        _Show                   (void);
    void        _Hide                   (void);
    virtual long        _Grow                   (Ptr);
    virtual bool        _Close                  (Ptr);
    virtual void        _Move                   (Ptr);
    void        _SelectWindow           (void);
    virtual void        _SetWindowRectangle     (int,int,int,int,bool=true);
    virtual void        _SetContentSize         (int,int);
    virtual void        _Paint                  (Ptr);
    virtual void        _Update                 (Ptr);
    virtual void        _Activate               (void);
    virtual void        _Deactivate             (void);
    virtual bool        _ProcessOSEvent         (Ptr);
    virtual void        _VisibleContents        (int&,int&,int&,int&);
    bool        _IsHScroll              (HWND);
    virtual bool        _ProcessMenuSelection   (long) {
        return false;
    }
    virtual void        _SetMenuBar             (void);
    virtual void        _UnsetMenuBar           (void);
    virtual Ptr         _GetOSWindowData        (void) {
        return (Ptr)theWindow;
    }

// new

    virtual void        _SetPosition            (int,int);
    virtual void        _BringWindowToFront     (void);
    virtual _HYRect     _GetWindowRect          (void);
    virtual _String&    _GetTitle               (void);
    void        _SetWindowBackColor     (_HYColor);

    virtual void        _AddStandardAccels      (void);
    virtual void        _BuildAccelTable        (bool force = false);

// end new

    HWND        theWindow,
                oldFrontWindow;
    HMENU       windowMenu;
    RECT        newVRect ();
    RECT        newHRect ();
    HACCEL      menuKeys;

    unsigned char
    flags;

    _SimpleList accels;

    Ptr         parentWindowPtr;
};

//__________________________________________________________________

class _HYPlatformTWindow
{

public:

    _HYPlatformTWindow  (Ptr) {
        idleTimer = 0;
        hWindowPad = 0;
        vWindowPad = 0;
        trackMouseComponent = nil;
    }

    virtual         ~_HYPlatformTWindow (void) {}
    virtual void    _SetWindowRectangle     (int,int,int,int,bool=true);

    UINT_PTR idleTimer;

    long     hWindowPad,
             vWindowPad;


    _HYGuiObject*
    trackMouseComponent;


//virtual void   _Activate          (void);
//virtual void   _Deactivate        (void);

};

//__________________________________________________________________

class _HYPlatformPWindow
{

public:

    _HYPlatformPWindow          (void);

    virtual ~_HYPlatformPWindow         (void);

    virtual void _StartPicture          (void);
    virtual void _EndPicture            (void);
    virtual void _DrawPicture           (_HYRect);

private:

    HENHMETAFILE     savedPic;
    HDC              stashedDC;

};


//__________________________________________________________________

COLORREF  HYColor2ColorRef (_HYColor&, HDC);

extern    bool          forceUpdateForScrolling;
extern    BOOL          UserAbortFlag;
extern    HBRUSH        windowStatusBarBrush;
extern    HFONT         statusBarPlain;
extern    HWND          PrintDialogHandle;
extern    char          WinName[],
          AppName[];

extern    HINSTANCE     ProgramInstance;
extern    HWND          WindowHandle;
extern    HBRUSH        windowStatusBarBrush;
extern    HPEN          _BLACKPEN_;

extern    HBITMAP       redButtonIcon,
          yellowButtonIcon,
          orangeButtonIcon,
          greenButtonIcon;

BOOL      CALLBACK      PrintDialogProc(HWND, UINT, WPARAM, LPARAM);
BOOL      CALLBACK      AbortProc(HDC, int);
HDC                     GetPrinterDeviceContext(HWND);

#define                 IDD_FNAME               10
#define                 IDLE_WINDOW_TIMER       111
#define                 GLOBAL_QUEUE_TIMER      222

extern  _SimpleList     windowPtrs,
        windowObjects,
        windowObjectRefs;

int     MessageLoop     (bool = true, bool = true);

void    _PaintTheCircle (HBITMAP, HWND, HDC);
#endif

//EOF