/*
    A pull down menu object for MacOS.

    Sergei L. Kosakovsky Pond, July 2000-June 2002.
*/

#ifndef _HYPPULLDOWNMENU_
#define _HYPPULLDOWNMENU_
#pragma once

#include "HYBaseGUI.h"
#include "Windows.h"
#include <strings.h>

//__________________________________________________________________

class _HYPlatformPullDown
{

public:

    _HYPlatformPullDown(void);
    // flags, title, visibility

    virtual ~_HYPlatformPullDown(void);

    virtual void        _AddMenuItem     (_String&, long);
    virtual void        _SetBackColor    (_HYColor&);
    virtual void        _Duplicate       (Ptr);
    virtual void        _DeleteMenuItem  (long);
    virtual long        _GetSelection    (void);
    virtual void        _SetDimensions   (_HYRect,_HYRect);
    virtual void        _SetVisibleSize  (_HYRect);
    virtual void        _EnableItem      (long, bool);


    virtual void        _Paint (Ptr p);
    virtual void        _Update(Ptr p);

// new

    virtual void        _MarkItem        (long, char);
    virtual char        _ItemMark        (long);

// end new

    HWND         myMenu;
    HBRUSH       backFill;
    long         selection, menuWidth;
    _List        disabledItems;
    _SimpleList  disabledIndices;
    RECT         menuRect;
};

//__________________________________________________________________

class _HYPlatformLabel
{

public:

    _HYPlatformLabel(void);
    // flags, title, visibility

    virtual ~_HYPlatformLabel(void);

    virtual void        _SetBackColor    (_HYColor&);
    virtual void        _SetForeColor    (_HYColor&);
    virtual void        _SetDimensions   (_HYRect,_HYRect);
    virtual void        _SetVisibleSize  (_HYRect);
    virtual void        _SetFont         (_HYFont&);

    virtual void        _Paint (Ptr p);
    virtual void        _Update(Ptr p);

    HBRUSH       backFill;
    COLORREF     fc;
    RECT         labelRect;
    HFONT        pLabelFont;
    HPEN         labelPen;
};

//__________________________________________________________________

class _HYPlatformButtonBar
{

public:

    _HYPlatformButtonBar(void);

    virtual ~_HYPlatformButtonBar(void);

    virtual void        _SetBackColor    (_HYColor&);
    virtual void        _SetDimensions   (_HYRect,_HYRect);
    virtual void        _SetVisibleSize  (_HYRect);

    virtual void        _Paint (Ptr p);
    virtual void        _Update(Ptr p);
    void        _DisposeButtons (void);
    void        _MarkButtonForUpdate(int);

    HBRUSH       backFill;
    RECT         buttonRect;
    int          pushed;
};

//__________________________________________________________________

#endif

//EOF