/*
    Win32 Portions of the picture window class

    Sergei L. Kosakovsky Pond, Spring 2000 - January 2003.
*/

#include "HYGWindow.h"
#include "HYCanvas.h"
#include "errorfns.h"
#include "HYDialogs.h"

#define  HY_PWINDOW_WIN32_MENU_BASE  9000


//__________________________________________________________________
// _HYPlatformPWindow
//__________________________________________________________________

_HYPlatformPWindow::_HYPlatformPWindow          (void)
{
    savedPic  = nil;
    stashedDC = nil;
}

//__________________________________________________________________

_HYPlatformPWindow::~_HYPlatformPWindow         (void)
{
    if (savedPic) {
        DeleteEnhMetaFile (savedPic);
    }
}

//__________________________________________________________________

void    _HYPlatformPWindow::_StartPicture   (void)
{
    _HYPWindow*     theParent = (_HYPWindow*)    this;

    HDC             oldDC = theParent->thePane;

    if (savedPic) {
        DeleteEnhMetaFile (savedPic);
    }

    long    iXMM = GetDeviceCaps (oldDC, HORZSIZE),
            iYMM = GetDeviceCaps (oldDC, VERTSIZE),
            iXPX = GetDeviceCaps (oldDC, HORZRES),
            iYPX = GetDeviceCaps (oldDC, VERTRES);

    RECT    bounds = {0,0, (theParent->w*100*iXMM)/iXPX,
                      (theParent->h*100*iYMM)/iYPX
                     };



    if (!(oldDC = CreateEnhMetaFile (NULL, NULL, &bounds, NULL))) {
        _String errMsg = _String ("Failed to create an enhanced meta file in call to _StartPicture. Windows Error:") & (long)GetLastError() & '.';
        WarnError (errMsg);
        return;
    }

    stashedDC = theParent->thePane;
    theParent->thePane = oldDC;
    SetBkMode (oldDC, TRANSPARENT);
}

//__________________________________________________________________

void    _HYPlatformPWindow::_EndPicture     (void)
{
    if (stashedDC) {
        _HYPWindow*     theParent = (_HYPWindow*)    this;
        savedPic = CloseEnhMetaFile (theParent->thePane);

        RECT    bounds = {0,0, theParent->w,
                          theParent->h
                         };


        theParent->thePane = stashedDC;
        PlayEnhMetaFile (stashedDC, savedPic, &bounds);
        stashedDC = nil;
    }
}

//__________________________________________________________________

void    _HYPlatformPWindow::_DrawPicture    (_HYRect r)
{
    RECT R = HYRect2Rect (r);
    if (savedPic) {
        PlayEnhMetaFile (((_HYPWindow*)this)->thePane, savedPic, &R);
    }
}

//__________________________________________________________________
// _HYPWindow
//__________________________________________________________________

void        _HYPWindow::_PrintPWindow(void)
{
    DOCINFO                 di = {sizeof(DOCINFO), "HYPHY.out", NULL };
    PRINTDLG                pd;
    BOOL                    SuccessFlag;

    pd.lStructSize         = sizeof(PRINTDLG);
    pd.hwndOwner           = theWindow;
    pd.hDevMode            = NULL;
    pd.hDevNames           = NULL;
    pd.hDC                 = NULL;
    pd.Flags               = PD_COLLATE | PD_RETURNDC | PD_NOSELECTION;
    pd.nFromPage           = 1;
    pd.nToPage             = 0xffff;
    pd.nMinPage            = 1;
    pd.nMaxPage            = 0xffff;
    pd.nCopies             = 1;
    pd.hInstance           = NULL;
    pd.lCustData           = 0L;
    pd.lpfnPrintHook       = NULL;
    pd.lpfnSetupHook       = NULL;
    pd.lpPrintTemplateName = NULL;
    pd.lpSetupTemplateName = NULL;
    pd.hPrintTemplate      = NULL;
    pd.hSetupTemplate      = NULL;

    if (!PrintDlg(&pd)) {
        return;
    }

    if (pd.hDC == NULL) {
        pd.hDC = GetPrinterDeviceContext(theWindow);
    }


    EnableWindow(theWindow, FALSE);

    SuccessFlag   = TRUE;
    UserAbortFlag = FALSE;

    PrintDialogHandle = CreateDialog(GetModuleHandle(NULL), (LPCTSTR)"PrintDlgBox", theWindow,
                                     PrintDialogProc);
    SetDlgItemText(PrintDialogHandle, IDD_FNAME, "Chart Printing...");

    SetAbortProc(pd.hDC, AbortProc);

    if (StartDoc(pd.hDC, &di) > 0) {
        HDC         windowDC = GetDC (theWindow);

        long        printW = GetDeviceCaps(pd.hDC, HORZRES),
                    printH = GetDeviceCaps(pd.hDC, VERTRES),

                    hRes = GetDeviceCaps(pd.hDC, LOGPIXELSX),
                    vRes = GetDeviceCaps(pd.hDC, LOGPIXELSY),

                    screenHRes = GetDeviceCaps(windowDC, LOGPIXELSX),
                    screenVRes = GetDeviceCaps(windowDC, LOGPIXELSY),

                    fromPage = pd.nMinPage,
                    toPage   = pd.nMaxPage;


        if (pd.Flags & PD_PAGENUMS) {
            fromPage = pd.nFromPage;
            toPage   = pd.nToPage;
        }

        ReleaseDC   (theWindow, windowDC);
        hRes = printW*((_Parameter)screenHRes/hRes);
        vRes = printH*((_Parameter)screenVRes/vRes);
        screenHRes = printW;
        screenVRes = printH;

        printW = hRes;
        printH = vRes;

        if (StartPage (pd.hDC) <= 0) {
            SuccessFlag = FALSE;
        } else {
            SetMapMode  (pd.hDC, MM_ISOTROPIC);
            SetWindowExtEx (pd.hDC, hRes, vRes,nil);
            SetViewportExtEx (pd.hDC, screenHRes, screenVRes, nil);

            _Parameter sx = 1., sy = 1.;

            if (printW<w) {
                sx = (_Parameter)printW/w;
            }
            if (printH<h) {
                sy = (_Parameter)printH/h;
            }

            if (sx>sy) {
                sx = sy;
            } else {
                sy = sx;
            }

            _HYRect         drect = {0,0,h*sy,w*sx,0};
            drect.left   = (printW-drect.right)/2;
            drect.right += drect.left;
            drect.top    = (printH-drect.bottom)/2;
            drect.bottom+= drect.top;

            HDC         saveDC = thePane;

            thePane = pd.hDC;
            _DrawPicture    (drect);
            thePane = saveDC;

            if (EndPage (pd.hDC) <= 0) {
                SuccessFlag = FALSE;
            }
        }
    } else {
        SuccessFlag = FALSE;
    }

    if (SuccessFlag) {
        SuccessFlag = (EndDoc(pd.hDC)>0);
    }

    if (!UserAbortFlag) {
        EnableWindow(theWindow, TRUE);
        DestroyWindow(PrintDialogHandle);
    }

    DeleteDC (pd.hDC);

    if (!SuccessFlag && !UserAbortFlag) {
        _String errMsg = _String("Failed to print the picture. Windows Error:") & (long)GetLastError();
        ProblemReport (errMsg,nil);
    }
}

//__________________________________________________________________

void _HYPWindow::_SetWindowRectangle(int top, int left, int bottom, int right, bool ss)
{
    _HYPlatformWindow::_SetWindowRectangle (top,left,bottom,right, ss);
    SetPaneSize     (bottom-top,right-left,depth);
    SetContentSize  (right-left,bottom-top);
}

//__________________________________________________________________

void    _HYPWindow::_Paint (Ptr p)
{
    RECT          srcRect  = {0,0,w,h},
                  destRect = srcRect;

    InvalidateRect (theWindow,&destRect,FALSE);
    PAINTSTRUCT      thePS;
    HDC theContext = BeginPaint (theWindow,&thePS);
    BitBlt (theContext,0,0,srcRect.right-srcRect.left,srcRect.bottom-srcRect.top,
            thePane,srcRect.left,srcRect.top,SRCCOPY);
    EndPaint (theWindow,&thePS);


}

//__________________________________________________________________

void    _HYPWindow::_Update (Ptr p)
{
    _Paint (p);
}

//__________________________________________________________________

long _HYPWindow::_Grow(Ptr theData)
{
    _HYPlatformWindow::_Grow (theData);
    RECT myDims;
    GetClientRect (theWindow,&myDims);

    SetWindowRectangle (0,0,myDims.bottom,myDims.right,false);

    GetClientRect  (theWindow,&myDims);
    InvalidateRect (theWindow,&myDims,false);
    return 0;
}

//__________________________________________________________________

bool        _HYPWindow::_ProcessMenuSelection (long msel)
{
    if (_HYWindow::_ProcessMenuSelection(msel)) {
        return true;
    }

    bool        done = false;

    switch (msel) {
    case HY_WINDOW_MENU_ID_FILE+2:
        _PrintPWindow();
        done = true;
        break;

    case HY_PWINDOW_WIN32_MENU_BASE:
        Zoom (1.1);
        done = true;
        break;

    case HY_PWINDOW_WIN32_MENU_BASE+1:
        Zoom (.9);
        done = true;
        break;

    case HY_PWINDOW_WIN32_MENU_BASE+2:
        OriginalSize();
        done = true;
        break;
    }

    if (!done) {
        return _HYGWindow::_ProcessMenuSelection (msel);
    }

    return done;
}

//__________________________________________________________________

void _HYPWindow::_SetMenuBar(void)
{

    _HYGWindow::_SetMenuBar();

    HMENU            windowMenu = GetMenu (theWindow),
                     chartMenu =  GetSubMenu(windowMenu,2);

    if (!chartMenu) {
        chartMenu   = CreateMenu();

        InsertMenu   (chartMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PWINDOW_WIN32_MENU_BASE  , "&Enlarge\tCtrl-1");
        InsertMenu   (chartMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PWINDOW_WIN32_MENU_BASE+1, "&Shrink\tCtrl-2");
        InsertMenu   (chartMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PWINDOW_WIN32_MENU_BASE+2, "&Original Size\tCtrl-3");

        InsertMenu   (windowMenu, 2, MF_BYPOSITION|MF_POPUP, (UINT) chartMenu , "&Image");


        accels       << (FCONTROL|FVIRTKEY);
        accels       << '1';
        accels       << HY_PWINDOW_WIN32_MENU_BASE;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << '2';
        accels       << HY_PWINDOW_WIN32_MENU_BASE+1;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << '3';
        accels       << HY_PWINDOW_WIN32_MENU_BASE+2;

        _AddStandardAccels();
        _BuildAccelTable  (true);
        accels.Clear();
    }

    DrawMenuBar(theWindow);

}

//__________________________________________________________________

void _HYPWindow::_UnsetMenuBar(void)
{

}

//__________________________________________________________________

bool _HYPWindow::_ProcessOSEvent (Ptr vEvent)
{
    _HYWindowsUIMessage * theEvent = (_HYWindowsUIMessage *)vEvent;

    switch (theEvent->iMsg) {
    case WM_GETMINMAXINFO:

        MINMAXINFO* windowInfo = (MINMAXINFO*)theEvent->lParam;

        windowInfo->ptMinTrackSize.x = 10;
        windowInfo->ptMinTrackSize.y = 10;
        windowInfo->ptMaxSize.x=windowInfo->ptMaxTrackSize.x = 0x7777;
        windowInfo->ptMaxSize.y=windowInfo->ptMaxTrackSize.y = 0x7777;

        return false;
        break;
    }

    return _HYPlatformWindow::_ProcessOSEvent (vEvent);
}

//__________________________________________________________________
//EOF