/*
    Win32 Portions of the parameter table class

    Sergei L. Kosakovsky Pond, Spring 2000 - January 2003.
*/

#include "HYParameterTable.h"
#include "HYUtils.h"

#define     HY_PT_WIN32_MENU_BASE  9000

//__________________________________________________________________

void _HYParameterTable::_SetMenuBar(void)
{
    _HYWindow::_SetMenuBar();

    HMENU     windowMenu = GetMenu (theWindow),
              ptMenu     = GetSubMenu(windowMenu,2);

    if (!ptMenu) {
        ptMenu = CreateMenu();
        HMENU viewMenu = CreatePopupMenu ();

        checkPointer (ptMenu);
        checkPointer (viewMenu);

        InsertMenu      (viewMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+10, "&Local Parameters");
        InsertMenu      (viewMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+11, "&Global Parameters");
        InsertMenu      (viewMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+12, "&Constrained Parameters");
        InsertMenu      (viewMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+13, "&Rate Classes");
        InsertMenu      (viewMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+14, "&Trees");

        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_POPUP, (UINT)viewMenu, "&View Options");
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_SEPARATOR, 0, nil);
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE  , "&Recalculate LF\tCtrl-U");
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+1, "&Optimize LF\tCtrl-T");
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_SEPARATOR, 0, nil);
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+2, "&Enter Command");
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+3, "Remove &Unused Parameters");
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_SEPARATOR, 0, nil);
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+4, "Covariance, Sampler and C&I");
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+5, "Likelihood Pro&file Plot");
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_SEPARATOR, 0, nil);
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+6, "Cate&gories Processor");
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_SEPARATOR, 0, nil);
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+7, "Sele&ct Parameters");
        InsertMenu      (ptMenu,    0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_PT_WIN32_MENU_BASE+8, "Open Selection in &Table");

        _UpdateViewMenu();

        InsertMenu      (windowMenu, 2, MF_BYPOSITION|MF_POPUP, (UINT) ptMenu , "&Likelihood");

        accels       << (FCONTROL|FVIRTKEY);
        accels       << 'U';
        accels       << HY_PT_WIN32_MENU_BASE;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << 'T';
        accels       << HY_PT_WIN32_MENU_BASE+1;


        _AddStandardAccels();
        _BuildAccelTable  (true);
        accels.Clear();

    }

    ptMenu = GetSubMenu (windowMenu,1);
    EnableMenuItem (ptMenu,6,MF_BYPOSITION|MF_ENABLED);
    if (undoCommands.lLength) {
        EnableMenuItem (ptMenu,0,MF_BYPOSITION|MF_ENABLED);
    }

    DrawMenuBar(theWindow);
}

//__________________________________________________________________


bool        _HYParameterTable::_ProcessMenuSelection (long msel)
{

    _HYTable*   table = (_HYTable*)GetCellObject(HY_PARAMETER_TABLE_TABLE_ROW,0);
    bool        res = false;

    switch (msel) {
    case HY_WINDOW_MENU_ID_FILE+1: { // save
        DoSave ();
        res = true;
        break;
    }
    case HY_WINDOW_MENU_ID_FILE+2: { // print
        _SimpleList columns,
                    sel;
        columns << 0;
        columns << 1;
        columns << 2;
        columns << 3;
        table->GetSelection (sel);
        char    resp = 3;
        if (sel.lLength) {
            _String pr ("Would you like to print only the selected cells? (Click \"No\" to print the entire table).");
            resp = YesNoCancelPrompt (pr);
        }
        if (resp == 3) {
            table->_PrintTable(columns,(_HYTable*)GetCellObject(HY_PARAMETER_TABLE_TABLE_ROW-1,0));
        } else if (resp == 1) {
            _SimpleList rows;
            for (long k = 0; k < sel.lLength; k+=4) {
                rows << sel.lData[k]/4;
            }
            table->_PrintTable(columns,rows,(_HYTable*)GetCellObject(HY_PARAMETER_TABLE_TABLE_ROW-1,0));
        }
        res = true;
        break;
    }

    case HY_WINDOW_MENU_ID_EDIT: { // undo
        UndoCommand();
        _UpdateUndoMenu (nil,nil);
        res = true;
        break;
    }

    case HY_WINDOW_MENU_ID_EDIT+5: { // undo
        SelectAll();
        res = true;
        break;
    }

    case HY_PT_WIN32_MENU_BASE+10:
    case HY_PT_WIN32_MENU_BASE+11:
    case HY_PT_WIN32_MENU_BASE+12:
    case HY_PT_WIN32_MENU_BASE+13: {
        res = true;
        char   toggleFlag;
        msel -= HY_PT_WIN32_MENU_BASE+10;
        switch (msel) {
        case 0:
            toggleFlag = HY_PARAMETER_TABLE_VIEW_LOCAL;
            break;
        case 1:
            toggleFlag = HY_PARAMETER_TABLE_VIEW_GLOBAL;
            break;
        case 2:
            toggleFlag = HY_PARAMETER_TABLE_VIEW_CONSTRAINED;
            break;
        case 3:
            toggleFlag = HY_PARAMETER_TABLE_VIEW_CATEGORY;
            break;

        }
        if (viewOptions&toggleFlag) {
            if (viewOptions-toggleFlag) {
                viewOptions-=toggleFlag;
            } else {
                break;
            }
        } else {
            viewOptions+=toggleFlag;
        }

        CheckMenuItem (GetSubMenu(GetSubMenu (GetMenu (theWindow),2),0),msel,MF_BYPOSITION|((viewOptions&toggleFlag)?MF_CHECKED:MF_UNCHECKED));
        ConstructTheTable();
        SetWindowRectangle (top,left,bottom,right);
        break;
    }

    case HY_PT_WIN32_MENU_BASE+1:
        OptimizeLikelihoodFunction();
        res = true;
        break;

    case HY_PT_WIN32_MENU_BASE+2:
        DoEnterConstraint ();
        res = true;
        break;

    case HY_PT_WIN32_MENU_BASE+3:
        DoCleanUp   ();
        res = true;
        break;

    case HY_PT_WIN32_MENU_BASE+4:
        HandleVarianceEstimates ();
        res = true;
        break;

    case HY_PT_WIN32_MENU_BASE+5:
        HandleProfilePlot   ();
        res = true;
        break;

    case HY_PT_WIN32_MENU_BASE+6:
        HandleCategories    ();
        res = true;
        break;

    case HY_PT_WIN32_MENU_BASE+7:
        HandleSelectParameters  ();
        res = true;
        break;

    case HY_PT_WIN32_MENU_BASE+8:
        HandleOpenInChart   ();
        res = true;
        break;
    }

    if (!res) {
        res = _HYTWindow::_ProcessMenuSelection(msel);
    }
    DrawMenuBar (theWindow);
    return res;
}

//__________________________________________________________________

void _HYParameterTable::_UpdateViewMenu(void)
{
    HMENU viewMenu = GetSubMenu(GetSubMenu (GetMenu (theWindow),2),0);

    if (!(avViewOptions&HY_PARAMETER_TABLE_VIEW_GLOBAL)) {
        EnableMenuItem (viewMenu,1,MF_BYPOSITION|MF_GRAYED);
    } else {
        EnableMenuItem (viewMenu,1,MF_BYPOSITION|MF_ENABLED);
    }


    if (!(avViewOptions&HY_PARAMETER_TABLE_VIEW_CONSTRAINED)) {
        EnableMenuItem (viewMenu,2,MF_BYPOSITION|MF_GRAYED);
    } else {
        EnableMenuItem (viewMenu,2,MF_BYPOSITION|MF_ENABLED);
    }

    if (!(avViewOptions&HY_PARAMETER_TABLE_VIEW_CATEGORY)) {
        EnableMenuItem (viewMenu,3,MF_BYPOSITION|MF_GRAYED);
    } else {
        EnableMenuItem (viewMenu,3,MF_BYPOSITION|MF_ENABLED);
    }

    if (!(avViewOptions&HY_PARAMETER_TABLE_VIEW_TREES)) {
        EnableMenuItem (viewMenu,4,MF_BYPOSITION|MF_GRAYED);
    } else {
        EnableMenuItem (viewMenu,4,MF_BYPOSITION|MF_ENABLED);
    }

    CheckMenuItem (viewMenu,0,MF_BYPOSITION|((viewOptions&HY_PARAMETER_TABLE_VIEW_LOCAL)?MF_CHECKED:MF_UNCHECKED));
    CheckMenuItem (viewMenu,1,MF_BYPOSITION|((viewOptions&HY_PARAMETER_TABLE_VIEW_GLOBAL)?MF_CHECKED:MF_UNCHECKED));
    CheckMenuItem (viewMenu,2,MF_BYPOSITION|((viewOptions&HY_PARAMETER_TABLE_VIEW_CONSTRAINED)?MF_CHECKED:MF_UNCHECKED));
    CheckMenuItem (viewMenu,3,MF_BYPOSITION|((viewOptions&HY_PARAMETER_TABLE_VIEW_CATEGORY)?MF_CHECKED:MF_UNCHECKED));
    CheckMenuItem (viewMenu,4,MF_BYPOSITION|((viewOptions&HY_PARAMETER_TABLE_VIEW_TREES)?MF_CHECKED:MF_UNCHECKED));
}


//__________________________________________________________________

void _HYParameterTable::_UnsetMenuBar(void)
{
}

//__________________________________________________________________

void _HYParameterTable::_UpdateUndoMenu(_String* command, _String* desc)
{
    HMENU editMenu = GetSubMenu (GetMenu (theWindow),1);
    if (command&&desc) {
        undoCommands        &&  command;
        undoDescriptions    &&  desc;
        _String       temp = _String('&') & *desc & "\tCtrl-Z";
        ModifyMenu    (editMenu,0,MF_BYPOSITION|MF_STRING|MF_ENABLED, HY_WINDOW_MENU_ID_EDIT, temp.sData);
    } else {
        if (undoDescriptions.lLength==0) {
            ModifyMenu    (editMenu,0,MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_WINDOW_MENU_ID_EDIT, "Can't &Undo\tCtrl-Z");
        } else {
            _String       temp = _String('&') & *(_String*)undoDescriptions(undoDescriptions.lLength-1) & "\tCtrl-Z";
            ModifyMenu    (editMenu,0,MF_BYPOSITION|MF_STRING|MF_ENABLED, HY_WINDOW_MENU_ID_EDIT, temp.sData);
        }
    }
    DrawMenuBar(theWindow);
}

//EOF